"""
    Karrio API

     ## API Reference  Karrio is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services.  The Karrio API is organized around REST. Our API has predictable resource-oriented URLs, accepts JSON-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.  The Karrio API differs for every account as we release new versions. These docs are customized to your version of the API.   ## Versioning  When backwards-incompatible changes are made to the API, a new, dated version is released. The current version is `2022.4`.  Read our API changelog and to learn more about backwards compatibility.  As a precaution, use API versioning to check a new API version before committing to an upgrade.   ## Pagination  All top-level API resources have support for bulk fetches via \"list\" API methods. For instance, you can list addresses, list shipments, and list trackers. These list API methods share a common structure, taking at least these two parameters: limit, and offset.  Karrio utilizes offset-based pagination via the offset and limit parameters. Both parameters take a number as value (see below) and return objects in reverse chronological order. The offset parameter returns objects listed after an index. The limit parameter take a limit on the number of objects to be returned from 1 to 100.   ```json {     \"next\": \"/v1/shipments?limit=25&offset=25\",     \"previous\": \"/v1/shipments?limit=25&offset=25\",     \"results\": [     ] } ```  ## Environments  The Karrio API offer the possibility to create and retrieve certain objects in `test_mode`. In development, it is therefore possible to add carrier connections, get live rates, buy labels, create trackers and schedule pickups in `test_mode`.    # noqa: E501

    The version of the OpenAPI document: 2022.4
    Contact: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from karrio.api_client import ApiClient, Endpoint as _Endpoint
from karrio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from karrio.model.error_response import ErrorResponse
from karrio.model.operation_response import OperationResponse
from karrio.model.pickup_cancel_request import PickupCancelRequest
from karrio.model.pickup_request import PickupRequest
from karrio.model.pickup_response import PickupResponse
from karrio.model.pickup_update_request import PickupUpdateRequest
from karrio.model.rate_request import RateRequest
from karrio.model.rate_response import RateResponse
from karrio.model.shipment_cancel_request import ShipmentCancelRequest
from karrio.model.shipping_request import ShippingRequest
from karrio.model.shipping_response import ShippingResponse
from karrio.model.tracking_response import TrackingResponse


class ProxyApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.buy_label_endpoint = _Endpoint(
            settings={
                'response_type': (ShippingResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/shipping',
                'operation_id': 'buy_label',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'data',
                ],
                'required': [
                    'data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data':
                        (ShippingRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.cancel_pickup_endpoint = _Endpoint(
            settings={
                'response_type': (OperationResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/pickups/{carrier_name}/cancel',
                'operation_id': 'cancel_pickup',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'carrier_name',
                    'data',
                    'test',
                ],
                'required': [
                    'carrier_name',
                    'data',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'carrier_name':
                        (str,),
                    'data':
                        (PickupCancelRequest,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'carrier_name': 'path',
                    'data': 'body',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.fetch_rates_endpoint = _Endpoint(
            settings={
                'response_type': (RateResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/rates',
                'operation_id': 'fetch_rates',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'data',
                    'test',
                ],
                'required': [
                    'data',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'data':
                        (RateRequest,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'test': 'test',
                },
                'location_map': {
                    'data': 'body',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.schedule_pickup_endpoint = _Endpoint(
            settings={
                'response_type': (PickupResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/pickups/{carrier_name}',
                'operation_id': 'schedule_pickup',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'carrier_name',
                    'data',
                    'test',
                ],
                'required': [
                    'carrier_name',
                    'data',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'carrier_name':
                        (str,),
                    'data':
                        (PickupRequest,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'carrier_name': 'path',
                    'data': 'body',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.track_shipment_endpoint = _Endpoint(
            settings={
                'response_type': (TrackingResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/tracking/{carrier_name}/{tracking_number}',
                'operation_id': 'track_shipment',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tracking_number',
                    'carrier_name',
                    'test',
                ],
                'required': [
                    'tracking_number',
                    'carrier_name',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'tracking_number':
                        (str,),
                    'carrier_name':
                        (str,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'tracking_number': 'tracking_number',
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'tracking_number': 'path',
                    'carrier_name': 'path',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_pickup_endpoint = _Endpoint(
            settings={
                'response_type': (PickupResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/pickups/{carrier_name}',
                'operation_id': 'update_pickup',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'carrier_name',
                    'data',
                    'test',
                ],
                'required': [
                    'carrier_name',
                    'data',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'carrier_name':
                        (str,),
                    'data':
                        (PickupUpdateRequest,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'carrier_name': 'path',
                    'data': 'body',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.void_label_endpoint = _Endpoint(
            settings={
                'response_type': (OperationResponse,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/proxy/shipping/{carrier_name}/cancel',
                'operation_id': 'void_label',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'carrier_name',
                    'data',
                    'test',
                ],
                'required': [
                    'carrier_name',
                    'data',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'carrier_name':
                        (str,),
                    'data':
                        (ShipmentCancelRequest,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'carrier_name': 'path',
                    'data': 'body',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def buy_label(
        self,
        data,
        **kwargs
    ):
        """Buy a shipment label  # noqa: E501

        Once the shipping rates are retrieved, provide the required info to submit the shipment by specifying your preferred rate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.buy_label(data, async_req=True)
        >>> result = thread.get()

        Args:
            data (ShippingRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ShippingResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['data'] = \
            data
        return self.buy_label_endpoint.call_with_http_info(**kwargs)

    def cancel_pickup(
        self,
        carrier_name,
        data,
        **kwargs
    ):
        """Cancel a pickup  # noqa: E501

        Cancel a pickup previously scheduled  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_pickup(carrier_name, data, async_req=True)
        >>> result = thread.get()

        Args:
            carrier_name (str):
            data (PickupCancelRequest):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OperationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['carrier_name'] = \
            carrier_name
        kwargs['data'] = \
            data
        return self.cancel_pickup_endpoint.call_with_http_info(**kwargs)

    def fetch_rates(
        self,
        data,
        **kwargs
    ):
        """Fetch shipment rates  # noqa: E501

         The Shipping process begins by fetching rates for your shipment. Use this service to fetch a shipping rates available.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_rates(data, async_req=True)
        >>> result = thread.get()

        Args:
            data (RateRequest):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['data'] = \
            data
        return self.fetch_rates_endpoint.call_with_http_info(**kwargs)

    def schedule_pickup(
        self,
        carrier_name,
        data,
        **kwargs
    ):
        """Schedule a pickup  # noqa: E501

        Schedule one or many parcels pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.schedule_pickup(carrier_name, data, async_req=True)
        >>> result = thread.get()

        Args:
            carrier_name (str):
            data (PickupRequest):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PickupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['carrier_name'] = \
            carrier_name
        kwargs['data'] = \
            data
        return self.schedule_pickup_endpoint.call_with_http_info(**kwargs)

    def track_shipment(
        self,
        tracking_number,
        carrier_name,
        **kwargs
    ):
        """Track a shipment  # noqa: E501

        You can track a shipment by specifying the carrier and the shipment tracking number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.track_shipment(tracking_number, carrier_name, async_req=True)
        >>> result = thread.get()

        Args:
            tracking_number (str):
            carrier_name (str):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TrackingResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tracking_number'] = \
            tracking_number
        kwargs['carrier_name'] = \
            carrier_name
        return self.track_shipment_endpoint.call_with_http_info(**kwargs)

    def update_pickup(
        self,
        carrier_name,
        data,
        **kwargs
    ):
        """Update a pickup  # noqa: E501

        Modify a scheduled pickup  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_pickup(carrier_name, data, async_req=True)
        >>> result = thread.get()

        Args:
            carrier_name (str):
            data (PickupUpdateRequest):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            PickupResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['carrier_name'] = \
            carrier_name
        kwargs['data'] = \
            data
        return self.update_pickup_endpoint.call_with_http_info(**kwargs)

    def void_label(
        self,
        carrier_name,
        data,
        **kwargs
    ):
        """Void a shipment label  # noqa: E501

        Cancel a shipment and the label previously created  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.void_label(carrier_name, data, async_req=True)
        >>> result = thread.get()

        Args:
            carrier_name (str):
            data (ShipmentCancelRequest):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OperationResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['carrier_name'] = \
            carrier_name
        kwargs['data'] = \
            data
        return self.void_label_endpoint.call_with_http_info(**kwargs)

