"""
    Karrio API

     ## API Reference  Karrio is an open source multi-carrier shipping API that simplifies the integration of logistic carrier services.  The Karrio API is organized around REST. Our API has predictable resource-oriented URLs, accepts JSON-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.  The Karrio API differs for every account as we release new versions. These docs are customized to your version of the API.   ## Versioning  When backwards-incompatible changes are made to the API, a new, dated version is released. The current version is `2022.4`.  Read our API changelog and to learn more about backwards compatibility.  As a precaution, use API versioning to check a new API version before committing to an upgrade.   ## Pagination  All top-level API resources have support for bulk fetches via \"list\" API methods. For instance, you can list addresses, list shipments, and list trackers. These list API methods share a common structure, taking at least these two parameters: limit, and offset.  Karrio utilizes offset-based pagination via the offset and limit parameters. Both parameters take a number as value (see below) and return objects in reverse chronological order. The offset parameter returns objects listed after an index. The limit parameter take a limit on the number of objects to be returned from 1 to 100.   ```json {     \"next\": \"/v1/shipments?limit=25&offset=25\",     \"previous\": \"/v1/shipments?limit=25&offset=25\",     \"results\": [     ] } ```  ## Environments  The Karrio API offer the possibility to create and retrieve certain objects in `test_mode`. In development, it is therefore possible to add carrier connections, get live rates, buy labels, create trackers and schedule pickups in `test_mode`.    # noqa: E501

    The version of the OpenAPI document: 2022.4
    Contact: 
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from karrio.api_client import ApiClient, Endpoint as _Endpoint
from karrio.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from karrio.model.error_response import ErrorResponse
from karrio.model.operation import Operation
from karrio.model.tracker_list import TrackerList
from karrio.model.tracking_status import TrackingStatus


class TrackersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_endpoint = _Endpoint(
            settings={
                'response_type': (TrackingStatus,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/trackers/{carrier_name}/{tracking_number}',
                'operation_id': 'create',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tracking_number',
                    'carrier_name',
                    'test',
                ],
                'required': [
                    'tracking_number',
                    'carrier_name',
                ],
                'nullable': [
                    'test',
                ],
                'enum': [
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'tracking_number':
                        (str,),
                    'carrier_name':
                        (str,),
                    'test':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'tracking_number': 'tracking_number',
                    'carrier_name': 'carrier_name',
                    'test': 'test',
                },
                'location_map': {
                    'tracking_number': 'path',
                    'carrier_name': 'path',
                    'test': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_type': (TrackerList,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/trackers',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'test_mode',
                    'status',
                    'created_after',
                    'created_before',
                    'carrier_id',
                    'limit',
                    'offset',
                    'carrier_name',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'carrier_name',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('status',): {

                        "PENDING": "pending",
                        "IN_TRANSIT": "in_transit",
                        "INCIDENT": "incident",
                        "DELIVERED": "delivered"
                    },
                    ('carrier_name',): {

                        "ARAMEX": "aramex",
                        "AUSTRALIAPOST": "australiapost",
                        "CANADAPOST": "canadapost",
                        "CANPAR": "canpar",
                        "DHL_EXPRESS": "dhl_express",
                        "DHL_POLAND": "dhl_poland",
                        "DHL_UNIVERSAL": "dhl_universal",
                        "DICOM": "dicom",
                        "ESHIPPER": "eshipper",
                        "FEDEX": "fedex",
                        "FREIGHTCOM": "freightcom",
                        "GENERIC": "generic",
                        "PUROLATOR": "purolator",
                        "ROYALMAIL": "royalmail",
                        "SENDLE": "sendle",
                        "SF_EXPRESS": "sf_express",
                        "TNT": "tnt",
                        "UPS": "ups",
                        "USPS": "usps",
                        "USPS_INTERNATIONAL": "usps_international",
                        "YANWEN": "yanwen",
                        "YUNEXPRESS": "yunexpress"
                    },
                },
                'openapi_types': {
                    'test_mode':
                        (bool,),
                    'status':
                        (str,),
                    'created_after':
                        (datetime,),
                    'created_before':
                        (datetime,),
                    'carrier_id':
                        (str,),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'carrier_name':
                        (str,),
                },
                'attribute_map': {
                    'test_mode': 'test_mode',
                    'status': 'status',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'carrier_id': 'carrier_id',
                    'limit': 'limit',
                    'offset': 'offset',
                    'carrier_name': 'carrier_name',
                },
                'location_map': {
                    'test_mode': 'query',
                    'status': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'carrier_id': 'query',
                    'limit': 'query',
                    'offset': 'query',
                    'carrier_name': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_endpoint = _Endpoint(
            settings={
                'response_type': (Operation,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/trackers/{id_or_tracking_number}',
                'operation_id': 'remove',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id_or_tracking_number',
                ],
                'required': [
                    'id_or_tracking_number',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id_or_tracking_number':
                        (str,),
                },
                'attribute_map': {
                    'id_or_tracking_number': 'id_or_tracking_number',
                },
                'location_map': {
                    'id_or_tracking_number': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieves_endpoint = _Endpoint(
            settings={
                'response_type': (TrackingStatus,),
                'auth': [
                    'Token'
                ],
                'endpoint_path': '/v1/trackers/{id_or_tracking_number}',
                'operation_id': 'retrieves',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id_or_tracking_number',
                ],
                'required': [
                    'id_or_tracking_number',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id_or_tracking_number':
                        (str,),
                },
                'attribute_map': {
                    'id_or_tracking_number': 'id_or_tracking_number',
                },
                'location_map': {
                    'id_or_tracking_number': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create(
        self,
        tracking_number,
        carrier_name,
        **kwargs
    ):
        """Create a shipment tracker  # noqa: E501

        This API creates or retrieves (if existent) a tracking status object containing the details and events of a shipping in progress.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create(tracking_number, carrier_name, async_req=True)
        >>> result = thread.get()

        Args:
            tracking_number (str):
            carrier_name (str):

        Keyword Args:
            test (bool, none_type): The test flag indicates whether to use a carrier configured for test.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TrackingStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tracking_number'] = \
            tracking_number
        kwargs['carrier_name'] = \
            carrier_name
        return self.create_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        **kwargs
    ):
        """List all shipment trackers  # noqa: E501

        Retrieve all shipment trackers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            test_mode (bool): [optional]
            status (str): [optional]
            created_after (datetime): DateTime in format `YYYY-MM-DD H:M:S.fz`. [optional]
            created_before (datetime): DateTime in format `YYYY-MM-DD H:M:S.fz`. [optional]
            carrier_id (str): [optional]
            limit (int): Number of results to return per page.. [optional]
            offset (int): The initial index from which to return the results.. [optional]
            carrier_name (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TrackerList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_endpoint.call_with_http_info(**kwargs)

    def remove(
        self,
        id_or_tracking_number,
        **kwargs
    ):
        """Discard a shipment tracker  # noqa: E501

        Discard a shipment tracker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove(id_or_tracking_number, async_req=True)
        >>> result = thread.get()

        Args:
            id_or_tracking_number (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Operation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id_or_tracking_number'] = \
            id_or_tracking_number
        return self.remove_endpoint.call_with_http_info(**kwargs)

    def retrieves(
        self,
        id_or_tracking_number,
        **kwargs
    ):
        """Retrieves a shipment tracker  # noqa: E501

        Retrieve a shipment tracker  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.retrieves(id_or_tracking_number, async_req=True)
        >>> result = thread.get()

        Args:
            id_or_tracking_number (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TrackingStatus
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id_or_tracking_number'] = \
            id_or_tracking_number
        return self.retrieves_endpoint.call_with_http_info(**kwargs)

