"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template } = props;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: (_b = template.branches) === null || _b === void 0 ? void 0 : _b.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
_a = JSII_RTTI_SYMBOL_1;
ApprovalRuleTemplate[_a] = { fqn: "@cloudcomponents/cdk-pull-request-approval-rule.ApprovalRuleTemplate", version: "1.47.0" };
//# sourceMappingURL=data:application/json;base64,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