/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.HookType;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.NamedParam;
import com.certora.evmverifier.cvl.SlotPattern;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kotlinizable.Kotlinizable;
import spec.TypeResolver;
import spec.cvlast.CVLHookPattern;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSlotPattern;
import spec.cvlast.VMParam;
import spec.cvlast.parser.GeneratedOpcodeParsers;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class HookPattern
implements Kotlinizable<CVLHookPattern> {
    private final CVLRange cvlRange;
    private final HookType hookType;
    private final NamedParam value;
    private final NamedParam oldValue;
    private final SlotPattern slot;
    private final Base base;
    private final List<NamedParam> params;

    HookPattern(CVLRange _cvlRange, HookType _hookType, NamedParam _value, SlotPattern _slot, Base _base) {
        this.cvlRange = _cvlRange;
        this.hookType = _hookType;
        this.value = _value;
        this.oldValue = null;
        this.slot = _slot;
        this.base = _base;
        this.params = null;
    }

    HookPattern(CVLRange _cvlRange, HookType _hookType, NamedParam _value, NamedParam _oldValue, SlotPattern _slot, Base _base) {
        this.cvlRange = _cvlRange;
        this.hookType = _hookType;
        this.value = _value;
        this.oldValue = _oldValue;
        this.slot = _slot;
        this.base = _base;
        this.params = null;
    }

    HookPattern(CVLRange _cvlRange, HookType _hookType, NamedParam _value) {
        this.cvlRange = _cvlRange;
        this.hookType = _hookType;
        this.value = _value;
        this.oldValue = null;
        this.slot = null;
        this.base = Base.NONE;
        this.params = null;
    }

    HookPattern(CVLRange _cvlRange, String _hookTypeName, List<NamedParam> _params, NamedParam _value) {
        this.cvlRange = _cvlRange;
        this.hookType = HookType.valueOf(_hookTypeName);
        this.value = _value;
        this.oldValue = null;
        this.slot = null;
        this.base = Base.NONE;
        this.params = _params;
    }

    HookPattern(CVLRange _cvlRange, String _hookTypeName, List<NamedParam> _params) {
        this.cvlRange = _cvlRange;
        this.hookType = HookType.valueOf(_hookTypeName);
        this.value = null;
        this.oldValue = null;
        this.slot = null;
        this.base = Base.NONE;
        this.params = _params;
    }

    @Override
    public CollectingResult<CVLHookPattern, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        Function<Function, CollectingResult> bindWithValue = callBack -> {
            Objects.requireNonNull(this.value);
            return KotlinizeResult.bind(this.value.toNamedVMParam(resolver, scope), callBack);
        };
        if (this.hookType == HookType.SLOAD) {
            assert (this.slot != null);
            return bindWithValue.apply(cvlvmParam -> KotlinizeResult.map(this.slot.kotlinize(resolver, scope), slot -> new CVLHookPattern.StoragePattern.Load((VMParam.Named)cvlvmParam, (CVLSlotPattern)slot, this.base())));
        }
        if (this.hookType == HookType.SSTORE) {
            return bindWithValue.apply(cvlvmParam -> {
                CollectingResult<Object, CVLError> kotlinizedOldValue = this.oldValue == null ? KotlinizeResult.lift(null) : this.oldValue.toNamedVMParam(resolver, scope);
                assert (this.slot != null);
                return KotlinizeResult.map(kotlinizedOldValue, this.slot.kotlinize(resolver, scope), (old, slot) -> new CVLHookPattern.StoragePattern.Store((VMParam.Named)cvlvmParam, (CVLSlotPattern)slot, this.base(), (VMParam.Named)old));
            });
        }
        if (this.hookType == HookType.CREATE) {
            return bindWithValue.apply(cvlvmParam -> KotlinizeResult.lift(new CVLHookPattern.Create((VMParam.Named)cvlvmParam)));
        }
        if (!this.hookType.lowLevel) {
            throw new IllegalStateException("Did not expect a non-opcode low-level hook type " + this.hookType.name());
        }
        if (GeneratedOpcodeParsers.INSTANCE.supportsAutoParse(this.hookType)) {
            return GeneratedOpcodeParsers.INSTANCE.handleParse(resolver, scope, this.hookType, this.value, this.params, this.cvlRange);
        }
        throw new IllegalStateException("Unrecognized hook pattern " + this.hookType.name());
    }

    private CVLHookPattern.StoragePattern.Base base() {
        return CVLHookPattern.StoragePattern.Base.STORAGE;
    }

    static enum Base {
        NONE,
        STORAGE;

    }
}

