/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.InvariantProof;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.MethodParamFiltersMap;
import com.certora.evmverifier.cvl.NamedParam;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kotlinizable.Kotlinizable;
import spec.TypeResolver;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLInvariantProof;
import spec.cvlast.CVLParam;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.MethodParamFilters;
import spec.cvlast.SpecType;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class Invariant
implements Kotlinizable<CVLInvariant> {
    public Boolean isImportedSpecFile;
    public CVLRange cvlRange;
    public String id;
    public List<NamedParam> params;
    public Exp exp;
    public MethodParamFiltersMap mpf;
    public InvariantProof proof;

    Invariant(Boolean _isImportedSpecFile, CVLRange _cvlRange, String _id, List<NamedParam> _params, Exp _exp, MethodParamFiltersMap _mpf, InvariantProof _proof) {
        this.isImportedSpecFile = _isImportedSpecFile;
        this.cvlRange = _cvlRange;
        this.id = _id;
        this.params = _params;
        this.exp = _exp;
        this.mpf = _mpf;
        this.proof = _proof;
    }

    public String toString() {
        Stream<String> paramsListToString = this.params.stream().map(Objects::toString);
        return String.format("Invariant(%s,%s,%s)", this.id, paramsListToString.reduce("", (S, s) -> S + ", " + s), this.exp);
    }

    @Override
    public CollectingResult<CVLInvariant, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        return scope.extendInCollecting(CVLScope.Item.InvariantScopeItem::new, iScope -> {
            CollectingResult<List<CVLParam.Named>, CVLError> params = NamedParam.toPureNamedParams(this.params, resolver, iScope);
            CollectingResult exp = this.exp.kotlinize(resolver, (CVLScope)iScope);
            CollectingResult<MethodParamFilters, CVLError> mpf = this.mpf.kotlinize(resolver, (CVLScope)iScope);
            CollectingResult<CVLInvariantProof, CVLError> proof = this.proof.kotlinize(resolver, (CVLScope)iScope);
            return KotlinizeResult.bindMany(() -> KotlinizeResult.lift(new CVLInvariant(this.cvlRange, this.id, this.isImportedSpecFile != false ? SpecType.Single.FromUser.ImportedSpecFile.INSTANCE : SpecType.Single.FromUser.SpecFile.INSTANCE, (List)params.force(), (CVLExp)exp.force(), (MethodParamFilters)mpf.force(), (CVLInvariantProof)proof.force(), (CVLScope)iScope, iScope.currentScope())), params, exp, mpf, proof);
        });
    }
}

