/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.CallSummary;
import com.certora.evmverifier.cvl.KotlinizeResult;
import com.certora.evmverifier.cvl.LocatedToken;
import com.certora.evmverifier.cvl.MethodEntry;
import com.certora.evmverifier.cvl.MethodReferenceExp;
import config.Config;
import java.util.Collections;
import java.util.List;
import spec.TypeResolver;
import spec.cvlast.AnnotationQualifiers;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.CatchAllSummaryAnnotation;
import spec.cvlast.MethodEntryTargetContract;
import spec.cvlast.SolidityContract;
import spec.cvlast.SpecCallSummary;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class CatchAllSummary
implements MethodEntry<CatchAllSummaryAnnotation> {
    private final MethodReferenceExp ref;
    private final CallSummary summ;
    private final CVLRange range;
    private final List<LocatedToken> preFlags;

    public CatchAllSummary(CVLRange range, MethodReferenceExp ref, CallSummary summ, List<LocatedToken> preFlags) {
        this.summ = summ;
        this.range = range;
        this.ref = ref;
        this.preFlags = preFlags;
    }

    @Override
    public CollectingResult<? extends CatchAllSummaryAnnotation, CVLError> kotlinize(TypeResolver res2, CVLScope inScope) {
        if (this.ref.contract == null || !this.ref.method.equals("_")) {
            return KotlinizeResult.error(new CVLError.General(this.ref.cvlRange, "Catch-all summaries must be of the form ContractName._"));
        }
        if (!(this.summ instanceof CallSummary.HavocingSummary)) {
            return KotlinizeResult.error(new CVLError.General(this.ref.cvlRange, "Catch-all summaries can only use havocing summaries (`NONDET`, `HAVOC_ALL`, `HAVOC_ECF`, `AUTO`)"));
        }
        String contract = res2.resolveContract(this.ref.contract.id);
        if (!res2.validContract(contract)) {
            return KotlinizeResult.error(new CVLError.General(this.ref.contract.range, String.format("Contract with name %s does not exist", this.ref.contract.id)));
        }
        return KotlinizeResult.map(this.summ.kotlinize(res2, inScope, Collections.emptyList()), Config.INSTANCE.getVMConfig().getMethodQualifierAnnotations(this.preFlags, Collections.emptyList(), this.range), (summ, annot2) -> new CatchAllSummaryAnnotation(this.range, new MethodEntryTargetContract.SpecificTarget(new SolidityContract(contract)), (SpecCallSummary.ExpressibleInCVL)summ, (AnnotationQualifiers)annot2));
    }
}

