/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u0000 \u001c*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0007\u001c\u001d\u001e\u001f !\"B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0013\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096\u0002J\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006#"}, d2={"Ldatastructures/SmallList;", "T", "", "Ljava/io/Serializable;", "()V", "containsAll", "", "elements", "", "equals", "other", "", "hashCode", "", "indexOf", "element", "(Ljava/lang/Object;)I", "iterator", "", "lastIndexOf", "listIterator", "", "index", "subList", "fromIndex", "toIndex", "toString", "", "Companion", "Empty", "Of1", "Of2", "Of3", "Of4", "Of5", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nSmallList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallList.kt\ndatastructures/SmallList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1726#2,3:119\n*S KotlinDebug\n*F\n+ 1 SmallList.kt\ndatastructures/SmallList\n*L\n52#1:119,3\n*E\n"})
public abstract class SmallList<T>
implements List<T>,
Serializable,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Empty<Object> empty = new Empty();

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this, ", ", "[", "]", 0, null, null, 56, null);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.get(i);
            hashCode = 31 * hashCode + (e != null ? e.hashCode() : 0);
        }
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        if (((List)other).size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual(((List)other).get(i), this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return new ListIterator<T>(index, this){
            private int i;
            final /* synthetic */ SmallList<T> this$0;
            {
                this.this$0 = $receiver;
                this.i = $index;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return this.i < this.this$0.size();
            }

            public int nextIndex() {
                return this.i;
            }

            public T next() {
                int n = this.i;
                this.i = n + 1;
                return (T)this.this$0.get(n);
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public T previous() {
                this.i += -1;
                return (T)this.this$0.get(this.i);
            }

            public void add(T element) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }

            public void set(T element) {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractList<T>(fromIndex, toIndex, this){
            private final int from;
            private final int size;
            final /* synthetic */ int $fromIndex;
            final /* synthetic */ SmallList<T> this$0;
            {
                this.$fromIndex = $fromIndex;
                this.this$0 = $receiver;
                this.from = $fromIndex;
                this.size = $toIndex - $fromIndex;
            }

            public final int getFrom() {
                return this.from;
            }

            public int getSize() {
                return this.size;
            }

            public T get(int index) {
                return (T)this.this$0.get(index - this.$fromIndex);
            }
        };
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, "elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public int indexOf(Object element) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual(this.get(i), element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        IntProgression intProgression = RangesKt.reversed(RangesKt.until(0, this.size()));
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if (Intrinsics.areEqual(this.get(i), element)) {
                    return i;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return -1;
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public abstract int getSize();

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u0007R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldatastructures/SmallList$Companion;", "", "()V", "empty", "Ldatastructures/SmallList$Empty;", "Of0", "Ldatastructures/SmallList;", "T", "GeneralUtils"})
    @SourceDebugExtension(value={"SMAP\nSmallList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallList.kt\ndatastructures/SmallList$Companion\n+ 2 ExtStdlib.kt\nutils/ExtStdlibKt\n*L\n1#1,118:1\n24#2:119\n*S KotlinDebug\n*F\n+ 1 SmallList.kt\ndatastructures/SmallList$Companion\n*L\n114#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SmallList<T> Of0() {
            Empty $this$uncheckedAs$iv = empty;
            boolean $i$f$uncheckedAs = false;
            return (SmallList)((Object)$this$uncheckedAs$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00028\u00012\u0006\u0010\r\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ldatastructures/SmallList$Empty;", "T", "Ldatastructures/SmallList;", "()V", "size", "", "getSize", "()I", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "isEmpty", "GeneralUtils"})
    public static class Empty<T>
    extends SmallList<T> {
        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object element) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new NoSuchElementException();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0003\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Ldatastructures/SmallList$Of1;", "T", "Ldatastructures/SmallList$Empty;", "value0", "(Ljava/lang/Object;)V", "size", "", "getSize", "()I", "Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "isEmpty", "GeneralUtils"})
    public static class Of1<T>
    extends Empty<T> {
        private final T value0;

        public Of1(T value0) {
            this.value0 = value0;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object element) {
            return Intrinsics.areEqual(element, this.value0) || super.contains(element);
        }

        @Override
        public T get(int index) {
            return index == 0 ? this.value0 : super.get(index);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0012"}, d2={"Ldatastructures/SmallList$Of2;", "T", "Ldatastructures/SmallList$Of1;", "value0", "value1", "(Ljava/lang/Object;Ljava/lang/Object;)V", "size", "", "getSize", "()I", "Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "GeneralUtils"})
    public static class Of2<T>
    extends Of1<T> {
        private final T value1;

        public Of2(T value0, T value1) {
            super(value0);
            this.value1 = value1;
        }

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public boolean contains(Object element) {
            return Intrinsics.areEqual(element, this.value1) || super.contains(element);
        }

        @Override
        public T get(int index) {
            return index == 1 ? this.value1 : super.get(index);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00028\u00012\u0006\u0010\u0011\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0005\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0013"}, d2={"Ldatastructures/SmallList$Of3;", "T", "Ldatastructures/SmallList$Of2;", "value0", "value1", "value2", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "size", "", "getSize", "()I", "Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "GeneralUtils"})
    public static class Of3<T>
    extends Of2<T> {
        private final T value2;

        public Of3(T value0, T value1, T value2) {
            super(value0, value1);
            this.value2 = value2;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public boolean contains(Object element) {
            return Intrinsics.areEqual(element, this.value2) || super.contains(element);
        }

        @Override
        public T get(int index) {
            return index == 2 ? this.value2 : super.get(index);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00028\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0006\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0014"}, d2={"Ldatastructures/SmallList$Of4;", "T", "Ldatastructures/SmallList$Of3;", "value0", "value1", "value2", "value3", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "size", "", "getSize", "()I", "Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "GeneralUtils"})
    public static class Of4<T>
    extends Of3<T> {
        private final T value3;

        public Of4(T value0, T value1, T value2, T value3) {
            super(value0, value1, value2);
            this.value3 = value3;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public boolean contains(Object element) {
            return Intrinsics.areEqual(element, this.value3) || super.contains(element);
        }

        @Override
        public T get(int index) {
            return index == 3 ? this.value3 : super.get(index);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u0012\u0006\u0010\u0007\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0015"}, d2={"Ldatastructures/SmallList$Of5;", "T", "Ldatastructures/SmallList$Of4;", "value0", "value1", "value2", "value3", "value4", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "size", "", "getSize", "()I", "Ljava/lang/Object;", "contains", "", "element", "(Ljava/lang/Object;)Z", "get", "index", "(I)Ljava/lang/Object;", "GeneralUtils"})
    public static class Of5<T>
    extends Of4<T> {
        private final T value4;

        public Of5(T value0, T value1, T value2, T value3, T value4) {
            super(value0, value1, value2, value3);
            this.value4 = value4;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public boolean contains(Object element) {
            return Intrinsics.areEqual(element, this.value4) || super.contains(element);
        }

        @Override
        public T get(int index) {
            return index == 4 ? this.value4 : super.get(index);
        }
    }
}

