import requests
from bs4 import BeautifulSoup

description = 'To get the latest Earthquake in Indonesia information from bmkg.go.id'


def ekstraksi_data():
    """
    Tanggal: 04 Mei 2023
    Waktu: 21:22:03 WIB
    Magnitudo: 3.6
    Kedalaman: 10 km
    lokasi: LS=10.52 - BT=121.70
    Pusat gempa: Pusat gempa berada di Laut 15 km BaratLaut Sabu Raijua
    Dirasakan: Dirasakan (Skala MMI): IV Sabu Raijua
    :return:
    """
    try:
        content = requests.get('https://bmkg.go.id')
    except Exception:
        return None
    if content.status_code == 200:
        soup = BeautifulSoup(content.text, 'html.parser')

        result = soup.find('span', {'class': 'waktu'})
        result = result.text.split(', ')
        tanggal = result[0]
        waktu = result[1]

        result = soup.find('div', {'class':'col-md-6 col-xs-6 gempabumi-detail no-padding'})
        result = result.findChildren('li')
        i = 0
        magnitudo = None
        ls = 0
        bt = 0
        dirasakan = None
        kedalaman = None

        for res in result:
            if i == 1:
                magnitudo = res.text
            elif i == 2:
                kedalaman = res.text
            elif i == 3:
                koordinat = res.text.split(' - ')
                ls = koordinat[0]
                bt = koordinat[1]
            elif i == 4:
                lokasi = res.text
            elif i == 5:
                dirasakan = res.text
            i = i + 1

#soup = BeautifulSoup(content)
#print(soup.prettify())

        hasil = dict()
        hasil['tanggal'] = tanggal
        hasil['waktu'] = waktu
        hasil['magnitudo'] = magnitudo
        hasil['kedalaman'] = kedalaman
        hasil['koordinat'] = {'ls': ls, 'bt': bt}
        hasil['lokasi'] = lokasi
        hasil['dirasakan'] = dirasakan
        return hasil
    else:
        return None


def tampilkan_data(result):
    if result is None:
        print("Tidak bisa menemukan data gempa terkini")
        return
    print('Gempa Terakhir berdasarkan BMKG')
    print(f"Tanggal {result['tanggal']}")
    print(f"Waktu {result['waktu']}")
    print(f"Magnitudo {result['magnitudo']}")
    print(f"Kedalaman {result['kedalaman']}")
    print(f"Lokasi {result['lokasi']}")
    print(f"Koordinat: LS={result['koordinat']['ls']}, BT={result['koordinat']['bt']}")
    print(f"Dirasakan {result['dirasakan']}")

if __name__ == '__main__':
    print('Deskripsi Package', description)
    result = ekstraksi_data()
    tampilkan_data(result)

# print('ini adalah package gempaterkini')
