# coding: utf-8

"""
    UMA Auth API

    This API allows you to authenticate with the UMA server to take actions on a user's wallet. It's the exposed communication layer between the NWC server and the main UMA server.

    The version of the OpenAPI document: 0.1
    Contact: info@lightspark.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Invoice(BaseModel):
    """
    Invoice
    """ # noqa: E501
    payment_request: StrictStr = Field(description="The full, encoded payment request.")
    amount: StrictInt = Field(description="The amount of the invoice in msats.")
    payment_hash: StrictStr = Field(description="The payment hash of the invoice.")
    memo: Optional[StrictStr] = Field(default=None, description="A memo attached to the invoice.")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional metadata attached to the invoice.")
    preimage: Optional[StrictStr] = Field(default=None, description="The payment preimage of the invoice.")
    expires_at: Optional[datetime] = Field(default=None, description="The time the invoice expires.")
    created_at: datetime = Field(description="The time the invoice was created.")
    settled_at: Optional[datetime] = Field(default=None, description="The time the invoice was settled.")
    type: StrictStr = Field(description="Whether the invoice is incoming (created by this user) or outgoing (created by another user).")
    __properties: ClassVar[List[str]] = ["payment_request", "amount", "payment_hash", "memo", "metadata", "preimage", "expires_at", "created_at", "settled_at", "type"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('incoming', 'outgoing'):
            raise ValueError("must be one of enum values ('incoming', 'outgoing')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Invoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            mode="json",
            by_alias=True,
            exclude={
            },
            exclude_none=True,
            exclude_unset=True,
        )
        # set to None if memo (nullable) is None
        # and model_fields_set contains the field
        if self.memo is None and "memo" in self.model_fields_set:
            _dict['memo'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if preimage (nullable) is None
        # and model_fields_set contains the field
        if self.preimage is None and "preimage" in self.model_fields_set:
            _dict['preimage'] = None

        # set to None if expires_at (nullable) is None
        # and model_fields_set contains the field
        if self.expires_at is None and "expires_at" in self.model_fields_set:
            _dict['expires_at'] = None

        # set to None if settled_at (nullable) is None
        # and model_fields_set contains the field
        if self.settled_at is None and "settled_at" in self.model_fields_set:
            _dict['settled_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Invoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payment_request": obj.get("payment_request"),
            "amount": obj.get("amount"),
            "payment_hash": obj.get("payment_hash"),
            "memo": obj.get("memo"),
            "metadata": obj.get("metadata"),
            "preimage": obj.get("preimage"),
            "expires_at": obj.get("expires_at"),
            "created_at": obj.get("created_at"),
            "settled_at": obj.get("settled_at"),
            "type": obj.get("type")
        })
        return _obj


