# coding: utf-8

"""
    UMA Auth API

    This API allows you to authenticate with the UMA server to take actions on a user's wallet. It's the exposed communication layer between the NWC server and the main UMA server.

    The version of the OpenAPI document: 0.1
    Contact: info@lightspark.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json




from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class PayToAddressRequest(BaseModel):
    """
    PayToAddressRequest
    """ # noqa: E501
    receiver_address: StrictStr = Field(description="The address to pay.")
    sending_currency_code: StrictStr = Field(description="The code of the currency being sent from the sender's wallet.")
    sending_currency_amount: StrictInt = Field(description="The amount to send in the smallest unit of the sending currency (eg. cents).")
    receiving_currency_code: Optional[StrictStr] = Field(default=None, description="The code of the currency being received by the receiver. If not provided, the receiver's default currency will be used.")
    __properties: ClassVar[List[str]] = ["receiver_address", "sending_currency_code", "sending_currency_amount", "receiving_currency_code"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of PayToAddressRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            mode="json",
            by_alias=True,
            exclude={
            },
            exclude_none=True,
            exclude_unset=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of PayToAddressRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "receiver_address": obj.get("receiver_address"),
            "sending_currency_code": obj.get("sending_currency_code"),
            "sending_currency_amount": obj.get("sending_currency_amount"),
            "receiving_currency_code": obj.get("receiving_currency_code")
        })
        return _obj


