/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.EelTootlus;
import ee.ut.soras.ajavtV2.JarelTootlus;
import ee.ut.soras.ajavtV2.Main;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.LiitumisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.SemLeidmiseMudel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.SemLeidmiseMudelImpl3;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.NegatiivneMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.util.LogiPidaja;
import ee.ut.soras.ajavtV2.util.MustridXMLFailist;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.EstyhmmWrapper;
import ee.ut.soras.wrappers.impl.EstyhmmWrapperImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AjaTuvastaja {
    private static final String versioon = "2014-05-21_01";
    private LogiPidaja logi;
    private String reegliFail = "reeglid.xml";
    private HashMap<String, SonaKlass> sonaKlassid = null;
    private List<TuvastamisReegel> reeglid = null;
    private List<LiitumisReegel> liitumisReeglid = null;
    private SemLeidmiseMudel mudel = new SemLeidmiseMudelImpl3();
    private EstyhmmWrapper wrapper;
    private static Pattern musterNumbrikombinatsioon = Pattern.compile("^(\\d+)(\\d|[.,!?]|-)+(-(st|ks|ni|nda)+)?$", 2);
    private static Pattern musterKuniSonaVoiMark = Pattern.compile("^(kuni|KUNI|-)$");
    private static int ON_NUMBRIKOMBINATSIOON = 1;
    private static int ON_ARVSONAFRAAS = 2;
    private static int ON_LEITUD_AJAVALJEND = 3;
    private static int ON_AJAVALJEND_NUMBRIKOMBINATSIOON = 4;

    public List<String> tuvastaAjavaljendidTekstisDebugSpeed(String[] konehetk, String sisendTekst, String morfAnalyysitudSisendTekst, boolean allowOnlyPureTimeML) throws Exception {
        long endTime;
        long startTime;
        long preprocessingTime = 0L;
        long ajavtTime = 0L;
        if (this.sonaKlassid == null || this.reeglid == null) {
            this.uuendaReegleid(this.reegliFail, false);
        }
        List<AjavtSona> sonad = null;
        if (morfAnalyysitudSisendTekst == null) {
            if (this.wrapper == null) {
                this.wrapper = new EstyhmmWrapperImpl("t3mesta -Y -cio utf8 +1", "UTF-8");
            }
            startTime = System.currentTimeMillis();
            sonad = EelTootlus.eeltootlusValiseMorfAnalyysiga(this.wrapper, sisendTekst);
            endTime = System.currentTimeMillis();
            preprocessingTime = endTime - startTime;
        } else {
            startTime = System.currentTimeMillis();
            sonad = EelTootlus.eeltootlus(morfAnalyysitudSisendTekst);
            endTime = System.currentTimeMillis();
            preprocessingTime = endTime - startTime;
        }
        startTime = System.currentTimeMillis();
        if (this.mudel == null) {
            throw new Exception("Arvutusmudel maaramata!");
        }
        TuvastamisReegel.setSemanticsModel(this.mudel.getMudeliTahised());
        this.eraldaAjavaljendiKandidaadid(sonad);
        this.lahendaYlekattedAjavaljenditeVahelJaRakendaNegMustreid(sonad);
        this.liidaKorvutiseisvadAjavaljendiFraasid(sonad);
        this.eraldaAjavahemikudJaLiidaFraasiks(sonad);
        this.mudel.leiaSemantika(sonad, konehetk);
        JarelTootlus.joondaAlgseTekstiga(sonad, sisendTekst);
        JarelTootlus.parandaTIDvaartused(sonad, allowOnlyPureTimeML);
        List<String> returnable = JarelTootlus.eraldamiseTulemusAinultValjendid(sonad, sisendTekst, allowOnlyPureTimeML, JarelTootlus.formatAsCreationTime(konehetk));
        long endTime2 = System.currentTimeMillis();
        ajavtTime = endTime2 - startTime;
        returnable.add(String.valueOf(preprocessingTime));
        returnable.add(String.valueOf(ajavtTime));
        return returnable;
    }

    public List<AjavtSona> tuvastaAjavaljendidTekstis(String[] konehetk, String sisendTekst, String morfAnalyysitudSisendTekst, boolean allowOnlyPureTimeML) throws Exception {
        if (this.sonaKlassid == null || this.reeglid == null) {
            this.uuendaReegleid(this.reegliFail, false);
        }
        List<AjavtSona> sonad = null;
        if (morfAnalyysitudSisendTekst == null) {
            if (this.wrapper == null) {
                this.wrapper = new EstyhmmWrapperImpl("t3mesta -Y -cio utf8 +1", "UTF-8");
            }
            sonad = EelTootlus.eeltootlusValiseMorfAnalyysiga(this.wrapper, sisendTekst);
        } else {
            sonad = EelTootlus.eeltootlus(morfAnalyysitudSisendTekst);
        }
        if (this.mudel == null) {
            throw new Exception("Arvutusmudel maaramata!");
        }
        TuvastamisReegel.setSemanticsModel(this.mudel.getMudeliTahised());
        this.eraldaAjavaljendiKandidaadid(sonad);
        this.lahendaYlekattedAjavaljenditeVahelJaRakendaNegMustreid(sonad);
        this.liidaKorvutiseisvadAjavaljendiFraasid(sonad);
        this.eraldaAjavahemikudJaLiidaFraasiks(sonad);
        this.mudel.leiaSemantika(sonad, konehetk);
        JarelTootlus.joondaAlgseTekstiga(sonad, sisendTekst);
        JarelTootlus.parandaTIDvaartused(sonad, allowOnlyPureTimeML);
        return sonad;
    }

    public List<HashMap<String, String>> tuvastaAjavaljendidTekstisTulemusPaiskTabelitena(String[] konehetk, String sisendTekst, String morfAnalyysitudSisendTekst, boolean allowOnlyPureTimeML) throws Exception {
        List<AjavtSona> sonad = this.tuvastaAjavaljendidTekstis(konehetk, sisendTekst, morfAnalyysitudSisendTekst, allowOnlyPureTimeML);
        return JarelTootlus.eraldamiseTulemusAinultValjendidPaistabelitena(sonad, sisendTekst, allowOnlyPureTimeML, JarelTootlus.formatAsCreationTime(konehetk));
    }

    public List<AjavtSona> tuvastaAjavaljendidT3OLP(String[] konehetk, String sisendT3OLP, boolean allowOnlyPureTimeML, boolean debug) throws Exception {
        if (this.sonaKlassid == null || this.reeglid == null) {
            this.uuendaReegleid(this.reegliFail, true);
        } else if (this.logi != null) {
            this.kuvaSonaKlassidJaReeglid(this.logi);
        }
        if (debug) {
            LogiPidaja logi = new LogiPidaja(true);
            logi.setKirjutaLogiValjundisse(true);
            logi.setKirjutaLogiFaili(false);
            SemantikaDefinitsioon.logi = logi;
        }
        List<AjavtSona> sonad = null;
        sonad = EelTootlus.eeltootlusT3OLP(sisendT3OLP);
        if (this.mudel == null) {
            throw new Exception("Arvutusmudel maaramata!");
        }
        TuvastamisReegel.setSemanticsModel(this.mudel.getMudeliTahised());
        this.eraldaAjavaljendiKandidaadid(sonad);
        this.lahendaYlekattedAjavaljenditeVahelJaRakendaNegMustreid(sonad);
        this.liidaKorvutiseisvadAjavaljendiFraasid(sonad);
        this.eraldaAjavahemikudJaLiidaFraasiks(sonad);
        this.mudel.leiaSemantika(sonad, konehetk);
        JarelTootlus.parandaTIDvaartused(sonad, allowOnlyPureTimeML);
        return sonad;
    }

    public List<HashMap<String, String>> tuvastaAjavaljendidT3OLPTulemusPaiskTabelitena(String[] konehetk, String sisendT3OLP, boolean allowOnlyPureTimeML, boolean debug) throws Exception {
        List<AjavtSona> sonad = this.tuvastaAjavaljendidT3OLP(konehetk, sisendT3OLP, allowOnlyPureTimeML, debug);
        return JarelTootlus.eraldamiseTulemusAinultValjendidPaistabelitena(sonad, null, allowOnlyPureTimeML, JarelTootlus.formatAsCreationTime(konehetk));
    }

    public List<AjavtSona> tuvastaAjavaljendidVabamorfJSON(String[] konehetk, String sisendJSON, boolean allowOnlyPureTimeML, boolean debug) throws Exception {
        if (this.sonaKlassid == null || this.reeglid == null) {
            this.uuendaReegleid(this.reegliFail, true);
        } else if (this.logi != null) {
            this.kuvaSonaKlassidJaReeglid(this.logi);
        }
        if (debug) {
            LogiPidaja logi = new LogiPidaja(true);
            logi.setKirjutaLogiValjundisse(true);
            logi.setKirjutaLogiFaili(false);
            SemantikaDefinitsioon.logi = logi;
        }
        List<AjavtSona> sonad = null;
        sonad = EelTootlus.eeltootlusJSON(sisendJSON);
        if (this.mudel == null) {
            throw new Exception("Arvutusmudel maaramata!");
        }
        TuvastamisReegel.setSemanticsModel(this.mudel.getMudeliTahised());
        this.eraldaAjavaljendiKandidaadid(sonad);
        this.lahendaYlekattedAjavaljenditeVahelJaRakendaNegMustreid(sonad);
        this.liidaKorvutiseisvadAjavaljendiFraasid(sonad);
        this.eraldaAjavahemikudJaLiidaFraasiks(sonad);
        this.mudel.leiaSemantika(sonad, konehetk);
        JarelTootlus.parandaTIDvaartused(sonad, allowOnlyPureTimeML);
        return sonad;
    }

    public String tuvastaAjavaljendidPyVabamorfJSON(String konehetkStr, String sisendJSON, boolean allowOnlyPureTimeML, boolean debug) throws Exception {
        String[] konehetk = Main.prooviLuuaJSONsisendiP6hjalRefAeg(sisendJSON);
        if (konehetk == null) {
            konehetk = Main.looSonePohjalReferentsAeg(konehetkStr);
        }
        if (konehetk == null) {
            konehetk = Main.looSonePohjalReferentsAeg(null);
        }
        List<AjavtSona> tulemAjavtSonad = this.tuvastaAjavaljendidVabamorfJSON(konehetk, sisendJSON, allowOnlyPureTimeML, debug);
        return JarelTootlus.eraldamiseTulemusVabaMorfiJSON(sisendJSON, tulemAjavtSonad, JarelTootlus.formatAsCreationTime(konehetk), allowOnlyPureTimeML, false);
    }

    public void uuendaReegleid(String reegliFailiNimi, boolean kuvaDebug) throws ParserConfigurationException, SAXException, IOException {
        MustridXMLFailist mustriLugeja = new MustridXMLFailist();
        mustriLugeja.votaMustridXMLFailist(reegliFailiNimi, this);
        if (kuvaDebug) {
            this.kuvaSonaKlassidJaReeglid(this.logi);
        }
    }

    public void uuendaReegleidFromInputStream(InputStream in, boolean kuvaDebug) throws ParserConfigurationException, SAXException, IOException {
        if (in != null) {
            MustridXMLFailist mustriLugeja = new MustridXMLFailist();
            mustriLugeja.votaMustridXMLSisendvoost(in, this);
            if (kuvaDebug) {
                this.kuvaSonaKlassidJaReeglid(this.logi);
            }
        }
    }

    private void eraldaAjavaljendiKandidaadid(List<AjavtSona> sonad) throws Exception {
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            HashMap<String, MallileVastavus> kontrollitudSonaKlassid = new HashMap<String, MallileVastavus>(this.sonaKlassid.size());
            boolean onViimaneSona = i == sonad.size() - 1;
            HashMap<String, MallileVastavus> kontrollitudDummySonaKlassid = onViimaneSona || sona.onLauseLopp() ? new HashMap<String, MallileVastavus>(this.sonaKlassid.size()) : null;
            for (TuvastamisReegel reegel : this.reeglid) {
                reegel.getFraasiMuster().kontrolliMustrileVastavust(sona, kontrollitudSonaKlassid);
                if (!onViimaneSona && !sona.onLauseLopp()) continue;
                AjavtSona dummyWord = new AjavtSona("*");
                reegel.getFraasiMuster().kontrolliMustrileVastavust(dummyWord, kontrollitudDummySonaKlassid);
            }
        }
    }

    private void lahendaYlekattedAjavaljenditeVahelJaRakendaNegMustreid(List<AjavtSona> sonad) {
        for (int i = 0; i < sonad.size(); ++i) {
            AjavtSona sona = sonad.get(i);
            if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
                sona.eemaldaYlekattuvadAjavaljendiKandidaadid();
            }
            if (!sona.onSeotudMoneAjavaljendiKandidaadiga()) continue;
            List<AjavaljendiKandidaat> ajavaljendiKandidaadid = sona.getAjavaljendiKandidaadid();
            List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = sona.getAjavaljendiKandidaatides();
            for (int j = 0; j < ajavaljendiKandidaadid.size(); ++j) {
                AjavaljendiKandidaat ajavaljendiKandidaat;
                if (!ajavaljendiKandidaatides.get(j).onFraasiAlgus() || (ajavaljendiKandidaat = ajavaljendiKandidaadid.get(j)).getTuvastamisReeglid() == null) continue;
                for (TuvastamisReegel tuvastamisReegel : ajavaljendiKandidaat.getTuvastamisReeglid()) {
                    if (tuvastamisReegel.getNegMustrid() == null) continue;
                    for (NegatiivneMuster negatiivneMuster : tuvastamisReegel.getNegMustrid()) {
                        negatiivneMuster.kontrolliNegatiivsetMustritJaVajaduselEemaldaAjav(sonad, i, ajavaljendiKandidaat);
                    }
                }
            }
        }
    }

    private void liidaKorvutiseisvadAjavaljendiFraasid(List<AjavtSona> sonad) {
        if (this.liitumisReeglid != null) {
            List<LiitumisReegel> fraasiksLiitumisReeglid = this.filtreeriEtteantudAstmegaLiitumisReeglid(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
            HashMap<String, String> vabaJarjekorragaPaarid = this.eraldaLubatudTahistePaarid(fraasiksLiitumisReeglid, true);
            HashMap<String, String> fikseeritudJarjekorragaPaarid = this.eraldaLubatudTahistePaarid(fraasiksLiitumisReeglid, false);
            ArrayList<AjavtSona> liitFraas = new ArrayList<AjavtSona>();
            boolean rohkemKuiYksAjav = false;
            boolean viimaneAjavOliMitteEraldiseisev = false;
            HashMap<String, String> kasutatudTahised = new HashMap<String, String>();
            for (int i = 0; i < sonad.size(); ++i) {
                AjavtSona sona = sonad.get(i);
                if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
                    AjavaljendiKandidaat ajav;
                    List<FraasisPaiknemiseKoht> ajavaljendiFraasides = sona.getAjavaljendiKandidaatides();
                    if (ajavaljendiFraasides.size() == 1) {
                        AjavaljendiKandidaat kaesolevAjav = sona.getAjavaljendiKandidaadid().get(0);
                        if (!(liitFraas.isEmpty() || ajavaljendiFraasides.get(0) != FraasisPaiknemiseKoht.AINUSSONA && ajavaljendiFraasides.get(0) != FraasisPaiknemiseKoht.ALGUSES)) {
                            AjavaljendiKandidaat eelmineAjav = ((AjavtSona)liitFraas.get(liitFraas.size() - 1)).getAjavaljendiKandidaadid().get(0);
                            AjavtSona eelmineSona = eelmineAjav.getFraas().get(eelmineAjav.getFraas().size() - 1);
                            if (eelmineSona.onLauseLopp()) {
                                if (rohkemKuiYksAjav) {
                                    ajav = new AjavaljendiKandidaat();
                                    ajav.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                                    ajav.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(liitFraas);
                                    AjaTuvastaja.seoSonadKandidaadiKylge(ajav, liitFraas);
                                    rohkemKuiYksAjav = false;
                                } else if (viimaneAjavOliMitteEraldiseisev) {
                                    eelmineAjav.eemaldaEnnastSonadeKyljest();
                                }
                                liitFraas.clear();
                                kasutatudTahised.clear();
                                viimaneAjavOliMitteEraldiseisev = false;
                            } else {
                                boolean voibYhendada = false;
                                for (int j = 0; j < liitFraas.size(); ++j) {
                                    eelmineAjav = ((AjavtSona)liitFraas.get(j)).getAjavaljendiKandidaadid().get(0);
                                    if (!eelmineAjav.voibYhendadaMustriTahisteJargi(kaesolevAjav, vabaJarjekorragaPaarid, kasutatudTahised, false, j == liitFraas.size() - 1) && !eelmineAjav.voibYhendadaMustriTahisteJargi(kaesolevAjav, fikseeritudJarjekorragaPaarid, kasutatudTahised, true, j == liitFraas.size() - 1)) continue;
                                    voibYhendada = true;
                                }
                                if (voibYhendada) {
                                    rohkemKuiYksAjav = true;
                                } else {
                                    if (rohkemKuiYksAjav) {
                                        AjavaljendiKandidaat ajav2 = new AjavaljendiKandidaat();
                                        ajav2.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                                        ajav2.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(liitFraas);
                                        AjaTuvastaja.seoSonadKandidaadiKylge(ajav2, liitFraas);
                                        rohkemKuiYksAjav = false;
                                    } else if (viimaneAjavOliMitteEraldiseisev) {
                                        eelmineAjav = ((AjavtSona)liitFraas.get(liitFraas.size() - 1)).getAjavaljendiKandidaadid().get(0);
                                        eelmineAjav.eemaldaEnnastSonadeKyljest();
                                    }
                                    liitFraas.clear();
                                    kasutatudTahised.clear();
                                    voibYhendada = false;
                                    viimaneAjavOliMitteEraldiseisev = false;
                                }
                            }
                        }
                        viimaneAjavOliMitteEraldiseisev = kaesolevAjav.isPoleEraldiseisevAjavaljend();
                        liitFraas.add(sona);
                        continue;
                    }
                    if (rohkemKuiYksAjav) {
                        boolean voibYhendada = true;
                        AjavtSona viimaneSona = (AjavtSona)liitFraas.get(liitFraas.size() - 1);
                        List<FraasisPaiknemiseKoht> paiknemised = viimaneSona.getAjavaljendiKandidaatides();
                        for (FraasisPaiknemiseKoht fraasisPaiknemiseKoht : paiknemised) {
                            if (fraasisPaiknemiseKoht.onFraasiLopp()) continue;
                            voibYhendada = false;
                            break;
                        }
                        if (voibYhendada) {
                            ajav = new AjavaljendiKandidaat();
                            ajav.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                            ajav.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(liitFraas);
                            AjaTuvastaja.seoSonadKandidaadiKylge(ajav, liitFraas);
                        } else {
                            for (AjavtSona sonaLiitFraasis : liitFraas) {
                                AjavaljendiKandidaat eelmineAjav;
                                if (!sonaLiitFraasis.onSeotudMoneAjavaljendiKandidaadiga() || !(eelmineAjav = sonaLiitFraasis.getAjavaljendiKandidaadid().get(0)).isPoleEraldiseisevAjavaljend()) continue;
                                eelmineAjav.eemaldaEnnastSonadeKyljest();
                            }
                        }
                        rohkemKuiYksAjav = false;
                    } else if (viimaneAjavOliMitteEraldiseisev && !liitFraas.isEmpty()) {
                        AjavaljendiKandidaat eelmineAjav = ((AjavtSona)liitFraas.get(liitFraas.size() - 1)).getAjavaljendiKandidaadid().get(0);
                        eelmineAjav.eemaldaEnnastSonadeKyljest();
                    }
                    liitFraas.clear();
                    kasutatudTahised.clear();
                    viimaneAjavOliMitteEraldiseisev = false;
                    continue;
                }
                if (rohkemKuiYksAjav) {
                    AjavaljendiKandidaat ajav = new AjavaljendiKandidaat();
                    ajav.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                    ajav.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(liitFraas);
                    AjaTuvastaja.seoSonadKandidaadiKylge(ajav, liitFraas);
                    rohkemKuiYksAjav = false;
                } else if (viimaneAjavOliMitteEraldiseisev && !liitFraas.isEmpty()) {
                    AjavaljendiKandidaat eelmineAjav = ((AjavtSona)liitFraas.get(liitFraas.size() - 1)).getAjavaljendiKandidaadid().get(0);
                    eelmineAjav.eemaldaEnnastSonadeKyljest();
                }
                liitFraas.clear();
                kasutatudTahised.clear();
                viimaneAjavOliMitteEraldiseisev = false;
            }
            if (rohkemKuiYksAjav) {
                AjavaljendiKandidaat ajav = new AjavaljendiKandidaat();
                ajav.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                ajav.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(liitFraas);
                AjaTuvastaja.seoSonadKandidaadiKylge(ajav, liitFraas);
                rohkemKuiYksAjav = false;
                viimaneAjavOliMitteEraldiseisev = false;
            } else if (viimaneAjavOliMitteEraldiseisev && !liitFraas.isEmpty()) {
                AjavaljendiKandidaat eelmineAjav = ((AjavtSona)liitFraas.get(liitFraas.size() - 1)).getAjavaljendiKandidaadid().get(0);
                eelmineAjav.eemaldaEnnastSonadeKyljest();
            }
        }
    }

    private void eraldaAjavahemikudJaLiidaFraasiks(List<AjavtSona> sonad) {
        HashMap<String, String> addedFromLocation = new HashMap<String, String>();
        int murdePunkt = -1;
        boolean murdePunktOnInklusiivne = false;
        for (int i = 0; i < sonad.size(); ++i) {
            int eelnevaSonaIndex;
            if (addedFromLocation.containsKey(String.valueOf(i))) continue;
            AjavtSona sona = sonad.get(i);
            boolean onKuniSonanaVoiKriips = musterKuniSonaVoiMark.matcher(sona.getAlgSonaErisymbolidNormaliseeritud()).matches();
            if ((!sona.isOnPotentsiaalneVahemikuAlgus() || sona.onLauseLopp()) && (!onKuniSonanaVoiKriips || sona.onLauseLopp()) || !onKuniSonanaVoiKriips && AjaTuvastaja.teeKindlaksSonaKuuluvus(sona) == 0) continue;
            murdePunktOnInklusiivne = !onKuniSonanaVoiKriips;
            LinkedList<AjavtSona> uusFraas = new LinkedList<AjavtSona>();
            if (onKuniSonanaVoiKriips) {
                uusFraas.add(sona);
            }
            int lopuPikkus = 0;
            int lopuKuuluvus = 0;
            if (i + 1 < sonad.size()) {
                AjavtSona jargmSona = sonad.get(i + 1);
                lopuKuuluvus = AjaTuvastaja.teeKindlaksSonaKuuluvus(jargmSona);
                if (lopuKuuluvus >= ON_LEITUD_AJAVALJEND) {
                    MutableInteger fraasiLoplikKuuluvus = new MutableInteger(lopuKuuluvus);
                    boolean lisamineOnnestus = AjaTuvastaja.koguKokkuJaLisaAjavaljendKonstrueeritavvaFraasi(uusFraas, jargmSona, true, fraasiLoplikKuuluvus);
                    lopuKuuluvus = lisamineOnnestus ? fraasiLoplikKuuluvus.getInteger() : 0;
                } else if (lopuKuuluvus > 0) {
                    boolean lisamineOnnestus = AjaTuvastaja.koguKokkuJaLisaArvKonstrueeritavvaFraasi(uusFraas, sonad, addedFromLocation, i + 1, true);
                    lopuKuuluvus = lisamineOnnestus ? lopuKuuluvus : 0;
                }
                int n = lopuPikkus = !murdePunktOnInklusiivne ? uusFraas.size() : uusFraas.size() + 1;
            }
            if (lopuKuuluvus == 0) continue;
            int alguseKuuluvus = 0;
            int n = eelnevaSonaIndex = onKuniSonanaVoiKriips ? i - 1 : i;
            if (eelnevaSonaIndex > -1) {
                AjavtSona eelnvSona = sonad.get(eelnevaSonaIndex);
                alguseKuuluvus = AjaTuvastaja.teeKindlaksSonaKuuluvus(eelnvSona);
                if (alguseKuuluvus >= ON_LEITUD_AJAVALJEND) {
                    MutableInteger fraasiLoplikKuuluvus = new MutableInteger(alguseKuuluvus);
                    boolean lisamineOnnestus = AjaTuvastaja.koguKokkuJaLisaAjavaljendKonstrueeritavvaFraasi(uusFraas, eelnvSona, false, fraasiLoplikKuuluvus);
                    alguseKuuluvus = lisamineOnnestus ? fraasiLoplikKuuluvus.getInteger() : 0;
                } else if (alguseKuuluvus > 0) {
                    boolean lisamineOnnestus = AjaTuvastaja.koguKokkuJaLisaArvKonstrueeritavvaFraasi(uusFraas, sonad, addedFromLocation, eelnevaSonaIndex, false);
                    alguseKuuluvus = lisamineOnnestus ? alguseKuuluvus : 0;
                }
                murdePunkt = uusFraas.size() - lopuPikkus;
            }
            if (alguseKuuluvus == 0 || alguseKuuluvus < ON_LEITUD_AJAVALJEND && lopuKuuluvus < ON_LEITUD_AJAVALJEND) continue;
            if (alguseKuuluvus == ON_LEITUD_AJAVALJEND && lopuKuuluvus == ON_LEITUD_AJAVALJEND) {
                int tunnuseidLeitud = 0;
                for (AjavtSona ajavtSona : uusFraas) {
                    if (ajavtSona.isOnPotentsiaalneVahemikuAlgus() && tunnuseidLeitud == 0) {
                        ++tunnuseidLeitud;
                    }
                    if (!ajavtSona.isOnPotentsiaalneVahemikuLopp() || tunnuseidLeitud != 1) continue;
                    ++tunnuseidLeitud;
                }
                if (tunnuseidLeitud != 2) continue;
            }
            AjavaljendiKandidaat ajav = new AjavaljendiKandidaat();
            ajav.setAste(AjavaljendiKandidaat.ASTE.YHENDATUD_VAHEMIKUNA);
            ajav.votaAntudSonadegaSeotudKandidaadidAlamkandidaatideks(uusFraas);
            AjaTuvastaja.seoSonadKandidaadiKylge(ajav, uusFraas);
            if (0 <= murdePunkt && murdePunkt < uusFraas.size()) {
                ajav.setPoolitus(murdePunkt, murdePunktOnInklusiivne);
            }
            addedFromLocation.put(String.valueOf(i), "added");
            murdePunkt = -1;
            murdePunktOnInklusiivne = false;
        }
    }

    private static int teeKindlaksSonaKuuluvus(AjavtSona sona) {
        if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
            return musterNumbrikombinatsioon.matcher(sona.getAlgSonaErisymbolidNormaliseeritud()).matches() ? ON_AJAVALJEND_NUMBRIKOMBINATSIOON : ON_LEITUD_AJAVALJEND;
        }
        if (sona.getArvSonaFraasis() != FraasisPaiknemiseKoht.PUUDUB) {
            return ON_ARVSONAFRAAS;
        }
        if (musterNumbrikombinatsioon.matcher(sona.getAlgSonaErisymbolidNormaliseeritud()).matches()) {
            return ON_NUMBRIKOMBINATSIOON;
        }
        return 0;
    }

    private static boolean koguKokkuJaLisaAjavaljendKonstrueeritavvaFraasi(LinkedList<AjavtSona> uusFraas, AjavtSona sona, boolean lisaLoppu, MutableInteger fraasiKuuluvus) {
        if (sona.onSeotudMoneAjavaljendiKandidaadiga()) {
            List<FraasisPaiknemiseKoht> paiknemisKohad = sona.getAjavaljendiKandidaatides();
            List<AjavaljendiKandidaat> ajavaljendiKandidaadid = sona.getAjavaljendiKandidaadid();
            for (int i = paiknemisKohad.size() - 1; i > -1; --i) {
                AjavtSona ajavtSona;
                int j;
                FraasisPaiknemiseKoht kohtFraasis = paiknemisKohad.get(i);
                AjavaljendiKandidaat ajavaljendiKandidaat = ajavaljendiKandidaadid.get(i);
                if (lisaLoppu) {
                    AjavtSona ajavtSona2;
                    int j2;
                    if (!kohtFraasis.onFraasiAlgus()) continue;
                    List<AjavtSona> fraas1 = ajavaljendiKandidaat.getFraas();
                    for (j2 = 0; j2 < fraas1.size(); ++j2) {
                        ajavtSona2 = fraas1.get(j2);
                        if (!ajavtSona2.onLauseLopp() || j2 >= fraas1.size() - 1) continue;
                        return false;
                    }
                    for (j2 = 0; j2 < fraas1.size(); ++j2) {
                        ajavtSona2 = fraas1.get(j2);
                        if (AjaTuvastaja.teeKindlaksSonaKuuluvus(ajavtSona2) == ON_LEITUD_AJAVALJEND) {
                            fraasiKuuluvus.setInteger(ON_LEITUD_AJAVALJEND);
                        }
                        uusFraas.addLast(ajavtSona2);
                    }
                    return true;
                }
                if (!kohtFraasis.onFraasiLopp()) continue;
                List<AjavtSona> fraas1 = ajavaljendiKandidaat.getFraas();
                for (j = fraas1.size() - 1; j > -1; --j) {
                    ajavtSona = fraas1.get(j);
                    if (!ajavtSona.onLauseLopp()) continue;
                    return false;
                }
                for (j = fraas1.size() - 1; j > -1; --j) {
                    ajavtSona = fraas1.get(j);
                    uusFraas.addFirst(ajavtSona);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean koguKokkuJaLisaArvKonstrueeritavvaFraasi(LinkedList<AjavtSona> uusFraas, List<AjavtSona> sonad, HashMap<String, String> addedFromLocation, int currentWordIndex, boolean lisaLoppu) {
        int eelmineKuuluvus = -1;
        boolean addingWasSuccessful = false;
        for (int i = currentWordIndex; 0 <= i && i < sonad.size(); i += lisaLoppu ? 1 : -1) {
            if (addedFromLocation.containsKey(String.valueOf(i))) {
                return addingWasSuccessful;
            }
            AjavtSona ajavtSona = sonad.get(i);
            if (ajavtSona.onLauseLopp() && !lisaLoppu) {
                return addingWasSuccessful;
            }
            int sonaKuuluvus = AjaTuvastaja.teeKindlaksSonaKuuluvus(ajavtSona);
            if (eelmineKuuluvus == -1 || sonaKuuluvus != 0 && sonaKuuluvus == eelmineKuuluvus) {
                if (sonaKuuluvus == ON_ARVSONAFRAAS && eelmineKuuluvus == -1) {
                    FraasisPaiknemiseKoht arvSonaFraasis = ajavtSona.getArvSonaFraasis();
                    if (lisaLoppu && !arvSonaFraasis.onFraasiAlgus()) {
                        return addingWasSuccessful;
                    }
                    if (!lisaLoppu && !arvSonaFraasis.onFraasiLopp()) {
                        return addingWasSuccessful;
                    }
                }
                if (lisaLoppu) {
                    uusFraas.addLast(ajavtSona);
                } else {
                    uusFraas.addFirst(ajavtSona);
                }
            } else {
                return addingWasSuccessful;
            }
            addingWasSuccessful = true;
            if (ajavtSona.onLauseLopp()) {
                return addingWasSuccessful;
            }
            eelmineKuuluvus = sonaKuuluvus;
        }
        return addingWasSuccessful;
    }

    public void kuvaSonaKlassidJaReeglid(LogiPidaja logi) {
        if (logi != null) {
            Set<String> keys = this.sonaKlassid.keySet();
            logi.println("=============================");
            logi.println("   SonaKlassid (" + keys.size() + ")");
            logi.println("=============================");
            for (String string : keys) {
                if (!this.sonaKlassid.containsKey(string)) continue;
                logi.println(string + " = ");
                SonaKlass klass = this.sonaKlassid.get(string);
                for (SonaMall mall : klass.getElemendid()) {
                    logi.println("     " + mall.toString());
                }
            }
            logi.println();
            logi.println("=============================");
            logi.println("   Reeglid (" + this.reeglid.size() + ")");
            logi.println("=============================");
            for (TuvastamisReegel tuvastamisReegel : this.reeglid) {
                logi.println(" " + tuvastamisReegel);
                if (tuvastamisReegel.getNegMustrid() == null) continue;
                for (NegatiivneMuster negMuster : tuvastamisReegel.getNegMustrid()) {
                    logi.println("   " + negMuster.toString());
                }
            }
            logi.println();
            if (this.liitumisReeglid != null) {
                logi.println("=============================");
                logi.println("   LiitumisReeglid (" + this.liitumisReeglid.size() + ")");
                logi.println("=============================");
                for (LiitumisReegel liitumisReegel : this.liitumisReeglid) {
                    logi.println(" " + liitumisReegel);
                }
            }
            logi.println();
        }
    }

    private List<LiitumisReegel> filtreeriEtteantudAstmegaLiitumisReeglid(AjavaljendiKandidaat.ASTE aste) {
        ArrayList<LiitumisReegel> liitumisReegliteAlamHulk = new ArrayList<LiitumisReegel>(this.liitumisReeglid);
        Iterator iteraator = liitumisReegliteAlamHulk.iterator();
        while (iteraator.hasNext()) {
            LiitumisReegel liitumisReegel = (LiitumisReegel)iteraator.next();
            if (liitumisReegel.getYhendamiseAste() == aste) continue;
            iteraator.remove();
        }
        return liitumisReegliteAlamHulk;
    }

    private HashMap<String, String> eraldaLubatudTahistePaarid(List<LiitumisReegel> sisendLiitumisReegelid, boolean eraldaVabaJarjekorragaTahised) {
        HashMap<String, String> tahistePaarid = new HashMap<String, String>();
        for (LiitumisReegel liitumisReegel : sisendLiitumisReegelid) {
            String v6ti;
            String[] mustriTahised;
            if (!liitumisReegel.onFikseeritudJarjekord() && eraldaVabaJarjekorragaTahised) {
                mustriTahised = liitumisReegel.getMustriTahised();
                v6ti = TextUtils.looMustriTahisteVoti(Arrays.asList(mustriTahised), true);
                if (v6ti == null || v6ti.length() <= 0) continue;
                if (liitumisReegel.isTapseltKorvuti()) {
                    tahistePaarid.put(v6ti, "TK");
                    continue;
                }
                tahistePaarid.put(v6ti, "1");
                continue;
            }
            if (!liitumisReegel.onFikseeritudJarjekord() || eraldaVabaJarjekorragaTahised || (v6ti = TextUtils.looMustriTahisteVoti(Arrays.asList(mustriTahised = liitumisReegel.getMustriTahised()), false)) == null || v6ti.length() <= 0) continue;
            if (liitumisReegel.isTapseltKorvuti()) {
                tahistePaarid.put(v6ti, "TK");
                continue;
            }
            tahistePaarid.put(v6ti, "1");
        }
        return tahistePaarid;
    }

    public String getReegliFail() {
        return this.reegliFail;
    }

    public void setReegliFail(String reegliFail) {
        this.reegliFail = reegliFail;
    }

    public void setLogi(LogiPidaja logi) {
        this.logi = logi;
    }

    public HashMap<String, SonaKlass> getSonaKlassid() {
        return this.sonaKlassid;
    }

    public void setSonaKlassid(HashMap<String, SonaKlass> sonaKlassid) {
        this.sonaKlassid = sonaKlassid;
    }

    public List<LiitumisReegel> getLiitumisReeglid() {
        return this.liitumisReeglid;
    }

    public void setLiitumisReeglid(List<LiitumisReegel> liitumisReeglid) {
        this.liitumisReeglid = liitumisReeglid;
    }

    public List<TuvastamisReegel> getReeglid() {
        return this.reeglid;
    }

    public void setReeglid(List<TuvastamisReegel> reeglid) {
        this.reeglid = reeglid;
    }

    public static String getVersioon() {
        return versioon;
    }

    public EstyhmmWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(EstyhmmWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public SemLeidmiseMudel getMudel() {
        return this.mudel;
    }

    public void setMudel(SemLeidmiseMudel mudel) {
        this.mudel = mudel;
    }

    public static void seoSonadKandidaadiKylge(AjavaljendiKandidaat ajav, List<AjavtSona> eraldatudSonad) {
        for (int i = 0; i < eraldatudSonad.size(); ++i) {
            FraasisPaiknemiseKoht koht = FraasisPaiknemiseKoht.AINUSSONA;
            if (eraldatudSonad.size() > 1) {
                koht = i == 0 ? FraasisPaiknemiseKoht.ALGUSES : (i == eraldatudSonad.size() - 1 ? FraasisPaiknemiseKoht.LOPUS : FraasisPaiknemiseKoht.KESKEL);
            }
            ajav.lisaFraasiUusSona(eraldatudSonad.get(i), koht);
        }
    }

    class MutableInteger {
        private int integer = Integer.MIN_VALUE;

        MutableInteger(int integer) {
            this.integer = integer;
        }

        public int getInteger() {
            return this.integer;
        }

        public void setInteger(int integer) {
            this.integer = integer;
        }
    }
}

