/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.arvutus.TimeMLDateTimePoint;
import ee.ut.soras.ajavtV2.util.TextUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.joda.time.Period;

public class SemDefValjadeParsija {
    private static final String LABEL_VERBI_AEG = "VERBI_AEG";

    public static FORMAT_OF_VALUE detectFormatOfValue(String value) {
        if (value != null) {
            if (value.matches("^(-|\\+)?[0-9]+$")) {
                return FORMAT_OF_VALUE.INTEGER;
            }
            if (value.matches("^([0-9][0-9])(:|\\.)([0-9][0-9])$")) {
                return FORMAT_OF_VALUE.DATE_OR_TIME;
            }
            if (value.matches("^([0-9][0-9])(:|\\.)([0-9][0-9])-([0-9][0-9])(:|\\.)([0-9][0-9])$")) {
                return FORMAT_OF_VALUE.DATE_OR_TIME_INTERVAL;
            }
            if (value.matches("^([A-Z_]+)$")) {
                return FORMAT_OF_VALUE.CONSTANT;
            }
            if (value.matches("^([A-Z_]+)-([A-Z_]+)$")) {
                return FORMAT_OF_VALUE.CONSTANTS_INTERVAL;
            }
            if (value.matches("^PARSE_FROM_SELF:([0-9.]+)$")) {
                return FORMAT_OF_VALUE.PARSE_FROM_SELF;
            }
            if (value.matches("^PARSE_FROM_NUMERAL:([0-9.]+)$")) {
                return FORMAT_OF_VALUE.PARSE_FROM_NUMERAL;
            }
            if (value.matches("^REF_VAL:([A-Z_][A-Z0-9_]+)$")) {
                return FORMAT_OF_VALUE.REF_TO_VAL;
            }
            if (value.matches("^REF_LAB:([A-Z_][A-Z0-9_]+)$")) {
                return FORMAT_OF_VALUE.REF_TO_LAB;
            }
            if (value.matches("^(-|\\+)?[0-9]+,[0-9]+$")) {
                return FORMAT_OF_VALUE.FRACTION;
            }
        }
        return FORMAT_OF_VALUE.UNSET;
    }

    public static int parseValueFromConstant(String dateTimeConstant) {
        if (dateTimeConstant.equals("AM")) {
            return 0;
        }
        if (dateTimeConstant.equals("PM")) {
            return 1;
        }
        if (dateTimeConstant.equals("MONDAY")) {
            return 1;
        }
        if (dateTimeConstant.equals("TUESDAY")) {
            return 2;
        }
        if (dateTimeConstant.equals("WEDNESDAY")) {
            return 3;
        }
        if (dateTimeConstant.equals("THURSDAY")) {
            return 4;
        }
        if (dateTimeConstant.equals("FRIDAY")) {
            return 5;
        }
        if (dateTimeConstant.equals("SATURDAY")) {
            return 6;
        }
        if (dateTimeConstant.equals("SUNDAY")) {
            return 7;
        }
        if (dateTimeConstant.equals("JANUARY")) {
            return 1;
        }
        if (dateTimeConstant.equals("FEBRUARY")) {
            return 2;
        }
        if (dateTimeConstant.equals("MARCH")) {
            return 3;
        }
        if (dateTimeConstant.equals("APRIL")) {
            return 4;
        }
        if (dateTimeConstant.equals("MAY")) {
            return 5;
        }
        if (dateTimeConstant.equals("JUNE")) {
            return 6;
        }
        if (dateTimeConstant.equals("JULY")) {
            return 7;
        }
        if (dateTimeConstant.equals("AUGUST")) {
            return 8;
        }
        if (dateTimeConstant.equals("SEPTEMBER")) {
            return 9;
        }
        if (dateTimeConstant.equals("OCTOBER")) {
            return 10;
        }
        if (dateTimeConstant.equals("NOVEMBER")) {
            return 11;
        }
        if (dateTimeConstant.equals("DECEMBER")) {
            return 12;
        }
        return Integer.MIN_VALUE;
    }

    public static List<SemantikaDefinitsioon> kirjutaLahtiSemantikadefinitsioon(SemantikaDefinitsioon semDef, FORMAT_OF_VALUE formatOfValue) {
        String[] parts;
        LinkedList<SemantikaDefinitsioon> newSemDefs = new LinkedList<SemantikaDefinitsioon>();
        if (!(semDef.getOp() != null && semDef.onSET_attrib("value") || formatOfValue != FORMAT_OF_VALUE.CONSTANTS_INTERVAL && formatOfValue != FORMAT_OF_VALUE.DATE_OR_TIME_INTERVAL || (parts = semDef.getSemValue().split("-")).length != 2)) {
            SemantikaDefinitsioon semDef2 = semDef.clone();
            SemDefValjadeParsija.addSimpleOpp(SemantikaDefinitsioon.OP.CREATE_beginPoint.toString(), semDef.getPriority(), newSemDefs);
            semDef.setSemValue(parts[0]);
            newSemDefs.addAll(SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semDef, SemDefValjadeParsija.detectFormatOfValue(semDef.getSemValue())));
            SemDefValjadeParsija.addSimpleOpp(SemantikaDefinitsioon.OP.CREATE_endPoint.toString(), semDef.getPriority(), newSemDefs);
            semDef2.setSemValue(parts[1]);
            newSemDefs.addAll(SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semDef2, SemDefValjadeParsija.detectFormatOfValue(semDef2.getSemValue())));
            return newSemDefs;
        }
        if (semDef.getGranulaarsus() == Granulaarsus.HOUR_OF_DAY) {
            try {
                int hourOfDayInt = Integer.parseInt(semDef.getSemValue());
                semDef.setGranulaarsus(Granulaarsus.HOUR_OF_HALF_DAY);
                SemantikaDefinitsioon semDef2 = semDef.clone();
                semDef2.setGranulaarsus(Granulaarsus.AM_PM);
                if (hourOfDayInt == 0 || hourOfDayInt == 24) {
                    semDef.setSemValue("0");
                    semDef2.setSemValue("AM");
                } else if (hourOfDayInt == 12) {
                    semDef.setSemValue("0");
                    semDef2.setSemValue("PM");
                } else if (hourOfDayInt < 13) {
                    semDef2.setSemValue("AM");
                } else if (hourOfDayInt > 12) {
                    semDef.setSemValue(String.valueOf(hourOfDayInt - 12));
                    semDef2.setSemValue("PM");
                }
                newSemDefs.add(semDef2);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            newSemDefs.add(semDef);
            return newSemDefs;
        }
        if (formatOfValue == FORMAT_OF_VALUE.DATE_OR_TIME) {
            if (semDef.getGranulaarsus() == Granulaarsus.TIME && (parts = semDef.getSemValue().split("(\\.|:)")).length == 2) {
                try {
                    int hourOfDay = Integer.parseInt(parts[0]);
                    int minOfHour = Integer.parseInt(parts[1]);
                    SemantikaDefinitsioon semDef2 = semDef.clone();
                    semDef.setGranulaarsus(Granulaarsus.HOUR_OF_DAY);
                    semDef.setSemValue(String.valueOf(hourOfDay));
                    newSemDefs.addAll(SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semDef, SemDefValjadeParsija.detectFormatOfValue(semDef.getSemValue())));
                    semDef2.setGranulaarsus(Granulaarsus.MINUTE);
                    semDef2.setSemValue(String.valueOf(minOfHour));
                    newSemDefs.add(semDef2);
                    return newSemDefs;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (semDef.getGranulaarsus() == Granulaarsus.DATE && (parts = semDef.getSemValue().split("(\\.|:)")).length == 2) {
                try {
                    int dayOfMonth = Integer.parseInt(parts[0]);
                    int month = Integer.parseInt(parts[1]);
                    SemantikaDefinitsioon semDef2 = semDef.clone();
                    semDef.setGranulaarsus(Granulaarsus.MONTH);
                    semDef.setSemValue(String.valueOf(month));
                    newSemDefs.add(semDef);
                    semDef2.setGranulaarsus(Granulaarsus.DAY_OF_MONTH);
                    semDef2.setSemValue(String.valueOf(dayOfMonth));
                    newSemDefs.add(semDef2);
                    return newSemDefs;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        newSemDefs.add(semDef);
        return newSemDefs;
    }

    private static void addSimpleOpp(String op, String priority, List<SemantikaDefinitsioon> semDefs) {
        SemantikaDefinitsioon semDef = new SemantikaDefinitsioon();
        semDef.setPriority(priority);
        semDef.setOp(op);
        semDefs.add(semDef);
    }

    public static void parsiN6utudJaKeelatudTunnused(SemantikaDefinitsioon.CONTEXT prefiks, String kontekstStr, List<String> n6utudTunnused, List<String> keelatudTunnused) {
        String[] allListedElements;
        if (prefiks != null) {
            kontekstStr = kontekstStr.replaceAll(prefiks.toString() + ":?", "");
        }
        if ((allListedElements = kontekstStr.split(",")).length > 0) {
            for (int i = 0; i < allListedElements.length; ++i) {
                String element = TextUtils.trim(allListedElements[i]);
                if (!element.startsWith("^")) {
                    if (n6utudTunnused == null) continue;
                    n6utudTunnused.add(element);
                    continue;
                }
                if (keelatudTunnused == null) continue;
                keelatudTunnused.add(element.replaceAll("\\^", ""));
            }
        }
    }

    public static int parseSeekDirection(String direction, AjavtSona lahimVerb) {
        int dirAsInteger = Integer.MIN_VALUE;
        if (direction.equals(LABEL_VERBI_AEG)) {
            if (lahimVerb != null && lahimVerb.getGrammatilineAeg() != AjavtSona.GRAMMATILINE_AEG.MAARAMATA) {
                if (lahimVerb.getGrammatilineAeg() == AjavtSona.GRAMMATILINE_AEG.OLEVIK || lahimVerb.getGrammatilineAeg() == AjavtSona.GRAMMATILINE_AEG.KS_OLEVIK) {
                    return 1;
                }
                return -1;
            }
        } else {
            String withOutPlus = direction.replace("+", "");
            try {
                dirAsInteger = Integer.parseInt(withOutPlus);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return dirAsInteger;
    }

    public static boolean fookusaegRahuldabSeotudKontekstiTingimusi(String kontekstStr, String[] aegFookuses) {
        boolean eitus = kontekstStr.startsWith("^");
        String[] allListedElements = (kontekstStr = kontekstStr.replaceAll("^[^:]+:", "")).split(",");
        if (allListedElements.length == 2 && aegFookuses.length == TimeMLDateTimePoint.valueFieldsInOrder.length) {
            String gran = TextUtils.trim(allListedElements[0]);
            String condition = TextUtils.trim(allListedElements[1]);
            Granulaarsus g = Granulaarsus.getGranulaarsus(gran);
            try {
                Pattern p = Pattern.compile(condition);
                if (g != null && p != null) {
                    for (Granulaarsus granulaarsus : Granulaarsus.fieldsInSafeOrder) {
                        if (g.compareByCoarseRank(granulaarsus) != 1) continue;
                        for (int i = 0; i < TimeMLDateTimePoint.valueFieldsInOrder.length; ++i) {
                            TimeMLDateTimePoint.VALUE_FIELD field = TimeMLDateTimePoint.valueFieldsInOrder[i];
                            if (!field.matchesGranularity(granulaarsus)) continue;
                            return eitus ^ p.matcher(aegFookuses[i]).matches();
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return eitus ^ false;
    }

    public static Object[] parsiMurdarvulineAjakvantiteetPerioodiks(Granulaarsus field, double murdarvuline) {
        Period periood = new Period();
        String modifier = null;
        int[] taisArvuOsaJaMurdArvuOsa = SemDefValjadeParsija.separateIntegerPartAndFloatingPart(murdarvuline);
        if (field == Granulaarsus.MINUTE) {
            try {
                periood = periood.plusMinutes(taisArvuOsaJaMurdArvuOsa[0]);
            }
            catch (Exception e) {}
        } else if (field == Granulaarsus.HOUR_OF_HALF_DAY || field == Granulaarsus.HOUR_OF_DAY) {
            try {
                periood = periood.plusMinutes(taisArvuOsaJaMurdArvuOsa[1] * 60 / 100);
                periood = periood.plusHours(taisArvuOsaJaMurdArvuOsa[0]);
            }
            catch (Exception e) {}
        } else if (field == Granulaarsus.DAY_OF_WEEK || field == Granulaarsus.DAY_OF_MONTH) {
            try {
                periood = periood.plusHours(taisArvuOsaJaMurdArvuOsa[1] * 24 / 100);
                periood = periood.plusDays(taisArvuOsaJaMurdArvuOsa[0]);
            }
            catch (Exception e) {}
        } else if (field == Granulaarsus.WEEK_OF_YEAR) {
            try {
                periood = periood.plusDays(taisArvuOsaJaMurdArvuOsa[1] * 7 / 100);
                periood = periood.plusWeeks(taisArvuOsaJaMurdArvuOsa[0]);
            }
            catch (Exception e) {}
        } else if (field == Granulaarsus.MONTH) {
            try {
                periood = periood.plusDays(taisArvuOsaJaMurdArvuOsa[1] * 30 / 100);
                periood = periood.plusMonths(taisArvuOsaJaMurdArvuOsa[0]);
                modifier = "APPROX";
            }
            catch (Exception e) {}
        } else if (field == Granulaarsus.YEAR) {
            try {
                periood = periood.plusMonths(taisArvuOsaJaMurdArvuOsa[1] * 12 / 100);
                periood = periood.plusYears(taisArvuOsaJaMurdArvuOsa[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (field == Granulaarsus.CENTURY_OF_ERA) {
            try {
                periood = periood.plusYears(taisArvuOsaJaMurdArvuOsa[1]);
                periood = periood.plusYears(taisArvuOsaJaMurdArvuOsa[0] * 100);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Object[] tagastatav = null;
        tagastatav = modifier != null ? new Object[]{periood, modifier} : new Object[]{periood};
        return tagastatav;
    }

    public static String[] parsiMurdarvulineAjakvantiteetS6neks(Granulaarsus granulaarsus, String value) {
        try {
            float f = Float.parseFloat(value.replaceAll(",", "."));
            Object[] perioodJaMOD = SemDefValjadeParsija.parsiMurdarvulineAjakvantiteetPerioodiks(granulaarsus, f);
            if (perioodJaMOD != null && perioodJaMOD[0] != null) {
                String[] returnable = null;
                returnable = perioodJaMOD.length == 2 ? new String[]{((Period)perioodJaMOD[0]).toString(), (String)perioodJaMOD[1]} : new String[]{((Period)perioodJaMOD[0]).toString()};
                return returnable;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static int[] separateIntegerPartAndFloatingPart(double value) {
        int[] parts = new int[]{(int)value, (int)((value - (double)((int)value)) * 100.0)};
        return parts;
    }

    public static enum FORMAT_OF_VALUE {
        PARSE_FROM_SELF,
        PARSE_FROM_NUMERAL,
        INTEGER,
        FRACTION,
        DATE_OR_TIME,
        DATE_OR_TIME_INTERVAL,
        CONSTANT,
        CONSTANTS_INTERVAL,
        REF_TO_VAL,
        REF_TO_LAB,
        UNSET;

    }
}

