/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.impl;

import ee.ut.soras.wrappers.mudel.MorfAnRida;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.json.Json;
import javax.json.stream.JsonParser;

public class VabaMorfJSONReader {
    public static List<MorfAnSona> parseJSONtext(BufferedReader input) throws Exception {
        ArrayList<MorfAnSona> tulemused = new ArrayList<MorfAnSona>();
        Stack<String> jsonKeyPath = new Stack<String>();
        JsonParser.Event lastEvent = null;
        String lastString = "";
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        ArrayList<MorfAnRida> analyysiRead = new ArrayList<MorfAnRida>();
        String tokenText = null;
        JsonParser parser = Json.createParser(input);
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_ARRAY: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonKeyPath.push(lastString);
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_ARRAY: {
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words") && !tulemused.isEmpty()) {
                        ((MorfAnSona)tulemused.get(tulemused.size() - 1)).setOnLauseLopp(true);
                    }
                    lastEvent = event;
                    lastString = "";
                    jsonKeyPath.pop();
                    break;
                }
                case START_OBJECT: {
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("analysis")) {
                        keyValuePairs.clear();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_OBJECT: {
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words")) {
                        if (tokenText == null) {
                            throw new Exception(" Unable to find text form for a word ...");
                        }
                        MorfAnSona sona = new MorfAnSona(tokenText);
                        for (MorfAnRida morfAnRida : analyysiRead) {
                            sona.lisaAnalyysiRida(morfAnRida);
                        }
                        tulemused.add(sona);
                        sona.setTokenPosition(tulemused.size());
                        tokenText = null;
                        analyysiRead.clear();
                    }
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("analysis")) {
                        MorfAnRida analyysirida = new MorfAnRida(keyValuePairs);
                        analyysiRead.add(analyysirida);
                        keyValuePairs.clear();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: 
                case VALUE_TRUE: {
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case KEY_NAME: {
                    lastEvent = event;
                    lastString = parser.getString();
                    break;
                }
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    keyValuePairs.add(lastString);
                    keyValuePairs.add(parser.getString());
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words") && lastString != null && lastString.equals("text")) {
                        tokenText = parser.getString();
                    }
                    lastEvent = event;
                    lastString = parser.getString();
                }
            }
        }
        return tulemused;
    }

    static String debugPrintPath(Stack<String> path) {
        String s = "";
        for (int i = 0; i < path.size(); ++i) {
            s = s + " " + (String)path.get(i);
        }
        return s;
    }
}

