import { Construct } from '../construct-compat';
import { Stack } from '../stack';
/**
 * Construct that will render the metadata resource
 */
export declare class MetadataResource extends Construct {
    /**
     * Clear the modules cache
     *
     * The next time the MetadataResource is rendered, it will do a lookup of the
     * modules from the NodeJS module cache again.
     *
     * Used only for unit tests.
     */
    static clearModulesCache(): void;
    /**
     * Cached version of the _modulesProperty() accessor
     *
     * No point in calculating this fairly expensive list more than once.
     */
    private static _modulesPropertyCache?;
    /**
     * Calculate the modules property
     */
    private static modulesProperty;
    constructor(scope: Stack, id: string);
}
