import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CostManagementExportResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#active CostManagementExportResourceGroup#active}.
     *
     * @stability stable
     */
    readonly active?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#name CostManagementExportResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#recurrence_period_end CostManagementExportResourceGroup#recurrence_period_end}.
     *
     * @stability stable
     */
    readonly recurrencePeriodEnd: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#recurrence_period_start CostManagementExportResourceGroup#recurrence_period_start}.
     *
     * @stability stable
     */
    readonly recurrencePeriodStart: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#recurrence_type CostManagementExportResourceGroup#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#resource_group_id CostManagementExportResourceGroup#resource_group_id}.
     *
     * @stability stable
     */
    readonly resourceGroupId: string;
    /**
     * delivery_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#delivery_info CostManagementExportResourceGroup#delivery_info}
     *
     * @stability stable
     */
    readonly deliveryInfo: CostManagementExportResourceGroupDeliveryInfo;
    /**
     * query block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#query CostManagementExportResourceGroup#query}
     *
     * @stability stable
     */
    readonly query: CostManagementExportResourceGroupQuery;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#timeouts CostManagementExportResourceGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CostManagementExportResourceGroupTimeouts;
}
/**
 * @stability stable
 */
export interface CostManagementExportResourceGroupDeliveryInfo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#container_name CostManagementExportResourceGroup#container_name}.
     *
     * @stability stable
     */
    readonly containerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#root_folder_path CostManagementExportResourceGroup#root_folder_path}.
     *
     * @stability stable
     */
    readonly rootFolderPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#storage_account_id CostManagementExportResourceGroup#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
}
export declare function costManagementExportResourceGroupDeliveryInfoToTerraform(struct?: CostManagementExportResourceGroupDeliveryInfoOutputReference | CostManagementExportResourceGroupDeliveryInfo): any;
/**
 * @stability stable
 */
export declare class CostManagementExportResourceGroupDeliveryInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CostManagementExportResourceGroupDeliveryInfo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CostManagementExportResourceGroupDeliveryInfo | undefined);
    private _containerName?;
    /**
     * @stability stable
     */
    get containerName(): string;
    /**
     * @stability stable
     */
    set containerName(value: string);
    /**
     * @stability stable
     */
    get containerNameInput(): string | undefined;
    private _rootFolderPath?;
    /**
     * @stability stable
     */
    get rootFolderPath(): string;
    /**
     * @stability stable
     */
    set rootFolderPath(value: string);
    /**
     * @stability stable
     */
    get rootFolderPathInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CostManagementExportResourceGroupQuery {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#time_frame CostManagementExportResourceGroup#time_frame}.
     *
     * @stability stable
     */
    readonly timeFrame: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#type CostManagementExportResourceGroup#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function costManagementExportResourceGroupQueryToTerraform(struct?: CostManagementExportResourceGroupQueryOutputReference | CostManagementExportResourceGroupQuery): any;
/**
 * @stability stable
 */
export declare class CostManagementExportResourceGroupQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CostManagementExportResourceGroupQuery | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CostManagementExportResourceGroupQuery | undefined);
    private _timeFrame?;
    /**
     * @stability stable
     */
    get timeFrame(): string;
    /**
     * @stability stable
     */
    set timeFrame(value: string);
    /**
     * @stability stable
     */
    get timeFrameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CostManagementExportResourceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#create CostManagementExportResourceGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#delete CostManagementExportResourceGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#read CostManagementExportResourceGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html#update CostManagementExportResourceGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function costManagementExportResourceGroupTimeoutsToTerraform(struct?: CostManagementExportResourceGroupTimeoutsOutputReference | CostManagementExportResourceGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class CostManagementExportResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CostManagementExportResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CostManagementExportResourceGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html azurerm_cost_management_export_resource_group}.
 *
 * @stability stable
 */
export declare class CostManagementExportResourceGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cost_management_export_resource_group.html azurerm_cost_management_export_resource_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CostManagementExportResourceGroupConfig);
    private _active?;
    /**
     * @stability stable
     */
    get active(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set active(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActive(): void;
    /**
     * @stability stable
     */
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recurrencePeriodEnd?;
    /**
     * @stability stable
     */
    get recurrencePeriodEnd(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodEnd(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodEndInput(): string | undefined;
    private _recurrencePeriodStart?;
    /**
     * @stability stable
     */
    get recurrencePeriodStart(): string;
    /**
     * @stability stable
     */
    set recurrencePeriodStart(value: string);
    /**
     * @stability stable
     */
    get recurrencePeriodStartInput(): string | undefined;
    private _recurrenceType?;
    /**
     * @stability stable
     */
    get recurrenceType(): string;
    /**
     * @stability stable
     */
    set recurrenceType(value: string);
    /**
     * @stability stable
     */
    get recurrenceTypeInput(): string | undefined;
    private _resourceGroupId?;
    /**
     * @stability stable
     */
    get resourceGroupId(): string;
    /**
     * @stability stable
     */
    set resourceGroupId(value: string);
    /**
     * @stability stable
     */
    get resourceGroupIdInput(): string | undefined;
    private _deliveryInfo;
    /**
     * @stability stable
     */
    get deliveryInfo(): CostManagementExportResourceGroupDeliveryInfoOutputReference;
    /**
     * @stability stable
     */
    putDeliveryInfo(value: CostManagementExportResourceGroupDeliveryInfo): void;
    /**
     * @stability stable
     */
    get deliveryInfoInput(): CostManagementExportResourceGroupDeliveryInfo | undefined;
    private _query;
    /**
     * @stability stable
     */
    get query(): CostManagementExportResourceGroupQueryOutputReference;
    /**
     * @stability stable
     */
    putQuery(value: CostManagementExportResourceGroupQuery): void;
    /**
     * @stability stable
     */
    get queryInput(): CostManagementExportResourceGroupQuery | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CostManagementExportResourceGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CostManagementExportResourceGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CostManagementExportResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
