import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DatabricksWorkspaceCustomerManagedKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#key_vault_key_id DatabricksWorkspaceCustomerManagedKey#key_vault_key_id}.
     *
     * @stability stable
     */
    readonly keyVaultKeyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#workspace_id DatabricksWorkspaceCustomerManagedKey#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#timeouts DatabricksWorkspaceCustomerManagedKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DatabricksWorkspaceCustomerManagedKeyTimeouts;
}
/**
 * @stability stable
 */
export interface DatabricksWorkspaceCustomerManagedKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#create DatabricksWorkspaceCustomerManagedKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#delete DatabricksWorkspaceCustomerManagedKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#read DatabricksWorkspaceCustomerManagedKey#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html#update DatabricksWorkspaceCustomerManagedKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function databricksWorkspaceCustomerManagedKeyTimeoutsToTerraform(struct?: DatabricksWorkspaceCustomerManagedKeyTimeoutsOutputReference | DatabricksWorkspaceCustomerManagedKeyTimeouts): any;
/**
 * @stability stable
 */
export declare class DatabricksWorkspaceCustomerManagedKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DatabricksWorkspaceCustomerManagedKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DatabricksWorkspaceCustomerManagedKeyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html azurerm_databricks_workspace_customer_managed_key}.
 *
 * @stability stable
 */
export declare class DatabricksWorkspaceCustomerManagedKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/databricks_workspace_customer_managed_key.html azurerm_databricks_workspace_customer_managed_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DatabricksWorkspaceCustomerManagedKeyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultKeyId?;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    /**
     * @stability stable
     */
    set keyVaultKeyId(value: string);
    /**
     * @stability stable
     */
    get keyVaultKeyIdInput(): string | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DatabricksWorkspaceCustomerManagedKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DatabricksWorkspaceCustomerManagedKeyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DatabricksWorkspaceCustomerManagedKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
