import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#databases MssqlFailoverGroup#databases}.
     *
     * @stability stable
     */
    readonly databases?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#name MssqlFailoverGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#readonly_endpoint_failover_policy_enabled MssqlFailoverGroup#readonly_endpoint_failover_policy_enabled}.
     *
     * @stability stable
     */
    readonly readonlyEndpointFailoverPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#server_id MssqlFailoverGroup#server_id}.
     *
     * @stability stable
     */
    readonly serverId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#tags MssqlFailoverGroup#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * partner_server block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#partner_server MssqlFailoverGroup#partner_server}
     *
     * @stability stable
     */
    readonly partnerServer: MssqlFailoverGroupPartnerServer[];
    /**
     * read_write_endpoint_failover_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#read_write_endpoint_failover_policy MssqlFailoverGroup#read_write_endpoint_failover_policy}
     *
     * @stability stable
     */
    readonly readWriteEndpointFailoverPolicy: MssqlFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#timeouts MssqlFailoverGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlFailoverGroupTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlFailoverGroupPartnerServer {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#id MssqlFailoverGroup#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
export declare function mssqlFailoverGroupPartnerServerToTerraform(struct?: MssqlFailoverGroupPartnerServer): any;
/**
 * @stability stable
 */
export interface MssqlFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#grace_minutes MssqlFailoverGroup#grace_minutes}.
     *
     * @stability stable
     */
    readonly graceMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#mode MssqlFailoverGroup#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
}
export declare function mssqlFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | MssqlFailoverGroupReadWriteEndpointFailoverPolicy): any;
/**
 * @stability stable
 */
export declare class MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    /**
     * @stability stable
     */
    get graceMinutes(): number;
    /**
     * @stability stable
     */
    set graceMinutes(value: number);
    /**
     * @stability stable
     */
    resetGraceMinutes(): void;
    /**
     * @stability stable
     */
    get graceMinutesInput(): number | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlFailoverGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#create MssqlFailoverGroup#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#delete MssqlFailoverGroup#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#read MssqlFailoverGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html#update MssqlFailoverGroup#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlFailoverGroupTimeoutsToTerraform(struct?: MssqlFailoverGroupTimeoutsOutputReference | MssqlFailoverGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlFailoverGroupTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html azurerm_mssql_failover_group}.
 *
 * @stability stable
 */
export declare class MssqlFailoverGroup extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_failover_group.html azurerm_mssql_failover_group} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlFailoverGroupConfig);
    private _databases?;
    /**
     * @stability stable
     */
    get databases(): string[];
    /**
     * @stability stable
     */
    set databases(value: string[]);
    /**
     * @stability stable
     */
    resetDatabases(): void;
    /**
     * @stability stable
     */
    get databasesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _readonlyEndpointFailoverPolicyEnabled?;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set readonlyEndpointFailoverPolicyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReadonlyEndpointFailoverPolicyEnabled(): void;
    /**
     * @stability stable
     */
    get readonlyEndpointFailoverPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _serverId?;
    /**
     * @stability stable
     */
    get serverId(): string;
    /**
     * @stability stable
     */
    set serverId(value: string);
    /**
     * @stability stable
     */
    get serverIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _partnerServer?;
    /**
     * @stability stable
     */
    get partnerServer(): MssqlFailoverGroupPartnerServer[];
    /**
     * @stability stable
     */
    set partnerServer(value: MssqlFailoverGroupPartnerServer[]);
    /**
     * @stability stable
     */
    get partnerServerInput(): MssqlFailoverGroupPartnerServer[] | undefined;
    private _readWriteEndpointFailoverPolicy;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicy(): MssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    /**
     * @stability stable
     */
    putReadWriteEndpointFailoverPolicy(value: MssqlFailoverGroupReadWriteEndpointFailoverPolicy): void;
    /**
     * @stability stable
     */
    get readWriteEndpointFailoverPolicyInput(): MssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlFailoverGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlFailoverGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlFailoverGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
