import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SiteRecoveryReplicatedVmConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#managed_disk SiteRecoveryReplicatedVm#managed_disk}.
     *
     * @stability stable
     */
    readonly managedDisk?: SiteRecoveryReplicatedVmManagedDisk[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#name SiteRecoveryReplicatedVm#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#network_interface SiteRecoveryReplicatedVm#network_interface}.
     *
     * @stability stable
     */
    readonly networkInterface?: SiteRecoveryReplicatedVmNetworkInterface[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#recovery_replication_policy_id SiteRecoveryReplicatedVm#recovery_replication_policy_id}.
     *
     * @stability stable
     */
    readonly recoveryReplicationPolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#recovery_vault_name SiteRecoveryReplicatedVm#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#resource_group_name SiteRecoveryReplicatedVm#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#source_recovery_fabric_name SiteRecoveryReplicatedVm#source_recovery_fabric_name}.
     *
     * @stability stable
     */
    readonly sourceRecoveryFabricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#source_recovery_protection_container_name SiteRecoveryReplicatedVm#source_recovery_protection_container_name}.
     *
     * @stability stable
     */
    readonly sourceRecoveryProtectionContainerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#source_vm_id SiteRecoveryReplicatedVm#source_vm_id}.
     *
     * @stability stable
     */
    readonly sourceVmId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_availability_set_id SiteRecoveryReplicatedVm#target_availability_set_id}.
     *
     * @stability stable
     */
    readonly targetAvailabilitySetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_network_id SiteRecoveryReplicatedVm#target_network_id}.
     *
     * @stability stable
     */
    readonly targetNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_recovery_fabric_id SiteRecoveryReplicatedVm#target_recovery_fabric_id}.
     *
     * @stability stable
     */
    readonly targetRecoveryFabricId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_recovery_protection_container_id SiteRecoveryReplicatedVm#target_recovery_protection_container_id}.
     *
     * @stability stable
     */
    readonly targetRecoveryProtectionContainerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}.
     *
     * @stability stable
     */
    readonly targetResourceGroupId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#timeouts SiteRecoveryReplicatedVm#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SiteRecoveryReplicatedVmTimeouts;
}
/**
 * @stability stable
 */
export interface SiteRecoveryReplicatedVmManagedDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#disk_id SiteRecoveryReplicatedVm#disk_id}.
     *
     * @stability stable
     */
    readonly diskId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#staging_storage_account_id SiteRecoveryReplicatedVm#staging_storage_account_id}.
     *
     * @stability stable
     */
    readonly stagingStorageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_disk_encryption_set_id SiteRecoveryReplicatedVm#target_disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly targetDiskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_disk_type SiteRecoveryReplicatedVm#target_disk_type}.
     *
     * @stability stable
     */
    readonly targetDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_replica_disk_type SiteRecoveryReplicatedVm#target_replica_disk_type}.
     *
     * @stability stable
     */
    readonly targetReplicaDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_resource_group_id SiteRecoveryReplicatedVm#target_resource_group_id}.
     *
     * @stability stable
     */
    readonly targetResourceGroupId?: string;
}
export declare function siteRecoveryReplicatedVmManagedDiskToTerraform(struct?: SiteRecoveryReplicatedVmManagedDisk): any;
/**
 * @stability stable
 */
export interface SiteRecoveryReplicatedVmNetworkInterface {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#recovery_public_ip_address_id SiteRecoveryReplicatedVm#recovery_public_ip_address_id}.
     *
     * @stability stable
     */
    readonly recoveryPublicIpAddressId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#source_network_interface_id SiteRecoveryReplicatedVm#source_network_interface_id}.
     *
     * @stability stable
     */
    readonly sourceNetworkInterfaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_static_ip SiteRecoveryReplicatedVm#target_static_ip}.
     *
     * @stability stable
     */
    readonly targetStaticIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#target_subnet_name SiteRecoveryReplicatedVm#target_subnet_name}.
     *
     * @stability stable
     */
    readonly targetSubnetName?: string;
}
export declare function siteRecoveryReplicatedVmNetworkInterfaceToTerraform(struct?: SiteRecoveryReplicatedVmNetworkInterface): any;
/**
 * @stability stable
 */
export interface SiteRecoveryReplicatedVmTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#create SiteRecoveryReplicatedVm#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#delete SiteRecoveryReplicatedVm#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#read SiteRecoveryReplicatedVm#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html#update SiteRecoveryReplicatedVm#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function siteRecoveryReplicatedVmTimeoutsToTerraform(struct?: SiteRecoveryReplicatedVmTimeoutsOutputReference | SiteRecoveryReplicatedVmTimeouts): any;
/**
 * @stability stable
 */
export declare class SiteRecoveryReplicatedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SiteRecoveryReplicatedVmTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SiteRecoveryReplicatedVmTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html azurerm_site_recovery_replicated_vm}.
 *
 * @stability stable
 */
export declare class SiteRecoveryReplicatedVm extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/site_recovery_replicated_vm.html azurerm_site_recovery_replicated_vm} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SiteRecoveryReplicatedVmConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _managedDisk?;
    /**
     * @stability stable
     */
    get managedDisk(): SiteRecoveryReplicatedVmManagedDisk[];
    /**
     * @stability stable
     */
    set managedDisk(value: SiteRecoveryReplicatedVmManagedDisk[]);
    /**
     * @stability stable
     */
    resetManagedDisk(): void;
    /**
     * @stability stable
     */
    get managedDiskInput(): SiteRecoveryReplicatedVmManagedDisk[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkInterface?;
    /**
     * @stability stable
     */
    get networkInterface(): SiteRecoveryReplicatedVmNetworkInterface[];
    /**
     * @stability stable
     */
    set networkInterface(value: SiteRecoveryReplicatedVmNetworkInterface[]);
    /**
     * @stability stable
     */
    resetNetworkInterface(): void;
    /**
     * @stability stable
     */
    get networkInterfaceInput(): SiteRecoveryReplicatedVmNetworkInterface[] | undefined;
    private _recoveryReplicationPolicyId?;
    /**
     * @stability stable
     */
    get recoveryReplicationPolicyId(): string;
    /**
     * @stability stable
     */
    set recoveryReplicationPolicyId(value: string);
    /**
     * @stability stable
     */
    get recoveryReplicationPolicyIdInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceRecoveryFabricName?;
    /**
     * @stability stable
     */
    get sourceRecoveryFabricName(): string;
    /**
     * @stability stable
     */
    set sourceRecoveryFabricName(value: string);
    /**
     * @stability stable
     */
    get sourceRecoveryFabricNameInput(): string | undefined;
    private _sourceRecoveryProtectionContainerName?;
    /**
     * @stability stable
     */
    get sourceRecoveryProtectionContainerName(): string;
    /**
     * @stability stable
     */
    set sourceRecoveryProtectionContainerName(value: string);
    /**
     * @stability stable
     */
    get sourceRecoveryProtectionContainerNameInput(): string | undefined;
    private _sourceVmId?;
    /**
     * @stability stable
     */
    get sourceVmId(): string;
    /**
     * @stability stable
     */
    set sourceVmId(value: string);
    /**
     * @stability stable
     */
    get sourceVmIdInput(): string | undefined;
    private _targetAvailabilitySetId?;
    /**
     * @stability stable
     */
    get targetAvailabilitySetId(): string;
    /**
     * @stability stable
     */
    set targetAvailabilitySetId(value: string);
    /**
     * @stability stable
     */
    resetTargetAvailabilitySetId(): void;
    /**
     * @stability stable
     */
    get targetAvailabilitySetIdInput(): string | undefined;
    private _targetNetworkId?;
    /**
     * @stability stable
     */
    get targetNetworkId(): string;
    /**
     * @stability stable
     */
    set targetNetworkId(value: string);
    /**
     * @stability stable
     */
    resetTargetNetworkId(): void;
    /**
     * @stability stable
     */
    get targetNetworkIdInput(): string | undefined;
    private _targetRecoveryFabricId?;
    /**
     * @stability stable
     */
    get targetRecoveryFabricId(): string;
    /**
     * @stability stable
     */
    set targetRecoveryFabricId(value: string);
    /**
     * @stability stable
     */
    get targetRecoveryFabricIdInput(): string | undefined;
    private _targetRecoveryProtectionContainerId?;
    /**
     * @stability stable
     */
    get targetRecoveryProtectionContainerId(): string;
    /**
     * @stability stable
     */
    set targetRecoveryProtectionContainerId(value: string);
    /**
     * @stability stable
     */
    get targetRecoveryProtectionContainerIdInput(): string | undefined;
    private _targetResourceGroupId?;
    /**
     * @stability stable
     */
    get targetResourceGroupId(): string;
    /**
     * @stability stable
     */
    set targetResourceGroupId(value: string);
    /**
     * @stability stable
     */
    get targetResourceGroupIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SiteRecoveryReplicatedVmTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SiteRecoveryReplicatedVmTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SiteRecoveryReplicatedVmTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
