import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnGatewayNatRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#external_address_space_mappings VpnGatewayNatRule#external_address_space_mappings}.
     *
     * @stability stable
     */
    readonly externalAddressSpaceMappings: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#internal_address_space_mappings VpnGatewayNatRule#internal_address_space_mappings}.
     *
     * @stability stable
     */
    readonly internalAddressSpaceMappings: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#ip_configuration_id VpnGatewayNatRule#ip_configuration_id}.
     *
     * @stability stable
     */
    readonly ipConfigurationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#mode VpnGatewayNatRule#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#name VpnGatewayNatRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#resource_group_name VpnGatewayNatRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#type VpnGatewayNatRule#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#vpn_gateway_id VpnGatewayNatRule#vpn_gateway_id}.
     *
     * @stability stable
     */
    readonly vpnGatewayId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#timeouts VpnGatewayNatRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnGatewayNatRuleTimeouts;
}
/**
 * @stability stable
 */
export interface VpnGatewayNatRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#create VpnGatewayNatRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#delete VpnGatewayNatRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#read VpnGatewayNatRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html#update VpnGatewayNatRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnGatewayNatRuleTimeoutsToTerraform(struct?: VpnGatewayNatRuleTimeoutsOutputReference | VpnGatewayNatRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class VpnGatewayNatRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnGatewayNatRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnGatewayNatRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html azurerm_vpn_gateway_nat_rule}.
 *
 * @stability stable
 */
export declare class VpnGatewayNatRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_gateway_nat_rule.html azurerm_vpn_gateway_nat_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnGatewayNatRuleConfig);
    private _externalAddressSpaceMappings?;
    /**
     * @stability stable
     */
    get externalAddressSpaceMappings(): string[];
    /**
     * @stability stable
     */
    set externalAddressSpaceMappings(value: string[]);
    /**
     * @stability stable
     */
    get externalAddressSpaceMappingsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _internalAddressSpaceMappings?;
    /**
     * @stability stable
     */
    get internalAddressSpaceMappings(): string[];
    /**
     * @stability stable
     */
    set internalAddressSpaceMappings(value: string[]);
    /**
     * @stability stable
     */
    get internalAddressSpaceMappingsInput(): string[] | undefined;
    private _ipConfigurationId?;
    /**
     * @stability stable
     */
    get ipConfigurationId(): string;
    /**
     * @stability stable
     */
    set ipConfigurationId(value: string);
    /**
     * @stability stable
     */
    resetIpConfigurationId(): void;
    /**
     * @stability stable
     */
    get ipConfigurationIdInput(): string | undefined;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vpnGatewayId?;
    /**
     * @stability stable
     */
    get vpnGatewayId(): string;
    /**
     * @stability stable
     */
    set vpnGatewayId(value: string);
    /**
     * @stability stable
     */
    get vpnGatewayIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnGatewayNatRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnGatewayNatRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnGatewayNatRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
