import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnSiteConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#address_cidrs VpnSite#address_cidrs}.
     *
     * @stability stable
     */
    readonly addressCidrs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#device_model VpnSite#device_model}.
     *
     * @stability stable
     */
    readonly deviceModel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#device_vendor VpnSite#device_vendor}.
     *
     * @stability stable
     */
    readonly deviceVendor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#location VpnSite#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#name VpnSite#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#resource_group_name VpnSite#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#tags VpnSite#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#virtual_wan_id VpnSite#virtual_wan_id}.
     *
     * @stability stable
     */
    readonly virtualWanId: string;
    /**
     * link block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#link VpnSite#link}
     *
     * @stability stable
     */
    readonly link?: VpnSiteLink[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#timeouts VpnSite#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnSiteTimeouts;
}
/**
 * @stability stable
 */
export interface VpnSiteLinkBgp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#asn VpnSite#asn}.
     *
     * @stability stable
     */
    readonly asn: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#peering_address VpnSite#peering_address}.
     *
     * @stability stable
     */
    readonly peeringAddress: string;
}
export declare function vpnSiteLinkBgpToTerraform(struct?: VpnSiteLinkBgpOutputReference | VpnSiteLinkBgp): any;
/**
 * @stability stable
 */
export declare class VpnSiteLinkBgpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnSiteLinkBgp | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnSiteLinkBgp | undefined);
    private _asn?;
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    set asn(value: number);
    /**
     * @stability stable
     */
    get asnInput(): number | undefined;
    private _peeringAddress?;
    /**
     * @stability stable
     */
    get peeringAddress(): string;
    /**
     * @stability stable
     */
    set peeringAddress(value: string);
    /**
     * @stability stable
     */
    get peeringAddressInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface VpnSiteLink {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#fqdn VpnSite#fqdn}.
     *
     * @stability stable
     */
    readonly fqdn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#ip_address VpnSite#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#name VpnSite#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#provider_name VpnSite#provider_name}.
     *
     * @stability stable
     */
    readonly providerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#speed_in_mbps VpnSite#speed_in_mbps}.
     *
     * @stability stable
     */
    readonly speedInMbps?: number;
    /**
     * bgp block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#bgp VpnSite#bgp}
     *
     * @stability stable
     */
    readonly bgp?: VpnSiteLinkBgp;
}
export declare function vpnSiteLinkToTerraform(struct?: VpnSiteLink): any;
/**
 * @stability stable
 */
export interface VpnSiteTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#create VpnSite#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#delete VpnSite#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#read VpnSite#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html#update VpnSite#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function vpnSiteTimeoutsToTerraform(struct?: VpnSiteTimeoutsOutputReference | VpnSiteTimeouts): any;
/**
 * @stability stable
 */
export declare class VpnSiteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VpnSiteTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VpnSiteTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html azurerm_vpn_site}.
 *
 * @stability stable
 */
export declare class VpnSite extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_site.html azurerm_vpn_site} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnSiteConfig);
    private _addressCidrs?;
    /**
     * @stability stable
     */
    get addressCidrs(): string[];
    /**
     * @stability stable
     */
    set addressCidrs(value: string[]);
    /**
     * @stability stable
     */
    resetAddressCidrs(): void;
    /**
     * @stability stable
     */
    get addressCidrsInput(): string[] | undefined;
    private _deviceModel?;
    /**
     * @stability stable
     */
    get deviceModel(): string;
    /**
     * @stability stable
     */
    set deviceModel(value: string);
    /**
     * @stability stable
     */
    resetDeviceModel(): void;
    /**
     * @stability stable
     */
    get deviceModelInput(): string | undefined;
    private _deviceVendor?;
    /**
     * @stability stable
     */
    get deviceVendor(): string;
    /**
     * @stability stable
     */
    set deviceVendor(value: string);
    /**
     * @stability stable
     */
    resetDeviceVendor(): void;
    /**
     * @stability stable
     */
    get deviceVendorInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _virtualWanId?;
    /**
     * @stability stable
     */
    get virtualWanId(): string;
    /**
     * @stability stable
     */
    set virtualWanId(value: string);
    /**
     * @stability stable
     */
    get virtualWanIdInput(): string | undefined;
    private _link?;
    /**
     * @stability stable
     */
    get link(): VpnSiteLink[];
    /**
     * @stability stable
     */
    set link(value: VpnSiteLink[]);
    /**
     * @stability stable
     */
    resetLink(): void;
    /**
     * @stability stable
     */
    get linkInput(): VpnSiteLink[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VpnSiteTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnSiteTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnSiteTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
