# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import AnyUrl, BaseModel, ConfigDict, EmailStr, Field, RootModel, constr

from .. import EnvScopedObjectReference, GlobalObjectReference
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    cdx_v1 = 'cdx/v1'


class Kind(Enum):
    provider_shared_resource = 'ProviderSharedResource'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shared-resources/psr-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/provider-shared-resource=psr-12345'
        ],
    )


class Resource(RootModel[AnyUrl]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AnyUrl = Field(
        ...,
        description='crn that specifies the shared resource',
        examples=[
            'crn://confluent.cloud/environment=env-123/cloud-cluster=lkc-111aaa/kafka=lkc-111aaa/topic=my.topic'
        ],
    )


class Kind1Model(Enum):
    provider_share = 'ProviderShare'


class Metadata1Model(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/provider-shares/ps-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/provider-share=ps-12345'
        ],
    )


class ProviderShareStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(..., description='Status of share', examples=['ACTIVE'])


class Kind1Model1(Enum):
    consumer_shared_resource = 'ConsumerSharedResource'


class Metadata1Model1(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shared-resources/csr-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/consumer-shared-resource=csr-12345'
        ],
    )


class Kind1Model2(Enum):
    consumer_share = 'ConsumerShare'


class Metadata1Model2(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/consumer-shares/cs-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/consumer-share=cs-12345'
        ],
    )


class ConsumerShareStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    phase: str = Field(..., description='Status of share', examples=['ACTIVE'])


class Kind1Model3(Enum):
    shared_token = 'SharedToken'


class Metadata1Model3(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/shared-tokens/st-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/shared-token=st-12345'
        ],
    )


class SharedToken(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model3] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model3] = None
    token: Optional[str] = Field(None, description='The encrypted token')


class Kind1Model4(Enum):
    opt_in = 'OptIn'


class OptIn(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model4] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    stream_share_enabled: Optional[bool] = Field(
        None, description='Enable stream sharing for the organization'
    )


class Kind1Model5(Enum):
    create_provider_share_request = 'CreateProviderShareRequest'


class Metadata1Model4(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/create-provider-share-requests/cpsr-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/create-provider-share-request=cpsr-12345'
        ],
    )


class Resource1Model(RootModel[AnyUrl]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AnyUrl = Field(
        ...,
        description='crn that specifies the sharedresource',
        examples=[
            'crn://confluent.cloud/environment=env-123/cloud-cluster=lkc-111aaa/kafka=lkc-111aaa/topic=my.topic'
        ],
    )


class Kind1Model6(Enum):
    redeem_token_request = 'RedeemTokenRequest'


class Metadata1Model5(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=['https://api.confluent.cloud/cdx/v1/redeem-token-requests/rtr-12345'],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/redeem-token-request=rtr-12345'
        ],
    )


class RedeemTokenRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model6] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model5] = None
    token: Optional[str] = Field(None, description='The encrypted token')
    aws_account: Optional[str] = Field(
        None,
        description="Consumer's AWS account ID for PrivateLink access.",
        examples=['000000000000'],
    )
    azure_subscription: Optional[str] = Field(
        None,
        description="Consumer's Azure subscription ID for PrivateLink access.",
        examples=['00000000-0000-0000-0000-000000000000'],
    )
    gcp_project: Optional[constr(min_length=1)] = Field(
        None,
        description="Consumer's GCP project ID for Private Service Connect access.",
    )


class Kind1Model7(Enum):
    redeem_token_response = 'RedeemTokenResponse'


class Metadata1Model6(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/redeem-token-responses/rtr-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/redeem-token-response=rtr-12345'
        ],
    )


class Kind1Model8(Enum):
    email = 'Email'


class EmailConsumerRestriction(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Email'] = Field(..., description='The resource kind')
    email: EmailStr = Field(..., description='Email based matching for the consumers')


class Kind1Model9(Enum):
    topic = 'Topic'


class SharedTopic(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Topic'] = Field(..., description='The shared resource kind')
    topic: str = Field(..., description='The topic name')


class Kind1Model10(Enum):
    group = 'Group'


class SharedGroup(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Group'] = Field(..., description='The resource kind')
    group_prefix: str = Field(..., description='The consumer group prefix')


class Kind1Model11(Enum):
    subject = 'Subject'


class SharedSubject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['Subject'] = Field(..., description='The shared resource kind')
    subject: str = Field(..., description='The subject name')


class Kind1Model12(Enum):
    network = 'Network'


class Metadata1Model7(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/networks/n-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/network=n-12345'
        ],
    )


class Kind1Model13(Enum):
    aws_network = 'AwsNetwork'


class AwsNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AwsNetwork'] = Field(..., description='Network kind type.')
    private_link_endpoint_service: Optional[str] = Field(
        None,
        description='The AWS VPC endpoint service for the network (used for PrivateLink) if available.',
        examples=['com.amazonaws.vpce.eu-west-3.vpce-00000000000000000'],
    )


class Kind1Model14(Enum):
    azure_network = 'AzureNetwork'


class AzureNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['AzureNetwork'] = Field(..., description='Network kind type.')
    private_link_service_aliases: Optional[Dict[str, str]] = Field(
        None,
        description='The mapping of zones to PrivateLink Service Aliases if available.  Keys are zones\nand values are [Azure PrivateLink Service\nAliases](https://docs.microsoft.com/en-us/azure/private-link/private-link-service-overview#share-your-service)\n',
        examples=[
            {
                '1': '0-00000-privatelink-1.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
                '2': '0-00000-privatelink-2.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
                '3': '0-00000-privatelink-3.00000000-0000-0000-0000-000000000000.westeurope.azure.privatelinkservice',
            }
        ],
    )


class Kind1Model15(Enum):
    gcp_network = 'GcpNetwork'


class GcpNetwork(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    kind: Literal['GcpNetwork'] = Field(..., description='Network kind type.')
    private_service_connect_service_attachments: Optional[Dict[str, str]] = Field(
        None,
        description='The mapping of zones to Private Service Connect Service\nAttachments if available. Keys are zones and values are\n[GCP Private Service Connect Service\nAttachment](https://cloud.google.com/vpc/docs/configure-private-service-connect-producer#api_7)\n',
        examples=[
            {
                'us-central1-a': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-a',
                'us-central1-b': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-b',
                'us-central1-c': 'projects/cc-prod/regions/us-central1/serviceAttachments/s-7jjm9-service-attachment-us-central1-c',
            }
        ],
    )


class ConnectionType(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(
        ..., description='Network connection type.', examples=['PRIVATELINK']
    )


class Schema(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subject: Optional[str] = Field(
        None, description='Name of the subject', examples=['User']
    )
    version: Optional[int] = Field(None, description='Version number', examples=[1])
    id: Optional[int] = Field(
        None, description='Globally unique identifier of the schema', examples=[100001]
    )
    schema_type: Optional[str] = Field(
        None, description='Schema type', examples=['AVRO']
    )
    schema_: Optional[str] = Field(
        None,
        alias='schema',
        description='Schema definition string',
        examples=['{"schema": "{"type": "string"}"}'],
    )


class Kind1Model16(Enum):
    provider_shared_resource_list = 'ProviderSharedResourceList'


class Metadata1Model8(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/provider-shared-resources']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shared-resources?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shared-resources?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shared-resources?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model17(Enum):
    provider_share_list = 'ProviderShareList'


class Metadata1Model9(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/provider-shares']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shares?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shares?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shares?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model18(Enum):
    consumer_shared_resource_list = 'ConsumerSharedResourceList'


class Metadata1Model10(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/consumer-shared-resources']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shared-resources?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shared-resources?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shared-resources?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model19(Enum):
    consumer_share_list = 'ConsumerShareList'


class Metadata1Model11(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/cdx/v1/consumer-shares']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shares?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shares?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/consumer-shares?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class Kind1Model20(Enum):
    provider_shared_resource = 'ProviderSharedResource'


class Metadata1Model12(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/cdx/v1/provider-shared-resources/psr-12345'
        ],
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/provider-shared-resource=psr-12345'
        ],
    )


class Resource1Model1(RootModel[AnyUrl]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AnyUrl = Field(
        ...,
        description='crn that specifies the shared resource',
        examples=[
            'crn://confluent.cloud/environment=env-123/cloud-cluster=lkc-111aaa/kafka=lkc-111aaa/topic=my.topic'
        ],
    )


class ProviderSharedResourceUpdate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model20] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model12] = None
    resources: Optional[List[Resource1Model1]] = Field(
        None, description='List of resource crns that are shared together', min_length=1
    )
    display_name: Optional[str] = Field(
        None, description='Shared resource display name', examples=['Stock Trades']
    )
    organization_description: Optional[str] = Field(
        None,
        description="Shared resource's organization description",
        examples=['ABC Corp is the biggest online retailer'],
    )
    organization_contact: Optional[EmailStr] = Field(
        None,
        description='Email of contact person from the organization',
        examples=['jane.doe@example.com'],
    )
    logo_url: Optional[AnyUrl] = Field(
        None,
        description='Resource logo url',
        examples=[
            'https://confluent.cloud/api/cdx/v1/provider-shared-resources/sr-123/images/logo'
        ],
    )


class ProviderSharedResource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    crn: Optional[AnyUrl] = Field(
        None,
        description='Deprecated please use resources attribute.',
        examples=[
            'crn://confluent.cloud/environment=env-123/cloud-cluster=lkc-1111aaa/kafka=lkc-111aaa/topic=my.topic'
        ],
    )
    resources: Optional[List[Resource]] = Field(
        None, description='List of resource crns that are shared together', min_length=1
    )
    display_name: Optional[str] = Field(
        None, description='Shared resource display name', examples=['Stock Trades']
    )
    description: Optional[str] = Field(
        None,
        description='Description of shared resource',
        examples=[
            'This topic provides realtime data for the orders placed through the website'
        ],
    )
    tags: Optional[List[str]] = Field(
        None, description='list of tags', examples=[['recent', 'pending']]
    )
    schemas: Optional[List[Schema]] = Field(
        None,
        description='List of schemas in JSON format. This field is work in progress and subject to changes.',
    )
    organization_description: Optional[str] = Field(
        None,
        description="Shared resource's organization description",
        examples=['ABC Corp is the biggest online retailer'],
    )
    organization_contact: Optional[EmailStr] = Field(
        None,
        description='Email of contact person from the organization',
        examples=['jane.doe@example.com'],
    )
    logo_url: Optional[AnyUrl] = Field(
        None,
        description='Resource logo url',
        examples=[
            'https://confluent.cloud/api/cdx/v1/provider-shared-resources/sr-123/images/logo'
        ],
    )
    organization_name: Optional[Any] = Field(
        None,
        description='Organization to which the shared resource belongs. Deprecated',
        examples=['ABC Corp'],
    )
    environment_name: Optional[str] = Field(
        None,
        description='The environment name of the shared resource. Deprecated',
        examples=['Public Env'],
    )
    cluster_name: Optional[str] = Field(
        None,
        description='The cluster display name of the shared resource. Deprecated',
        examples=['Published Trades'],
    )
    cloud_cluster: Optional[EnvScopedObjectReference] = Field(
        None, description='The cloud cluster to which this belongs.'
    )


class ProviderShare(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model] = None
    consumer_user_name: Optional[str] = Field(
        None, description='Name of the consumer', examples=['John Doe']
    )
    consumer_organization_name: Optional[str] = Field(
        None, description='Consumer organization name', examples=['Nasdaq']
    )
    provider_user_name: Optional[str] = Field(
        None,
        description='Name or email of the provider user. Deprecated',
        examples=['Jane Doe'],
    )
    delivery_method: Optional[str] = Field(
        None,
        description='Method by which the invite will be delivered',
        examples=['EMAIL'],
    )
    consumer_restriction: Optional[EmailConsumerRestriction] = Field(
        None,
        description='Restrictions on the consumer that can redeem this token',
        discriminator='kind',
    )
    invited_at: Optional[datetime] = Field(
        None,
        description='The date and time at which consumer was invited',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    invite_expires_at: Optional[datetime] = Field(
        None,
        description='The date and time at which the invitation will expire. Only for invited shares',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    redeemed_at: Optional[datetime] = Field(
        None,
        description='The date and time at which the invite was redeemed',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    provider_user: Optional[GlobalObjectReference] = Field(
        None, description='The provider user/inviter'
    )
    service_account: Optional[GlobalObjectReference] = Field(
        None, description='The service account associated with this object.'
    )
    cloud_cluster: Optional[EnvScopedObjectReference] = Field(
        None, description='The cloud cluster to which this belongs.'
    )
    status: Optional[ProviderShareStatus] = None


class ConsumerSharedResource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model1] = None
    cloud: Optional[str] = Field(
        None,
        description='The cloud service provider of the provider shared cluster.',
        examples=['AWS'],
    )
    network_connection_types: Optional[List[ConnectionType]] = Field(
        None,
        description='The network connection types of the provider shared cluster. If the shared cluster is on public internet,\nthen the list will be empty\n',
    )
    display_name: Optional[str] = Field(
        None, description='Consumer resource display name', examples=['Stock Trades']
    )
    description: Optional[str] = Field(
        None,
        description='Description of consumer resource',
        examples=[
            'This topic provides realtime data for the orders placed through the website'
        ],
    )
    tags: Optional[List[str]] = Field(
        None, description='list of tags', examples=[['recent', 'pending']]
    )
    schemas: Optional[List[Schema]] = Field(
        None,
        description='List of schemas in JSON format. This field is work in progress and subject to changes.',
    )
    organization_name: Optional[str] = Field(
        None, description="Shared resource's organization name", examples=['ABC Corp']
    )
    organization_description: Optional[str] = Field(
        None,
        description="Shared resource's organization description",
        examples=['ABC Corp is the biggest online retailer'],
    )
    organization_contact: Optional[EmailStr] = Field(
        None,
        description="Email of the shared resource's organization contact",
        examples=['jane.doe@example.com'],
    )
    logo_url: Optional[AnyUrl] = Field(
        None,
        description='Resource logo url',
        examples=[
            'https://confluent.cloud/api/cdx/v1/consumer-shared-resources/sr-123/images/logo'
        ],
    )


class ConsumerShare(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model2] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model2] = None
    provider_organization_name: Optional[str] = Field(
        None, description='Provider organization name', examples=['Nasdaq']
    )
    provider_user_name: Optional[str] = Field(
        None, description='Name or email of the provider user', examples=['Jane Doe']
    )
    invite_expires_at: Optional[datetime] = Field(
        None,
        description='The date and time at which the invitation will expire. Only for invited shares',
        examples=['2006-01-02T15:04:05-07:00'],
    )
    consumer_organization_name: Optional[str] = Field(
        None, description='Consumer organization name. Deprecated', examples=['Nasdaq']
    )
    consumer_user_name: Optional[str] = Field(
        None, description='Name of the consumer. Deprecated', examples=['John Doe']
    )
    consumer_user: Optional[GlobalObjectReference] = Field(
        None, description='The consumer user/invitee'
    )
    status: Optional[ConsumerShareStatus] = None


class CreateProviderShareRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model5] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model4] = None
    delivery_method: Optional[str] = Field(
        None,
        description='Method by which the invite will be delivered',
        examples=['EMAIL'],
    )
    consumer_restriction: Optional[EmailConsumerRestriction] = Field(
        None,
        description='Restrictions on the consumer that can redeem this token',
        discriminator='kind',
    )
    resources: Optional[List[Resource1Model]] = Field(
        None, description='List of resource crns to be shared', min_length=1
    )


class Resources(RootModel[Union[SharedTopic, SharedGroup, SharedSubject]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Union[SharedTopic, SharedGroup, SharedSubject] = Field(
        ..., discriminator='kind'
    )


class RedeemTokenResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model7] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model6] = None
    api_key: Optional[str] = Field(None, description='The api key')
    secret: Optional[str] = Field(None, description='The api key secret')
    kafka_bootstrap_url: Optional[AnyUrl] = Field(
        None,
        description='The kafka cluster bootstrap url',
        examples=['SASL://pkc-xxxxx.us-west-2.aws.confluent.cloud:9092'],
    )
    schema_registry_api_key: Optional[str] = Field(
        None, description='The api key for schema registry'
    )
    schema_registry_secret: Optional[str] = Field(
        None, description='The api key secret for schema registry'
    )
    schema_registry_url: Optional[AnyUrl] = Field(
        None,
        description='The schema registry endpoint url',
        examples=['https://psrc-xxxxx.us-west-2.aws.confluent.cloud'],
    )
    resources: Optional[List[Resources]] = Field(
        None, description='List of shared resources', min_length=1
    )


class Network(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1Model12] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata1Model7] = None
    kafka_bootstrap_url: Optional[AnyUrl] = Field(
        None,
        description='The kafka cluster bootstrap url',
        examples=['SASL://pkc-xxxxx.us-west-2.aws.confluent.cloud:9092'],
    )
    zones: Optional[List[str]] = Field(
        None,
        description='The 3 availability zones for this network. They can optionally be specified for AWS networks\nused with PrivateLink. Otherwise, they are automatically chosen by Confluent Cloud.\n\nOn AWS, zones are AWS [AZ IDs](https://docs.aws.amazon.com/ram/latest/userguide/working-with-az-ids.html)\n (e.g. use1-az3)\n\nOn GCP, zones are GCP [zones](https://cloud.google.com/compute/docs/regions-zones)\n (e.g. us-central1-c).\n\nOn Azure, zones are Confluent-chosen names (e.g. 1, 2, 3) since Azure does not\n have universal zone identifiers.\n',
        examples=[['use1-az1', 'use1-az2', 'use1-az3']],
        max_length=3,
        min_length=3,
    )
    dns_domain: Optional[str] = Field(
        None,
        description='The root DNS domain for the network if applicable.',
        examples=['00000.us-east-1.aws.glb.confluent.cloud'],
    )
    zonal_subdomains: Optional[Dict[str, str]] = Field(
        None,
        description='The DNS subdomain for each zone. Present on networks that support PrivateLink. Keys are zones and\nvalues are DNS domains.\n',
        examples=[
            {
                'use1-az1': 'use1-az1.00000.us-east-1.aws.confluent.cloud',
                'use1-az4': 'use1-az4.00000.us-east-1.aws.confluent.cloud',
                'use1-az5': 'use1-az5.00000.us-east-1.aws.confluent.cloud',
            }
        ],
    )
    cloud: Optional[Union[AwsNetwork, AzureNetwork, GcpNetwork]] = Field(
        None,
        description='The cloud-specific network details. These will be populated when the network reaches the READY state.',
        discriminator='kind',
    )


class ProviderSharedResourceList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model16 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model8
    data: List[ProviderSharedResource] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ProviderShareList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model17 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model9
    data: List[ProviderShare] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ConsumerSharedResourceList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model18 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model10
    data: List[ConsumerSharedResource] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )


class ConsumerShareList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model19 = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: Metadata1Model11
    data: List[ConsumerShare] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
