# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict, Field, constr

from .. import (
    EnvScopedObjectReference,
    GlobalObjectReference,
    TypedGlobalObjectReference,
)
from ..ListMeta import ListMeta
from ..ObjectMeta import ObjectMeta


class ApiVersion(Enum):
    ksqldbcm_v2 = 'ksqldbcm/v2'


class Kind(Enum):
    cluster = 'Cluster'


class Metadata(ObjectMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    self: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/ksqldbcm/v2/clusters/lksqlc-12345']
    )
    resource_name: Optional[Any] = Field(
        None,
        examples=[
            'crn://confluent.cloud/organization=9bb441c4-edef-46ac-8a41-c49e44a3fd9a/environment=env-abc123/cloud-cluster=lksqlc-12345'
        ],
    )


class ClusterStatus(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    http_endpoint: Optional[str] = Field(
        None,
        description='The dataplane endpoint of the ksqlDB cluster.',
        examples=['https://pksqlc-00000.us-central1.gcp.glb.confluent.cloud'],
    )
    phase: str = Field(
        ..., description='Status of the ksqlDB cluster.', examples=['PROVISIONING']
    )
    is_paused: bool = Field(..., description='Tells you if the cluster has been paused')
    storage: int = Field(
        ...,
        description='Amount of storage (in GB) provisioned to this cluster',
        examples=[125],
    )
    topic_prefix: Optional[str] = Field(
        None,
        description='Topic name prefix used by this ksqlDB cluster. Used to assign ACLs for this ksqlDB cluster to use.',
        examples=['pksqlc-00000'],
    )


class KindModel(Enum):
    cluster_list = 'ClusterList'


class MetadataModel(ListMeta):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    first: Optional[Any] = Field(
        None, examples=['https://api.confluent.cloud/ksqldbcm/v2/clusters']
    )
    last: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ksqldbcm/v2/clusters?page_token=bcAOehAY8F16YD84Z1wT'
        ],
    )
    prev: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ksqldbcm/v2/clusters?page_token=YIXRY97wWYmwzrax4dld'
        ],
    )
    next: Optional[Any] = Field(
        None,
        examples=[
            'https://api.confluent.cloud/ksqldbcm/v2/clusters?page_token=UvmDWOB1iwfAIBPj6EYb'
        ],
    )


class ClusterSpec(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    display_name: Optional[constr(pattern=r'^(?:[0-9A-Za-z\-])[\w-]{0,31}$')] = Field(
        None,
        description='The name of the ksqlDB cluster.',
        examples=['ksqlDB_cluster_0'],
    )
    use_detailed_processing_log: Optional[bool] = Field(
        True,
        description="This flag controls whether you want to include the row data in the processing log topic. Turn it off if you\ndon't want to emit sensitive information to the processing log\n",
    )
    csu: Optional[int] = Field(
        None,
        description='The number of CSUs (Confluent Streaming Units) in a ksqlDB cluster.',
        examples=[4],
    )
    kafka_cluster: Optional[EnvScopedObjectReference] = Field(
        None, description='The kafka_cluster to which this belongs.'
    )
    credential_identity: Optional[TypedGlobalObjectReference] = Field(
        None,
        description='The credential_identity to which this belongs. The credential_identity can be one of iam.v2.User, iam.v2.ServiceAccount.',
    )
    environment: Optional[GlobalObjectReference] = Field(
        None, description='The environment to which this belongs.'
    )


class Cluster(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[constr(max_length=255)] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[Metadata] = None
    spec: Optional[ClusterSpec] = None
    status: Optional[ClusterStatus] = None


class Datum(Cluster):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec: Dict[str, Any]


class ClusterList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: MetadataModel
    data: List[Datum] = Field(
        ...,
        description='A data property that contains an array of resource items. Each entry in the array is a separate resource.',
    )
