# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2025-03-21T21:21:27+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, constr

from .. import AzureSSOConfig, ListMeta, ObjectMeta, ObjectReference


class ApiVersion(Enum):
    partner_v2 = 'partner/v2'


class Kind(Enum):
    entitlement = 'Entitlement'


class Entitlement(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[str] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[ObjectMeta] = None
    external_id: Optional[str] = Field(
        None,
        description='The unique external ID of the entitlement (this should be unique to customer)',
        examples=['1111-2222-3333-4444'],
    )
    name: Optional[str] = Field(
        None,
        description='The name of the entitlement',
        examples=['Acme Prod Entitlement'],
    )
    plan_id: Optional[str] = Field(
        None,
        description='The plan ID the entitlement',
        examples=['confluent-cloud-payg-prod'],
    )
    product_id: Optional[str] = Field(
        None,
        description='The product ID of the entitlement',
        examples=['confluent-cloud-kafka-service-azure'],
    )
    usage_reporting_id: Optional[str] = Field(
        None,
        description='The usage reporting ID of the entitlement (if usage reporting uses\na different ID, otherwise, same as external_id)\n',
        examples=['1111-2222-3333-4444'],
    )
    resource_id: Optional[str] = Field(
        None,
        description='The resource ID of the entitlement',
        examples=['1111-2222-3333-4444'],
    )
    organization: Optional[ObjectReference] = Field(
        None, description='The organization associated with this object.'
    )


class KindModel(Enum):
    entitlement_list = 'EntitlementList'


class EntitlementList(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: KindModel = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: ListMeta
    data: List[Entitlement]


class Kind1(Enum):
    organization = 'Organization'


class Kind1Model(Enum):
    organization_list = 'OrganizationList'


class Organization(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    api_version: Optional[ApiVersion] = Field(
        None,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Optional[Kind1] = Field(
        None, description='Kind defines the object this REST resource represents.'
    )
    id: Optional[str] = Field(
        None,
        description='ID is the "natural identifier" for an object within its scope/namespace; it is normally unique across time but not space. That is, you can assume that the ID will not be reclaimed and reused after an object is deleted ("time"); however, it may collide with IDs for other object `kinds` or objects of the same `kind` within a different scope/namespace ("space").',
        examples=['dlz-f3a90de'],
    )
    metadata: Optional[ObjectMeta] = None
    name: Optional[constr(pattern=r'^[^<>#%\'*^`{|}~\"]{1,31}$')] = Field(
        None, description='The name of the organization', examples=['Acme Organization']
    )
    sso_url: Optional[AnyUrl] = Field(
        None,
        description='The login URL for the customer to access Confluent Cloud',
        examples=['https://confluent.cloud/login/sso/AzureAD-OIDC-Conn'],
    )
    sso_config: Optional[AzureSSOConfig] = Field(None, discriminator='kind')


class OrganizationList(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
        populate_by_name=True,
    )
    api_version: ApiVersion = Field(
        ...,
        description='APIVersion defines the schema version of this representation of a resource.',
    )
    kind: Kind1Model = Field(
        ..., description='Kind defines the object this REST resource represents.'
    )
    metadata: ListMeta
    data: List[Organization]
