"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 5.12.1836
    Contact: servicedesk@veeroute.com
    Auto Generated
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_studio.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from vrt_lss_studio.exceptions import ApiAttributeError


def lazy_import():
    from vrt_lss_studio.model.capacity import Capacity
    from vrt_lss_studio.model.measurements import Measurements
    from vrt_lss_studio.model.quality_statistics import QualityStatistics
    globals()['Capacity'] = Capacity
    globals()['Measurements'] = Measurements
    globals()['QualityStatistics'] = QualityStatistics


class Statistics(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('cost',): {
            'inclusive_minimum': 0,
        },
        ('reward',): {
            'inclusive_minimum': 0,
        },
        ('performers_count',): {
            'inclusive_maximum': 30001,
            'inclusive_minimum': 0,
        },
        ('orders_count',): {
            'inclusive_maximum': 30001,
            'inclusive_minimum': 0,
        },
        ('plan_orders_count',): {
            'inclusive_maximum': 30001,
            'inclusive_minimum': 0,
        },
        ('waitlist_orders_count',): {
            'inclusive_maximum': 30001,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'cost': (float,),  
            'reward': (float,),  
            'measurements': (Measurements,),  
            'performers_count': (int,),  
            'orders_count': (int,),  
            'plan_orders_count': (int,),  
            'waitlist_orders_count': (int,),  
            'capacity_utilization': (Capacity,),  
            'capacity_max': (Capacity,),  
            'quality': (QualityStatistics,),  
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'cost': 'cost',  
        'reward': 'reward',  
        'measurements': 'measurements',  
        'performers_count': 'performers_count',  
        'orders_count': 'orders_count',  
        'plan_orders_count': 'plan_orders_count',  
        'waitlist_orders_count': 'waitlist_orders_count',  
        'capacity_utilization': 'capacity_utilization',  
        'capacity_max': 'capacity_max',  
        'quality': 'quality',  
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, cost, reward, measurements, performers_count, orders_count, plan_orders_count, waitlist_orders_count, capacity_utilization, capacity_max, quality, *args, **kwargs):  
        """Statistics - a model defined in OpenAPI

        Args:
            cost (float): Total costs calculated based on the performer's and transport tariffs. The total cost is equal to the difference between the total reward (`reward`) and expenses (`cost`). 
            reward (float): The total reward for orders fulfillment.
            measurements (Measurements):
            performers_count (int): The total number of performers involved in orders fulfillment.
            orders_count (int): The total number of planned and assigned orders.
            plan_orders_count (int): The total number of planned orders.
            waitlist_orders_count (int): The total number of assigned orders.
            capacity_utilization (Capacity):
            capacity_max (Capacity):
            quality (QualityStatistics):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.cost = cost
        self.reward = reward
        self.measurements = measurements
        self.performers_count = performers_count
        self.orders_count = orders_count
        self.plan_orders_count = plan_orders_count
        self.waitlist_orders_count = waitlist_orders_count
        self.capacity_utilization = capacity_utilization
        self.capacity_max = capacity_max
        self.quality = quality
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, cost, reward, measurements, performers_count, orders_count, plan_orders_count, waitlist_orders_count, capacity_utilization, capacity_max, quality, *args, **kwargs):  
        """Statistics - a model defined in OpenAPI

        Args:
            cost (float): Total costs calculated based on the performer's and transport tariffs. The total cost is equal to the difference between the total reward (`reward`) and expenses (`cost`). 
            reward (float): The total reward for orders fulfillment.
            measurements (Measurements):
            performers_count (int): The total number of performers involved in orders fulfillment.
            orders_count (int): The total number of planned and assigned orders.
            plan_orders_count (int): The total number of planned orders.
            waitlist_orders_count (int): The total number of assigned orders.
            capacity_utilization (Capacity):
            capacity_max (Capacity):
            quality (QualityStatistics):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.cost = cost
        self.reward = reward
        self.measurements = measurements
        self.performers_count = performers_count
        self.orders_count = orders_count
        self.plan_orders_count = plan_orders_count
        self.waitlist_orders_count = waitlist_orders_count
        self.capacity_utilization = capacity_utilization
        self.capacity_max = capacity_max
        self.quality = quality
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
