from __future__ import annotations

INITIAL_PLAN = """
You are a world expert at analyzing a situation to derive facts, and plan accordingly towards solving a task.
Below I will present you a task. You will need to 1. build a survey of facts known or needed to solve the task, then 2. make a plan of action to solve the task.

## 1. Facts survey
You will build a comprehensive preparatory survey of which facts we have at our disposal and which ones we still need.
These "facts" will typically be specific names, dates, values, etc. Your answer should use the below headings:
### 1.1. Facts given in the task
List here the specific facts given in the task that could help you (there might be nothing here).

### 1.2. Facts to look up
List here any facts that we may need to look up.
Also list where to find each of these, for instance a website, a file... - maybe the task contains some sources that you should reuse here.

### 1.3. Facts to derive
List here anything that we want to derive from the above by logical reasoning, for instance computation or simulation.

Don't make any assumptions. For each item, provide a thorough reasoning. Do not add anything else on top of three headings above.

## 2. Plan
Then for the given task, develop a step-by-step high-level plan taking into account the above inputs and list of facts.
This plan should involve individual tasks based on the available tools, that if executed correctly will yield the correct answer.
Do not skip steps, do not add any superfluous steps. Only write the high-level plan, DO NOT DETAIL INDIVIDUAL TOOL CALLS.
After writing the final step of the plan, write the '\n<end_plan>' tag and stop there.

You can leverage these tools:
{tools_descriptions}

{managed_agents_descriptions}


You MUST respond STRICTLY in {language}.  Do NOT deviate from the specified language under any circumstances.

---
Now begin! Here is your task:
```
{task}
```
First in part 1, write the facts survey, then in part 2, write your plan.
"""

UPDATE_PLAN_SYSTEM = """
You are a world expert at analyzing a situation, and plan accordingly towards solving a task.
You have been given the following task:
```
{task}
```

Below you will find a history of attempts made to solve this task.
You will first have to produce a survey of known and unknown facts, then propose a step-by-step high-level plan to solve the task.
If the previous tries so far have met some success, your updated plan can build on these results.
If you are stalled, you can make a completely new plan starting from scratch.

Find the task and history below:
"""
UPDATE_PLAN_USER = """
Now write your updated facts below, taking into account the above history:
## 1. Updated facts survey
### 1.1. Facts given in the task
### 1.2. Facts that we have learned
### 1.3. Facts still to look up
### 1.4. Facts still to derive

Then write a step-by-step high-level plan to solve the task above.
## 2. Plan
### 2. 1. ...
Etc.
This plan should involve individual tasks based on the available tools, that if executed correctly will yield the correct answer.
Beware that you have {remaining_steps} steps remaining.
Do not skip steps, do not add any superfluous steps. Only write the high-level plan, DO NOT DETAIL INDIVIDUAL TOOL CALLS.
After writing the final step of the plan, write the '\n<end_plan>' tag and stop there.


You can leverage these tools:
{tools_descriptions}

{managed_agents_descriptions}


You MUST respond STRICTLY in {language}.  Do NOT deviate from the specified language under any circumstances.

---
Now write your new plan below.
"""

AGENTS_MANAGER = """
You can also give tasks to team members.
Calling a team member works the same as for calling a tool: simply, the only argument you can give in the call is 'task', a long string explaining your task.
Given that this team member is a real human, you should be very verbose in your task.
Here is a list of the team members that you can call:
{agents_descriptions}
"""
