"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/awslabs/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 */
class Intrinsic {
    constructor(value) {
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = stack_trace_1.captureStackTrace();
        this.value = value;
    }
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return `<unresolved-token>`;
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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