"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tag_manager_1 = require("./tag-manager");
/**
 * The common functionality for Tag and Remove Tag Aspects
 */
class TagBase {
    constructor(key, props = {}) {
        this.key = key;
        this.props = props;
    }
    visit(construct) {
        if (tag_manager_1.TagManager.isTaggable(construct)) {
            this.applyTag(construct);
        }
    }
}
/**
 * The Tag Aspect will handle adding a tag to this node and cascading tags to children
 */
class Tag extends TagBase {
    constructor(key, value, props = {}) {
        super(key, props);
        this.defaultPriority = 100;
        if (value === undefined) {
            throw new Error('Tag must have a value');
        }
        this.value = value;
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.setTag(this.key, this.value, this.props.priority !== undefined ? this.props.priority : this.defaultPriority, this.props.applyToLaunchedInstances !== false);
        }
    }
}
exports.Tag = Tag;
/**
 * The RemoveTag Aspect will handle removing tags from this node and children
 */
class RemoveTag extends TagBase {
    constructor(key, props = {}) {
        super(key, props);
        this.defaultPriority = 200;
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.removeTag(this.key, this.props.priority !== undefined ? this.props.priority : this.defaultPriority);
        }
    }
}
exports.RemoveTag = RemoveTag;
//# sourceMappingURL=data:application/json;base64,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