"use strict";
const lib_1 = require("../lib");
const construct_1 = require("../lib/construct");
class MyConstruct extends construct_1.Construct {
    constructor() {
        super(...arguments);
        this.visitCounter = 0;
    }
    static IsMyConstruct(x) {
        return x.visitCounter !== undefined;
    }
}
class VisitOnce {
    visit(node) {
        if (MyConstruct.IsMyConstruct(node)) {
            node.visitCounter += 1;
        }
    }
}
module.exports = {
    'Aspects are invoked only once'(test) {
        const app = new lib_1.App();
        const root = new MyConstruct(app, 'MyConstruct');
        root.node.applyAspect(new VisitOnce());
        construct_1.ConstructNode.prepare(root.node);
        test.deepEqual(root.visitCounter, 1);
        construct_1.ConstructNode.prepare(root.node);
        test.deepEqual(root.visitCounter, 1);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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