"use strict";
const nodeunit = require("nodeunit");
const core = require("../lib");
module.exports = nodeunit.testCase({
    '._toCloudFormation': {
        'does not call renderProperties with an undefined value'(test) {
            const app = new core.App();
            const stack = new core.Stack(app, 'TestStack');
            const resource = new core.CfnResource(stack, 'DefaultResource', { type: 'Test::Resource::Fake' });
            let called = false;
            resource.renderProperties = (val) => {
                called = true;
                test.notEqual(val, null);
            };
            test.deepEqual(app.synth().getStack(stack.stackName).template, {
                Resources: {
                    DefaultResource: {
                        Type: 'Test::Resource::Fake'
                    }
                }
            });
            test.ok(called, `renderProperties must be called called`);
            test.done();
        }
    }
});
//# sourceMappingURL=data:application/json;base64,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