"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before
 * synthesis.
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     * @param scope The scope for which these aspects will apply.
     */
    static of(scope) {
        jsiiDeprecationWarnings._aws_cdk_core_IConstruct(scope);
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     * @param aspect The aspect to add.
     */
    add(aspect) {
        jsiiDeprecationWarnings._aws_cdk_core_IAspect(aspect);
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "@aws-cdk/core.Aspects", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXNwZWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXNwZWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLE1BQU0sY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUMsQ0FBQztBQVk3Qzs7O0dBR0c7QUFDSCxNQUFhLE9BQU87SUFvQmxCLCtEQUErRDtJQUMvRCxZQUFxQyxLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0tBQUs7SUFuQjNEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxFQUFFLENBQUMsS0FBaUI7O1FBQ2hDLElBQUksT0FBTyxHQUFJLEtBQWEsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUM3QyxJQUFJLENBQUMsT0FBTyxFQUFFO1lBQ1osT0FBTyxHQUFHLElBQUksT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBRTdCLE1BQU0sQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLGNBQWMsRUFBRTtnQkFDM0MsS0FBSyxFQUFFLE9BQU87Z0JBQ2QsWUFBWSxFQUFFLEtBQUs7Z0JBQ25CLFVBQVUsRUFBRSxLQUFLO2FBQ2xCLENBQUMsQ0FBQztTQUNKO1FBQ0QsT0FBTyxPQUFPLENBQUM7S0FDaEI7SUFLRDs7O09BR0c7SUFDSSxHQUFHLENBQUMsTUFBZTs7UUFDeEIseUNBQXlDO1FBQ3pDLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUM7S0FDakQ7SUFFRDs7T0FFRztJQUNILElBQVcsT0FBTztRQUNoQiwyQ0FBMkM7UUFDM0MsT0FBTyxDQUFDLEdBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsV0FBbUIsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFFBQVE7S0FDcEU7O0FBdENILDBCQXVDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElDb25zdHJ1Y3QgfSBmcm9tICcuL2NvbnN0cnVjdC1jb21wYXQnO1xuXG5jb25zdCBBU1BFQ1RTX1NZTUJPTCA9IFN5bWJvbCgnY2RrLWFzcGVjdHMnKTtcblxuLyoqXG4gKiBSZXByZXNlbnRzIGFuIEFzcGVjdFxuICovXG5leHBvcnQgaW50ZXJmYWNlIElBc3BlY3Qge1xuICAvKipcbiAgICogQWxsIGFzcGVjdHMgY2FuIHZpc2l0IGFuIElDb25zdHJ1Y3RcbiAgICovXG4gIHZpc2l0KG5vZGU6IElDb25zdHJ1Y3QpOiB2b2lkO1xufVxuXG4vKipcbiAqIEFzcGVjdHMgY2FuIGJlIGFwcGxpZWQgdG8gQ0RLIHRyZWUgc2NvcGVzIGFuZCBjYW4gb3BlcmF0ZSBvbiB0aGUgdHJlZSBiZWZvcmVcbiAqIHN5bnRoZXNpcy5cbiAqL1xuZXhwb3J0IGNsYXNzIEFzcGVjdHMge1xuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBgQXNwZWN0c2Agb2JqZWN0IGFzc29jaWF0ZWQgd2l0aCBhIGNvbnN0cnVjdCBzY29wZS5cbiAgICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBmb3Igd2hpY2ggdGhlc2UgYXNwZWN0cyB3aWxsIGFwcGx5LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBvZihzY29wZTogSUNvbnN0cnVjdCk6IEFzcGVjdHMge1xuICAgIGxldCBhc3BlY3RzID0gKHNjb3BlIGFzIGFueSlbQVNQRUNUU19TWU1CT0xdO1xuICAgIGlmICghYXNwZWN0cykge1xuICAgICAgYXNwZWN0cyA9IG5ldyBBc3BlY3RzKHNjb3BlKTtcblxuICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHNjb3BlLCBBU1BFQ1RTX1NZTUJPTCwge1xuICAgICAgICB2YWx1ZTogYXNwZWN0cyxcbiAgICAgICAgY29uZmlndXJhYmxlOiBmYWxzZSxcbiAgICAgICAgZW51bWVyYWJsZTogZmFsc2UsXG4gICAgICB9KTtcbiAgICB9XG4gICAgcmV0dXJuIGFzcGVjdHM7XG4gIH1cblxuICAvLyBUT0RPKDIuMCk6IHByaXZhdGUgcmVhZG9ubHkgX2FzcGVjdHMgPSBuZXcgQXJyYXk8SUFzcGVjdD4oKTtcbiAgcHJpdmF0ZSBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHNjb3BlOiBJQ29uc3RydWN0KSB7IH1cblxuICAvKipcbiAgICogQWRkcyBhbiBhc3BlY3QgdG8gYXBwbHkgdGhpcyBzY29wZSBiZWZvcmUgc3ludGhlc2lzLlxuICAgKiBAcGFyYW0gYXNwZWN0IFRoZSBhc3BlY3QgdG8gYWRkLlxuICAgKi9cbiAgcHVibGljIGFkZChhc3BlY3Q6IElBc3BlY3QpIHtcbiAgICAvLyBUT0RPKDIuMCk6IHRoaXMuX2FzcGVjdHMucHVzaChhc3BlY3QpO1xuICAgIHRoaXMuc2NvcGUubm9kZS5fYWN0dWFsTm9kZS5hcHBseUFzcGVjdChhc3BlY3QpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBsaXN0IG9mIGFzcGVjdHMgd2hpY2ggd2VyZSBkaXJlY3RseSBhcHBsaWVkIG9uIHRoaXMgc2NvcGUuXG4gICAqL1xuICBwdWJsaWMgZ2V0IGFzcGVjdHMoKTogSUFzcGVjdFtdIHtcbiAgICAvLyBUT0RPKDIuMCk6IHJldHVybiAgWyAuLi50aGlzLl9hc3BlY3RzIF07XG4gICAgcmV0dXJuIFsuLi4odGhpcy5zY29wZS5ub2RlLl9hY3R1YWxOb2RlIGFzIGFueSkuX2FzcGVjdHNdOyAvLyBjbG9uZVxuICB9XG59Il19