# generated by datamodel-codegen:
#   filename:  email/emailRequest.json
#   timestamp: 2023-01-19T16:55:24+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class ContentType(Enum):
    plain = 'plain'
    html = 'html'


class NameEmailPair(BaseModel):
    class Config:
        extra = Extra.forbid

    name: Optional[str] = Field(None, description='Name')
    email: basic.Email = Field(..., description='Email address of the user.')


class EmailRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    senderName: Optional[str] = Field(None, description='Sender Name')
    senderMail: Optional[str] = Field(None, description='From Email Address')
    recipientMails: Optional[List[NameEmailPair]] = Field(
        None, description='List of Receiver Name with Email'
    )
    ccMails: Optional[List[NameEmailPair]] = Field(None, description='List of CC')
    bccMails: Optional[List[NameEmailPair]] = Field(None, description='List of BCC')
    subject: str = Field(..., description='Subject for Mail')
    contentType: ContentType
    content: Optional[str] = Field(None, description='Content for mail')
