# generated by datamodel-codegen:
#   filename:  entity/data/glossary.json
#   timestamp: 2023-01-19T16:55:24+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference, tagLabel


class Name(BaseModel):
    __root__: basic.EntityName = Field(
        ..., description='Name that identifies a glossary term.'
    )


class Glossary(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(..., description='Unique identifier of a glossary instance.')
    name: Name = Field(..., description='Name of the glossary')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as name.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this glossary.'
    )
    description: basic.Markdown = Field(..., description='Description of the glossary.')
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    reviewers: Optional[List[entityReference.EntityReference]] = Field(
        None, description='User references of the reviewers for this glossary.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this glossary.'
    )
    usageCount: Optional[int] = Field(
        None, description='Count of how many times terms from this glossary are used.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this glossary.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Optional[bool] = Field(
        None,
        description="System glossary can't be deleted. Use this flag to disable them.",
    )
    mutuallyExclusive: Optional[bool] = Field(
        'false',
        description='Glossary terms that are direct children in this glossary are mutually exclusive. When mutually exclusive is `true` only one term can be used to label an entity. When mutually exclusive is `false`, multiple terms from this group can be used to label an entity.',
    )
