# coding: utf-8

"""
    Financial Reports API

    API for accessing company filings, financial data, industry classifications, and related information.

    The version of the OpenAPI document: 1.0.0
    Contact: api@financialreports.eu
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from financial_reports_generated_client.models.company_minimal import CompanyMinimal
from financial_reports_generated_client.models.filing_type import FilingType
from financial_reports_generated_client.models.language import Language
from financial_reports_generated_client.models.source import Source
from typing import Optional, Set
from typing_extensions import Self

class Filing(BaseModel):
    """
    Filing
    """ # noqa: E501
    id: StrictInt
    company: CompanyMinimal
    filing_type: FilingType
    language: Language
    filing_date: date = Field(description="The official date of the filing (soon to be deprecated).")
    title: Optional[Annotated[str, Field(strict=True, max_length=200)]] = Field(default=None, description="Optional title for the filing")
    added_to_platform: datetime = Field(description="Date and time when the filing was added to our platform")
    updated_date: datetime = Field(description="The date and time this filing record was last modified.")
    dissemination_datetime: Optional[datetime] = Field(default=None, description="Time the document was released to the public and sent to the authority")
    release_datetime: Optional[datetime] = Field(default=None, description="Time the document was published on the authority page")
    source: Optional[Source]
    document: Optional[StrictStr]
    markdown_url: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["id", "company", "filing_type", "language", "filing_date", "title", "added_to_platform", "updated_date", "dissemination_datetime", "release_datetime", "source", "document", "markdown_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Filing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "company",
            "filing_type",
            "language",
            "added_to_platform",
            "updated_date",
            "source",
            "document",
            "markdown_url",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filing_type
        if self.filing_type:
            _dict['filing_type'] = self.filing_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of language
        if self.language:
            _dict['language'] = self.language.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # set to None if dissemination_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.dissemination_datetime is None and "dissemination_datetime" in self.model_fields_set:
            _dict['dissemination_datetime'] = None

        # set to None if release_datetime (nullable) is None
        # and model_fields_set contains the field
        if self.release_datetime is None and "release_datetime" in self.model_fields_set:
            _dict['release_datetime'] = None

        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict['source'] = None

        # set to None if document (nullable) is None
        # and model_fields_set contains the field
        if self.document is None and "document" in self.model_fields_set:
            _dict['document'] = None

        # set to None if markdown_url (nullable) is None
        # and model_fields_set contains the field
        if self.markdown_url is None and "markdown_url" in self.model_fields_set:
            _dict['markdown_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Filing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "company": CompanyMinimal.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "filing_type": FilingType.from_dict(obj["filing_type"]) if obj.get("filing_type") is not None else None,
            "language": Language.from_dict(obj["language"]) if obj.get("language") is not None else None,
            "filing_date": obj.get("filing_date"),
            "title": obj.get("title"),
            "added_to_platform": obj.get("added_to_platform"),
            "updated_date": obj.get("updated_date"),
            "dissemination_datetime": obj.get("dissemination_datetime"),
            "release_datetime": obj.get("release_datetime"),
            "source": Source.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "document": obj.get("document"),
            "markdown_url": obj.get("markdown_url")
        })
        return _obj


