# coding: utf-8

"""
    Financial Reports API

    API for accessing company filings, financial data, industry classifications, and related information.

    The version of the OpenAPI document: 1.0.0
    Contact: api@financialreports.eu
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from financial_reports_generated_client.models.filing import Filing
from financial_reports_generated_client.models.paginated_filing_summary_list import PaginatedFilingSummaryList

from financial_reports_generated_client.api_client import ApiClient, RequestSerialized
from financial_reports_generated_client.api_response import ApiResponse
from financial_reports_generated_client.rest import RESTResponseType


class FilingsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def filings_list(
        self,
        added_to_platform_from: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        added_to_platform_to: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        company: Annotated[Optional[StrictInt], Field(description="Filter by internal Company ID.")] = None,
        company_isin: Annotated[Optional[StrictStr], Field(description="Filter by Company ISIN. Case-insensitive.")] = None,
        countries: Annotated[Optional[StrictStr], Field(description="Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).")] = None,
        dissemination_datetime_from: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        dissemination_datetime_to: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Filter by a single filing language ISO 639-1 code (e.g., en).")] = None,
        languages: Annotated[Optional[StrictStr], Field(description="Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).")] = None,
        lei: Annotated[Optional[StrictStr], Field(description="Filter by Company Legal Entity Identifier (LEI).")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        release_datetime_from: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        release_datetime_to: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        source: Optional[StrictInt] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter by Filing Type code (e.g., ANNREP).")] = None,
        updated_date_from: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        updated_date_to: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> PaginatedFilingSummaryList:
        """List Filings

        Retrieve a paginated list of regulatory filings. This endpoint supports extensive filtering via query parameters, including: - **Company Identification**: Filter by internal `company` ID, `company_isin` (case-insensitive), or company `lei`. - **Company Location**: Filter by `countries` using comma-separated ISO Alpha-2 codes (e.g., `US,GB`). - **Filing Attributes**: Filter by `source` ID, `language` (single ISO 639-1 code), `languages` (comma-separated ISO 639-1 codes), or filing `type` code. - **Date Ranges**: Filter by various date fields. All datetime filters expect an ISO 8601 format (e.g., `YYYY-MM-DDTHH:MM:SSZ` or `YYYY-MM-DD`):     - `added_to_platform_from` / `added_to_platform_to`: Date the filing was added to the platform.     - `dissemination_datetime_from` / `dissemination_datetime_to`: Original dissemination date/time of the filing.     - `release_datetime_from` / `release_datetime_to`: Actual release date/time of the filing.  Additionally, you can use the `search` parameter to perform a text search across the company name and filing title. Results can be ordered using the `ordering` parameter with the fields: `release_datetime` and `added_to_platform` (e.g., `?ordering=-release_datetime`).

        :param added_to_platform_from: Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_from: datetime
        :param added_to_platform_to: Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_to: datetime
        :param company: Filter by internal Company ID.
        :type company: int
        :param company_isin: Filter by Company ISIN. Case-insensitive.
        :type company_isin: str
        :param countries: Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).
        :type countries: str
        :param dissemination_datetime_from: Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_from: datetime
        :param dissemination_datetime_to: Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_to: datetime
        :param language: Filter by a single filing language ISO 639-1 code (e.g., en).
        :type language: str
        :param languages: Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).
        :type languages: str
        :param lei: Filter by Company Legal Entity Identifier (LEI).
        :type lei: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param release_datetime_from: Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_from: datetime
        :param release_datetime_to: Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_to: datetime
        :param search: A search term.
        :type search: str
        :param source:
        :type source: int
        :param type: Filter by Filing Type code (e.g., ANNREP).
        :type type: str
        :param updated_date_from: Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_from: datetime
        :param updated_date_to: Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_to: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_list_serialize(
            added_to_platform_from=added_to_platform_from,
            added_to_platform_to=added_to_platform_to,
            company=company,
            company_isin=company_isin,
            countries=countries,
            dissemination_datetime_from=dissemination_datetime_from,
            dissemination_datetime_to=dissemination_datetime_to,
            language=language,
            languages=languages,
            lei=lei,
            ordering=ordering,
            page=page,
            page_size=page_size,
            release_datetime_from=release_datetime_from,
            release_datetime_to=release_datetime_to,
            search=search,
            source=source,
            type=type,
            updated_date_from=updated_date_from,
            updated_date_to=updated_date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedFilingSummaryList",
            '401': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def filings_list_with_http_info(
        self,
        added_to_platform_from: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        added_to_platform_to: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        company: Annotated[Optional[StrictInt], Field(description="Filter by internal Company ID.")] = None,
        company_isin: Annotated[Optional[StrictStr], Field(description="Filter by Company ISIN. Case-insensitive.")] = None,
        countries: Annotated[Optional[StrictStr], Field(description="Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).")] = None,
        dissemination_datetime_from: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        dissemination_datetime_to: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Filter by a single filing language ISO 639-1 code (e.g., en).")] = None,
        languages: Annotated[Optional[StrictStr], Field(description="Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).")] = None,
        lei: Annotated[Optional[StrictStr], Field(description="Filter by Company Legal Entity Identifier (LEI).")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        release_datetime_from: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        release_datetime_to: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        source: Optional[StrictInt] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter by Filing Type code (e.g., ANNREP).")] = None,
        updated_date_from: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        updated_date_to: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[PaginatedFilingSummaryList]:
        """List Filings

        Retrieve a paginated list of regulatory filings. This endpoint supports extensive filtering via query parameters, including: - **Company Identification**: Filter by internal `company` ID, `company_isin` (case-insensitive), or company `lei`. - **Company Location**: Filter by `countries` using comma-separated ISO Alpha-2 codes (e.g., `US,GB`). - **Filing Attributes**: Filter by `source` ID, `language` (single ISO 639-1 code), `languages` (comma-separated ISO 639-1 codes), or filing `type` code. - **Date Ranges**: Filter by various date fields. All datetime filters expect an ISO 8601 format (e.g., `YYYY-MM-DDTHH:MM:SSZ` or `YYYY-MM-DD`):     - `added_to_platform_from` / `added_to_platform_to`: Date the filing was added to the platform.     - `dissemination_datetime_from` / `dissemination_datetime_to`: Original dissemination date/time of the filing.     - `release_datetime_from` / `release_datetime_to`: Actual release date/time of the filing.  Additionally, you can use the `search` parameter to perform a text search across the company name and filing title. Results can be ordered using the `ordering` parameter with the fields: `release_datetime` and `added_to_platform` (e.g., `?ordering=-release_datetime`).

        :param added_to_platform_from: Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_from: datetime
        :param added_to_platform_to: Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_to: datetime
        :param company: Filter by internal Company ID.
        :type company: int
        :param company_isin: Filter by Company ISIN. Case-insensitive.
        :type company_isin: str
        :param countries: Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).
        :type countries: str
        :param dissemination_datetime_from: Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_from: datetime
        :param dissemination_datetime_to: Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_to: datetime
        :param language: Filter by a single filing language ISO 639-1 code (e.g., en).
        :type language: str
        :param languages: Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).
        :type languages: str
        :param lei: Filter by Company Legal Entity Identifier (LEI).
        :type lei: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param release_datetime_from: Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_from: datetime
        :param release_datetime_to: Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_to: datetime
        :param search: A search term.
        :type search: str
        :param source:
        :type source: int
        :param type: Filter by Filing Type code (e.g., ANNREP).
        :type type: str
        :param updated_date_from: Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_from: datetime
        :param updated_date_to: Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_to: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_list_serialize(
            added_to_platform_from=added_to_platform_from,
            added_to_platform_to=added_to_platform_to,
            company=company,
            company_isin=company_isin,
            countries=countries,
            dissemination_datetime_from=dissemination_datetime_from,
            dissemination_datetime_to=dissemination_datetime_to,
            language=language,
            languages=languages,
            lei=lei,
            ordering=ordering,
            page=page,
            page_size=page_size,
            release_datetime_from=release_datetime_from,
            release_datetime_to=release_datetime_to,
            search=search,
            source=source,
            type=type,
            updated_date_from=updated_date_from,
            updated_date_to=updated_date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedFilingSummaryList",
            '401': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def filings_list_without_preload_content(
        self,
        added_to_platform_from: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        added_to_platform_to: Annotated[Optional[datetime], Field(description="Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        company: Annotated[Optional[StrictInt], Field(description="Filter by internal Company ID.")] = None,
        company_isin: Annotated[Optional[StrictStr], Field(description="Filter by Company ISIN. Case-insensitive.")] = None,
        countries: Annotated[Optional[StrictStr], Field(description="Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).")] = None,
        dissemination_datetime_from: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        dissemination_datetime_to: Annotated[Optional[datetime], Field(description="Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        language: Annotated[Optional[StrictStr], Field(description="Filter by a single filing language ISO 639-1 code (e.g., en).")] = None,
        languages: Annotated[Optional[StrictStr], Field(description="Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).")] = None,
        lei: Annotated[Optional[StrictStr], Field(description="Filter by Company Legal Entity Identifier (LEI).")] = None,
        ordering: Annotated[Optional[StrictStr], Field(description="Which field to use when ordering the results.")] = None,
        page: Annotated[Optional[StrictInt], Field(description="A page number within the paginated result set.")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Number of results to return per page.")] = None,
        release_datetime_from: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        release_datetime_to: Annotated[Optional[datetime], Field(description="Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        search: Annotated[Optional[StrictStr], Field(description="A search term.")] = None,
        source: Optional[StrictInt] = None,
        type: Annotated[Optional[StrictStr], Field(description="Filter by Filing Type code (e.g., ANNREP).")] = None,
        updated_date_from: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        updated_date_to: Annotated[Optional[datetime], Field(description="Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Filings

        Retrieve a paginated list of regulatory filings. This endpoint supports extensive filtering via query parameters, including: - **Company Identification**: Filter by internal `company` ID, `company_isin` (case-insensitive), or company `lei`. - **Company Location**: Filter by `countries` using comma-separated ISO Alpha-2 codes (e.g., `US,GB`). - **Filing Attributes**: Filter by `source` ID, `language` (single ISO 639-1 code), `languages` (comma-separated ISO 639-1 codes), or filing `type` code. - **Date Ranges**: Filter by various date fields. All datetime filters expect an ISO 8601 format (e.g., `YYYY-MM-DDTHH:MM:SSZ` or `YYYY-MM-DD`):     - `added_to_platform_from` / `added_to_platform_to`: Date the filing was added to the platform.     - `dissemination_datetime_from` / `dissemination_datetime_to`: Original dissemination date/time of the filing.     - `release_datetime_from` / `release_datetime_to`: Actual release date/time of the filing.  Additionally, you can use the `search` parameter to perform a text search across the company name and filing title. Results can be ordered using the `ordering` parameter with the fields: `release_datetime` and `added_to_platform` (e.g., `?ordering=-release_datetime`).

        :param added_to_platform_from: Filter by date added to platform (inclusive start date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_from: datetime
        :param added_to_platform_to: Filter by date added to platform (inclusive end date, YYYY-MM-DDTHH:MM:SSZ format).
        :type added_to_platform_to: datetime
        :param company: Filter by internal Company ID.
        :type company: int
        :param company_isin: Filter by Company ISIN. Case-insensitive.
        :type company_isin: str
        :param countries: Filter by Company country ISO Alpha-2 code(s). Comma-separated for multiple values (e.g., US,GB,DE).
        :type countries: str
        :param dissemination_datetime_from: Filter by dissemination datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_from: datetime
        :param dissemination_datetime_to: Filter by dissemination datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type dissemination_datetime_to: datetime
        :param language: Filter by a single filing language ISO 639-1 code (e.g., en).
        :type language: str
        :param languages: Filter by filing language ISO 639-1 code(s). Comma-separated for multiple values (e.g., en,de).
        :type languages: str
        :param lei: Filter by Company Legal Entity Identifier (LEI).
        :type lei: str
        :param ordering: Which field to use when ordering the results.
        :type ordering: str
        :param page: A page number within the paginated result set.
        :type page: int
        :param page_size: Number of results to return per page.
        :type page_size: int
        :param release_datetime_from: Filter by release datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_from: datetime
        :param release_datetime_to: Filter by release datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type release_datetime_to: datetime
        :param search: A search term.
        :type search: str
        :param source:
        :type source: int
        :param type: Filter by Filing Type code (e.g., ANNREP).
        :type type: str
        :param updated_date_from: Filter by last update datetime (inclusive start, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_from: datetime
        :param updated_date_to: Filter by last update datetime (inclusive end, YYYY-MM-DDTHH:MM:SSZ format).
        :type updated_date_to: datetime
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_list_serialize(
            added_to_platform_from=added_to_platform_from,
            added_to_platform_to=added_to_platform_to,
            company=company,
            company_isin=company_isin,
            countries=countries,
            dissemination_datetime_from=dissemination_datetime_from,
            dissemination_datetime_to=dissemination_datetime_to,
            language=language,
            languages=languages,
            lei=lei,
            ordering=ordering,
            page=page,
            page_size=page_size,
            release_datetime_from=release_datetime_from,
            release_datetime_to=release_datetime_to,
            search=search,
            source=source,
            type=type,
            updated_date_from=updated_date_from,
            updated_date_to=updated_date_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PaginatedFilingSummaryList",
            '401': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _filings_list_serialize(
        self,
        added_to_platform_from,
        added_to_platform_to,
        company,
        company_isin,
        countries,
        dissemination_datetime_from,
        dissemination_datetime_to,
        language,
        languages,
        lei,
        ordering,
        page,
        page_size,
        release_datetime_from,
        release_datetime_to,
        search,
        source,
        type,
        updated_date_from,
        updated_date_to,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if added_to_platform_from is not None:
            if isinstance(added_to_platform_from, datetime):
                _query_params.append(
                    (
                        'added_to_platform_from',
                        added_to_platform_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('added_to_platform_from', added_to_platform_from))
            
        if added_to_platform_to is not None:
            if isinstance(added_to_platform_to, datetime):
                _query_params.append(
                    (
                        'added_to_platform_to',
                        added_to_platform_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('added_to_platform_to', added_to_platform_to))
            
        if company is not None:
            
            _query_params.append(('company', company))
            
        if company_isin is not None:
            
            _query_params.append(('company_isin', company_isin))
            
        if countries is not None:
            
            _query_params.append(('countries', countries))
            
        if dissemination_datetime_from is not None:
            if isinstance(dissemination_datetime_from, datetime):
                _query_params.append(
                    (
                        'dissemination_datetime_from',
                        dissemination_datetime_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('dissemination_datetime_from', dissemination_datetime_from))
            
        if dissemination_datetime_to is not None:
            if isinstance(dissemination_datetime_to, datetime):
                _query_params.append(
                    (
                        'dissemination_datetime_to',
                        dissemination_datetime_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('dissemination_datetime_to', dissemination_datetime_to))
            
        if language is not None:
            
            _query_params.append(('language', language))
            
        if languages is not None:
            
            _query_params.append(('languages', languages))
            
        if lei is not None:
            
            _query_params.append(('lei', lei))
            
        if ordering is not None:
            
            _query_params.append(('ordering', ordering))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if release_datetime_from is not None:
            if isinstance(release_datetime_from, datetime):
                _query_params.append(
                    (
                        'release_datetime_from',
                        release_datetime_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('release_datetime_from', release_datetime_from))
            
        if release_datetime_to is not None:
            if isinstance(release_datetime_to, datetime):
                _query_params.append(
                    (
                        'release_datetime_to',
                        release_datetime_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('release_datetime_to', release_datetime_to))
            
        if search is not None:
            
            _query_params.append(('search', search))
            
        if source is not None:
            
            _query_params.append(('source', source))
            
        if type is not None:
            
            _query_params.append(('type', type))
            
        if updated_date_from is not None:
            if isinstance(updated_date_from, datetime):
                _query_params.append(
                    (
                        'updated_date_from',
                        updated_date_from.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_date_from', updated_date_from))
            
        if updated_date_to is not None:
            if isinstance(updated_date_to, datetime):
                _query_params.append(
                    (
                        'updated_date_to',
                        updated_date_to.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('updated_date_to', updated_date_to))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/filings/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def filings_markdown_retrieve(
        self,
        filing_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Retrieve Filing Markdown

        Retrieve the raw processed content of a single filing in Markdown format.

        :param filing_id: (required)
        :type filing_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_markdown_retrieve_serialize(
            filing_id=filing_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def filings_markdown_retrieve_with_http_info(
        self,
        filing_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Retrieve Filing Markdown

        Retrieve the raw processed content of a single filing in Markdown format.

        :param filing_id: (required)
        :type filing_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_markdown_retrieve_serialize(
            filing_id=filing_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def filings_markdown_retrieve_without_preload_content(
        self,
        filing_id: StrictInt,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve Filing Markdown

        Retrieve the raw processed content of a single filing in Markdown format.

        :param filing_id: (required)
        :type filing_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_markdown_retrieve_serialize(
            filing_id=filing_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '404': None,
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _filings_markdown_retrieve_serialize(
        self,
        filing_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if filing_id is not None:
            _path_params['filing_id'] = filing_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/filings/{filing_id}/markdown/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def filings_retrieve(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this filing.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Filing:
        """Retrieve Filing Details

        Retrieve detailed information for a single filing by its ID.

        :param id: A unique integer value identifying this filing. (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_retrieve_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Filing",
            '401': "ErrorDetail",
            '404': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def filings_retrieve_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this filing.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Filing]:
        """Retrieve Filing Details

        Retrieve detailed information for a single filing by its ID.

        :param id: A unique integer value identifying this filing. (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_retrieve_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Filing",
            '401': "ErrorDetail",
            '404': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def filings_retrieve_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="A unique integer value identifying this filing.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve Filing Details

        Retrieve detailed information for a single filing by its ID.

        :param id: A unique integer value identifying this filing. (required)
        :type id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._filings_retrieve_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Filing",
            '401': "ErrorDetail",
            '404': "ErrorDetail",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _filings_retrieve_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/filings/{id}/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


