# coding: utf-8

"""
    Financial Reports API

    API for accessing company filings, financial data, industry classifications, and related information.

    The version of the OpenAPI document: 1.0.0
    Contact: api@financialreports.eu
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from financial_reports_generated_client.models.isic_class import ISICClass
from financial_reports_generated_client.models.isic_division import ISICDivision
from financial_reports_generated_client.models.isic_group import ISICGroup
from financial_reports_generated_client.models.isic_section import ISICSection
from typing import Optional, Set
from typing_extensions import Self

class Company(BaseModel):
    """
    Company
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier for the company.")
    name: StrictStr = Field(description="Company name.")
    lei: StrictStr = Field(description="Legal Entity Identifier (ISO 17442).")
    country_code: Optional[StrictStr] = Field(description="ISO 3166-1 alpha-2 country code of the company's primary registration or headquarters.")
    sector: Optional[ISICSection] = Field(description="Company's ISIC Section classification.")
    industry_group: Optional[ISICDivision] = Field(description="Company's ISIC Division classification.")
    industry: Optional[ISICGroup] = Field(description="Company's ISIC Group classification.")
    sub_industry: Optional[ISICClass] = Field(description="Company's ISIC Class classification.")
    ir_link: StrictStr = Field(description="Link to the company's Investor Relations page.")
    homepage_link: StrictStr = Field(description="Link to the company's main homepage.")
    date_public: Optional[date] = Field(description="Date the company first became public.")
    date_ipo: date = Field(description="Date of the company's Initial Public Offering.")
    main_stock_exchange: StrictStr = Field(description="Primary stock exchange where the company is listed.")
    social_facebook: Optional[StrictStr] = Field(description="Facebook profile/page identifier.")
    social_instagram: Optional[StrictStr] = Field(description="Instagram profile identifier.")
    social_twitter: Optional[StrictStr] = Field(description="Twitter handle (without @).")
    social_linkedin: Optional[StrictStr] = Field(description="LinkedIn company page identifier/URL path.")
    social_youtube: Optional[StrictStr] = Field(description="YouTube channel identifier.")
    social_tiktok: Optional[StrictStr] = Field(description="TikTok profile identifier.")
    social_pinterest: Optional[StrictStr] = Field(description="Pinterest profile identifier.")
    social_xing: Optional[StrictStr] = Field(description="Xing company profile identifier.")
    social_glassdoor: Optional[StrictStr] = Field(description="Glassdoor company identifier.")
    year_founded: Optional[date] = Field(description="Date the company was founded.")
    corporate_video_id: Optional[StrictStr] = Field(description="Identifier for a corporate video (e.g., YouTube ID).")
    served_area: Optional[StrictStr] = Field(description="Geographical area served by the company.")
    headcount: Optional[StrictInt] = Field(description="Approximate number of employees.")
    contact_email: Optional[StrictStr] = Field(description="General contact email address.")
    ticker: Optional[StrictStr] = Field(description="Primary stock ticker symbol.")
    is_listed: StrictBool = Field(description="Indicates if the company is currently publicly listed.")
    __properties: ClassVar[List[str]] = ["id", "name", "lei", "country_code", "sector", "industry_group", "industry", "sub_industry", "ir_link", "homepage_link", "date_public", "date_ipo", "main_stock_exchange", "social_facebook", "social_instagram", "social_twitter", "social_linkedin", "social_youtube", "social_tiktok", "social_pinterest", "social_xing", "social_glassdoor", "year_founded", "corporate_video_id", "served_area", "headcount", "contact_email", "ticker", "is_listed"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Company from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "name",
            "lei",
            "country_code",
            "sector",
            "industry_group",
            "industry",
            "sub_industry",
            "ir_link",
            "homepage_link",
            "date_public",
            "date_ipo",
            "main_stock_exchange",
            "social_facebook",
            "social_instagram",
            "social_twitter",
            "social_linkedin",
            "social_youtube",
            "social_tiktok",
            "social_pinterest",
            "social_xing",
            "social_glassdoor",
            "year_founded",
            "corporate_video_id",
            "served_area",
            "headcount",
            "contact_email",
            "ticker",
            "is_listed",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sector
        if self.sector:
            _dict['sector'] = self.sector.to_dict()
        # override the default output from pydantic by calling `to_dict()` of industry_group
        if self.industry_group:
            _dict['industry_group'] = self.industry_group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of industry
        if self.industry:
            _dict['industry'] = self.industry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_industry
        if self.sub_industry:
            _dict['sub_industry'] = self.sub_industry.to_dict()
        # set to None if country_code (nullable) is None
        # and model_fields_set contains the field
        if self.country_code is None and "country_code" in self.model_fields_set:
            _dict['country_code'] = None

        # set to None if sector (nullable) is None
        # and model_fields_set contains the field
        if self.sector is None and "sector" in self.model_fields_set:
            _dict['sector'] = None

        # set to None if industry_group (nullable) is None
        # and model_fields_set contains the field
        if self.industry_group is None and "industry_group" in self.model_fields_set:
            _dict['industry_group'] = None

        # set to None if industry (nullable) is None
        # and model_fields_set contains the field
        if self.industry is None and "industry" in self.model_fields_set:
            _dict['industry'] = None

        # set to None if sub_industry (nullable) is None
        # and model_fields_set contains the field
        if self.sub_industry is None and "sub_industry" in self.model_fields_set:
            _dict['sub_industry'] = None

        # set to None if date_public (nullable) is None
        # and model_fields_set contains the field
        if self.date_public is None and "date_public" in self.model_fields_set:
            _dict['date_public'] = None

        # set to None if social_facebook (nullable) is None
        # and model_fields_set contains the field
        if self.social_facebook is None and "social_facebook" in self.model_fields_set:
            _dict['social_facebook'] = None

        # set to None if social_instagram (nullable) is None
        # and model_fields_set contains the field
        if self.social_instagram is None and "social_instagram" in self.model_fields_set:
            _dict['social_instagram'] = None

        # set to None if social_twitter (nullable) is None
        # and model_fields_set contains the field
        if self.social_twitter is None and "social_twitter" in self.model_fields_set:
            _dict['social_twitter'] = None

        # set to None if social_linkedin (nullable) is None
        # and model_fields_set contains the field
        if self.social_linkedin is None and "social_linkedin" in self.model_fields_set:
            _dict['social_linkedin'] = None

        # set to None if social_youtube (nullable) is None
        # and model_fields_set contains the field
        if self.social_youtube is None and "social_youtube" in self.model_fields_set:
            _dict['social_youtube'] = None

        # set to None if social_tiktok (nullable) is None
        # and model_fields_set contains the field
        if self.social_tiktok is None and "social_tiktok" in self.model_fields_set:
            _dict['social_tiktok'] = None

        # set to None if social_pinterest (nullable) is None
        # and model_fields_set contains the field
        if self.social_pinterest is None and "social_pinterest" in self.model_fields_set:
            _dict['social_pinterest'] = None

        # set to None if social_xing (nullable) is None
        # and model_fields_set contains the field
        if self.social_xing is None and "social_xing" in self.model_fields_set:
            _dict['social_xing'] = None

        # set to None if social_glassdoor (nullable) is None
        # and model_fields_set contains the field
        if self.social_glassdoor is None and "social_glassdoor" in self.model_fields_set:
            _dict['social_glassdoor'] = None

        # set to None if year_founded (nullable) is None
        # and model_fields_set contains the field
        if self.year_founded is None and "year_founded" in self.model_fields_set:
            _dict['year_founded'] = None

        # set to None if corporate_video_id (nullable) is None
        # and model_fields_set contains the field
        if self.corporate_video_id is None and "corporate_video_id" in self.model_fields_set:
            _dict['corporate_video_id'] = None

        # set to None if served_area (nullable) is None
        # and model_fields_set contains the field
        if self.served_area is None and "served_area" in self.model_fields_set:
            _dict['served_area'] = None

        # set to None if headcount (nullable) is None
        # and model_fields_set contains the field
        if self.headcount is None and "headcount" in self.model_fields_set:
            _dict['headcount'] = None

        # set to None if contact_email (nullable) is None
        # and model_fields_set contains the field
        if self.contact_email is None and "contact_email" in self.model_fields_set:
            _dict['contact_email'] = None

        # set to None if ticker (nullable) is None
        # and model_fields_set contains the field
        if self.ticker is None and "ticker" in self.model_fields_set:
            _dict['ticker'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Company from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "lei": obj.get("lei"),
            "country_code": obj.get("country_code"),
            "sector": ISICSection.from_dict(obj["sector"]) if obj.get("sector") is not None else None,
            "industry_group": ISICDivision.from_dict(obj["industry_group"]) if obj.get("industry_group") is not None else None,
            "industry": ISICGroup.from_dict(obj["industry"]) if obj.get("industry") is not None else None,
            "sub_industry": ISICClass.from_dict(obj["sub_industry"]) if obj.get("sub_industry") is not None else None,
            "ir_link": obj.get("ir_link"),
            "homepage_link": obj.get("homepage_link"),
            "date_public": obj.get("date_public"),
            "date_ipo": obj.get("date_ipo"),
            "main_stock_exchange": obj.get("main_stock_exchange"),
            "social_facebook": obj.get("social_facebook"),
            "social_instagram": obj.get("social_instagram"),
            "social_twitter": obj.get("social_twitter"),
            "social_linkedin": obj.get("social_linkedin"),
            "social_youtube": obj.get("social_youtube"),
            "social_tiktok": obj.get("social_tiktok"),
            "social_pinterest": obj.get("social_pinterest"),
            "social_xing": obj.get("social_xing"),
            "social_glassdoor": obj.get("social_glassdoor"),
            "year_founded": obj.get("year_founded"),
            "corporate_video_id": obj.get("corporate_video_id"),
            "served_area": obj.get("served_area"),
            "headcount": obj.get("headcount"),
            "contact_email": obj.get("contact_email"),
            "ticker": obj.get("ticker"),
            "is_listed": obj.get("is_listed")
        })
        return _obj


