"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BootstraplessSynthesizer = void 0;
const _shared_1 = require("./_shared");
const default_synthesizer_1 = require("./default-synthesizer");
/**
 * A special synthesizer that behaves similarly to DefaultStackSynthesizer,
 * but doesn't require bootstrapping the environment it operates in.
 * Because of that, stacks using it cannot have assets inside of them.
 * Used by the CodePipeline construct for the support stacks needed for
 * cross-region replication S3 buckets.
 */
class BootstraplessSynthesizer extends default_synthesizer_1.DefaultStackSynthesizer {
    constructor(props) {
        super({
            deployRoleArn: props.deployRoleArn,
            cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn,
            generateBootstrapVersionRule: false,
        });
    }
    addFileAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    addDockerImageAsset(_asset) {
        throw new Error('Cannot add assets to a Stack that uses the BootstraplessSynthesizer');
    }
    synthesize(session) {
        _shared_1.assertBound(this.stack);
        this.synthesizeStackTemplate(this.stack, session);
        // do _not_ treat the template as an asset,
        // because this synthesizer doesn't have a bootstrap bucket to put it in
        this.emitStackArtifact(this.stack, session, {
            assumeRoleArn: this.deployRoleArn,
            cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn,
            requiresBootstrapStackVersion: 1,
        });
    }
}
exports.BootstraplessSynthesizer = BootstraplessSynthesizer;
//# sourceMappingURL=data:application/json;base64,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