"use strict";
const cdk = require("../lib");
const util_1 = require("./util");
module.exports = {
    'chain conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const param = new cdk.CfnParameter(stack, 'Param1', { type: 'String' });
        const cond1 = new cdk.CfnCondition(stack, 'Condition1', { expression: cdk.Fn.conditionEquals('a', 'b') });
        const cond2 = new cdk.CfnCondition(stack, 'Condition2', { expression: cdk.Fn.conditionContains(['a', 'b', 'c'], 'c') });
        const cond3 = new cdk.CfnCondition(stack, 'Condition3', { expression: cdk.Fn.conditionEquals(param, 'hello') });
        // WHEN
        new cdk.CfnCondition(stack, 'Condition4', {
            expression: cdk.Fn.conditionOr(cond1, cond2, cdk.Fn.conditionNot(cond3)),
        });
        // THEN
        test.deepEqual(util_1.toCloudFormation(stack), {
            Parameters: { Param1: { Type: 'String' } },
            Conditions: {
                Condition1: { 'Fn::Equals': ['a', 'b'] },
                Condition2: { 'Fn::Contains': [['a', 'b', 'c'], 'c'] },
                Condition3: { 'Fn::Equals': [{ Ref: 'Param1' }, 'hello'] },
                Condition4: {
                    'Fn::Or': [
                        { Condition: 'Condition1' },
                        { Condition: 'Condition2' },
                        { 'Fn::Not': [{ Condition: 'Condition3' }] },
                    ],
                },
            },
        });
        test.done();
    },
    'condition expressions can be embedded as strings'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const propValue = cdk.Fn.conditionIf('Cond', 'A', 'B').toString();
        // WHEN
        new cdk.CfnResource(stack, 'MyResource', {
            type: 'AWS::Foo::Bar',
            properties: {
                StringProp: propValue,
            },
        });
        // THEN
        test.ok(cdk.Token.isUnresolved(propValue));
        test.deepEqual(util_1.toCloudFormation(stack), {
            Resources: {
                MyResource: {
                    Type: 'AWS::Foo::Bar',
                    Properties: {
                        StringProp: { 'Fn::If': ['Cond', 'A', 'B'] },
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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