"use strict";
const nodeunit = require("nodeunit");
const lib_1 = require("../lib");
module.exports = nodeunit.testCase({
    'from string'(test) {
        const date = new Date('Sun, 26 Jan 2020 00:53:20 GMT');
        test.equal(lib_1.Expiration.fromString('Sun, 26 Jan 2020 00:53:20 GMT').date.getDate(), date.getDate());
        test.done();
    },
    'at specified date'(test) {
        const date = new Date('Sun, 26 Jan 2020 00:53:20 GMT');
        test.equal(lib_1.Expiration.atDate(new Date('Sun, 26 Jan 2020 00:53:20 GMT')).date.toUTCString(), 'Sun, 26 Jan 2020 00:53:20 GMT');
        test.equal(lib_1.Expiration.atDate(new Date(1580000000000)).date.toUTCString(), 'Sun, 26 Jan 2020 00:53:20 GMT');
        test.equal(lib_1.Expiration.atDate(new Date(date)).date.toUTCString(), 'Sun, 26 Jan 2020 00:53:20 GMT');
        test.done();
    },
    'at time stamp'(test) {
        test.equal(lib_1.Expiration.atDate(new Date(1580000000000)).date.toUTCString(), 'Sun, 26 Jan 2020 00:53:20 GMT');
        test.done();
    },
    'after'(test) {
        test.ok(Math.abs(new Date(lib_1.Expiration.after(lib_1.Duration.minutes(10)).date.toUTCString()).getTime() - (Date.now() + 600000)) < 15000);
        test.done();
    },
    'toEpoch returns correct value'(test) {
        const date = new Date('Sun, 26 Jan 2020 00:53:20 GMT');
        test.equal(lib_1.Expiration.atDate(date).toEpoch(), 1580000000);
        test.done();
    },
    'isBefore'(test) {
        const expire = lib_1.Expiration.after(lib_1.Duration.days(2));
        test.ok(!expire.isBefore(lib_1.Duration.days(1)));
        test.ok(expire.isBefore(lib_1.Duration.days(3)));
        test.done();
    },
    'isAfter'(test) {
        const expire = lib_1.Expiration.after(lib_1.Duration.days(2));
        test.ok(expire.isAfter(lib_1.Duration.days(1)));
        test.ok(!expire.isAfter(lib_1.Duration.days(3)));
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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