from typing import List, Optional, Dict, Iterable, Any, overload
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.cells
import aspose.cells.charts
import aspose.cells.datamodels
import aspose.cells.digitalsignatures
import aspose.cells.drawing
import aspose.cells.drawing.activexcontrols
import aspose.cells.drawing.equations
import aspose.cells.drawing.texts
import aspose.cells.externalconnections
import aspose.cells.json
import aspose.cells.loading
import aspose.cells.lowcode
import aspose.cells.markdown
import aspose.cells.markup
import aspose.cells.metadata
import aspose.cells.metas
import aspose.cells.numbers
import aspose.cells.ods
import aspose.cells.pivot
import aspose.cells.properties
import aspose.cells.querytables
import aspose.cells.rendering
import aspose.cells.rendering.pdfsecurity
import aspose.cells.revisions
import aspose.cells.saving
import aspose.cells.settings
import aspose.cells.slicers
import aspose.cells.slides
import aspose.cells.tables
import aspose.cells.timelines
import aspose.cells.utility
import aspose.cells.vba
import aspose.cells.webextensions

class ArcShape(Shape):
    '''Represents the arc shape.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the begin arrow head style of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_style.setter
    def begin_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the begin arrow head style of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the begin arrow head width of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_width.setter
    def begin_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the begin arrow head width of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the begin arrow head length of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_length.setter
    def begin_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the begin arrow head length of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the end arrow head style of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_style.setter
    def end_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the end arrow head style of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the end arrow head width of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_width.setter
    def end_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the end arrow head width of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the end arrow head length of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_length.setter
    def end_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the end arrow head length of the line.'''
        raise NotImplementedError()
    

class Area:
    '''Encapsulates the object that represents an area format.'''
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Gets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Gets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @property
    def formatting(self) -> aspose.cells.charts.FormattingType:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @formatting.setter
    def formatting(self, value : aspose.cells.charts.FormattingType) -> None:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @property
    def invert_if_negative(self) -> bool:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @invert_if_negative.setter
    def invert_if_negative(self, value : bool) -> None:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.FillFormat:
        '''Represents a :py:attr:`aspose.cells.drawing.Area.fill_format` object that contains fill formatting properties for the specified chart or shape.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    

class AutomaticFill(Fill):
    '''represents automatic fill.'''
    

class BaseShapeGuide:
    '''Represents the shape guide.'''
    

class Bevel:
    '''Represents a bevel of a shape'''
    
    @property
    def width(self) -> float:
        '''Gets and sets the width of the bevel, or how far into the shape it is applied.
        In unit of Points.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Gets and sets the width of the bevel, or how far into the shape it is applied.
        In unit of Points.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Gets and sets the height of the bevel, or how far above the shape it is applied.
        In unit of Points.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : float) -> None:
        '''Gets and sets the height of the bevel, or how far above the shape it is applied.
        In unit of Points.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.BevelPresetType:
        '''Gets and sets the preset bevel type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.drawing.BevelPresetType) -> None:
        '''Gets and sets the preset bevel type.'''
        raise NotImplementedError()
    

class Button(Shape):
    '''Represents the Forms control: Button'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class CellsDrawing(Shape):
    '''Represents the auto shape and drawing object.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class ChartShape(Shape):
    '''Represents the shape of the chart.
    Properties and methods for the ChartObject object control the appearance and size of the embedded chart on the worksheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def chart(self) -> aspose.cells.charts.Chart:
        '''Returns a Chart object that represents the chart contained in the object.'''
        raise NotImplementedError()
    

class CheckBox(Shape):
    '''Represents a check box object in a worksheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> bool:
        '''Indicates if the checkbox is checked or not.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : bool) -> None:
        '''Indicates if the checkbox is checked or not.'''
        raise NotImplementedError()
    
    @property
    def check_value(self) -> aspose.cells.drawing.CheckValueType:
        '''Gets or set checkbox\' value.'''
        raise NotImplementedError()
    
    @check_value.setter
    def check_value(self, value : aspose.cells.drawing.CheckValueType) -> None:
        '''Set checkbox\' value.'''
        raise NotImplementedError()
    
    @property
    def checked_value(self) -> aspose.cells.drawing.CheckValueType:
        '''Gets or set checkbox\' value.'''
        raise NotImplementedError()
    
    @checked_value.setter
    def checked_value(self, value : aspose.cells.drawing.CheckValueType) -> None:
        '''Set checkbox\' value.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    

class CheckBoxCollection:
    '''Represents a collection of :py:class:`aspose.cells.drawing.CheckBox` objects in a worksheet.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.CheckBox]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.CheckBox], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.CheckBox, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.CheckBox, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.CheckBox) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.CheckBox, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.CheckBox, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, upper_left_row : int, upper_left_column : int, height : int, width : int) -> int:
        '''Adds a checkBox to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param height: Height of checkBox, in unit of pixel.
        :param width: Width of checkBox, in unit of pixel.
        :returns: :py:class:`aspose.cells.drawing.CheckBox` object index.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.CheckBox) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ColorHelper:
    '''Provides helper functions about color.'''
    
    @staticmethod
    def from_ole_color(ole_color : int) -> aspose.pydrawing.Color:
        '''Convert OLE_COLOR.
        
        :param ole_color: The value of OLE_COLOR.
        :returns: The :py:class:`aspose.pydrawing.Color` object.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_ole_color(color : aspose.pydrawing.Color, workbook : aspose.cells.Workbook) -> int:
        '''Convert color to OLE_COLOR
        
        :param color: The :py:class:`aspose.pydrawing.Color` object.
        :returns: The value of OLE_COLOR'''
        raise NotImplementedError()
    

class ComboBox(Shape):
    '''Represents the control form ComboBox.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def selected_index(self) -> int:
        '''Gets the index number of the currently selected item in a list box or combo box.
        Zero-based.'''
        raise NotImplementedError()
    
    @selected_index.setter
    def selected_index(self, value : int) -> None:
        '''Sets the index number of the currently selected item in a list box or combo box.
        Zero-based.'''
        raise NotImplementedError()
    
    @property
    def selected_value(self) -> str:
        '''Gets the selected value of the combox box.'''
        raise NotImplementedError()
    
    @property
    def selected_cell(self) -> aspose.cells.Cell:
        '''Gets the selected cell in the input range of the combo box.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @property
    def drop_down_lines(self) -> int:
        '''Gets the number of list lines displayed in the drop-down portion of a combo box.'''
        raise NotImplementedError()
    
    @drop_down_lines.setter
    def drop_down_lines(self, value : int) -> None:
        '''Sets the number of list lines displayed in the drop-down portion of a combo box.'''
        raise NotImplementedError()
    

class CommentShape(Shape):
    '''Represents the shape of the comment.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def comment(self) -> aspose.cells.Comment:
        '''Gets the comment object.'''
        raise NotImplementedError()
    

class CustomGeometry(Geometry):
    '''Represents a custom geometric shape.'''
    
    @property
    def shape_adjust_values(self) -> aspose.cells.drawing.ShapeGuideCollection:
        '''Gets a collection of shape adjust value'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets path collection information when shape is a NotPrimitive autoshape'''
        raise NotImplementedError()
    

class CustomXmlShape(Shape):
    '''Represents Custom xml shape ,such as Ink.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class DialogBox(Shape):
    '''Represents the dialog box.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class Fill:
    '''Represents the fill format of the shape.'''
    

class FillFormat:
    '''Encapsulates the object that represents fill formatting for a shape.'''
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, color2 : aspose.pydrawing.Color, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param color2: Two gradient color.
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, transparency1 : float, color2 : aspose.pydrawing.Color, transparency2 : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param transparency1: The degree of transparency of the color1 as a value from 0.0 (opaque) through 1.0 (clear).
        :param color2: Two gradient color.
        :param transparency2: The degree of transparency of the color2 as a value from 0.0 (opaque) through 1.0 (clear).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def set_one_color_gradient(self, color : aspose.pydrawing.Color, degree : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a one-color gradient.
        Only applies for Excel 2007.
        
        :param color: One gradient color.
        :param degree: The gradient degree. Can be a value from 0.0 (dark) through 1.0 (light).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def set_preset_color_gradient(self, preset_color : aspose.cells.drawing.GradientPresetType, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a preset-color gradient.
        Only applies for Excel 2007.
        
        :param preset_color: Preset color type
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.FillType:
        '''Gets and sets the fill type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.drawing.FillType) -> None:
        '''Gets and sets the fill type.'''
        raise NotImplementedError()
    
    @property
    def fill_type(self) -> aspose.cells.drawing.FillType:
        '''Gets and sets fill type'''
        raise NotImplementedError()
    
    @fill_type.setter
    def fill_type(self, value : aspose.cells.drawing.FillType) -> None:
        '''Gets and sets fill type'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def set_type(self) -> aspose.cells.drawing.FormatSetType:
        '''Gets the fill format set type.'''
        raise NotImplementedError()
    
    @set_type.setter
    def set_type(self, value : aspose.cells.drawing.FormatSetType) -> None:
        '''Gets the fill format set type.'''
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.cells.drawing.GradientFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.gradient_fill` object.'''
        raise NotImplementedError()
    
    @property
    def texture_fill(self) -> aspose.cells.drawing.TextureFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.texture_fill` object.'''
        raise NotImplementedError()
    
    @property
    def solid_fill(self) -> aspose.cells.drawing.SolidFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.solid_fill` object.'''
        raise NotImplementedError()
    
    @property
    def pattern_fill(self) -> aspose.cells.drawing.PatternFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.pattern_fill` object.'''
        raise NotImplementedError()
    
    @property
    def gradient_color_type(self) -> aspose.cells.drawing.GradientColorType:
        '''Returns the gradient color type for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_style(self) -> aspose.cells.drawing.GradientStyleType:
        '''Returns the gradient style for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_color1(self) -> aspose.pydrawing.Color:
        '''Returns the gradient color 1 for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_color2(self) -> aspose.pydrawing.Color:
        '''Returns the gradient color 2 for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_degree(self) -> float:
        '''Returns the gradient degree for the specified fill.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @property
    def gradient_variant(self) -> int:
        '''Returns the gradient variant for the specified fill.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @property
    def preset_color(self) -> aspose.cells.drawing.GradientPresetType:
        '''Returns the gradient preset color for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def texture(self) -> aspose.cells.drawing.TextureType:
        '''Represents the texture type for the specified fill.'''
        raise NotImplementedError()
    
    @texture.setter
    def texture(self, value : aspose.cells.drawing.TextureType) -> None:
        '''Represents the texture type for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def pattern(self) -> aspose.cells.drawing.FillPattern:
        '''Represents an area\'s display pattern.'''
        raise NotImplementedError()
    
    @pattern.setter
    def pattern(self, value : aspose.cells.drawing.FillPattern) -> None:
        '''Represents an area\'s display pattern.'''
        raise NotImplementedError()
    
    @property
    def picture_format_type(self) -> aspose.cells.drawing.FillPictureType:
        '''Gets and sets the picture format type.'''
        raise NotImplementedError()
    
    @picture_format_type.setter
    def picture_format_type(self, value : aspose.cells.drawing.FillPictureType) -> None:
        '''Gets and sets the picture format type.'''
        raise NotImplementedError()
    
    @property
    def scale(self) -> float:
        '''Gets and sets the picture format scale.'''
        raise NotImplementedError()
    
    @scale.setter
    def scale(self, value : float) -> None:
        '''Gets and sets the picture format scale.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Gets and sets the picture image data.'''
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        '''Gets and sets the picture image data.'''
        raise NotImplementedError()
    

class Format3D:
    '''This class specifies the 3D shape properties for a chart element or shape.'''
    
    def has_top_bevel_data(self) -> bool:
        '''Indicates if the shape has top bevel data.'''
        raise NotImplementedError()
    
    @property
    def top_bevel(self) -> aspose.cells.drawing.Bevel:
        '''Gets the :py:class:`aspose.cells.drawing.Bevel` object that holds the properties associated with defining a bevel on the top or front face of a shape.'''
        raise NotImplementedError()
    
    @property
    def surface_material_type(self) -> aspose.cells.drawing.PresetMaterialType:
        '''Gets and sets the material type which is combined with the lighting properties to give the final look and feel of a shape.
        Default value is PresetMaterialType.WarmMatte.'''
        raise NotImplementedError()
    
    @surface_material_type.setter
    def surface_material_type(self, value : aspose.cells.drawing.PresetMaterialType) -> None:
        '''Gets and sets the material type which is combined with the lighting properties to give the final look and feel of a shape.
        Default value is PresetMaterialType.WarmMatte.'''
        raise NotImplementedError()
    
    @property
    def surface_lighting_type(self) -> aspose.cells.drawing.LightRigType:
        '''Gets and sets the lighting type which is to be applied to the scene of the shape.
        Default value is LightRigType.ThreePoint.'''
        raise NotImplementedError()
    
    @surface_lighting_type.setter
    def surface_lighting_type(self, value : aspose.cells.drawing.LightRigType) -> None:
        '''Gets and sets the lighting type which is to be applied to the scene of the shape.
        Default value is LightRigType.ThreePoint.'''
        raise NotImplementedError()
    
    @property
    def lighting_angle(self) -> float:
        '''Gets and sets the lighting angle. Range from 0 to 359.9 degrees.'''
        raise NotImplementedError()
    
    @lighting_angle.setter
    def lighting_angle(self, value : float) -> None:
        '''Gets and sets the lighting angle. Range from 0 to 359.9 degrees.'''
        raise NotImplementedError()
    

class Geometry:
    '''Represents a geometric shape.'''
    
    @property
    def shape_adjust_values(self) -> aspose.cells.drawing.ShapeGuideCollection:
        '''Gets a collection of shape adjust value'''
        raise NotImplementedError()
    

class GlowEffect:
    '''This class specifies a glow effect, in which a color blurred outline
    is added outside the edges of the object.'''
    
    @property
    def color(self) -> aspose.cells.CellsColor:
        '''Gets the color of the glow effect.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets the color of the glow effect.'''
        raise NotImplementedError()
    
    @property
    def radius(self) -> float:
        '''Gets and sets the radius of the glow, in unit of points.'''
        raise NotImplementedError()
    
    @radius.setter
    def radius(self, value : float) -> None:
        '''Gets and sets the radius of the glow, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> float:
        '''Gets and sets the radius of the glow, in unit of points.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : float) -> None:
        '''Gets and sets the radius of the glow, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Gets and sets the degree of transparency of the glow effect. Range from 0.0 (opaque) to 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Gets and sets the degree of transparency of the glow effect. Range from 0.0 (opaque) to 1.0 (clear).'''
        raise NotImplementedError()
    

class GradientFill(Fill):
    '''Represents the gradient fill.'''
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, color2 : aspose.pydrawing.Color, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param color2: Two gradient color.
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, transparency1 : float, color2 : aspose.pydrawing.Color, transparency2 : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param transparency1: The degree of transparency of the color1 as a value from 0.0 (opaque) through 1.0 (clear).
        :param color2: Two gradient color.
        :param transparency2: The degree of transparency of the color2 as a value from 0.0 (opaque) through 1.0 (clear).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def set_gradient(self, type : aspose.cells.drawing.GradientFillType, angle : float, direction : aspose.cells.drawing.GradientDirectionType) -> None:
        '''Set the gradient fill type and direction.
        
        :param type: Gradient fill type.
        :param angle: The angle. Only applies for GradientFillType.Linear.
        :param direction: The direction type. Only applies for GradientFillType.Radial and GradientFillType.Rectangle.'''
        raise NotImplementedError()
    
    def set_preset_theme_gradient(self, gradient_type : aspose.cells.drawing.PresetThemeGradientType, theme_color_type : aspose.cells.ThemeColorType) -> None:
        '''Sets preset theme gradient fill.
        
        :param gradient_type: The preset gradient type.
        :param theme_color_type: The theme color type.'''
        raise NotImplementedError()
    
    def set_one_color_gradient(self, color : aspose.pydrawing.Color, degree : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a one-color gradient.
        Only applies for Excel 2007.
        
        :param color: One gradient color.
        :param degree: The gradient degree. Can be a value from 0.0 (dark) through 1.0 (light).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @property
    def gradient_stops(self) -> aspose.cells.drawing.GradientStopCollection:
        '''Represents the gradient stop collection.'''
        raise NotImplementedError()
    
    @property
    def fill_type(self) -> aspose.cells.drawing.GradientFillType:
        '''Gets the gradient fill type.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.drawing.GradientDirectionType:
        '''Gets the gradient direction type.'''
        raise NotImplementedError()
    
    @property
    def angle(self) -> float:
        '''The angle of linear fill.'''
        raise NotImplementedError()
    
    @angle.setter
    def angle(self, value : float) -> None:
        '''The angle of linear fill.'''
        raise NotImplementedError()
    

class GradientStop:
    '''Represents the gradient stop.'''
    
    @property
    def position(self) -> float:
        '''The position of the stop.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : float) -> None:
        '''The position of the stop.'''
        raise NotImplementedError()
    
    @property
    def cells_color(self) -> aspose.cells.CellsColor:
        '''Gets the color of this gradient stop.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    

class GradientStopCollection:
    '''Represents the gradient stop collection.'''
    
    @overload
    def add(self, position : float, color : aspose.cells.CellsColor, alpha : int) -> None:
        '''Add a gradient stop.
        
        :param position: The position of the stop,in unit of percentage.
        :param color: The color of the stop.
        :param alpha: The alpha of the color.'''
        raise NotImplementedError()
    
    @overload
    def add(self, position : float, color : aspose.pydrawing.Color, alpha : int) -> None:
        '''Add a gradient stop.
        
        :param position: The position of the stop,in unit of percentage.
        :param color: The color of the stop.
        :param alpha: The alpha of the color.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.GradientStop]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.GradientStop], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.GradientStop, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.GradientStop, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.GradientStop) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.GradientStop, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.GradientStop, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.GradientStop) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class GroupBox(Shape):
    '''Encapsulates the object that represents a groupbox in a spreadsheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the groupbox has shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the groupbox has shadow.'''
        raise NotImplementedError()
    

class GroupFill(Fill):
    '''Represents this fill format should inherit the fill properties of the group.'''
    

class GroupShape(Shape):
    '''Represents the group shape which contains the individual shapes.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    def ungroup(self) -> None:
        '''Ungroups the shape items.'''
        raise NotImplementedError()
    
    def get_grouped_shapes(self) -> List[aspose.cells.drawing.Shape]:
        '''Gets the shapes grouped by this shape.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.drawing.Shape:
        '''Gets the child shape by index.'''
        raise NotImplementedError()
    

class Label(Shape):
    '''Encapsulates the object that represents a label in a spreadsheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class Line:
    '''Encapsulates the object that represents the line format.'''
    
    @property
    def compound_type(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @compound_type.setter
    def compound_type(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @property
    def dash_type(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @dash_type.setter
    def dash_type(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @property
    def cap_type(self) -> aspose.cells.drawing.LineCapType:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @cap_type.setter
    def cap_type(self, value : aspose.cells.drawing.LineCapType) -> None:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @property
    def join_type(self) -> aspose.cells.drawing.LineJoinType:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @join_type.setter
    def join_type(self, value : aspose.cells.drawing.LineJoinType) -> None:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @property
    def begin_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_type.setter
    def begin_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_type.setter
    def end_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_length.setter
    def begin_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_length.setter
    def end_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_width.setter
    def begin_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_width.setter
    def end_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.drawing.LineType:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.drawing.LineType) -> None:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> aspose.cells.drawing.WeightType:
        '''Gets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : aspose.cells.drawing.WeightType) -> None:
        '''Sets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @property
    def weight_pt(self) -> float:
        '''Gets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @weight_pt.setter
    def weight_pt(self, value : float) -> None:
        '''Sets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @property
    def weight_px(self) -> float:
        '''Gets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @weight_px.setter
    def weight_px(self, value : float) -> None:
        '''Sets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def formatting_type(self) -> aspose.cells.charts.ChartLineFormattingType:
        '''Gets format type.'''
        raise NotImplementedError()
    
    @formatting_type.setter
    def formatting_type(self, value : aspose.cells.charts.ChartLineFormattingType) -> None:
        '''Sets format type.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_color(self) -> bool:
        '''Indicates whether the color of line is automatic assigned.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @property
    def is_auto(self) -> bool:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @is_auto.setter
    def is_auto(self, value : bool) -> None:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.cells.drawing.GradientFill:
        '''Represents gradient fill.'''
        raise NotImplementedError()
    

class LineFormat(FillFormat):
    '''Represents all setting of the line.'''
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, color2 : aspose.pydrawing.Color, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param color2: Two gradient color.
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @overload
    def set_two_color_gradient(self, color1 : aspose.pydrawing.Color, transparency1 : float, color2 : aspose.pydrawing.Color, transparency2 : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a two-color gradient.
        Only applies for Excel 2007.
        
        :param color1: One gradient color.
        :param transparency1: The degree of transparency of the color1 as a value from 0.0 (opaque) through 1.0 (clear).
        :param color2: Two gradient color.
        :param transparency2: The degree of transparency of the color2 as a value from 0.0 (opaque) through 1.0 (clear).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def set_one_color_gradient(self, color : aspose.pydrawing.Color, degree : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a one-color gradient.
        Only applies for Excel 2007.
        
        :param color: One gradient color.
        :param degree: The gradient degree. Can be a value from 0.0 (dark) through 1.0 (light).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    def set_preset_color_gradient(self, preset_color : aspose.cells.drawing.GradientPresetType, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a preset-color gradient.
        Only applies for Excel 2007.
        
        :param preset_color: Preset color type
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.FillType:
        '''Gets and sets the fill type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.drawing.FillType) -> None:
        '''Gets and sets the fill type.'''
        raise NotImplementedError()
    
    @property
    def fill_type(self) -> aspose.cells.drawing.FillType:
        '''Gets and sets fill type'''
        raise NotImplementedError()
    
    @fill_type.setter
    def fill_type(self, value : aspose.cells.drawing.FillType) -> None:
        '''Gets and sets fill type'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def set_type(self) -> aspose.cells.drawing.FormatSetType:
        '''Gets the fill format set type.'''
        raise NotImplementedError()
    
    @set_type.setter
    def set_type(self, value : aspose.cells.drawing.FormatSetType) -> None:
        '''Gets the fill format set type.'''
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.cells.drawing.GradientFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.gradient_fill` object.'''
        raise NotImplementedError()
    
    @property
    def texture_fill(self) -> aspose.cells.drawing.TextureFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.texture_fill` object.'''
        raise NotImplementedError()
    
    @property
    def solid_fill(self) -> aspose.cells.drawing.SolidFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.solid_fill` object.'''
        raise NotImplementedError()
    
    @property
    def pattern_fill(self) -> aspose.cells.drawing.PatternFill:
        '''Gets :py:attr:`aspose.cells.drawing.FillFormat.pattern_fill` object.'''
        raise NotImplementedError()
    
    @property
    def gradient_color_type(self) -> aspose.cells.drawing.GradientColorType:
        '''Returns the gradient color type for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_style(self) -> aspose.cells.drawing.GradientStyleType:
        '''Returns the gradient style for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_color1(self) -> aspose.pydrawing.Color:
        '''Returns the gradient color 1 for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_color2(self) -> aspose.pydrawing.Color:
        '''Returns the gradient color 2 for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def gradient_degree(self) -> float:
        '''Returns the gradient degree for the specified fill.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @property
    def gradient_variant(self) -> int:
        '''Returns the gradient variant for the specified fill.
        Only applies for Excel 2007.'''
        raise NotImplementedError()
    
    @property
    def preset_color(self) -> aspose.cells.drawing.GradientPresetType:
        '''Returns the gradient preset color for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def texture(self) -> aspose.cells.drawing.TextureType:
        '''Represents the texture type for the specified fill.'''
        raise NotImplementedError()
    
    @texture.setter
    def texture(self, value : aspose.cells.drawing.TextureType) -> None:
        '''Represents the texture type for the specified fill.'''
        raise NotImplementedError()
    
    @property
    def pattern(self) -> aspose.cells.drawing.FillPattern:
        '''Represents an area\'s display pattern.'''
        raise NotImplementedError()
    
    @pattern.setter
    def pattern(self, value : aspose.cells.drawing.FillPattern) -> None:
        '''Represents an area\'s display pattern.'''
        raise NotImplementedError()
    
    @property
    def picture_format_type(self) -> aspose.cells.drawing.FillPictureType:
        '''Gets and sets the picture format type.'''
        raise NotImplementedError()
    
    @picture_format_type.setter
    def picture_format_type(self, value : aspose.cells.drawing.FillPictureType) -> None:
        '''Gets and sets the picture format type.'''
        raise NotImplementedError()
    
    @property
    def scale(self) -> float:
        '''Gets and sets the picture format scale.'''
        raise NotImplementedError()
    
    @scale.setter
    def scale(self, value : float) -> None:
        '''Gets and sets the picture format scale.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Gets and sets the picture image data.'''
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        '''Gets and sets the picture image data.'''
        raise NotImplementedError()
    
    @property
    def compound_type(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Specifies the line compound type.'''
        raise NotImplementedError()
    
    @compound_type.setter
    def compound_type(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Specifies the line compound type.'''
        raise NotImplementedError()
    
    @property
    def dash_style(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Specifies the line dash type.'''
        raise NotImplementedError()
    
    @dash_style.setter
    def dash_style(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Specifies the line dash type.'''
        raise NotImplementedError()
    
    @property
    def cap_type(self) -> aspose.cells.drawing.LineCapType:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @cap_type.setter
    def cap_type(self, value : aspose.cells.drawing.LineCapType) -> None:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @property
    def join_type(self) -> aspose.cells.drawing.LineJoinType:
        '''Specifies the line join type.'''
        raise NotImplementedError()
    
    @join_type.setter
    def join_type(self, value : aspose.cells.drawing.LineJoinType) -> None:
        '''Specifies the line join type.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the begin arrow type of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_style.setter
    def begin_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the begin arrow type of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the begin arrow width type of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_width.setter
    def begin_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the begin arrow width type of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the begin arrow length type of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_length.setter
    def begin_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the begin arrow length type of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the end arrow type of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_style.setter
    def end_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the end arrow type of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the end arrow width type of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_width.setter
    def end_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the end arrow width type of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the end arrow length type of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_length.setter
    def end_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the end arrow length type of the line.'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> float:
        '''Gets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : float) -> None:
        '''Sets the weight of the line in unit of points.'''
        raise NotImplementedError()
    

class LineShape(Shape):
    '''Represents the line shape.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the begin arrow head style of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_style.setter
    def begin_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the begin arrow head style of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the begin arrow head width of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_width.setter
    def begin_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the begin arrow head width of the line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the begin arrow head length of the line.'''
        raise NotImplementedError()
    
    @begin_arrowhead_length.setter
    def begin_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the begin arrow head length of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_style(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Gets and sets the end arrow head style of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_style.setter
    def end_arrowhead_style(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Gets and sets the end arrow head style of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Gets and sets the end arrow head width of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_width.setter
    def end_arrowhead_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Gets and sets the end arrow head width of the line.'''
        raise NotImplementedError()
    
    @property
    def end_arrowhead_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Gets and sets the end arrow head length of the line.'''
        raise NotImplementedError()
    
    @end_arrowhead_length.setter
    def end_arrowhead_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Gets and sets the end arrow head length of the line.'''
        raise NotImplementedError()
    

class ListBox(Shape):
    '''Represents a list box object.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    def selected_item(self, item_index : int, is_selected : bool) -> None:
        '''Sets whether the item is selected
        
        :param item_index: The item index
        :param is_selected: Whether the item is selected.
        True means that this item should be selected.
        False means that this item should be unselected.'''
        raise NotImplementedError()
    
    def is_selected(self, item_index : int) -> bool:
        '''Indicates whether the item is selected.
        
        :param item_index: The item index.
        :returns: whether the item is selected.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def item_count(self) -> int:
        '''Gets the number of items in the list box.'''
        raise NotImplementedError()
    
    @property
    def selected_index(self) -> int:
        '''Gets the index number of the currently selected item in a list box or combo box.
        Zero-based.'''
        raise NotImplementedError()
    
    @selected_index.setter
    def selected_index(self, value : int) -> None:
        '''Sets the index number of the currently selected item in a list box or combo box.
        Zero-based.'''
        raise NotImplementedError()
    
    @property
    def selected_cells(self) -> List[aspose.cells.Cell]:
        '''Gets the selected cells.
        Returns null if the input range is not set or no item is selected'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @property
    def selection_type(self) -> aspose.cells.drawing.SelectionType:
        '''Gets the selection mode of the specified list box.'''
        raise NotImplementedError()
    
    @selection_type.setter
    def selection_type(self, value : aspose.cells.drawing.SelectionType) -> None:
        '''Sets the selection mode of the specified list box.'''
        raise NotImplementedError()
    
    @property
    def page_change(self) -> int:
        '''Specifies the amount by which the control\'s value is changed
        when the user clicks on the scrollbar\'s page up or page down region.'''
        raise NotImplementedError()
    
    @page_change.setter
    def page_change(self, value : int) -> None:
        '''Specifies the amount by which the control\'s value is changed
        when the user clicks on the scrollbar\'s page up or page down region.'''
        raise NotImplementedError()
    

class MsoFillFormat:
    '''Represents fill formatting for a shape.'''
    
    def set_one_color_gradient(self, color : aspose.pydrawing.Color, degree : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a one-color gradient.
        
        :param color: One gradient color.
        :param degree: The gradient degree. Can be a value from 0.0 (dark) through 1.0 (light).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @property
    def fore_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the fill fore color.'''
        raise NotImplementedError()
    
    @fore_color.setter
    def fore_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the fill fore color.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def back_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the file back color.'''
        raise NotImplementedError()
    
    @back_color.setter
    def back_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the file back color.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Gets and sets the Texture and Picture fill data.'''
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        '''Gets and sets the Texture and Picture fill data.'''
        raise NotImplementedError()
    
    @property
    def texture(self) -> aspose.cells.drawing.TextureType:
        '''Gets the texture fill type.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether there is fill.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Indicates whether there is fill.'''
        raise NotImplementedError()
    

class MsoFillFormatHelper:
    '''Represents fill formatting for a shape.'''
    
    def set_one_color_gradient(self, color : aspose.pydrawing.Color, degree : float, style : aspose.cells.drawing.GradientStyleType, variant : int) -> None:
        '''Sets the specified fill to a one-color gradient.
        
        :param color: One gradient color.
        :param degree: The gradient degree. Can be a value from 0.0 (dark) through 1.0 (light).
        :param style: Gradient shading style.
        :param variant: The gradient variant. Can be a value from 1 through 4, corresponding to one of the four variants on the Gradient tab in the Fill Effects dialog box. If style is GradientStyle.FromCenter, the Variant argument can only be 1 or 2.'''
        raise NotImplementedError()
    
    @property
    def fore_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the fill fore color.'''
        raise NotImplementedError()
    
    @fore_color.setter
    def fore_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the fill fore color.'''
        raise NotImplementedError()
    
    @property
    def fore_color_transparency(self) -> float:
        '''Returns the degree of fore color of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @fore_color_transparency.setter
    def fore_color_transparency(self, value : float) -> None:
        '''Returns or sets the degree of fore color of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def back_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the file back color.'''
        raise NotImplementedError()
    
    @back_color.setter
    def back_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the file back color.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Gets and sets the Texture and Picture fill data.'''
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        '''Gets and sets the Texture and Picture fill data.'''
        raise NotImplementedError()
    
    @property
    def texture(self) -> aspose.cells.drawing.TextureType:
        '''Gets the texture fill type.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether there is fill.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Indicates whether there is fill.'''
        raise NotImplementedError()
    

class MsoFormatPicture:
    '''Represents the picture format.'''
    
    @property
    def top_crop_inch(self) -> float:
        '''Represents the location of the top of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @top_crop_inch.setter
    def top_crop_inch(self, value : float) -> None:
        '''Represents the location of the top of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def bottom_crop_inch(self) -> float:
        '''Represents the location of the bottom of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @bottom_crop_inch.setter
    def bottom_crop_inch(self, value : float) -> None:
        '''Represents the location of the bottom of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_crop_inch(self) -> float:
        '''Represents the location of the left of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @left_crop_inch.setter
    def left_crop_inch(self, value : float) -> None:
        '''Represents the location of the left of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def right_crop_inch(self) -> float:
        '''Represents the location of the right of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @right_crop_inch.setter
    def right_crop_inch(self, value : float) -> None:
        '''Represents the location of the right of the crop rectangle expressed, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_crop(self) -> float:
        '''Represents the location of the top of the crop rectangle expressed, expressed as a ratio of the image\'s height.'''
        raise NotImplementedError()
    
    @top_crop.setter
    def top_crop(self, value : float) -> None:
        '''Represents the location of the top of the crop rectangle expressed, expressed as a ratio of the image\'s height.'''
        raise NotImplementedError()
    
    @property
    def bottom_crop(self) -> float:
        '''Represents the location of the bottom of the crop rectangle expressed, expressed as a ratio of the image\'s height.'''
        raise NotImplementedError()
    
    @bottom_crop.setter
    def bottom_crop(self, value : float) -> None:
        '''Represents the location of the bottom of the crop rectangle expressed, expressed as a ratio of the image\'s height.'''
        raise NotImplementedError()
    
    @property
    def left_crop(self) -> float:
        '''Represents the location of the left of the crop rectangle expressed, expressed as a ratio of the image\'s width.'''
        raise NotImplementedError()
    
    @left_crop.setter
    def left_crop(self, value : float) -> None:
        '''Represents the location of the left of the crop rectangle expressed, expressed as a ratio of the image\'s width.'''
        raise NotImplementedError()
    
    @property
    def right_crop(self) -> float:
        '''Represents the location of the right of the crop rectangle expressed, expressed as a ratio of the image\'s width.'''
        raise NotImplementedError()
    
    @right_crop.setter
    def right_crop(self, value : float) -> None:
        '''Represents the location of the right of the crop rectangle expressed, expressed as a ratio of the image\'s width.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def transparent_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the transparent color of the picture.'''
        raise NotImplementedError()
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the transparent color of the picture.'''
        raise NotImplementedError()
    
    @property
    def contrast(self) -> float:
        '''Represents the contrast modification for the picture.in unit of percentage.'''
        raise NotImplementedError()
    
    @contrast.setter
    def contrast(self, value : float) -> None:
        '''Represents the contrast modification for the picture.in unit of percentage.'''
        raise NotImplementedError()
    
    @property
    def brightness(self) -> float:
        '''Represents the brightness modification for the picture in unit of percentage.'''
        raise NotImplementedError()
    
    @brightness.setter
    def brightness(self, value : float) -> None:
        '''Represents the brightness modification for the picture in unit of percentage.'''
        raise NotImplementedError()
    
    @property
    def gamma(self) -> float:
        '''Represents gamma of the picture.'''
        raise NotImplementedError()
    
    @gamma.setter
    def gamma(self, value : float) -> None:
        '''Represents gamma of the picture.'''
        raise NotImplementedError()
    
    @property
    def is_bi_level(self) -> bool:
        '''Indicates whether this picture should display in two-color black and white.'''
        raise NotImplementedError()
    
    @is_bi_level.setter
    def is_bi_level(self, value : bool) -> None:
        '''Indicates whether this picture should display in two-color black and white.'''
        raise NotImplementedError()
    
    @property
    def is_gray(self) -> bool:
        '''Indicates whether this picture should display in grayscale.'''
        raise NotImplementedError()
    
    @is_gray.setter
    def is_gray(self, value : bool) -> None:
        '''Indicates whether this picture should display in grayscale.'''
        raise NotImplementedError()
    

class MsoLineFormat:
    '''Represents line and arrowhead formatting.'''
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Returns a Style object that represents the style of the specified range.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Returns a Style object that represents the style of the specified range.'''
        raise NotImplementedError()
    
    @property
    def fore_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the border line fore color.'''
        raise NotImplementedError()
    
    @fore_color.setter
    def fore_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the border line fore color.'''
        raise NotImplementedError()
    
    @property
    def back_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the border line back color.'''
        raise NotImplementedError()
    
    @back_color.setter
    def back_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the border line back color.'''
        raise NotImplementedError()
    
    @property
    def dash_style(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Gets the dash style for the specified line.'''
        raise NotImplementedError()
    
    @dash_style.setter
    def dash_style(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Sets the dash style for the specified line.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> float:
        '''Returns the weight of the line ,in units of pt.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : float) -> None:
        '''Returns or sets the weight of the line ,in units of pt.'''
        raise NotImplementedError()
    

class MsoLineFormatHelper:
    '''Represents line and arrowhead formatting.'''
    
    @property
    def is_visible(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Returns a Style object that represents the style of the specified range.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Returns a Style object that represents the style of the specified range.'''
        raise NotImplementedError()
    
    @property
    def fore_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the border line fore color.'''
        raise NotImplementedError()
    
    @fore_color.setter
    def fore_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the border line fore color.'''
        raise NotImplementedError()
    
    @property
    def back_color(self) -> aspose.pydrawing.Color:
        '''Gets and sets the border line back color.'''
        raise NotImplementedError()
    
    @back_color.setter
    def back_color(self, value : aspose.pydrawing.Color) -> None:
        '''Gets and sets the border line back color.'''
        raise NotImplementedError()
    
    @property
    def dash_style(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Gets the dash style for the specified line.'''
        raise NotImplementedError()
    
    @dash_style.setter
    def dash_style(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Sets the dash style for the specified line.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the specified fill as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> float:
        '''Returns the weight of the line ,in units of pt.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : float) -> None:
        '''Returns or sets the weight of the line ,in units of pt.'''
        raise NotImplementedError()
    

class MsoTextFrame:
    '''Represents the text frame in a Shape object.'''
    
    @property
    def auto_size(self) -> bool:
        '''Indicates if size of shape is adjusted automatically according to its content.'''
        raise NotImplementedError()
    
    @auto_size.setter
    def auto_size(self, value : bool) -> None:
        '''Indicates if size of shape is adjusted automatically according to its content.'''
        raise NotImplementedError()
    
    @property
    def is_auto_margin(self) -> bool:
        '''Indicates whether the margin is auto calculated.'''
        raise NotImplementedError()
    
    @is_auto_margin.setter
    def is_auto_margin(self, value : bool) -> None:
        '''Indicates whether the margin is auto calculated.'''
        raise NotImplementedError()
    
    @property
    def rotate_text_with_shape(self) -> bool:
        '''Indicates whether rotating text with shape.'''
        raise NotImplementedError()
    
    @rotate_text_with_shape.setter
    def rotate_text_with_shape(self, value : bool) -> None:
        '''Indicates whether rotating text with shape.'''
        raise NotImplementedError()
    
    @property
    def left_margin_pt(self) -> float:
        '''Returns the left margin in unit of Points'''
        raise NotImplementedError()
    
    @left_margin_pt.setter
    def left_margin_pt(self, value : float) -> None:
        '''Returns the left margin in unit of Points'''
        raise NotImplementedError()
    
    @property
    def right_margin_pt(self) -> float:
        '''Returns the right margin in unit of Points'''
        raise NotImplementedError()
    
    @right_margin_pt.setter
    def right_margin_pt(self, value : float) -> None:
        '''Returns the right margin in unit of Points'''
        raise NotImplementedError()
    
    @property
    def top_margin_pt(self) -> float:
        '''Returns the top margin in unit of Points'''
        raise NotImplementedError()
    
    @top_margin_pt.setter
    def top_margin_pt(self, value : float) -> None:
        '''Returns the top margin in unit of Points'''
        raise NotImplementedError()
    
    @property
    def bottom_margin_pt(self) -> float:
        '''Returns the bottom margin in unit of Points'''
        raise NotImplementedError()
    
    @bottom_margin_pt.setter
    def bottom_margin_pt(self, value : float) -> None:
        '''Returns the bottom margin in unit of Points'''
        raise NotImplementedError()
    

class NoneFill(Fill):
    '''Represents no fill.'''
    

class OleObject(Shape):
    '''Represents an OleObject in a worksheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    @overload
    def set_embedded_object(self, link_to_file : bool, object_data : List[int], source_file_name : str, display_as_icon : bool, label : str) -> None:
        '''Sets embedded object data.
        
        :param link_to_file: Indicates whether the object links to the file. If true, the parameter objectData is ignored.
        :param object_data: The embedded object data.
        :param source_file_name: The file name.
        :param display_as_icon: Indicates whether diplaying object as an icon.
        If true, the orginal image data will be covered by icon.
        :param label: The icon label. Only works when displayAsIcon as true.'''
        raise NotImplementedError()
    
    @overload
    def set_embedded_object(self, link_to_file : bool, object_data : List[int], source_file_name : str, display_as_icon : bool, label : str, update_icon : bool) -> None:
        '''Sets embedded object data.
        
        :param link_to_file: Indicates whether the object links to the file. If true, the parameter objectData is ignored.
        :param object_data: The embedded object data.
        :param source_file_name: The file name.
        :param display_as_icon: Indicates whether diplaying object as an icon.
        If true, the orginal image data will be covered by icon.
        :param label: The icon label. Only works when displayAsIcon as true.
        :param update_icon: Indicates whether automatically updating icon.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    def set_native_source_full_name(self, source_full_name : str) -> None:
        '''Sets the ole native source full file name with path.
        
        :param source_full_name: the ole native source full file name'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def is_auto_size(self) -> bool:
        '''True indicates that the size of the ole object will be auto changed as the size of snapshot of the embedded content
        when the ole object is activated.'''
        raise NotImplementedError()
    
    @is_auto_size.setter
    def is_auto_size(self, value : bool) -> None:
        '''True indicates that the size of the ole object will be auto changed as the size of snapshot of the embedded content
        when the ole object is activated.'''
        raise NotImplementedError()
    
    @property
    def is_link(self) -> bool:
        '''Returns true if the OleObject links to the file.'''
        raise NotImplementedError()
    
    @is_link.setter
    def is_link(self, value : bool) -> None:
        '''Returns true if the OleObject links to the file.'''
        raise NotImplementedError()
    
    @property
    def display_as_icon(self) -> bool:
        '''True if the specified object is displayed as an icon
        and the image will not be auto changed.'''
        raise NotImplementedError()
    
    @display_as_icon.setter
    def display_as_icon(self, value : bool) -> None:
        '''True if the specified object is displayed as an icon
        and the image will not be auto changed.'''
        raise NotImplementedError()
    
    @property
    def image_data(self) -> List[int]:
        '''Represents image of ole object as byte array.'''
        raise NotImplementedError()
    
    @image_data.setter
    def image_data(self, value : List[int]) -> None:
        '''Represents image of ole object as byte array.'''
        raise NotImplementedError()
    
    @property
    def object_data(self) -> List[int]:
        '''Represents embedded ole object data as byte array.'''
        raise NotImplementedError()
    
    @object_data.setter
    def object_data(self, value : List[int]) -> None:
        '''Represents embedded ole object data as byte array.'''
        raise NotImplementedError()
    
    @property
    def full_object_bin(self) -> List[int]:
        '''Gets the full embedded ole object binary data in the template file.'''
        raise NotImplementedError()
    
    @property
    def image_source_full_name(self) -> str:
        '''Gets the path and name of the source file for the linked image.'''
        raise NotImplementedError()
    
    @image_source_full_name.setter
    def image_source_full_name(self, value : str) -> None:
        '''Sets the path and name of the source file for the linked image.'''
        raise NotImplementedError()
    
    @property
    def prog_id(self) -> str:
        '''Gets the ProgID of the OLE object.'''
        raise NotImplementedError()
    
    @prog_id.setter
    def prog_id(self, value : str) -> None:
        '''Sets the ProgID of the OLE object.'''
        raise NotImplementedError()
    
    @property
    def file_format_type(self) -> aspose.cells.FileFormatType:
        '''Gets and sets the file type of the embedded ole object data'''
        raise NotImplementedError()
    
    @file_format_type.setter
    def file_format_type(self, value : aspose.cells.FileFormatType) -> None:
        '''Gets and sets the file type of the embedded ole object data'''
        raise NotImplementedError()
    
    @property
    def object_source_full_name(self) -> str:
        '''Returns the source full name of the source file for the linked OLE object.'''
        raise NotImplementedError()
    
    @object_source_full_name.setter
    def object_source_full_name(self, value : str) -> None:
        '''Returns the source full name of the source file for the linked OLE object.'''
        raise NotImplementedError()
    
    @property
    def label(self) -> str:
        '''Gets and sets the display label of the linked ole object.'''
        raise NotImplementedError()
    
    @label.setter
    def label(self, value : str) -> None:
        '''Gets and sets the display label of the linked ole object.'''
        raise NotImplementedError()
    
    @property
    def source_full_name(self) -> str:
        '''Returns the source full name of the source file for the linked OLE object.'''
        raise NotImplementedError()
    
    @source_full_name.setter
    def source_full_name(self, value : str) -> None:
        '''Returns the source full name of the source file for the linked OLE object.'''
        raise NotImplementedError()
    
    @property
    def auto_update(self) -> bool:
        '''Specifies whether the link to the OleObject is automatically updated or not.'''
        raise NotImplementedError()
    
    @auto_update.setter
    def auto_update(self, value : bool) -> None:
        '''Specifies whether the link to the OleObject is automatically updated or not.'''
        raise NotImplementedError()
    
    @property
    def auto_load(self) -> bool:
        '''Specifies whether the host application for the embedded object shall be called to load
        the object data automatically when the parent workbook is opened.'''
        raise NotImplementedError()
    
    @auto_load.setter
    def auto_load(self, value : bool) -> None:
        '''Specifies whether the host application for the embedded object shall be called to load
        the object data automatically when the parent workbook is opened.'''
        raise NotImplementedError()
    
    @property
    def class_identifier(self) -> List[int]:
        '''Gets and sets the class identifier of the embedded object.
        It means which application opens the embedded file.'''
        raise NotImplementedError()
    
    @class_identifier.setter
    def class_identifier(self, value : List[int]) -> None:
        '''Gets and sets the class identifier of the embedded object.
        It means which application opens the embedded file.'''
        raise NotImplementedError()
    
    @property
    def image_type(self) -> aspose.cells.drawing.ImageType:
        '''Gets the image format of the ole object.'''
        raise NotImplementedError()
    

class OleObjectCollection:
    '''Represents embedded OLE objects.'''
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, height : int, width : int, image_data : List[int]) -> int:
        '''Adds an OleObject to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param height: Height of oleObject, in unit of pixel.
        :param width: Width of oleObject, in unit of pixel.
        :param image_data: Image of ole object as byte array.
        :returns: :py:class:`aspose.cells.drawing.OleObject` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, height : int, width : int, image_data : List[int], linked_file : str) -> int:
        '''Adds a linked OleObject to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param height: Height of oleObject, in unit of pixel.
        :param width: Width of oleObject, in unit of pixel.
        :param image_data: Image of ole object as byte array.
        :returns: :py:class:`aspose.cells.drawing.OleObject` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.OleObject]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.OleObject], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.OleObject, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.OleObject, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.OleObject) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.OleObject, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.OleObject, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.OleObject) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Oval(Shape):
    '''Represents the oval shape.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class PatternFill(Fill):
    '''Encapsulates the object that represents pattern fill format'''
    
    @property
    def pattern(self) -> aspose.cells.drawing.FillPattern:
        '''Gets the fill pattern type'''
        raise NotImplementedError()
    
    @pattern.setter
    def pattern(self, value : aspose.cells.drawing.FillPattern) -> None:
        '''Sets the fill pattern type'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Gets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @property
    def background_cells_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the foreground :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    @background_cells_color.setter
    def background_cells_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the foreground :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Gets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @property
    def foreground_cells_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the foreground :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    @foreground_cells_color.setter
    def foreground_cells_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the foreground :py:class:`aspose.cells.CellsColor` object.'''
        raise NotImplementedError()
    
    @property
    def fore_transparency(self) -> float:
        '''Gets the transparency of foreground color.'''
        raise NotImplementedError()
    
    @fore_transparency.setter
    def fore_transparency(self, value : float) -> None:
        '''Sets the transparency of foreground color.'''
        raise NotImplementedError()
    
    @property
    def back_transparency(self) -> float:
        '''Gets the transparency of background color.'''
        raise NotImplementedError()
    
    @back_transparency.setter
    def back_transparency(self, value : float) -> None:
        '''Sets the transparency of background color.'''
        raise NotImplementedError()
    

class PicFormatOption:
    '''Represents picture format option'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.FillPictureType:
        '''Gets the picture fill type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.drawing.FillPictureType) -> None:
        '''Sets the picture fill type.'''
        raise NotImplementedError()
    
    @property
    def scale(self) -> float:
        '''Gets how many the picture stack and scale with.'''
        raise NotImplementedError()
    
    @scale.setter
    def scale(self, value : float) -> None:
        '''Sets how many the picture stack and scale with.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> float:
        '''Gets the left offset for stretching picture.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : float) -> None:
        '''Sets the left offset for stretching picture.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> float:
        '''Gets the top offset for stretching picture.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : float) -> None:
        '''Sets the top offset for stretching picture.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> float:
        '''Gets the bottom offset for stretching picture.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : float) -> None:
        '''Sets the bottom offset for stretching picture.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> float:
        '''Gets the right offset for stretching picture.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : float) -> None:
        '''Sets the right offset for stretching picture.'''
        raise NotImplementedError()
    

class Picture(Shape):
    '''Encapsulates the object that represents a single picture in a spreadsheet.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    def copy(self, source : aspose.cells.drawing.Picture, options : aspose.cells.CopyOptions) -> None:
        '''Copy the picture.
        
        :param source: The source picture.
        :param options: The copy options.'''
        raise NotImplementedError()
    
    def move(self, upper_left_row : int, upper_left_column : int) -> None:
        '''Moves the picture to a specified location.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.'''
        raise NotImplementedError()
    
    def place_in_cell(self) -> None:
        '''Place this picture in the cell'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def original_height(self) -> int:
        '''Gets the original height of the picture.'''
        raise NotImplementedError()
    
    @property
    def original_width(self) -> int:
        '''Gets the original width of the picture.'''
        raise NotImplementedError()
    
    @property
    def border_line_color(self) -> aspose.pydrawing.Color:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the border line of a picture.'''
        raise NotImplementedError()
    
    @border_line_color.setter
    def border_line_color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the border line of a picture.'''
        raise NotImplementedError()
    
    @property
    def border_weight(self) -> float:
        '''Gets the weight of the border line of a picture in units of pt.'''
        raise NotImplementedError()
    
    @border_weight.setter
    def border_weight(self, value : float) -> None:
        '''Sets the weight of the border line of a picture in units of pt.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets the data of the picture.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Gets the data of the picture.'''
        raise NotImplementedError()
    
    @property
    def source_full_name(self) -> str:
        '''Gets the path and name of the source file for the linked image.'''
        raise NotImplementedError()
    
    @source_full_name.setter
    def source_full_name(self, value : str) -> None:
        '''Sets the path and name of the source file for the linked image.'''
        raise NotImplementedError()
    
    @property
    def formula(self) -> str:
        '''Gets and sets the data of the formula.'''
        raise NotImplementedError()
    
    @formula.setter
    def formula(self, value : str) -> None:
        '''Gets and sets the data of the formula.'''
        raise NotImplementedError()
    
    @property
    def is_auto_size(self) -> bool:
        '''True indicates that the size of the ole object will be auto changed as the size of snapshot of the embedded content
        when the ole object is activated.'''
        raise NotImplementedError()
    
    @is_auto_size.setter
    def is_auto_size(self, value : bool) -> None:
        '''True indicates that the size of the ole object will be auto changed as the size of snapshot of the embedded content
        when the ole object is activated.'''
        raise NotImplementedError()
    
    @property
    def is_link(self) -> bool:
        '''Returns true if the picture is linked to a file.'''
        raise NotImplementedError()
    
    @is_link.setter
    def is_link(self, value : bool) -> None:
        '''Returns true if the picture is linked to a file.'''
        raise NotImplementedError()
    
    @property
    def is_dynamic_data_exchange(self) -> bool:
        '''Gets whether dynamic data exchange'''
        raise NotImplementedError()
    
    @is_dynamic_data_exchange.setter
    def is_dynamic_data_exchange(self, value : bool) -> None:
        '''Sets whether dynamic data exchange'''
        raise NotImplementedError()
    
    @property
    def display_as_icon(self) -> bool:
        '''True if the specified object is displayed as an icon
        and the image will not be auto changed.'''
        raise NotImplementedError()
    
    @display_as_icon.setter
    def display_as_icon(self, value : bool) -> None:
        '''True if the specified object is displayed as an icon
        and the image will not be auto changed.'''
        raise NotImplementedError()
    
    @property
    def image_type(self) -> aspose.cells.drawing.ImageType:
        '''Gets the image format of the picture.'''
        raise NotImplementedError()
    
    @property
    def original_height_cm(self) -> float:
        '''Gets the original height of picture, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def original_width_cm(self) -> float:
        '''Gets the original width of picture, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def original_height_inch(self) -> float:
        '''Gets the original height of picture, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def original_width_inch(self) -> float:
        '''Gets the original width of picture, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def signature_line(self) -> aspose.cells.drawing.SignatureLine:
        '''Gets and sets the signature line'''
        raise NotImplementedError()
    
    @signature_line.setter
    def signature_line(self, value : aspose.cells.drawing.SignatureLine) -> None:
        '''Gets and sets the signature line'''
        raise NotImplementedError()
    

class PictureCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.drawing.Picture` objects.'''
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int, stream : io._IOBase) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index
        :param stream: Stream object which contains the image data.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int, file_name : str) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index
        :param file_name: Image filename.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, stream : io._IOBase) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param stream: Stream object which contains the image data.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, file_name : str) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param file_name: Image filename.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, stream : io._IOBase, width_scale : int, height_scale : int) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param stream: Stream object which contains the image data.
        :param width_scale: Scale of image width, a percentage.
        :param height_scale: Scale of image height, a percentage.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, upper_left_row : int, upper_left_column : int, file_name : str, width_scale : int, height_scale : int) -> int:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param file_name: Image filename.
        :param width_scale: Scale of image width, a percentage.
        :param height_scale: Scale of image height, a percentage.
        :returns: :py:class:`aspose.cells.drawing.Picture` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.Picture]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.Picture], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.Picture, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.Picture, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Picture) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Picture, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Picture, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def camera(self, row : int, column : int, range : str) -> int:
        '''Takes a photo of the range.
        
        :param row: The row index of this picture.
        :param column: The column index  of this picture.
        :param range: The area that requires photography'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.Picture) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class RadioButton(Shape):
    '''Represents a radio button.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    def get_option_index(self) -> int:
        '''Gets the option index (one-based) in all the radio buttons of the GroupBox which contains this radio button.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def is_checked(self) -> bool:
        '''Indicates if the radiobutton is checked or not.'''
        raise NotImplementedError()
    
    @is_checked.setter
    def is_checked(self, value : bool) -> None:
        '''Indicates if the radiobutton is checked or not.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the combobox has 3-D shading.'''
        raise NotImplementedError()
    
    @property
    def group_box(self) -> aspose.cells.drawing.GroupBox:
        '''Gets the GroupBox that contains this RadioButton.'''
        raise NotImplementedError()
    

class RectangleShape(Shape):
    '''Represents the rectangle shape.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class ReflectionEffect:
    '''This class specifies a reflection effect.'''
    
    @property
    def type(self) -> aspose.cells.drawing.ReflectionEffectType:
        '''Gets and sets the preset reflection effect.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.drawing.ReflectionEffectType) -> None:
        '''Gets and sets the preset reflection effect.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Gets and sets the degree of the starting reflection transparency as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Gets and sets the degree of the starting reflection transparency as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def size(self) -> float:
        '''Gets and sets the end position (along the alpha gradient ramp) of the end alpha value,in unit of percentage'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : float) -> None:
        '''Gets and sets the end position (along the alpha gradient ramp) of the end alpha value,in unit of percentage'''
        raise NotImplementedError()
    
    @property
    def blur(self) -> float:
        '''Gets and sets the blur radius,in unit of points.'''
        raise NotImplementedError()
    
    @blur.setter
    def blur(self, value : float) -> None:
        '''Gets and sets the blur radius,in unit of points.'''
        raise NotImplementedError()
    
    @property
    def direction(self) -> float:
        '''Gets and sets the direction of the alpha gradient ramp relative to the shape itself.'''
        raise NotImplementedError()
    
    @direction.setter
    def direction(self, value : float) -> None:
        '''Gets and sets the direction of the alpha gradient ramp relative to the shape itself.'''
        raise NotImplementedError()
    
    @property
    def distance(self) -> float:
        '''Gets and sets how far to distance the shadow,in unit of points.'''
        raise NotImplementedError()
    
    @distance.setter
    def distance(self, value : float) -> None:
        '''Gets and sets how far to distance the shadow,in unit of points.'''
        raise NotImplementedError()
    
    @property
    def fade_direction(self) -> float:
        '''Gets and sets the direction to offset the reflection.'''
        raise NotImplementedError()
    
    @fade_direction.setter
    def fade_direction(self, value : float) -> None:
        '''Gets and sets the direction to offset the reflection.'''
        raise NotImplementedError()
    
    @property
    def rot_with_shape(self) -> bool:
        '''Gets and sets if the reflection should rotate with the shape.'''
        raise NotImplementedError()
    
    @rot_with_shape.setter
    def rot_with_shape(self, value : bool) -> None:
        '''Gets and sets if the reflection should rotate with the shape.'''
        raise NotImplementedError()
    

class ScrollBar(Shape):
    '''Represents a scroll bar object.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @property
    def current_value(self) -> int:
        '''Gets the current value.'''
        raise NotImplementedError()
    
    @current_value.setter
    def current_value(self, value : int) -> None:
        '''Sets the current value.'''
        raise NotImplementedError()
    
    @property
    def min(self) -> int:
        '''Gets the minimum value of a scroll bar or spinner range.'''
        raise NotImplementedError()
    
    @min.setter
    def min(self, value : int) -> None:
        '''Sets the minimum value of a scroll bar or spinner range.'''
        raise NotImplementedError()
    
    @property
    def max(self) -> int:
        '''Gets the maximum value of a scroll bar or spinner range.'''
        raise NotImplementedError()
    
    @max.setter
    def max(self, value : int) -> None:
        '''Sets the maximum value of a scroll bar or spinner range.'''
        raise NotImplementedError()
    
    @property
    def incremental_change(self) -> int:
        '''Gets the amount that the scroll bar or spinner is incremented a line scroll.'''
        raise NotImplementedError()
    
    @incremental_change.setter
    def incremental_change(self, value : int) -> None:
        '''Sets the amount that the scroll bar or spinner is incremented a line scroll.'''
        raise NotImplementedError()
    
    @property
    def page_change(self) -> int:
        '''Gets page change'''
        raise NotImplementedError()
    
    @page_change.setter
    def page_change(self, value : int) -> None:
        '''Sets page change'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''Indicates whether the shape has 3-D shading.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''Indicates whether the shape has 3-D shading.'''
        raise NotImplementedError()
    
    @property
    def is_horizontal(self) -> bool:
        '''Indicates whether this is a horizontal scroll bar.'''
        raise NotImplementedError()
    
    @is_horizontal.setter
    def is_horizontal(self, value : bool) -> None:
        '''Indicates whether this is a horizontal scroll bar.'''
        raise NotImplementedError()
    

class ShadowEffect:
    '''This class specifies the shadow effect of the chart element or shape.'''
    
    @property
    def preset_type(self) -> aspose.cells.drawing.PresetShadowType:
        '''Gets and sets the preset shadow type of the shadow.'''
        raise NotImplementedError()
    
    @preset_type.setter
    def preset_type(self, value : aspose.cells.drawing.PresetShadowType) -> None:
        '''Gets and sets the preset shadow type of the shadow.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the shadow.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the shadow.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Gets and sets the degree of transparency of the shadow. Range from 0.0 (opaque) to 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Gets and sets the degree of transparency of the shadow. Range from 0.0 (opaque) to 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def size(self) -> float:
        '''Gets and sets the size of the shadow. Range from 0 to 2.0.
        Meaningless in inner shadow.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : float) -> None:
        '''Gets and sets the size of the shadow. Range from 0 to 2.0.
        Meaningless in inner shadow.'''
        raise NotImplementedError()
    
    @property
    def blur(self) -> float:
        '''Gets and sets the blur of the shadow. Range from 0 to 100 points.'''
        raise NotImplementedError()
    
    @blur.setter
    def blur(self, value : float) -> None:
        '''Gets and sets the blur of the shadow. Range from 0 to 100 points.'''
        raise NotImplementedError()
    
    @property
    def angle(self) -> float:
        '''Gets and sets the lighting angle. Range from 0 to 359.9 degrees.'''
        raise NotImplementedError()
    
    @angle.setter
    def angle(self, value : float) -> None:
        '''Gets and sets the lighting angle. Range from 0 to 359.9 degrees.'''
        raise NotImplementedError()
    
    @property
    def distance(self) -> float:
        '''Gets and sets the distance of the shadow. Range from 0 to 200 points.'''
        raise NotImplementedError()
    
    @distance.setter
    def distance(self, value : float) -> None:
        '''Gets and sets the distance of the shadow. Range from 0 to 200 points.'''
        raise NotImplementedError()
    

class Shape:
    '''Represents the msodrawing object.'''
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the shape image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a file.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Saves the shape to a stream.'''
        raise NotImplementedError()
    
    def get_result_of_smart_art(self) -> aspose.cells.drawing.GroupShape:
        '''Converting smart art to grouped shapes.'''
        raise NotImplementedError()
    
    def to_front_or_back(self, orders : int) -> None:
        '''Brings the shape to the front or sends the shape to back.
        
        :param orders: If it\'s less than zero, sets the shape to back.
        If it\'s greater than zero, brings the shape to front.'''
        raise NotImplementedError()
    
    def get_locked_property(self, type : aspose.cells.drawing.ShapeLockType) -> bool:
        '''Gets the value of locked property.
        
        :param type: The type of the shape locked property.
        :returns: Returns  the value of locked property.'''
        raise NotImplementedError()
    
    def set_locked_property(self, type : aspose.cells.drawing.ShapeLockType, value : bool) -> None:
        '''Set the locked property.
        
        :param type: The locked type.
        :param value: The value of the property.'''
        raise NotImplementedError()
    
    def add_hyperlink(self, address : str) -> aspose.cells.Hyperlink:
        '''Adds a hyperlink to the shape.
        
        :param address: Address of the hyperlink.
        :returns: Return the new hyperlink object.'''
        raise NotImplementedError()
    
    def remove_hyperlink(self) -> None:
        '''Removes the hyperlink of the shape.'''
        raise NotImplementedError()
    
    def move_to_range(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the shape to a specified range.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index'''
        raise NotImplementedError()
    
    def align_top_right_corner(self, top_row : int, right_column : int) -> None:
        '''Moves the picture to the top-right corner.
        
        :param top_row: the row index.
        :param right_column: the column index.'''
        raise NotImplementedError()
    
    def get_connection_points(self) -> List[List[float]]:
        '''Get the connection points
        
        :returns: [X,Y] pairs of the connection point. Every item is a float[2] array, [0] represents x and [1] represents y.'''
        raise NotImplementedError()
    
    def get_linked_cell(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range linked to the control\'s value.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range linked to the control\'s value.'''
        raise NotImplementedError()
    
    def set_linked_cell(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range linked to the control\'s value.
        
        :param formula: The range linked to the control\'s value.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def get_input_range(self, is_r1c1 : bool, is_local : bool) -> str:
        '''Gets the range used to fill the control.
        
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.
        :returns: The range used to fill the control.'''
        raise NotImplementedError()
    
    def set_input_range(self, formula : str, is_r1c1 : bool, is_local : bool) -> None:
        '''Sets the range used to fill the control.
        
        :param formula: The range used to fill the control.
        :param is_r1c1: Whether the formula needs to be formatted as R1C1.
        :param is_local: Whether the formula needs to be formatted by locale.'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell.'''
        raise NotImplementedError()
    
    def calculate_text_size(self) -> List[int]:
        '''Recalculate the text area
        
        :returns: Text\'s Size in an array(width and height).'''
        raise NotImplementedError()
    
    def format_characters(self, start_index : int, length : int, font : aspose.cells.Font, flag : aspose.cells.StyleFlag) -> None:
        '''Formats some characters with the font setting.
        
        :param start_index: The start index.
        :param length: The length.
        :param font: The font setting.
        :param flag: The flag of the font setting.'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_characters(self) -> List[Any]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def get_rich_formattings(self) -> List[aspose.cells.FontSetting]:
        '''Returns all Characters objects
        that represents a range of characters within the text .
        
        :returns: All Characters objects'''
        raise NotImplementedError()
    
    def remove_active_x_control(self) -> None:
        '''Remove activeX control.'''
        raise NotImplementedError()
    
    def is_same_setting(self, obj : Any) -> bool:
        '''Returns whether the shape is same.'''
        raise NotImplementedError()
    
    def get_actual_box(self) -> List[float]:
        '''Get the actual position and size of the shape (after applying rotation, flip, etc.)
        
        :returns: Return the position and size in the order of x, y, w, h'''
        raise NotImplementedError()
    
    def fit_to_text_size(self) -> None:
        '''Recalculate a text area suitable for displaying all text content.'''
        raise NotImplementedError()
    
    @property
    def macro_name(self) -> str:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @macro_name.setter
    def macro_name(self, value : str) -> None:
        '''Gets and sets the name of macro.'''
        raise NotImplementedError()
    
    @property
    def is_equation(self) -> bool:
        '''Indicates whether the shape only contains an equation.'''
        raise NotImplementedError()
    
    @property
    def is_smart_art(self) -> bool:
        '''Indicates whether the shape is a smart art.'''
        raise NotImplementedError()
    
    @property
    def z_order_position(self) -> int:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @z_order_position.setter
    def z_order_position(self, value : int) -> None:
        '''Returns the position of a shape in the z-order.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the shape.'''
        raise NotImplementedError()
    
    @property
    def alternative_text(self) -> str:
        '''Returns the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @alternative_text.setter
    def alternative_text(self, value : str) -> None:
        '''Returns or sets the descriptive (alternative) text string of the :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> str:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @title.setter
    def title(self, value : str) -> None:
        '''Specifies the title (caption) of the current shape object.'''
        raise NotImplementedError()
    
    @property
    def line_format(self) -> aspose.cells.drawing.MsoLineFormat:
        '''Returns a MsoLineFormat object that contains line formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.MsoFillFormat:
        '''Returns a MsoFillFormat object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.LineFormat:
        '''Gets line style'''
        raise NotImplementedError()
    
    @property
    def fill(self) -> aspose.cells.drawing.FillFormat:
        '''Returns a :py:attr:`aspose.cells.drawing.Shape.fill_format` object that contains fill formatting properties for the specified shape.'''
        raise NotImplementedError()
    
    @property
    def shadow_effect(self) -> aspose.cells.drawing.ShadowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ShadowEffect` object that specifies shadow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def reflection(self) -> aspose.cells.drawing.ReflectionEffect:
        '''Represents a :py:class:`aspose.cells.drawing.ReflectionEffect` object that specifies reflection effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def glow(self) -> aspose.cells.drawing.GlowEffect:
        '''Represents a :py:class:`aspose.cells.drawing.GlowEffect` object that specifies glow effect for the chart element or shape.'''
        raise NotImplementedError()
    
    @property
    def soft_edges(self) -> float:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @soft_edges.setter
    def soft_edges(self, value : float) -> None:
        '''Gets and sets the radius of blur to apply to the edges, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def three_d_format(self) -> aspose.cells.drawing.ThreeDFormat:
        '''Gets and sets 3d format of the shape.'''
        raise NotImplementedError()
    
    @property
    def format_picture(self) -> aspose.cells.drawing.MsoFormatPicture:
        '''Gets and sets the options of the picture format.'''
        raise NotImplementedError()
    
    @property
    def is_hidden(self) -> bool:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @is_hidden.setter
    def is_hidden(self, value : bool) -> None:
        '''Indicates whether the object is visible.'''
        raise NotImplementedError()
    
    @property
    def is_lock_aspect_ratio(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_lock_aspect_ratio.setter
    def is_lock_aspect_ratio(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def is_aspect_ratio_locked(self) -> bool:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @is_aspect_ratio_locked.setter
    def is_aspect_ratio_locked(self, value : bool) -> None:
        '''True means that aspect ratio of the shape is locked.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> float:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : float) -> None:
        '''Gets and sets the rotation of the shape.'''
        raise NotImplementedError()
    
    @property
    def hyperlink(self) -> aspose.cells.Hyperlink:
        '''Gets the hyperlink of the shape.'''
        raise NotImplementedError()
    
    @property
    def id(self) -> int:
        '''Gets the identifier of this shape.'''
        raise NotImplementedError()
    
    @property
    def spid(self) -> str:
        '''Specifies an optional string identifier that an application can use to identify the particular shape.'''
        raise NotImplementedError()
    
    @property
    def spt(self) -> int:
        '''Specifies an optional number that an application can use to associate the particular shape with a defined shape type.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the :py:attr:`aspose.cells.drawing.Shape.worksheet` object which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def is_group(self) -> bool:
        '''Indicates whether this shape is a group shape.'''
        raise NotImplementedError()
    
    @property
    def is_in_group(self) -> bool:
        '''Indicates whether the shape is grouped.'''
        raise NotImplementedError()
    
    @property
    def is_word_art(self) -> bool:
        '''Indicates whether this shape is a word art.'''
        raise NotImplementedError()
    
    @property
    def text_effect(self) -> aspose.cells.drawing.TextEffectFormat:
        '''Returns a TextEffectFormat object that contains text-effect formatting properties for the specified shape.
        Applies to Shape objects that represent WordArt.'''
        raise NotImplementedError()
    
    @property
    def is_locked(self) -> bool:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @is_locked.setter
    def is_locked(self, value : bool) -> None:
        '''True means the object can not be modified when the sheet is protected.
        Note that this value is meaningful only if the worksheet or objects in the worksheet are protected.'''
        raise NotImplementedError()
    
    @property
    def is_printable(self) -> bool:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @is_printable.setter
    def is_printable(self, value : bool) -> None:
        '''Indicates whether the object is printable.
        If False, this shape will not be printed when printing.'''
        raise NotImplementedError()
    
    @property
    def mso_drawing_type(self) -> aspose.cells.drawing.MsoDrawingType:
        '''Gets drawing type.'''
        raise NotImplementedError()
    
    @property
    def auto_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @auto_shape_type.setter
    def auto_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def anchor_type(self) -> aspose.cells.drawing.ShapeAnchorType:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @anchor_type.setter
    def anchor_type(self, value : aspose.cells.drawing.ShapeAnchorType) -> None:
        '''Gets and set the type of the shape anchor placeholder.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the drawing object is attached to the cells below it.
        The property controls the placement of an object on a worksheet.'''
        raise NotImplementedError()
    
    @property
    def upper_left_row(self) -> int:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @upper_left_row.setter
    def upper_left_row(self, value : int) -> None:
        '''Represents the top row index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @upper_delta_y.setter
    def upper_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its upper left corner row.'''
        raise NotImplementedError()
    
    @property
    def upper_left_column(self) -> int:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @upper_left_column.setter
    def upper_left_column(self, value : int) -> None:
        '''Represents upper left corner column index.'''
        raise NotImplementedError()
    
    @property
    def upper_delta_x(self) -> int:
        '''Gets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @upper_delta_x.setter
    def upper_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal offset from its upper left corner column.'''
        raise NotImplementedError()
    
    @property
    def lower_right_row(self) -> int:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @lower_right_row.setter
    def lower_right_row(self, value : int) -> None:
        '''Represents lower right corner row index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_y(self) -> int:
        '''Gets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @lower_delta_y.setter
    def lower_delta_y(self, value : int) -> None:
        '''Sets the shape\'s vertical offset from its lower right corner row.'''
        raise NotImplementedError()
    
    @property
    def lower_right_column(self) -> int:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @lower_right_column.setter
    def lower_right_column(self, value : int) -> None:
        '''Represents lower right corner column index.'''
        raise NotImplementedError()
    
    @property
    def lower_delta_x(self) -> int:
        '''Gets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @lower_delta_x.setter
    def lower_delta_x(self, value : int) -> None:
        '''Sets the shape\'s horizontal  offset from its lower right corner column.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Represents the width of the shape\'s horizontal  offset from its lower right corner column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Represents the width of the shape\'s vertical offset from its lower bottom corner row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Represents the width of shape, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_inch(self) -> float:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @width_inch.setter
    def width_inch(self, value : float) -> None:
        '''Represents the width of the shape, in unit of inch.'''
        raise NotImplementedError()
    
    @property
    def width_pt(self) -> float:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @width_pt.setter
    def width_pt(self, value : float) -> None:
        '''Represents the width of the shape, in unit of point.'''
        raise NotImplementedError()
    
    @property
    def width_cm(self) -> float:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @width_cm.setter
    def width_cm(self, value : float) -> None:
        '''Represents the width of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Represents the height of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    @property
    def height_inch(self) -> float:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @height_inch.setter
    def height_inch(self, value : float) -> None:
        '''Represents the height of the shape, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def height_pt(self) -> float:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @height_pt.setter
    def height_pt(self, value : float) -> None:
        '''Represents the height of the shape, in unit of points.'''
        raise NotImplementedError()
    
    @property
    def height_cm(self) -> float:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @height_cm.setter
    def height_cm(self, value : float) -> None:
        '''Represents the height of the shape, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_inch(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @left_inch.setter
    def left_inch(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def left_cm(self) -> float:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @left_cm.setter
    def left_cm(self, value : float) -> None:
        '''Represents the horizontal offset of shape from its left column, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def top_inch(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @top_inch.setter
    def top_inch(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of inches.'''
        raise NotImplementedError()
    
    @property
    def top_cm(self) -> float:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @top_cm.setter
    def top_cm(self, value : float) -> None:
        '''Represents the vertical offset of shape from its top row, in unit of centimeters.'''
        raise NotImplementedError()
    
    @property
    def top_to_corner(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @top_to_corner.setter
    def top_to_corner(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border, in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def left_to_corner(self) -> int:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @left_to_corner.setter
    def left_to_corner(self, value : int) -> None:
        '''Gets and sets the horizonal offset of shape from worksheet left border.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets the horizontal offset of shape from worksheet left border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets and sets the vertical offset of shape from worksheet top border,in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> int:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : int) -> None:
        '''Gets and sets the width scale, in unit of percent of the original picture width.
        If the shape is not picture ,the WidthScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def height_scale(self) -> int:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @height_scale.setter
    def height_scale(self, value : int) -> None:
        '''Gets and sets the height scale,in unit of percent of the original picture height.
        If the shape is not picture ,the HeightScale property only returns 100;'''
        raise NotImplementedError()
    
    @property
    def top_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @top_in_shape.setter
    def top_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape,
        in unit of 1/4000 of height of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def left_in_shape(self) -> int:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @left_in_shape.setter
    def left_in_shape(self, value : int) -> None:
        '''Represents the horizontal offset of shape from the left border of the parent shape,
        in unit of 1/4000 of width of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def width_in_shape(self) -> int:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @width_in_shape.setter
    def width_in_shape(self, value : int) -> None:
        '''Represents the width of the shape, in unit of 1/4000 of the parent shape.'''
        raise NotImplementedError()
    
    @property
    def height_in_shape(self) -> int:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @height_in_shape.setter
    def height_in_shape(self, value : int) -> None:
        '''Represents the vertical offset of shape from the top border of the parent shape, in unit of 1/4000 of height of the parent shape..'''
        raise NotImplementedError()
    
    @property
    def group(self) -> aspose.cells.drawing.GroupShape:
        '''Gets the group shape which contains this shape.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets the auto shape type.'''
        raise NotImplementedError()
    
    @property
    def has_line(self) -> bool:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @has_line.setter
    def has_line(self, value : bool) -> None:
        '''Gets and sets the line border of the shape is visible.'''
        raise NotImplementedError()
    
    @property
    def is_filled(self) -> bool:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @is_filled.setter
    def is_filled(self, value : bool) -> None:
        '''Indicates whether the fill format is visible.'''
        raise NotImplementedError()
    
    @property
    def is_flipped_horizontally(self) -> bool:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @is_flipped_horizontally.setter
    def is_flipped_horizontally(self, value : bool) -> None:
        '''Gets and sets whether shape is horizontally flipped .'''
        raise NotImplementedError()
    
    @property
    def is_flipped_vertically(self) -> bool:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @is_flipped_vertically.setter
    def is_flipped_vertically(self, value : bool) -> None:
        '''Gets and sets whether shape is vertically flipped .'''
        raise NotImplementedError()
    
    @property
    def actual_lower_right_row(self) -> int:
        '''Get the actual bottom row.'''
        raise NotImplementedError()
    
    @property
    def relative_to_original_picture_size(self) -> bool:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @relative_to_original_picture_size.setter
    def relative_to_original_picture_size(self, value : bool) -> None:
        '''Indicates whether shape is relative to original picture size.'''
        raise NotImplementedError()
    
    @property
    def linked_cell(self) -> str:
        '''Gets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @linked_cell.setter
    def linked_cell(self, value : str) -> None:
        '''Sets the worksheet range linked to the control\'s value.'''
        raise NotImplementedError()
    
    @property
    def input_range(self) -> str:
        '''Gets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @input_range.setter
    def input_range(self, value : str) -> None:
        '''Sets the worksheet range used to fill the specified combo box.'''
        raise NotImplementedError()
    
    @property
    def text_shape_type(self) -> aspose.cells.drawing.AutoShapeType:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @text_shape_type.setter
    def text_shape_type(self, value : aspose.cells.drawing.AutoShapeType) -> None:
        '''Gets and sets the preset text shape type.'''
        raise NotImplementedError()
    
    @property
    def text_body(self) -> aspose.cells.drawing.texts.FontSettingCollection:
        '''Gets and sets the setting of the shape\'s text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @font.setter
    def font(self, value : aspose.cells.Font) -> None:
        '''Represents the font of shape.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @text_options.setter
    def text_options(self, value : aspose.cells.drawing.texts.TextOptions) -> None:
        '''Represents the text options of the shape.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Gets and sets the text of this shape.'''
        raise NotImplementedError()
    
    @property
    def is_rich_text(self) -> bool:
        '''Whether or not the text is rich text.'''
        raise NotImplementedError()
    
    @property
    def html_text(self) -> str:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @html_text.setter
    def html_text(self, value : str) -> None:
        '''Gets and sets the html string which contains data and some formats in this textbox.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_vertical_overflow.setter
    def text_vertical_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text vertical overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_overflow(self) -> aspose.cells.drawing.TextOverflowType:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @text_horizontal_overflow.setter
    def text_horizontal_overflow(self, value : aspose.cells.drawing.TextOverflowType) -> None:
        '''Gets and sets the text horizontal overflow type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Gets and sets the text wrapped type of the shape which contains text.'''
        raise NotImplementedError()
    
    @property
    def text_orientation_type(self) -> aspose.cells.TextOrientationType:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @text_orientation_type.setter
    def text_orientation_type(self, value : aspose.cells.TextOrientationType) -> None:
        '''Gets and sets the text orientation type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text vertical alignment type of the shape.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Gets/Sets the direction of the text flow for this object.'''
        raise NotImplementedError()
    
    @property
    def text_box_options(self) -> aspose.cells.drawing.texts.TextBoxOptions:
        '''Gets the text information in the shape'''
        raise NotImplementedError()
    
    @property
    def control_data(self) -> List[int]:
        '''Gets the data of control.'''
        raise NotImplementedError()
    
    @property
    def active_x_control(self) -> aspose.cells.drawing.activexcontrols.ActiveXControl:
        '''Gets the ActiveX control.'''
        raise NotImplementedError()
    
    @property
    def paths(self) -> aspose.cells.drawing.ShapePathCollection:
        '''Gets the paths of a custom geometric shape.'''
        raise NotImplementedError()
    
    @property
    def geometry(self) -> aspose.cells.drawing.Geometry:
        '''Gets the geometry'''
        raise NotImplementedError()
    
    @property
    def create_id(self) -> UUID:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @create_id.setter
    def create_id(self, value : UUID) -> None:
        '''Gets and sets create id for this shape.'''
        raise NotImplementedError()
    
    @property
    def is_decorative(self) -> bool:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    
    @is_decorative.setter
    def is_decorative(self, value : bool) -> None:
        '''Indicates whether the object is decorative.'''
        raise NotImplementedError()
    

class ShapeCollection:
    '''Represents all the shape in a worksheet/chart.'''
    
    @overload
    def add_shape_in_chart(self, type : aspose.cells.drawing.MsoDrawingType, placement : aspose.cells.drawing.PlacementType, left : int, top : int, right : int, bottom : int, image_data : List[int]) -> aspose.cells.drawing.Shape:
        '''Add a shape to chart .All unit is 1/4000 of chart area.
        
        :param type: The drawing type.
        :param placement: the placement type.
        :param left: In unit of 1/4000 chart area width.
        :param top: In unit of 1/4000 chart area height.
        :param right: In unit of 1/4000 chart area width.
        :param bottom: In unit of 1/4000 chart area height.
        :param image_data: If the shape is not a picture or ole object,imageData should be null.'''
        raise NotImplementedError()
    
    @overload
    def add_shape_in_chart(self, type : aspose.cells.drawing.MsoDrawingType, placement : aspose.cells.drawing.PlacementType, left : int, top : int, right : int, bottom : int) -> aspose.cells.drawing.Shape:
        '''Add a shape to chart .All unit is 1/4000 of chart area.
        
        :param type: The drawing type.
        :param placement: the placement type.
        :param left: In unit of 1/4000 chart area width.
        :param top: In unit of 1/4000 chart area height.
        :param right: In unit of 1/4000 chart area width.
        :param bottom: In unit of 1/4000 chart area height.'''
        raise NotImplementedError()
    
    @overload
    def add_shape_in_chart_by_scale(self, type : aspose.cells.drawing.MsoDrawingType, placement : aspose.cells.drawing.PlacementType, left : float, top : float, right : float, bottom : float) -> aspose.cells.drawing.Shape:
        '''Add a shape to chart. All unit is percent scale of chart area.
        
        :param type: The drawing type.
        :param placement: the placement type.
        :param left: Unit is percent scale of chart area width.
        :param top: Unit is percent scale of chart area height.
        :param right: Unit is percent scale of chart area width.
        :param bottom: Unit is percent scale of chart area height.'''
        raise NotImplementedError()
    
    @overload
    def add_shape_in_chart_by_scale(self, type : aspose.cells.drawing.MsoDrawingType, placement : aspose.cells.drawing.PlacementType, left : float, top : float, right : float, bottom : float, image_data : List[int]) -> aspose.cells.drawing.Shape:
        '''Add a shape to chart .All unit is 1/4000 of chart area.
        
        :param type: The drawing type.
        :param placement: the placement type.
        :param left: Unit is percent scale of chart area width.
        :param top: Unit is percent scale of chart area height.
        :param right: Unit is percent scale of chart area width.
        :param bottom: Unit is percent scale of chart area height.
        :param image_data: If the shape is not a picture or ole object,imageData should be null.'''
        raise NotImplementedError()
    
    @overload
    def add_picture(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int, stream : io._IOBase) -> aspose.cells.drawing.Picture:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index
        :param stream: Stream object which contains the image data.
        :returns: :py:class:`aspose.cells.drawing.Picture` Picture object.'''
        raise NotImplementedError()
    
    @overload
    def add_picture(self, upper_left_row : int, upper_left_column : int, stream : io._IOBase, width_scale : int, height_scale : int) -> aspose.cells.drawing.Picture:
        '''Adds a picture to the collection.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param stream: Stream object which contains the image data.
        :param width_scale: Scale of image width, a percentage.
        :param height_scale: Scale of image height, a percentage.
        :returns: :py:class:`aspose.cells.drawing.Picture` Picture object.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.Shape]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.Shape], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.Shape, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.Shape, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Shape) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Shape, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.Shape, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def get(self, name : str) -> aspose.cells.drawing.Shape:
        '''Gets the :py:class:`aspose.cells.drawing.Shape` object by the name of the shape.
        
        :param name: The name of the shape.'''
        raise NotImplementedError()
    
    def add_copy(self, source_shape : aspose.cells.drawing.Shape, top_row : int, top : int, left_column : int, left : int) -> aspose.cells.drawing.Shape:
        '''Adds and copy a shape to the worksheet.
        
        :param source_shape: Source shape.
        :param top_row: The top row index.
        :param top: Represents the vertical  offset from its top row, in unit of pixel.
        :param left_column: The left column index.
        :param left: Represents the horizontal offset from its left column, in unit of pixel.
        :returns: The new :py:class:`aspose.cells.drawing.Shape` object.'''
        raise NotImplementedError()
    
    def add_check_box(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.CheckBox:
        '''Adds a checkbox to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of checkbox from its top row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of textbox from its left column, in unit of pixel.
        :param height: Height of textbox, in unit of pixel.
        :param width: Width of textbox, in unit of pixel.
        :returns: The new CheckBox object index.'''
        raise NotImplementedError()
    
    def add_text_box(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.TextBox:
        '''Adds a text box to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of textbox from its top row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of textbox from its left column, in unit of pixel.
        :param height: Represents the height of textbox, in unit of pixel.
        :param width: Represents the width of textbox, in unit of pixel.
        :returns: A :py:class:`aspose.cells.drawing.TextBox` object.'''
        raise NotImplementedError()
    
    def add_equation(self, top_row : int, top : int, left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.TextBox:
        '''Add an equation object to the worksheet.
        
        :param top_row: The top row index.
        :param top: The vertical  offset its top row, in unit of pixel.
        :param left_column: The left column index.
        :param left: The horizontal offset from its left column, in unit of pixel.
        :param height: The height of equation, in unit of pixel.
        :param width: The width of equation, in unit of pixel.'''
        raise NotImplementedError()
    
    def add_spinner(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Spinner:
        '''Adds a Spinner to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Spinner from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Spinner from its left column, in unit of pixel.
        :param height: Represents the height of Spinner, in unit of pixel.
        :param width: Represents the width of Spinner, in unit of pixel.
        :returns: A Spinner object.'''
        raise NotImplementedError()
    
    def add_scroll_bar(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.ScrollBar:
        '''Adds a ScrollBar to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of ScrollBar from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of ScrollBar from its left column, in unit of pixel.
        :param height: Represents the height of ScrollBar, in unit of pixel.
        :param width: Represents the width of ScrollBar, in unit of pixel.
        :returns: A ScrollBar object.'''
        raise NotImplementedError()
    
    def add_radio_button(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.RadioButton:
        '''Adds a RadioButton to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of RadioButton from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of RadioButton from its left column, in unit of pixel.
        :param height: Represents the height of RadioButton, in unit of pixel.
        :param width: Represents the width of RadioButton, in unit of pixel.
        :returns: A RadioButton object.'''
        raise NotImplementedError()
    
    def add_list_box(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.ListBox:
        '''Adds a ListBox to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of ListBox from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of ListBox from its left column, in unit of pixel.
        :param height: Represents the height of ListBox, in unit of pixel.
        :param width: Represents the width of ListBox, in unit of pixel.
        :returns: A ListBox object.'''
        raise NotImplementedError()
    
    def add_combo_box(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.ComboBox:
        '''Adds a ComboBox to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of ComboBox from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of ComboBox from its left column, in unit of pixel.
        :param height: Represents the height of ComboBox, in unit of pixel.
        :param width: Represents the width of ComboBox, in unit of pixel.
        :returns: A ComboBox object.'''
        raise NotImplementedError()
    
    def add_group_box(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.GroupBox:
        '''Adds a GroupBox to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of GroupBox from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of GroupBox from its left column, in unit of pixel.
        :param height: Represents the height of GroupBox, in unit of pixel.
        :param width: Represents the width of GroupBox, in unit of pixel.
        :returns: A GroupBox object.'''
        raise NotImplementedError()
    
    def add_button(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Button:
        '''Adds a Button to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Button from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Button from its left column, in unit of pixel.
        :param height: Represents the height of Button, in unit of pixel.
        :param width: Represents the width of Button, in unit of pixel.
        :returns: A Button object.'''
        raise NotImplementedError()
    
    def add_label(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Label:
        '''Adds a Label to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Label from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Label from its left column, in unit of pixel.
        :param height: Represents the height of Label, in unit of pixel.
        :param width: Represents the width of Label, in unit of pixel.
        :returns: A Label object.'''
        raise NotImplementedError()
    
    def add_label_in_chart(self, top : int, left : int, height : int, width : int) -> aspose.cells.drawing.Label:
        '''Adds a label to the chart.
        
        :param top: Represents the vertical offset of label from the upper left corner in units of 1/4000 of the chart area.
        :param left: Represents the vertical offset of label from the upper left corner in units of 1/4000 of the chart area.
        :param height: Represents the height of label, in units of 1/4000 of the chart area.
        :param width: Represents the width of label, in units of 1/4000 of the chart area.
        :returns: A new Label object.'''
        raise NotImplementedError()
    
    def add_text_box_in_chart(self, top : int, left : int, height : int, width : int) -> aspose.cells.drawing.TextBox:
        '''Adds a textbox to the chart.
        
        :param top: Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.
        :param left: Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.
        :param height: Represents the height of textbox, in units of 1/4000 of the chart area.
        :param width: Represents the width of textbox, in units of 1/4000 of the chart area.
        :returns: A TextBox object.'''
        raise NotImplementedError()
    
    def add_text_effect_in_chart(self, effect : aspose.cells.drawing.MsoPresetTextEffect, text : str, font_name : str, size : int, font_bold : bool, font_italic : bool, top : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Inserts a WordArt object to the chart
        
        :param effect: The mso preset text effect type.
        :param text: The WordArt text.
        :param font_name: The font name.
        :param size: The font size
        :param font_bold: Indicates whether font is bold.
        :param font_italic: Indicates whether font is italic.
        :param top: Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area.
        :param left: Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area.
        :param height: Represents the height of shape, in units of 1/4000 of the chart area.
        :param width: Represents the width of shape, in units of 1/4000 of the chart area.
        :returns: Returns a Shape object that represents the new WordArt object.'''
        raise NotImplementedError()
    
    def add_text_effect(self, effect : aspose.cells.drawing.MsoPresetTextEffect, text : str, font_name : str, size : int, font_bold : bool, font_italic : bool, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Inserts a WordArt object.
        
        :param effect: The mso preset text effect type.
        :param text: The WordArt text.
        :param font_name: The font name.
        :param size: The font size
        :param font_bold: Indicates whether font is bold.
        :param font_italic: Indicates whether font is italic.
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of shape from its left column, in unit of pixel.
        :param height: Represents the height of shape, in unit of pixel.
        :param width: Represents the width of shape, in unit of pixel.
        :returns: Returns a Shape object that represents the new WordArt object.'''
        raise NotImplementedError()
    
    def add_word_art(self, style : aspose.cells.drawing.PresetWordArtStyle, text : str, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Adds preset WordArt since Excel 2007.s
        
        :param style: The preset WordArt Style.
        :param text: The text.
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of shape from its left column, in unit of pixel.
        :param height: Represents the height of shape, in unit of pixel.
        :param width: Represents the width of shape, in unit of pixel.'''
        raise NotImplementedError()
    
    def add_rectangle(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.RectangleShape:
        '''Adds a RectangleShape to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of RectangleShape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of RectangleShape from its left column, in unit of pixel.
        :param height: Represents the height of RectangleShape, in unit of pixel.
        :param width: Represents the width of RectangleShape, in unit of pixel.
        :returns: A RectangleShape object.'''
        raise NotImplementedError()
    
    def add_oval(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Oval:
        '''Adds a Oval to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Oval from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Oval from its left column, in unit of pixel.
        :param height: Represents the height of Oval, in unit of pixel.
        :param width: Represents the width of Oval, in unit of pixel.
        :returns: A Oval object.'''
        raise NotImplementedError()
    
    def add_line(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.LineShape:
        '''Adds a LineShape to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of LineShape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of LineShape from its left column, in unit of pixel.
        :param height: Represents the height of LineShape, in unit of pixel.
        :param width: Represents the width of LineShape, in unit of pixel.
        :returns: A LineShape object.'''
        raise NotImplementedError()
    
    def add_free_floating_shape(self, type : aspose.cells.drawing.MsoDrawingType, top : int, left : int, height : int, width : int, image_data : List[int], is_original_size : bool) -> aspose.cells.drawing.Shape:
        '''Adds a free floating shape to the worksheet.Only applies for line/image shape.
        
        :param type: The shape type.
        :param top: Represents the vertical  offset of shape from the worksheet\'s top row, in unit of pixel.
        :param left: Represents the horizontal offset of shape from the worksheet\'s left column, in unit of pixel.
        :param height: Represents the height of LineShape, in unit of pixel.
        :param width: Represents the width of LineShape, in unit of pixel.
        :param image_data: The image data,only applies for the picture.
        :param is_original_size: Whether the shape use original size if the shape is image.'''
        raise NotImplementedError()
    
    def add_arc(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.ArcShape:
        '''Adds a ArcShape to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of ArcShape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of ArcShape from its left column, in unit of pixel.
        :param height: Represents the height of ArcShape, in unit of pixel.
        :param width: Represents the width of ArcShape, in unit of pixel.
        :returns: A ArcShape object.'''
        raise NotImplementedError()
    
    def add_shape(self, type : aspose.cells.drawing.MsoDrawingType, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Adds a Shape to the worksheet.
        
        :param type: Mso drawing type.
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Shape from its left column, in unit of pixel.
        :param height: Represents the height of Shape, in unit of pixel.
        :param width: Represents the width of Shape, in unit of pixel.
        :returns: A Shape object.'''
        raise NotImplementedError()
    
    def add_auto_shape(self, type : aspose.cells.drawing.AutoShapeType, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Adds a AutoShape to the worksheet.
        
        :param type: Auto shape type.
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Shape from its left column, in unit of pixel.
        :param height: Represents the height of Shape, in unit of pixel.
        :param width: Represents the width of Shape, in unit of pixel.
        :returns: A Shape object.'''
        raise NotImplementedError()
    
    def add_auto_shape_in_chart(self, type : aspose.cells.drawing.AutoShapeType, top : int, left : int, height : int, width : int) -> aspose.cells.drawing.Shape:
        '''Adds a AutoShape to the chart.
        
        :param type: Auto shape type.
        :param top: Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.
        :param left: Represents the vertical offset of textbox from the upper left corner in units of 1/4000 of the chart area.
        :param height: Represents the height of textbox, in units of 1/4000 of the chart area.
        :param width: Represents the width of textbox, in units of 1/4000 of the chart area.
        :returns: Returns a shape object.'''
        raise NotImplementedError()
    
    def add_active_x_control(self, type : aspose.cells.drawing.activexcontrols.ControlType, top_row : int, top : int, left_column : int, left : int, width : int, height : int) -> aspose.cells.drawing.Shape:
        '''Creates an Activex Control.
        
        :param type: The type of the control.
        :param top_row: Upper left row index.
        :param top: Represents the vertical  offset of Shape from its left row, in unit of pixel.
        :param left_column: Upper left column index.
        :param left: Represents the horizontal offset of Shape from its left column, in unit of pixel.
        :param height: Represents the height of Shape, in unit of pixel.
        :param width: Represents the width of Shape, in unit of pixel.'''
        raise NotImplementedError()
    
    def add_svg(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int, svg_data : List[int], compatible_image_data : List[int]) -> aspose.cells.drawing.Picture:
        '''Adds svg image.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: The horizontal offset of shape from its left column, in unit of pixel.
        :param height: The height of shape, in unit of pixel.
        :param width: The width of shape, in unit of pixel.
        :param svg_data: The svg image data.
        :param compatible_image_data: Converted image data from svg in order to be compatible with Excel 2016 or lower versions.'''
        raise NotImplementedError()
    
    def add_icons(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int, image_byte_data : List[int], compatible_image_data : List[int]) -> aspose.cells.drawing.Picture:
        '''Adds svg image.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical offset of shape from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: The horizontal offset of shape from its left column, in unit of pixel.
        :param height: The height of shape, in unit of pixel.
        :param width: The width of shape, in unit of pixel.
        :param image_byte_data: The image byte data.
        :param compatible_image_data: Converted image data from svg in order to be compatible with Excel 2016 or lower versions.'''
        raise NotImplementedError()
    
    def add_linked_picture(self, upper_left_row : int, upper_left_column : int, height : int, width : int, source_full_name : str) -> aspose.cells.drawing.Picture:
        '''Add a linked picture.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param height: The height of the shape. In unit of pixels
        :param width: The width of the shape. In unit of pixels
        :param source_full_name: The path and name of the source file for the linked image
        :returns: :py:class:`aspose.cells.drawing.Picture` Picture object.'''
        raise NotImplementedError()
    
    def add_ole_object_with_linked_image(self, upper_left_row : int, upper_left_column : int, height : int, width : int, source_full_name : str) -> aspose.cells.drawing.OleObject:
        '''Add a linked picture.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param height: The height of the shape. In unit of pixels
        :param width: The width of the shape. In unit of pixels
        :param source_full_name: The path and name of the source file for the linked image
        :returns: :py:class:`aspose.cells.drawing.Picture` Picture object.'''
        raise NotImplementedError()
    
    def add_picture_in_chart(self, top : int, left : int, stream : io._IOBase, width_scale : int, height_scale : int) -> aspose.cells.drawing.Picture:
        '''Adds a picture to the chart.
        
        :param top: Represents the vertical offset of shape from the upper left corner in units of 1/4000 of the chart area.
        :param left: Represents the horizontal offset of shape from the upper left corner in units of 1/4000 of the chart area.
        :param stream: Stream object which contains the image data.
        :param width_scale: Scale of image width, a percentage.
        :param height_scale: Scale of image height, a percentage.
        :returns: Returns a Picture object.'''
        raise NotImplementedError()
    
    def add_ole_object(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int, image_data : List[int]) -> aspose.cells.drawing.OleObject:
        '''Adds an OleObject.'''
        raise NotImplementedError()
    
    def copy_comments_in_range(self, shapes : aspose.cells.drawing.ShapeCollection, ca : aspose.cells.CellArea, dest_row : int, dest_column : int) -> None:
        '''Copy all comments in the range.
        
        :param shapes: The source shapes.
        :param ca: The source range.
        :param dest_row: The dest range start row.
        :param dest_column: The dest range start column.'''
        raise NotImplementedError()
    
    def copy_in_range(self, source_shapes : aspose.cells.drawing.ShapeCollection, ca : aspose.cells.CellArea, dest_row : int, dest_column : int, is_contained : bool) -> None:
        '''Copy shapes in the range to destination range.
        
        :param source_shapes: Source shapes.
        :param ca: The source range.
        :param dest_row: The dest row index of the dest range.
        :param dest_column: The dest column of the dest range.
        :param is_contained: Whether only copy the shapes which are contained in the range.
        If true,only copies the shapes in the range.
        Otherwise,it works as MS Office.'''
        raise NotImplementedError()
    
    def delete_in_range(self, ca : aspose.cells.CellArea) -> None:
        '''Delete shapes in the range.Comment shapes will not be deleted.
        
        :param ca: The range.If the shapes are contained in the range, they will be removed.'''
        raise NotImplementedError()
    
    def delete_shape(self, shape : aspose.cells.drawing.Shape) -> None:
        '''Delete a shape. If the shape is in the group or is a comment shape, it will not be deleted.'''
        raise NotImplementedError()
    
    def group(self, group_items : List[aspose.cells.drawing.Shape]) -> aspose.cells.drawing.GroupShape:
        '''Group the shapes.
        
        :param group_items: the group items.
        :returns: Return the group shape.'''
        raise NotImplementedError()
    
    def ungroup(self, group : aspose.cells.drawing.GroupShape) -> None:
        '''Ungroups the shape items.
        
        :param group: The group shape.'''
        raise NotImplementedError()
    
    def remove_a_shape(self, shape : aspose.cells.drawing.Shape) -> None:
        '''Add API for Python Via .Net.since this API is unsupported'''
        raise NotImplementedError()
    
    def update_selected_value(self) -> None:
        '''Update the selected value by the value of the linked cell or range of the shape.'''
        raise NotImplementedError()
    
    def add_freeform(self, upper_left_row : int, top : int, upper_left_column : int, left : int, height : int, width : int, paths : List[aspose.cells.drawing.ShapePath]) -> aspose.cells.drawing.Shape:
        '''Adds a freeform shape to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param top: Represents the vertical  offset of Polygon from its left row, in unit of pixel.
        :param upper_left_column: Upper left column index.
        :param left: Represents the horizontal offset of Polygon from its left column, in unit of pixel.
        :param height: Represents the height of Polygon, in unit of pixel.
        :param width: Represents the width of Polygon, in unit of pixel.
        :param paths: Represents a user-defined path
        :returns: A freeform shape.'''
        raise NotImplementedError()
    
    def add_signature_line(self, upper_left_row : int, upper_left_column : int, signature_line : aspose.cells.drawing.SignatureLine) -> aspose.cells.drawing.Picture:
        '''Adds a Signature Line to the worksheet.
        
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param signature_line: Represents a signature line object.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.Shape) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ShapeGuide(BaseShapeGuide):
    '''Encapsulates a shape guide specifies the presence of a shape guide that will be used to
    govern the geometry of the specified shape'''
    
    @property
    def value(self) -> float:
        '''Gets value of this guide'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : float) -> None:
        '''Sets value of this guide'''
        raise NotImplementedError()
    

class ShapeGuideCollection:
    '''Encapsulates a collection of shape guide'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.ShapeGuide]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.ShapeGuide], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapeGuide, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapeGuide, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapeGuide) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapeGuide, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapeGuide, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, name : str, val : float) -> int:
        '''Adds a shape guide.(Important: This feature is currently only available for Excel07 and above)
        
        :param name: the name of adjust. It\'s as "adj(Used when there is only one adjustment value)", "adj1", "adj2", "adj3" and so on.
        :param val: the value of adjust'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.ShapeGuide) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ShapePath:
    '''Represents a creation path consisting of a series of moves, lines and curves that when combined will form a geometric shape.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.cells.drawing.ShapePath` class.'''
        raise NotImplementedError()
    
    def move_to(self, x : float, y : float) -> None:
        '''Starts a new figure from the specified point without closing the current figure. All subsequent points added to the path are added to this new figure.
        
        :param x: The x-coordinate of the starting point of the figure.
        :param y: The y-coordinate of the starting point of the figure.'''
        raise NotImplementedError()
    
    def line_to(self, x : float, y : float) -> None:
        '''Appends a line segment to the current figure. The starting point is the end point of the current figure.
        
        :param x: The x-coordinate of the endpoint of the line segment.
        :param y: The y-coordinate of the endpoint of the line segment.'''
        raise NotImplementedError()
    
    def cubic_bezier_to(self, ctr_x1 : float, ctr_y1 : float, ctr_x2 : float, ctr_y2 : float, end_x : float, end_y : float) -> None:
        '''Appends a cubic Bézier curve to the current figure. The starting point is the end point of the current figure.
        
        :param ctr_x1: The x-coordinate of the first control point for the curve.
        :param ctr_y1: The y-coordinate of the first control point for the curve.
        :param ctr_x2: The x-coordinate of the second control point for the curve.
        :param ctr_y2: The y-coordinate of the second control point for the curve.
        :param end_x: The x-coordinate of the endpoint of the curve.
        :param end_y: The y-coordinate of the endpoint of the curve.'''
        raise NotImplementedError()
    
    def arc_to(self, w_r : float, h_r : float, st_ang : float, sw_ang : float) -> None:
        '''Appends an elliptical arc to the current figure. The starting point is the end point of the current figure.
        
        :param w_r: The half-width of the rectangular area of ​​the ellipse that draws the arc.
        :param h_r: The half-height of the rectangular area of ​​the ellipse that draws the arc.
        :param st_ang: The starting angle of the arc, measured in degrees clockwise from the x-axis.
        :param sw_ang: The angle between startAngle and the end of the arc.'''
        raise NotImplementedError()
    
    def close(self) -> None:
        '''Closes the current figure and starts a new figure. If the current figure contains a sequence of connected lines and curves, the method closes the loop by connecting a line from the endpoint to the starting point.'''
        raise NotImplementedError()
    
    @property
    def path_segement_list(self) -> aspose.cells.drawing.ShapeSegmentPathCollection:
        '''Gets :py:class:`aspose.cells.drawing.ShapeSegmentPathCollection` list'''
        raise NotImplementedError()
    

class ShapePathCollection:
    '''Represents path collection information in NotPrimitive autoshape'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.ShapePath]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.ShapePath], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapePath, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapePath, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapePath) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapePath, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapePath, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self) -> int:
        '''Add a creation path.
        
        :returns: Returns :py:class:`aspose.cells.drawing.ShapePath` object.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.drawing.ShapePath) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ShapePathPoint:
    '''Represents an x-y coordinate within the path coordinate space.'''
    
    @property
    def x(self) -> int:
        '''Gets and sets x coordinate for this position coordinate.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets and sets x coordinate for this position coordinate.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets y coordinate for this position coordinate.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets y coordinate for this position coordinate.'''
        raise NotImplementedError()
    

class ShapePathPointCollection:
    '''Represents all shape path points.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.drawing.ShapePathPoint]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.drawing.ShapePathPoint], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapePathPoint, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.drawing.ShapePathPoint, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapePathPoint) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.drawing.ShapePathPoint, index : int) -> int