from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore
import vtkmodules.vtkRenderingHyperTreeGrid

class vtkArrayRenderer(vtkmodules.vtkRenderingCore.vtkMapper):
    class ElementShape(int): ...
    Line:'ElementShape'
    LineStrip:'ElementShape'
    Point:'ElementShape'
    Triangle:'ElementShape'
    TriangleFan:'ElementShape'
    TriangleStrip:'ElementShape'
    bounds:'getset_descriptor'
    fragment_shader_source:'getset_descriptor'
    has_opaque:'getset_descriptor'
    has_translucent:'getset_descriptor'
    vertex_shader_source:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddMod(self, className:str) -> None: ...
    def AddMods(self, classNames:Sequence[str]) -> None: ...
    def BindArrayToTexture(self, textureName:'vtkStringToken', array:'vtkDataArray', asScalars:bool=False) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetFragmentShaderSource(self) -> str: ...
    def GetHasOpaque(self) -> int: ...
    def GetHasTranslucent(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShader(self, shaderType:vtkShader.Type) -> 'vtkShader': ...
    def GetVertexShaderSource(self) -> str: ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArrayRenderer': ...
    def PrepareColormap(self, cmap:'vtkScalarsToColors'=...) -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RemoveAllMods(self) -> None: ...
    def RemoveMod(self, className:str) -> None: ...
    def Render(self, ren:'vtkRenderer', a:'vtkActor') -> None: ...
    def ResetModsToDefault(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArrayRenderer': ...
    def SetElementType(self, elementType:int) -> bool: ...
    def SetFragmentShaderSource(self, arg:str) -> None: ...
    def SetHasOpaque(self, _arg:int) -> None: ...
    def SetHasTranslucent(self, _arg:int) -> None: ...
    def SetNumberOfElements(self, numberOfElements:int) -> bool: ...
    def SetNumberOfInstances(self, numberOfInstances:int) -> bool: ...
    def SetVertexShaderSource(self, arg:str) -> None: ...

class vtkCameraPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    aspect_ratio_override:'getset_descriptor'
    delegate_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAspectRatioOverride(self) -> float: ...
    def GetDelegatePass(self) -> 'vtkRenderPass': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraPass': ...
    def SetAspectRatioOverride(self, _arg:float) -> None: ...
    def SetDelegatePass(self, delegatePass:'vtkRenderPass') -> None: ...

class vtkClearRGBPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    background:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBackground(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClearRGBPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClearRGBPass': ...
    @overload
    def SetBackground(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackground(self, _arg:Sequence[float]) -> None: ...

class vtkClearZPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    depth:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDepth(self) -> float: ...
    def GetDepthMaxValue(self) -> float: ...
    def GetDepthMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClearZPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClearZPass': ...
    def SetDepth(self, _arg:float) -> None: ...

class vtkDataTransferHelper(vtkmodules.vtkCommonCore.vtkObject):
    array:'getset_descriptor'
    context:'getset_descriptor'
    cpu_extent:'getset_descriptor'
    cpu_extent_is_valid:'getset_descriptor'
    gpu_extent:'getset_descriptor'
    gpu_extent_is_valid:'getset_descriptor'
    min_texture_dimension:'getset_descriptor'
    shader_supports_texture_int:'getset_descriptor'
    texture:'getset_descriptor'
    texture_extent:'getset_descriptor'
    texture_extent_is_valid:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Download(self) -> bool: ...
    def DownloadAsync1(self) -> bool: ...
    def DownloadAsync2(self) -> bool: ...
    def GetArray(self) -> 'vtkDataArray': ...
    def GetCPUExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetCPUExtentIsValid(self) -> bool: ...
    def GetContext(self) -> 'vtkRenderWindow': ...
    def GetExtentIsValid(self, extent:MutableSequence[int]) -> bool: ...
    def GetGPUExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetGPUExtentIsValid(self) -> bool: ...
    def GetMinTextureDimension(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShaderSupportsTextureInt(self) -> bool: ...
    def GetTexture(self) -> 'vtkTextureObject': ...
    def GetTextureExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetTextureExtentIsValid(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsSupported(renWin:'vtkRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataTransferHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataTransferHelper': ...
    def SetArray(self, array:'vtkDataArray') -> None: ...
    @overload
    def SetCPUExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetCPUExtent(self, _arg:Sequence[int]) -> None: ...
    def SetContext(self, context:'vtkRenderWindow') -> None: ...
    @overload
    def SetGPUExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetGPUExtent(self, _arg:Sequence[int]) -> None: ...
    def SetMinTextureDimension(self, _arg:int) -> None: ...
    def SetShaderSupportsTextureInt(self, value:bool) -> None: ...
    def SetTexture(self, texture:'vtkTextureObject') -> None: ...
    @overload
    def SetTextureExtent(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetTextureExtent(self, _arg:Sequence[int]) -> None: ...
    def Upload(self, components:int=0, componentList:MutableSequence[int]=...) -> bool: ...

class vtkDefaultPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDefaultPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDefaultPass': ...

class vtkOpenGLRenderPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    active_draw_buffers:'getset_descriptor'
    shader_stage_m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActiveDrawBuffers(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShaderStageMTime(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLRenderPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def PreReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    @staticmethod
    def RenderPasses() -> 'vtkInformationObjectBaseVectorKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRenderPass': ...
    def SetActiveDrawBuffers(self, _arg:int) -> None: ...
    def SetShaderParameters(self, program:'vtkShaderProgram', mapper:'vtkAbstractMapper', prop:'vtkProp', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...

class vtkImageProcessingPass(vtkOpenGLRenderPass):
    delegate_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDelegatePass(self) -> 'vtkRenderPass': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageProcessingPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageProcessingPass': ...
    def SetDelegatePass(self, delegatePass:'vtkRenderPass') -> None: ...

class vtkDepthImageProcessingPass(vtkImageProcessingPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDepthImageProcessingPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDepthImageProcessingPass': ...

class vtkDepthOfFieldPass(vtkDepthImageProcessingPass):
    automatic_focal_distance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutomaticFocalDistanceOff(self) -> None: ...
    def AutomaticFocalDistanceOn(self) -> None: ...
    def GetAutomaticFocalDistance(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDepthOfFieldPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDepthOfFieldPass': ...
    def SetAutomaticFocalDistance(self, _arg:bool) -> None: ...

class vtkDepthPeelingPass(vtkOpenGLRenderPass):
    depth_format:'getset_descriptor'
    maximum_number_of_peels:'getset_descriptor'
    occlusion_ratio:'getset_descriptor'
    opaque_rgba_texture:'getset_descriptor'
    opaque_z_texture:'getset_descriptor'
    translucent_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaximumNumberOfPeels(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOcclusionRatio(self) -> float: ...
    def GetOcclusionRatioMaxValue(self) -> float: ...
    def GetOcclusionRatioMinValue(self) -> float: ...
    def GetTranslucentPass(self) -> 'vtkRenderPass': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDepthPeelingPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDepthPeelingPass': ...
    def SetDepthFormat(self, _arg:int) -> None: ...
    def SetMaximumNumberOfPeels(self, _arg:int) -> None: ...
    def SetOcclusionRatio(self, _arg:float) -> None: ...
    def SetOpaqueRGBATexture(self, __a:'vtkTextureObject') -> None: ...
    def SetOpaqueZTexture(self, __a:'vtkTextureObject') -> None: ...
    def SetShaderParameters(self, program:'vtkShaderProgram', mapper:'vtkAbstractMapper', prop:'vtkProp', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetTranslucentPass(self, translucentPass:'vtkRenderPass') -> None: ...

class vtkDrawTexturedElements(object):
    class ElementShape(int): ...
    class PatchShape(int): ...
    AbstractPatches:'ElementShape'
    Line:'ElementShape'
    LineStrip:'ElementShape'
    PatchLine:'PatchShape'
    PatchQuadrilateral:'PatchShape'
    PatchTriangle:'PatchShape'
    Point:'ElementShape'
    Triangle:'ElementShape'
    TriangleFan:'ElementShape'
    TriangleStrip:'ElementShape'
    element_type:'getset_descriptor'
    glsl_mod_collection:'getset_descriptor'
    include_colormap:'getset_descriptor'
    number_of_elements:'getset_descriptor'
    number_of_instances:'getset_descriptor'
    patch_type:'getset_descriptor'
    shader_program:'getset_descriptor'
    def __init__(self) -> None: ...
    def AppendArrayToTexture(self, textureName:'vtkStringToken', array:'vtkDataArray', asScalars:bool=False) -> None: ...
    def BindArrayToTexture(self, textureName:'vtkStringToken', array:'vtkDataArray', asScalars:bool=False) -> None: ...
    def DrawInstancedElements(self, ren:'vtkRenderer', a:'vtkActor', mapper:'vtkMapper') -> None: ...
    def GetElementType(self) -> int: ...
    def GetGLSLModCollection(self) -> 'vtkCollection': ...
    def GetIncludeColormap(self) -> bool: ...
    def GetNumberOfElements(self) -> int: ...
    def GetNumberOfInstances(self) -> int: ...
    def GetPatchType(self) -> int: ...
    def GetShader(self, shaderType:vtkShader.Type) -> 'vtkShader': ...
    def GetShaderProgram(self) -> 'vtkShaderProgram': ...
    @staticmethod
    def PatchVertexCountFromPrimitive(element:int) -> int: ...
    def ReleaseResources(self, window:'vtkWindow') -> None: ...
    def SetElementType(self, elementType:int) -> bool: ...
    def SetIncludeColormap(self, includeColormap:bool) -> bool: ...
    def SetNumberOfElements(self, numberOfElements:int) -> bool: ...
    def SetNumberOfInstances(self, numberOfInstances:int) -> bool: ...
    def SetPatchType(self, patchType:int) -> bool: ...
    def UnbindArray(self, __a:'vtkStringToken') -> bool: ...

class vtkDualDepthPeelingPass(vtkDepthPeelingPass):
    shader_stage_m_time:'getset_descriptor'
    volumetric_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShaderStageMTime(self) -> int: ...
    def GetVolumetricPass(self) -> 'vtkRenderPass': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDualDepthPeelingPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def PreReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDualDepthPeelingPass': ...
    def SetShaderParameters(self, program:'vtkShaderProgram', mapper:'vtkAbstractMapper', prop:'vtkProp', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetVolumetricPass(self, volumetricPass:'vtkRenderPass') -> None: ...

class vtkDummyGPUInfoList(vtkmodules.vtkRenderingCore.vtkGPUInfoList):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDummyGPUInfoList': ...
    def Probe(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDummyGPUInfoList': ...

class vtkEDLShading(vtkDepthImageProcessingPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEDLShading': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEDLShading': ...

class vtkOpenGLRenderWindow(vtkmodules.vtkRenderingCore.vtkRenderWindow):
    class FrameBlitModes(int): ...
    BlitToCurrent:'FrameBlitModes'
    BlitToCurrentWithDepth:'FrameBlitModes'
    BlitToHardware:'FrameBlitModes'
    NoBlit:'FrameBlitModes'
    buffer_needs_resolving:'getset_descriptor'
    context_creation_time:'getset_descriptor'
    depth_buffer_size:'getset_descriptor'
    display_framebuffer:'getset_descriptor'
    frame_blit_mode:'getset_descriptor'
    framebuffer_flip_y:'getset_descriptor'
    global_maximum_number_of_multi_samples:'getset_descriptor'
    maximum_hardware_line_width:'getset_descriptor'
    noise_texture_unit:'getset_descriptor'
    open_gl_support_message:'getset_descriptor'
    render_buffer_target_depth_size:'getset_descriptor'
    render_framebuffer:'getset_descriptor'
    rendering_backend:'getset_descriptor'
    shader_cache:'getset_descriptor'
    state:'getset_descriptor'
    t_quad2dvbo:'getset_descriptor'
    texture_unit_manager:'getset_descriptor'
    using_srgb_color_space:'getset_descriptor'
    vbo_cache:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ActivateTexture(self, __a:'vtkTextureObject') -> None: ...
    @overload
    def BlitDisplayFramebuffer(self) -> None: ...
    @overload
    def BlitDisplayFramebuffer(self, right:int, srcX:int, srcY:int, srcWidth:int, srcHeight:int, destX:int, destY:int, destWidth:int, destHeight:int, bufferMode:int, interpolation:int) -> None: ...
    def BlitDisplayFramebufferColorAndDepth(self) -> None: ...
    @overload
    def BlitToRenderFramebuffer(self, includeDepth:bool) -> None: ...
    @overload
    def BlitToRenderFramebuffer(self, srcX:int, srcY:int, srcWidth:int, srcHeight:int, destX:int, destY:int, destWidth:int, destHeight:int, bufferMode:int, interpolation:int) -> None: ...
    def DeactivateTexture(self, __a:'vtkTextureObject') -> None: ...
    @overload
    def DrawPixels(self, x1:int, y1:int, x2:int, y2:int, numComponents:int, dataType:int, data:Pointer) -> None: ...
    @overload
    def DrawPixels(self, dstXmin:int, dstYmin:int, dstXmax:int, dstYmax:int, srcXmin:int, srcYmin:int, srcXmax:int, srcYmax:int, srcWidth:int, srcHeight:int, numComponents:int, dataType:int, data:Pointer) -> None: ...
    @overload
    def DrawPixels(self, srcWidth:int, srcHeight:int, numComponents:int, dataType:int, data:Pointer) -> None: ...
    def End(self) -> None: ...
    def Frame(self) -> None: ...
    def FramebufferFlipYOff(self) -> None: ...
    def FramebufferFlipYOn(self) -> None: ...
    def GetBufferNeedsResolving(self) -> bool: ...
    def GetColorBufferInternalFormat(self, attachmentPoint:int) -> int: ...
    def GetColorBufferSizes(self, rgba:MutableSequence[int]) -> int: ...
    def GetContextCreationTime(self) -> int: ...
    def GetDefaultTextureInternalFormat(self, vtktype:int, numComponents:int, needInteger:bool, needFloat:bool, needSRGB:bool) -> int: ...
    def GetDepthBufferSize(self) -> int: ...
    def GetDisplayFramebuffer(self) -> 'vtkOpenGLFramebufferObject': ...
    def GetFrameBlitMode(self) -> 'FrameBlitModes': ...
    def GetFrameBlitModeMaxValue(self) -> 'FrameBlitModes': ...
    def GetFrameBlitModeMinValue(self) -> 'FrameBlitModes': ...
    def GetFramebufferFlipY(self) -> bool: ...
    @staticmethod
    def GetGlobalMaximumNumberOfMultiSamples() -> int: ...
    def GetMaximumHardwareLineWidth(self) -> float: ...
    def GetNoiseTextureUnit(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpenGLSupportMessage(self) -> str: ...
    def GetOpenGLVersion(self, major:int, minor:int) -> None: ...
    @overload
    def GetPixelData(self, x:int, y:int, x2:int, y2:int, front:int, right:int) -> Pointer: ...
    @overload
    def GetPixelData(self, x:int, y:int, x2:int, y2:int, front:int, data:'vtkUnsignedCharArray', right:int) -> int: ...
    @overload
    def GetRGBACharPixelData(self, x:int, y:int, x2:int, y2:int, front:int, right:int=0) -> Pointer: ...
    @overload
    def GetRGBACharPixelData(self, x:int, y:int, x2:int, y2:int, front:int, data:'vtkUnsignedCharArray', right:int=0) -> int: ...
    @overload
    def GetRGBAPixelData(self, x:int, y:int, x2:int, y2:int, front:int, right:int=0) -> Pointer: ...
    @overload
    def GetRGBAPixelData(self, x:int, y:int, x2:int, y2:int, front:int, data:'vtkFloatArray', right:int=0) -> int: ...
    def GetRenderBufferTargetDepthSize(self) -> int: ...
    def GetRenderFramebuffer(self) -> 'vtkOpenGLFramebufferObject': ...
    def GetRenderingBackend(self) -> str: ...
    def GetShaderCache(self) -> 'vtkOpenGLShaderCache': ...
    def GetState(self) -> 'vtkOpenGLState': ...
    def GetTQuad2DVBO(self) -> 'vtkOpenGLBufferObject': ...
    def GetTextureUnitForTexture(self, __a:'vtkTextureObject') -> int: ...
    def GetTextureUnitManager(self) -> 'vtkTextureUnitManager': ...
    def GetUsingSRGBColorSpace(self) -> bool: ...
    def GetVBOCache(self) -> 'vtkOpenGLVertexBufferObjectCache': ...
    @overload
    def GetZbufferData(self, x1:int, y1:int, x2:int, y2:int) -> Pointer: ...
    @overload
    def GetZbufferData(self, x1:int, y1:int, x2:int, y2:int, z:MutableSequence[float]) -> int: ...
    @overload
    def GetZbufferData(self, x1:int, y1:int, x2:int, y2:int, buffer:'vtkFloatArray') -> int: ...
    def Initialize(self) -> None: ...
    def InitializeFromCurrentContext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsPointSpriteBugPresent(self) -> bool: ...
    def IsPrimIDBugPresent(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLRenderWindow': ...
    def OpenGLInit(self) -> None: ...
    def OpenGLInitContext(self) -> None: ...
    def OpenGLInitState(self) -> None: ...
    def PopContext(self) -> None: ...
    def PushContext(self) -> None: ...
    def RegisterGraphicsResources(self, cb:'vtkGenericOpenGLResourceFreeCallback') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def ReleaseRGBAPixelData(self, data:MutableSequence[float]) -> None: ...
    def Render(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRenderWindow': ...
    def SetFrameBlitMode(self, _arg:'FrameBlitModes') -> None: ...
    def SetFrameBlitModeToBlitToCurrent(self) -> None: ...
    def SetFrameBlitModeToBlitToCurrentWithDepth(self) -> None: ...
    def SetFrameBlitModeToBlitToHardware(self) -> None: ...
    def SetFrameBlitModeToNoBlit(self) -> None: ...
    def SetFramebufferFlipY(self, _arg:bool) -> None: ...
    @staticmethod
    def SetGlobalMaximumNumberOfMultiSamples(val:int) -> None: ...
    @overload
    def SetPixelData(self, x:int, y:int, x2:int, y2:int, data:MutableSequence[int], front:int, right:int) -> int: ...
    @overload
    def SetPixelData(self, x:int, y:int, x2:int, y2:int, data:'vtkUnsignedCharArray', front:int, right:int) -> int: ...
    @overload
    def SetRGBACharPixelData(self, x:int, y:int, x2:int, y2:int, data:MutableSequence[int], front:int, blend:int=0, right:int=0) -> int: ...
    @overload
    def SetRGBACharPixelData(self, x:int, y:int, x2:int, y2:int, data:'vtkUnsignedCharArray', front:int, blend:int=0, right:int=0) -> int: ...
    @overload
    def SetRGBAPixelData(self, x:int, y:int, x2:int, y2:int, data:MutableSequence[float], front:int, blend:int=0, right:int=0) -> int: ...
    @overload
    def SetRGBAPixelData(self, x:int, y:int, x2:int, y2:int, data:'vtkFloatArray', front:int, blend:int=0, right:int=0) -> int: ...
    def SetRenderBufferTargetDepthSize(self, _arg:int) -> None: ...
    def SetSwapControl(self, __a:int) -> bool: ...
    @overload
    def SetZbufferData(self, x1:int, y1:int, x2:int, y2:int, buffer:MutableSequence[float]) -> int: ...
    @overload
    def SetZbufferData(self, x1:int, y1:int, x2:int, y2:int, buffer:'vtkFloatArray') -> int: ...
    def Start(self) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    @overload
    def TextureDepthBlit(self, source:'vtkTextureObject') -> None: ...
    @overload
    def TextureDepthBlit(self, source:'vtkTextureObject', srcX:int, srcY:int, srcX2:int, srcY2:int) -> None: ...
    @overload
    def TextureDepthBlit(self, source:'vtkTextureObject', srcX:int, srcY:int, srcX2:int, srcY2:int, destX:int, destY:int, destX2:int, destY2:int) -> None: ...
    def UnregisterGraphicsResources(self, cb:'vtkGenericOpenGLResourceFreeCallback') -> None: ...
    def WaitForCompletion(self) -> None: ...

class vtkEGLRenderWindow(vtkOpenGLRenderWindow):
    display_id:'getset_descriptor'
    event_pending:'getset_descriptor'
    full_screen:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    next_window_id:'getset_descriptor'
    next_window_info:'getset_descriptor'
    number_of_devices:'getset_descriptor'
    own_window:'getset_descriptor'
    parent_id:'getset_descriptor'
    parent_info:'getset_descriptor'
    position:'getset_descriptor'
    screen_size:'getset_descriptor'
    show_window:'getset_descriptor'
    size:'getset_descriptor'
    stereo_capable_window:'getset_descriptor'
    window_id:'getset_descriptor'
    window_info:'getset_descriptor'
    window_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def GetEGLSurfaceSize(self, width:MutableSequence[int], height:MutableSequence[int]) -> None: ...
    def GetEventPending(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetNumberOfDevices(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOwnWindow(self) -> int: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    def IsPointSpriteBugPresent(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkEGLRenderWindow': ...
    def PrefFullScreen(self) -> None: ...
    def ReleaseCurrent(self) -> None: ...
    def Render(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEGLRenderWindow': ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, __a:str) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, __a:str) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    def SetShowWindow(self, __a:bool) -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetStereoCapableWindow(self, capable:int) -> None: ...
    def SetWindowId(self, window:Pointer) -> None: ...
    def SetWindowInfo(self, __a:str) -> None: ...
    def SetWindowName(self, __a:str) -> None: ...
    def ShowCursor(self) -> None: ...
    def WindowInitialize(self) -> None: ...
    def WindowRemap(self) -> None: ...

class vtkOpenGLTexture(vtkmodules.vtkRenderingCore.vtkTexture):
    is_depth_texture:'getset_descriptor'
    texture_object:'getset_descriptor'
    texture_type:'getset_descriptor'
    texture_unit:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CopyTexImage(self, x:int, y:int, width:int, height:int) -> None: ...
    def GetIsDepthTexture(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextureObject(self) -> 'vtkTextureObject': ...
    def GetTextureType(self) -> int: ...
    def GetTextureUnit(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslucent(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def NewInstance(self) -> 'vtkOpenGLTexture': ...
    def PostRender(self, __a:'vtkRenderer') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLTexture': ...
    def SetIsDepthTexture(self, _arg:int) -> None: ...
    def SetTextureObject(self, __a:'vtkTextureObject') -> None: ...
    def SetTextureType(self, _arg:int) -> None: ...

class vtkEquirectangularToCubeMapTexture(vtkOpenGLTexture):
    cube_map_size:'getset_descriptor'
    input_texture:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCubeMapSize(self) -> int: ...
    def GetInputTexture(self) -> 'vtkOpenGLTexture': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def NewInstance(self) -> 'vtkEquirectangularToCubeMapTexture': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEquirectangularToCubeMapTexture': ...
    def SetCubeMapSize(self, _arg:int) -> None: ...
    def SetInputTexture(self, texture:'vtkOpenGLTexture') -> None: ...

class vtkOpenGLPolyDataMapper(vtkmodules.vtkRenderingCore.vtkPolyDataMapper):
    class PrimitiveTypes(int): ...
    PrimitiveEnd:'PrimitiveTypes'
    PrimitiveLines:'PrimitiveTypes'
    PrimitivePoints:'PrimitiveTypes'
    PrimitiveStart:'PrimitiveTypes'
    PrimitiveTriStrips:'PrimitiveTypes'
    PrimitiveTris:'PrimitiveTypes'
    PrimitiveVertices:'PrimitiveTypes'
    populate_selection_settings:'getset_descriptor'
    supports_selection:'getset_descriptor'
    use_program_point_size:'getset_descriptor'
    vb_os:'getset_descriptor'
    vbo_shift_scale_method:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPopulateSelectionSettings(self) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseProgramPointSize(self) -> bool: ...
    def GetVBOs(self) -> 'vtkOpenGLVertexBufferObjectGroup': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapDataArrayToMultiTextureAttribute(self, tname:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def MapDataArrayToVertexAttribute(self, vertexAttributeName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def NewInstance(self) -> 'vtkOpenGLPolyDataMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllVertexAttributeMappings(self) -> None: ...
    def RemoveVertexAttributeMapping(self, vertexAttributeName:str) -> None: ...
    def RenderPiece(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPieceDraw(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPieceFinish(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPieceStart(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLPolyDataMapper': ...
    def SetPopulateSelectionSettings(self, v:int) -> None: ...
    def SetUseProgramPointSize(self, _arg:bool) -> None: ...
    def SetVBOShiftScaleMethod(self, method:int) -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...
    def UseProgramPointSizeOff(self) -> None: ...
    def UseProgramPointSizeOn(self) -> None: ...

class vtkFastLabeledDataMapper(vtkOpenGLPolyDataMapper):
    class TextAnchor(int): ...
    Center:'TextAnchor'
    LeftEdge:'TextAnchor'
    LowerEdge:'TextAnchor'
    LowerLeft:'TextAnchor'
    LowerRight:'TextAnchor'
    RightEdge:'TextAnchor'
    UpperEdge:'TextAnchor'
    UpperLeft:'TextAnchor'
    UpperRight:'TextAnchor'
    component_separator:'getset_descriptor'
    field_data_array:'getset_descriptor'
    field_data_name:'getset_descriptor'
    frame_colors_name:'getset_descriptor'
    input_data:'getset_descriptor'
    label_format:'getset_descriptor'
    label_mode:'getset_descriptor'
    label_text_property:'getset_descriptor'
    labeled_component:'getset_descriptor'
    m_time:'getset_descriptor'
    text_anchor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetComponentSeparator(self) -> str: ...
    def GetFieldDataArray(self) -> int: ...
    def GetFieldDataArrayMaxValue(self) -> int: ...
    def GetFieldDataArrayMinValue(self) -> int: ...
    def GetFieldDataName(self) -> str: ...
    def GetFrameColorsName(self) -> str: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelMode(self) -> int: ...
    @overload
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetLabelTextProperty(self, type:int) -> 'vtkTextProperty': ...
    def GetLabeledComponent(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextAnchor(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFastLabeledDataMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderPiece(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPieceFinish(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPieceStart(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFastLabeledDataMapper': ...
    def SetComponentSeparator(self, _arg:str) -> None: ...
    def SetFieldDataArray(self, _arg:int) -> None: ...
    def SetFieldDataName(self, _arg:str) -> None: ...
    def SetFrameColorsName(self, _arg:str) -> None: ...
    def SetInputData(self, __a:'vtkDataSet') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelMode(self, _arg:int) -> None: ...
    def SetLabelModeToLabelFieldData(self) -> None: ...
    def SetLabelModeToLabelIds(self) -> None: ...
    def SetLabelModeToLabelNormals(self) -> None: ...
    def SetLabelModeToLabelScalars(self) -> None: ...
    def SetLabelModeToLabelTCoords(self) -> None: ...
    def SetLabelModeToLabelTensors(self) -> None: ...
    def SetLabelModeToLabelVectors(self) -> None: ...
    @overload
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    @overload
    def SetLabelTextProperty(self, p:'vtkTextProperty', type:int) -> None: ...
    def SetLabeledComponent(self, _arg:int) -> None: ...
    def SetTextAnchor(self, _arg:int) -> None: ...

class vtkFourByteUnion(object):
    def __init__(self) -> None: ...

class vtkFramebufferPass(vtkDepthImageProcessingPass):
    color_format:'getset_descriptor'
    color_texture:'getset_descriptor'
    depth_format:'getset_descriptor'
    depth_texture:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColorTexture(self) -> 'vtkTextureObject': ...
    def GetDepthTexture(self) -> 'vtkTextureObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFramebufferPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFramebufferPass': ...
    def SetColorFormat(self, _arg:int) -> None: ...
    def SetDepthFormat(self, _arg:int) -> None: ...

class vtkGLSLModifierBase(vtkmodules.vtkCommonCore.vtkObject):
    primitive_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def GLSL_MODIFIERS() -> 'vtkInformationObjectBaseKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUpToDate(self, renderer:'vtkOpenGLRenderer', mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    def NewInstance(self) -> 'vtkGLSLModifierBase': ...
    def ReplaceShaderValues(self, renderer:'vtkOpenGLRenderer', vertexShader:str, tessControlShader:str, tessEvalShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLSLModifierBase': ...
    def SetPrimitiveType(self, primType:int) -> None: ...
    def SetShaderParameters(self, renderer:'vtkOpenGLRenderer', program:'vtkShaderProgram', mapper:'vtkAbstractMapper', actor:'vtkActor', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...

class vtkGLSLModCamera(vtkGLSLModifierBase):
    def __init__(self, **properties:Any) -> None: ...
    def DisableShiftScale(self) -> None: ...
    def EnableShiftScale(self, coordShiftAndScaleInUse:bool, ssMatrix:'vtkMatrix4x4') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUpToDate(self, renderer:'vtkOpenGLRenderer', mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    def NewInstance(self) -> 'vtkGLSLModCamera': ...
    def ReplaceShaderValues(self, renderer:'vtkOpenGLRenderer', vertexShader:str, tessControlShader:str, tessEvalShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLSLModCamera': ...
    def SetShaderParameters(self, renderer:'vtkOpenGLRenderer', program:'vtkShaderProgram', mapper:'vtkAbstractMapper', actor:'vtkActor', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...

class vtkGLSLModCoincidentTopology(vtkGLSLModifierBase):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUpToDate(self, renderer:'vtkOpenGLRenderer', mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    def NewInstance(self) -> 'vtkGLSLModCoincidentTopology': ...
    def ReplaceShaderValues(self, renderer:'vtkOpenGLRenderer', vertexShader:str, tessControlShader:str, tessEvalShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLSLModCoincidentTopology': ...
    def SetShaderParameters(self, renderer:'vtkOpenGLRenderer', program:'vtkShaderProgram', mapper:'vtkAbstractMapper', actor:'vtkActor', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...

class vtkGLSLModLight(vtkGLSLModifierBase):
    use_anisotropy:'getset_descriptor'
    use_clear_coat:'getset_descriptor'
    use_pbr_textures:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseAnisotropy(self) -> bool: ...
    def GetUseClearCoat(self) -> bool: ...
    def GetUsePBRTextures(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUpToDate(self, renderer:'vtkOpenGLRenderer', mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    def NewInstance(self) -> 'vtkGLSLModLight': ...
    def ReplaceShaderValues(self, renderer:'vtkOpenGLRenderer', vertexShader:str, tessControlShader:str, tessEvalShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLSLModLight': ...
    def SetShaderParameters(self, renderer:'vtkOpenGLRenderer', program:'vtkShaderProgram', mapper:'vtkAbstractMapper', actor:'vtkActor', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetUseAnisotropy(self, _arg:bool) -> None: ...
    def SetUseClearCoat(self, _arg:bool) -> None: ...
    def SetUsePBRTextures(self, _arg:bool) -> None: ...

class vtkGLSLModPixelDebugger(vtkGLSLModifierBase):
    substitution_json_file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUpToDate(self, renderer:'vtkOpenGLRenderer', mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    def NewInstance(self) -> 'vtkGLSLModPixelDebugger': ...
    def ReplaceShaderValues(self, renderer:'vtkOpenGLRenderer', vertexShader:str, tessControlShader:str, tessEvalShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', actor:'vtkActor') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGLSLModPixelDebugger': ...
    def SetShaderParameters(self, renderer:'vtkOpenGLRenderer', program:'vtkShaderProgram', mapper:'vtkAbstractMapper', actor:'vtkActor', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetSubstitutionJSONFileName(self, filename:str) -> None: ...

class vtkGLSLModifierFactory(object):
    @staticmethod
    def CreateAMod(modName:str) -> 'vtkGLSLModifierBase': ...

class vtkGaussianBlurPass(vtkImageProcessingPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGaussianBlurPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGaussianBlurPass': ...

class vtkGenericOpenGLRenderWindow(vtkOpenGLRenderWindow):
    back_left_buffer:'getset_descriptor'
    back_right_buffer:'getset_descriptor'
    current_cursor:'getset_descriptor'
    display_id:'getset_descriptor'
    event_pending:'getset_descriptor'
    force_maximum_hardware_line_width:'getset_descriptor'
    front_left_buffer:'getset_descriptor'
    front_right_buffer:'getset_descriptor'
    full_screen:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    is_current:'getset_descriptor'
    is_direct:'getset_descriptor'
    mapped:'getset_descriptor'
    maximum_hardware_line_width:'getset_descriptor'
    next_window_id:'getset_descriptor'
    next_window_info:'getset_descriptor'
    own_context:'getset_descriptor'
    parent_id:'getset_descriptor'
    parent_info:'getset_descriptor'
    ready_for_rendering:'getset_descriptor'
    screen_size:'getset_descriptor'
    supports_open_gl:'getset_descriptor'
    window_id:'getset_descriptor'
    window_info:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateAWindow(self) -> None: ...
    def DestroyWindow(self) -> None: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def GetEventPending(self) -> int: ...
    def GetForceMaximumHardwareLineWidth(self) -> float: ...
    def GetForceMaximumHardwareLineWidthMaxValue(self) -> float: ...
    def GetForceMaximumHardwareLineWidthMinValue(self) -> float: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetMaximumHardwareLineWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReadyForRendering(self) -> bool: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def HideCursor(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkGenericOpenGLRenderWindow': ...
    def OpenGLInit(self) -> None: ...
    def PopState(self) -> None: ...
    def PushState(self) -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericOpenGLRenderWindow': ...
    def SetBackLeftBuffer(self, __a:int) -> None: ...
    def SetBackRightBuffer(self, __a:int) -> None: ...
    def SetCurrentCursor(self, cShape:int) -> None: ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetForceMaximumHardwareLineWidth(self, _arg:float) -> None: ...
    def SetFrontLeftBuffer(self, __a:int) -> None: ...
    def SetFrontRightBuffer(self, __a:int) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetIsCurrent(self, newValue:bool) -> None: ...
    def SetIsDirect(self, newValue:int) -> None: ...
    def SetMapped(self, _arg:int) -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, __a:str) -> None: ...
    def SetOwnContext(self, __a:int) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, __a:str) -> None: ...
    def SetReadyForRendering(self, _arg:bool) -> None: ...
    @overload
    def SetScreenSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetScreenSize(self, _arg:Sequence[int]) -> None: ...
    def SetSupportsOpenGL(self, newValue:int) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, __a:str) -> None: ...
    def ShowCursor(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def WindowRemap(self) -> None: ...

class vtkHiddenLineRemovalPass(vtkOpenGLRenderPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHiddenLineRemovalPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHiddenLineRemovalPass': ...

class vtkLightingMapPass(vtkDefaultPass):
    class RenderMode(int): ...
    LUMINANCE:'RenderMode'
    NORMALS:'RenderMode'
    render_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderType(self) -> 'RenderMode': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightingMapPass': ...
    @staticmethod
    def RENDER_LUMINANCE() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def RENDER_NORMALS() -> 'vtkInformationIntegerKey': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightingMapPass': ...
    def SetRenderType(self, _arg:'RenderMode') -> None: ...

class vtkLightsPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightsPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightsPass': ...

class vtkOSOpenGLRenderWindow(vtkOpenGLRenderWindow):
    display_id:'getset_descriptor'
    event_pending:'getset_descriptor'
    full_screen:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    next_window_id:'getset_descriptor'
    next_window_info:'getset_descriptor'
    parent_id:'getset_descriptor'
    parent_info:'getset_descriptor'
    position:'getset_descriptor'
    screen_size:'getset_descriptor'
    size:'getset_descriptor'
    stereo_capable_window:'getset_descriptor'
    window_id:'getset_descriptor'
    window_info:'getset_descriptor'
    window_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def GetEventPending(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkOSOpenGLRenderWindow': ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOSOpenGLRenderWindow': ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetForceMakeCurrent(self) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, info:str) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, info:str) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetStereoCapableWindow(self, capable:int) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, info:str) -> None: ...
    def SetWindowName(self, __a:str) -> None: ...
    def ShowCursor(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def WindowInitialize(self) -> None: ...
    def WindowRemap(self) -> None: ...

class vtkOpaquePass(vtkDefaultPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpaquePass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpaquePass': ...

class vtkOpenGLActor(vtkmodules.vtkRenderingCore.vtkActor):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def GLDepthMaskOverride() -> 'vtkInformationIntegerKey': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLActor': ...
    def Render(self, ren:'vtkRenderer', mapper:'vtkMapper') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLActor': ...

class vtkOpenGLArrayTextureBufferAdapter(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, array:'vtkDataArray', asScalars:bool, integerTexture:MutableSequence[bool]=...) -> None: ...
    @overload
    def __init__(self, __a:'vtkOpenGLArrayTextureBufferAdapter') -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Upload(self, renderWindow:'vtkOpenGLRenderWindow', force:bool=False) -> None: ...

class vtkOpenGLBatchedPolyDataMapper(vtkOpenGLPolyDataMapper):
    m_time:'getset_descriptor'
    parent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearBatchElements(self) -> None: ...
    def ClearUnmarkedBatchElements(self) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLBatchedPolyDataMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def RenderPiece(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLBatchedPolyDataMapper': ...
    def SetParent(self, parent:'vtkCompositePolyDataMapper') -> None: ...
    def UnmarkBatchElements(self) -> None: ...

class vtkOpenGLBillboardTextActor3D(vtkmodules.vtkRenderingCore.vtkBillboardTextActor3D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLBillboardTextActor3D': ...
    def RenderTranslucentPolygonalGeometry(self, vp:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLBillboardTextActor3D': ...

class vtkOpenGLBufferObject(vtkmodules.vtkCommonCore.vtkObject):
    class ObjectType(int): ...
    class ObjectUsage(int): ...
    ArrayBuffer:'ObjectType'
    DynamicCopy:'ObjectUsage'
    DynamicDraw:'ObjectUsage'
    DynamicRead:'ObjectUsage'
    ElementArrayBuffer:'ObjectType'
    StaticCopy:'ObjectUsage'
    StaticDraw:'ObjectUsage'
    StaticRead:'ObjectUsage'
    StreamCopy:'ObjectUsage'
    StreamDraw:'ObjectUsage'
    StreamRead:'ObjectUsage'
    TextureBuffer:'ObjectType'
    error:'getset_descriptor'
    handle:'getset_descriptor'
    size:'getset_descriptor'
    type:'getset_descriptor'
    usage:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Allocate(self, size:int, type:'ObjectType', usage:'ObjectUsage') -> bool: ...
    def Bind(self) -> bool: ...
    def BindShaderStorage(self, index:int) -> bool: ...
    def FlagBufferAsDirty(self) -> None: ...
    def GenerateBuffer(self, type:'ObjectType') -> bool: ...
    def GetError(self) -> str: ...
    def GetHandle(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self) -> int: ...
    def GetType(self) -> 'ObjectType': ...
    def GetUsage(self) -> 'ObjectUsage': ...
    def IsA(self, type:str) -> int: ...
    def IsReady(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLBufferObject': ...
    def Release(self) -> bool: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLBufferObject': ...
    def SetType(self, value:'ObjectType') -> None: ...
    def SetUsage(self, value:'ObjectUsage') -> None: ...

class vtkOpenGLCamera(vtkmodules.vtkRenderingCore.vtkCamera):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCamera': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCamera': ...
    def UpdateViewport(self, ren:'vtkRenderer') -> None: ...

class vtkOpenGLCellToVTKCellMap(vtkmodules.vtkCommonCore.vtkObject):
    final_offset:'getset_descriptor'
    primitive_offsets:'getset_descriptor'
    size:'getset_descriptor'
    start_offset:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ConvertOpenGLCellIdToVTKCellId(self, pointPicking:bool, openGLId:int) -> int: ...
    def GetFinalOffset(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrimitiveOffsets(self) -> Pointer: ...
    def GetSize(self) -> int: ...
    def GetValue(self, i:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCellToVTKCellMap': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCellToVTKCellMap': ...
    def SetStartOffset(self, start:int) -> None: ...

class vtkOpenGLCompositePolyDataMapperDelegator(vtkmodules.vtkRenderingCore.vtkCompositePolyDataMapperDelegator):
    def __init__(self, **properties:Any) -> None: ...
    def ClearUnmarkedBatchElements(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLCompositePolyDataMapperDelegator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLCompositePolyDataMapperDelegator': ...
    def ShallowCopy(self, mapper:'vtkCompositePolyDataMapper') -> None: ...
    def UnmarkBatchElements(self) -> None: ...

class vtkOpenGLPolyDataMapper2D(vtkmodules.vtkRenderingCore.vtkPolyDataMapper2D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLPolyDataMapper2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLPolyDataMapper2D': ...

class vtkOpenGLES30PolyDataMapper2D(vtkOpenGLPolyDataMapper2D):
    class PrimitiveTypes(int): ...
    PrimitiveEnd:'PrimitiveTypes'
    PrimitiveLines:'PrimitiveTypes'
    PrimitivePoints:'PrimitiveTypes'
    PrimitiveStart:'PrimitiveTypes'
    PrimitiveTriStrips:'PrimitiveTypes'
    PrimitiveTris:'PrimitiveTypes'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLES30PolyDataMapper2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLES30PolyDataMapper2D': ...

class vtkOpenGLFXAAFilter(vtkmodules.vtkCommonCore.vtkObject):
    debug_option_value:'getset_descriptor'
    endpoint_search_iterations:'getset_descriptor'
    hard_contrast_threshold:'getset_descriptor'
    relative_contrast_threshold:'getset_descriptor'
    subpixel_blend_limit:'getset_descriptor'
    subpixel_contrast_threshold:'getset_descriptor'
    use_high_quality_endpoints:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Execute(self, ren:'vtkOpenGLRenderer') -> None: ...
    def GetDebugOptionValue(self) -> vtkFXAAOptions.DebugOption: ...
    def GetEndpointSearchIterations(self) -> int: ...
    def GetEndpointSearchIterationsMaxValue(self) -> int: ...
    def GetEndpointSearchIterationsMinValue(self) -> int: ...
    def GetHardContrastThreshold(self) -> float: ...
    def GetHardContrastThresholdMaxValue(self) -> float: ...
    def GetHardContrastThresholdMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeContrastThreshold(self) -> float: ...
    def GetRelativeContrastThresholdMaxValue(self) -> float: ...
    def GetRelativeContrastThresholdMinValue(self) -> float: ...
    def GetSubpixelBlendLimit(self) -> float: ...
    def GetSubpixelBlendLimitMaxValue(self) -> float: ...
    def GetSubpixelBlendLimitMinValue(self) -> float: ...
    def GetSubpixelContrastThreshold(self) -> float: ...
    def GetSubpixelContrastThresholdMaxValue(self) -> float: ...
    def GetSubpixelContrastThresholdMinValue(self) -> float: ...
    def GetUseHighQualityEndpoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLFXAAFilter': ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLFXAAFilter': ...
    def SetDebugOptionValue(self, opt:vtkFXAAOptions.DebugOption) -> None: ...
    def SetEndpointSearchIterations(self, _arg:int) -> None: ...
    def SetHardContrastThreshold(self, _arg:float) -> None: ...
    def SetRelativeContrastThreshold(self, _arg:float) -> None: ...
    def SetSubpixelBlendLimit(self, _arg:float) -> None: ...
    def SetSubpixelContrastThreshold(self, _arg:float) -> None: ...
    def SetUseHighQualityEndpoints(self, val:bool) -> None: ...
    def UpdateConfiguration(self, opts:'vtkFXAAOptions') -> None: ...
    def UseHighQualityEndpointsOff(self) -> None: ...
    def UseHighQualityEndpointsOn(self) -> None: ...

class vtkOpenGLFXAAPass(vtkImageProcessingPass):
    fxaa_options:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFXAAOptions(self) -> 'vtkFXAAOptions': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLFXAAPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLFXAAPass': ...
    def SetFXAAOptions(self, __a:'vtkFXAAOptions') -> None: ...

class vtkOpenGLFluidMapper(vtkmodules.vtkRenderingCore.vtkAbstractVolumeMapper):
    class FluidSurfaceFilterMethod(int): ...
    class FluidDisplayMode(int): ...
    BilateralGaussian:'FluidSurfaceFilterMethod'
    FilteredOpaqueSurface:'FluidDisplayMode'
    FilteredSurfaceNormal:'FluidDisplayMode'
    NarrowRange:'FluidSurfaceFilterMethod'
    NumDisplayModes:'FluidDisplayMode'
    NumFilterMethods:'FluidSurfaceFilterMethod'
    TransparentFluidVolume:'FluidDisplayMode'
    UnfilteredOpaqueSurface:'FluidDisplayMode'
    UnfilteredSurfaceNormal:'FluidDisplayMode'
    additional_reflection:'getset_descriptor'
    attenuation_color:'getset_descriptor'
    attenuation_scale:'getset_descriptor'
    bilateral_gaussian_filter_parameter:'getset_descriptor'
    display_mode:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    narrow_range_filter_parameters:'getset_descriptor'
    opaque_color:'getset_descriptor'
    particle_color_power:'getset_descriptor'
    particle_color_scale:'getset_descriptor'
    particle_radius:'getset_descriptor'
    refraction_scale:'getset_descriptor'
    refractive_index:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    surface_filter_method:'getset_descriptor'
    thickness_and_volume_color_filter_radius:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAdditionalReflection(self) -> float: ...
    def GetAttenuationColor(self) -> Tuple[float, float, float]: ...
    def GetAttenuationScale(self) -> float: ...
    def GetDisplayMode(self) -> vtkOpenGLFluidMapper.FluidDisplayMode: ...
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpaqueColor(self) -> Tuple[float, float, float]: ...
    def GetParticleColorPower(self) -> float: ...
    def GetParticleColorScale(self) -> float: ...
    def GetParticleRadius(self) -> float: ...
    def GetRefractionScale(self) -> float: ...
    def GetRefractiveIndex(self) -> float: ...
    def GetScalarVisibility(self) -> bool: ...
    def GetSurfaceFilterMethod(self) -> vtkOpenGLFluidMapper.FluidSurfaceFilterMethod: ...
    def GetThicknessAndVolumeColorFilterRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLFluidMapper': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLFluidMapper': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    def SetAdditionalReflection(self, _arg:float) -> None: ...
    @overload
    def SetAttenuationColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAttenuationColor(self, _arg:Sequence[float]) -> None: ...
    def SetAttenuationScale(self, _arg:float) -> None: ...
    def SetBilateralGaussianFilterParameter(self, sigmaDepth:float) -> None: ...
    def SetDisplayMode(self, _arg:vtkOpenGLFluidMapper.FluidDisplayMode) -> None: ...
    def SetInputData(self, in_:'vtkPolyData') -> None: ...
    def SetNarrowRangeFilterParameters(self, lambda_:float, mu:float) -> None: ...
    @overload
    def SetOpaqueColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOpaqueColor(self, _arg:Sequence[float]) -> None: ...
    def SetParticleColorPower(self, _arg:float) -> None: ...
    def SetParticleColorScale(self, _arg:float) -> None: ...
    def SetParticleRadius(self, _arg:float) -> None: ...
    def SetRefractionScale(self, _arg:float) -> None: ...
    def SetRefractiveIndex(self, _arg:float) -> None: ...
    def SetScalarVisibility(self, _arg:bool) -> None: ...
    def SetSurfaceFilterMethod(self, _arg:vtkOpenGLFluidMapper.FluidSurfaceFilterMethod) -> None: ...
    def SetThicknessAndVolumeColorFilterRadius(self, _arg:float) -> None: ...

class vtkOpenGLFramebufferObject(vtkmodules.vtkRenderingCore.vtkFrameBufferObjectBase):
    active_read_buffer:'getset_descriptor'
    both_mode:'getset_descriptor'
    context:'getset_descriptor'
    depth_attachment_as_texture_object:'getset_descriptor'
    draw_mode:'getset_descriptor'
    fbo_index:'getset_descriptor'
    maximum_number_of_active_targets:'getset_descriptor'
    maximum_number_of_render_targets:'getset_descriptor'
    multi_samples:'getset_descriptor'
    number_of_color_attachments:'getset_descriptor'
    read_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ActivateBuffer(self, id:int) -> None: ...
    def ActivateDrawBuffer(self, id:int) -> None: ...
    @overload
    def ActivateDrawBuffers(self, n:int) -> None: ...
    @overload
    def ActivateDrawBuffers(self, ids:MutableSequence[int], n:int) -> None: ...
    def ActivateReadBuffer(self, id:int) -> None: ...
    @overload
    def AddColorAttachment(self, attId:int, tex:'vtkTextureObject', zslice:int=0, format:int=0, mipmapLevel:int=0) -> None: ...
    @overload
    def AddColorAttachment(self, attId:int, tex:'vtkRenderbuffer') -> None: ...
    @overload
    def AddDepthAttachment(self) -> None: ...
    @overload
    def AddDepthAttachment(self, tex:'vtkTextureObject') -> None: ...
    @overload
    def AddDepthAttachment(self, tex:'vtkRenderbuffer') -> None: ...
    @overload
    def Bind(self) -> None: ...
    @overload
    def Bind(self, mode:int) -> None: ...
    @staticmethod
    def Blit(srcExt:Sequence[int], destExt:Sequence[int], bits:int, mapping:int) -> int: ...
    def CheckFrameBufferStatus(self, mode:int) -> int: ...
    def DeactivateDrawBuffers(self) -> None: ...
    def DeactivateReadBuffer(self) -> None: ...
    @overload
    def Download(self, extent:MutableSequence[int], vtkType:int, nComps:int, oglType:int, oglFormat:int) -> 'vtkPixelBufferObject': ...
    @overload
    @staticmethod
    def Download(extent:MutableSequence[int], vtkType:int, nComps:int, oglType:int, oglFormat:int, pbo:'vtkPixelBufferObject') -> None: ...
    def DownloadColor1(self, extent:MutableSequence[int], vtkType:int, channel:int) -> 'vtkPixelBufferObject': ...
    def DownloadColor3(self, extent:MutableSequence[int], vtkType:int) -> 'vtkPixelBufferObject': ...
    def DownloadColor4(self, extent:MutableSequence[int], vtkType:int) -> 'vtkPixelBufferObject': ...
    def DownloadDepth(self, extent:MutableSequence[int], vtkType:int) -> 'vtkPixelBufferObject': ...
    def GetActiveDrawBuffer(self, id:int) -> int: ...
    def GetActiveReadBuffer(self) -> int: ...
    @staticmethod
    def GetBothMode() -> int: ...
    def GetColorAttachmentAsTextureObject(self, num:int) -> 'vtkTextureObject': ...
    def GetContext(self) -> 'vtkOpenGLRenderWindow': ...
    def GetDepthAttachmentAsTextureObject(self) -> 'vtkTextureObject': ...
    @staticmethod
    def GetDrawMode() -> int: ...
    def GetFBOIndex(self) -> int: ...
    @overload
    def GetLastSize(self) -> Pointer: ...
    @overload
    def GetLastSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def GetLastSize(self, _arg:MutableSequence[int]) -> None: ...
    def GetMaximumNumberOfActiveTargets(self) -> int: ...
    def GetMaximumNumberOfRenderTargets(self) -> int: ...
    def GetMultiSamples(self) -> int: ...
    def GetNumberOfColorAttachments(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetReadMode() -> int: ...
    def InitializeViewport(self, width:int, height:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsSupported(__a:'vtkOpenGLRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLFramebufferObject': ...
    @overload
    def PopulateFramebuffer(self, width:int, height:int) -> bool: ...
    @overload
    def PopulateFramebuffer(self, width:int, height:int, useTextures:bool, numberOfColorAttachments:int, colorDataType:int, wantDepthAttachment:bool, depthBitplanes:int, multisamples:int, wantStencilAttachment:bool=False) -> bool: ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def RemoveColorAttachment(self, index:int) -> None: ...
    def RemoveColorAttachments(self, num:int) -> None: ...
    def RemoveDepthAttachment(self) -> None: ...
    def RenderQuad(self, minX:int, maxX:int, minY:int, maxY:int, program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    def Resize(self, width:int, height:int) -> None: ...
    @overload
    def RestorePreviousBindingsAndBuffers(self) -> None: ...
    @overload
    def RestorePreviousBindingsAndBuffers(self, mode:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLFramebufferObject': ...
    @overload
    def SaveCurrentBindingsAndBuffers(self) -> None: ...
    @overload
    def SaveCurrentBindingsAndBuffers(self, mode:int) -> None: ...
    def SetContext(self, context:'vtkRenderWindow') -> None: ...
    def Start(self, width:int, height:int) -> bool: ...
    def StartNonOrtho(self, width:int, height:int) -> bool: ...
    @overload
    def UnBind(self) -> None: ...
    @overload
    def UnBind(self, mode:int) -> None: ...

class vtkOpenGLGL2PSHelper(vtkmodules.vtkCommonCore.vtkObject):
    class State(int): ...
    Background:'State'
    Capture:'State'
    Inactive:'State'
    active_state:'getset_descriptor'
    instance:'getset_descriptor'
    line_stipple:'getset_descriptor'
    line_width:'getset_descriptor'
    point_size:'getset_descriptor'
    render_window:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Draw3DPath(self, path:'vtkPath', actorMatrix:'vtkMatrix4x4', rasterPos:MutableSequence[float], actorColor:MutableSequence[int], ren:'vtkRenderer', label:str=...) -> None: ...
    def DrawImage(self, image:'vtkImageData', pos:MutableSequence[float]) -> None: ...
    def DrawPath(self, path:'vtkPath', rasterPos:MutableSequence[float], windowPos:MutableSequence[float], rgba:MutableSequence[int], scale:MutableSequence[float]=..., rotateAngle:float=0.0, strokeWidth:float=-1, label:str=...) -> None: ...
    def DrawString(self, str:str, tprop:'vtkTextProperty', pos:MutableSequence[float], backgroundDepth:float, ren:'vtkRenderer') -> None: ...
    def GetActiveState(self) -> 'State': ...
    @staticmethod
    def GetInstance() -> 'vtkOpenGLGL2PSHelper': ...
    def GetLineStipple(self) -> int: ...
    def GetLineWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointSize(self) -> float: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLGL2PSHelper': ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', col:MutableSequence[int]) -> None: ...
    @overload
    def ProcessTransformFeedback(self, tfc:'vtkTransformFeedback', ren:'vtkRenderer', col:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLGL2PSHelper': ...
    @staticmethod
    def SetInstance(__a:'vtkOpenGLGL2PSHelper') -> None: ...
    def SetLineStipple(self, _arg:int) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...

class vtkOpenGLGlyph3DHelper(vtkOpenGLPolyDataMapper):
    lod_coloring:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GlyphRender(self, ren:'vtkRenderer', actor:'vtkActor', numPts:int, colors:MutableSequence[int], matrices:MutableSequence[float], normalMatrices:MutableSequence[float], pickIds:MutableSequence[int], pointMTime:int, culling:bool) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLGlyph3DHelper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLGlyph3DHelper': ...
    def SetLODColoring(self, val:bool) -> None: ...

class vtkOpenGLGlyph3DMapper(vtkmodules.vtkRenderingCore.vtkGlyph3DMapper):
    max_number_of_lod:'getset_descriptor'
    number_of_lod:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMaxNumberOfLOD(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLGlyph3DMapper': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', a:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLGlyph3DMapper': ...
    def SetLODDistanceAndTargetReduction(self, index:int, distance:float, targetReduction:float) -> None: ...
    def SetNumberOfLOD(self, nb:int) -> None: ...

class vtkOpenGLHardwareSelector(vtkmodules.vtkRenderingCore.vtkHardwareSelector):
    def __init__(self, **properties:Any) -> None: ...
    def BeginRenderProp(self) -> None: ...
    def BeginSelection(self) -> None: ...
    def EndRenderProp(self) -> None: ...
    def EndSelection(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLHardwareSelector': ...
    def RenderCompositeIndex(self, index:int) -> None: ...
    def RenderProcessId(self, processid:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLHardwareSelector': ...

class vtkOpenGLHelper(object):
    def __init__(self) -> None: ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...

class vtkOpenGLHyperTreeGridMapper(vtkmodules.vtkRenderingHyperTreeGrid.vtkHyperTreeGridMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLHyperTreeGridMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLHyperTreeGridMapper': ...

class vtkOpenGLImageAlgorithmCallback(object):
    def __init__(self) -> None: ...
    def InitializeShaderUniforms(self, __a:'vtkShaderProgram') -> None: ...
    def UpdateShaderUniforms(self, __a:'vtkShaderProgram', __b:int) -> None: ...

class vtkOpenGLImageAlgorithmHelper(vtkmodules.vtkCommonCore.vtkObject):
    render_window:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLImageAlgorithmHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLImageAlgorithmHelper': ...
    def SetRenderWindow(self, renWin:'vtkRenderWindow') -> None: ...

class vtkOpenGLImageMapper(vtkmodules.vtkRenderingCore.vtkImageMapper):
    def __init__(self, **properties:Any) -> None: ...
    def DrawPixels(self, viewport:'vtkViewport', width:int, height:int, numComponents:int, data:Pointer) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLImageMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderData(self, viewport:'vtkViewport', data:'vtkImageData', actor:'vtkActor2D') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLImageMapper': ...

class vtkOpenGLImageSliceMapper(vtkmodules.vtkRenderingCore.vtkImageSliceMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLImageSliceMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', prop:'vtkImageSlice') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLImageSliceMapper': ...

class vtkOpenGLIndexBufferObject(vtkOpenGLBufferObject):
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def AppendEdgeFlagIndexBuffer(indexArray:MutableSequence[int], cells:'vtkCellArray', vertexOffset:int, edgeflags:'vtkDataArray') -> None: ...
    @staticmethod
    def AppendLineIndexBuffer(indexArray:MutableSequence[int], cells:'vtkCellArray', vertexOffset:int) -> None: ...
    @staticmethod
    def AppendPointIndexBuffer(indexArray:MutableSequence[int], cells:'vtkCellArray', vertexOffset:int) -> None: ...
    @staticmethod
    def AppendStripIndexBuffer(indexArray:MutableSequence[int], cells:'vtkCellArray', vertexOffset:int, wireframeTriStrips:bool) -> None: ...
    @staticmethod
    def AppendTriangleLineIndexBuffer(indexArray:MutableSequence[int], cells:'vtkCellArray', vertexOffset:int) -> None: ...
    def CreateEdgeFlagIndexBuffer(self, cells:'vtkCellArray', edgeflags:'vtkDataArray') -> int: ...
    def CreateLineIndexBuffer(self, cells:'vtkCellArray') -> int: ...
    def CreatePointIndexBuffer(self, cells:'vtkCellArray') -> int: ...
    def CreateStripIndexBuffer(self, cells:'vtkCellArray', wireframeTriStrips:bool) -> int: ...
    def CreateTriangleLineIndexBuffer(self, cells:'vtkCellArray') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLIndexBufferObject': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLIndexBufferObject': ...

class vtkOpenGLInstanceCulling(vtkmodules.vtkCommonCore.vtkObject):
    color_lod:'getset_descriptor'
    helper:'getset_descriptor'
    number_of_lod:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddLOD(self, distance:float, targetReduction:float) -> None: ...
    def BuildCullingShaders(self, cache:'vtkOpenGLShaderCache', numInstances:int, withNormals:bool) -> None: ...
    def GetColorLOD(self) -> bool: ...
    def GetHelper(self) -> 'vtkOpenGLHelper': ...
    def GetLODBuffer(self, index:int) -> 'vtkOpenGLBufferObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLOD(self) -> int: ...
    def InitLOD(self, pd:'vtkPolyData') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLInstanceCulling': ...
    def RunCullingShaders(self, numInstances:int, matrixBuffer:'vtkOpenGLBufferObject', colorBuffer:'vtkOpenGLBufferObject', normalBuffer:'vtkOpenGLBufferObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLInstanceCulling': ...
    def SetColorLOD(self, _arg:bool) -> None: ...

class vtkOpenGLLabeledContourMapper(vtkmodules.vtkRenderingCore.vtkLabeledContourMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLLabeledContourMapper': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLLabeledContourMapper': ...

class vtkOpenGLLight(vtkmodules.vtkRenderingCore.vtkLight):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLLight': ...
    def Render(self, ren:'vtkRenderer', light_index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLLight': ...

class vtkOpenGLLowMemoryPolyDataMapper(vtkmodules.vtkRenderingCore.vtkPolyDataMapper):
    populate_selection_settings:'getset_descriptor'
    supports_selection:'getset_descriptor'
    vbo_shift_scale_method:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddMod(self, className:str) -> None: ...
    def AddMods(self, classNames:Sequence[str]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPopulateSelectionSettings(self) -> bool: ...
    def GetSupportsSelection(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapDataArrayToMultiTextureAttribute(self, tname:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def MapDataArrayToVertexAttribute(self, vertexAttributeName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def NewInstance(self) -> 'vtkOpenGLLowMemoryPolyDataMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllMods(self) -> None: ...
    def RemoveAllVertexAttributeMappings(self) -> None: ...
    def RemoveMod(self, className:str) -> None: ...
    def RemoveVertexAttributeMapping(self, vertexAttributeName:str) -> None: ...
    def RenderPiece(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    def RenderPieceDraw(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    def RenderPieceFinish(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    def RenderPieceStart(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    def ResetModsToDefault(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLLowMemoryPolyDataMapper': ...
    def SetPopulateSelectionSettings(self, v:bool) -> None: ...
    def SetVBOShiftScaleMethod(self, method:int) -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...

class vtkOpenGLLowMemoryBatchedPolyDataMapper(vtkOpenGLLowMemoryPolyDataMapper):
    m_time:'getset_descriptor'
    parent:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearBatchElements(self) -> None: ...
    def ClearUnmarkedBatchElements(self) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLLowMemoryBatchedPolyDataMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def RenderPiece(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLLowMemoryBatchedPolyDataMapper': ...
    def SetParent(self, parent:'vtkCompositePolyDataMapper') -> None: ...
    def UnmarkBatchElements(self) -> None: ...

class vtkOpenGLPointGaussianMapper(vtkmodules.vtkRenderingCore.vtkPointGaussianMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLPointGaussianMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLPointGaussianMapper': ...

class vtkOpenGLProperty(vtkmodules.vtkRenderingCore.vtkProperty):
    def __init__(self, **properties:Any) -> None: ...
    def BackfaceRender(self, a:'vtkActor', ren:'vtkRenderer') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLProperty': ...
    def PostRender(self, a:'vtkActor', r:'vtkRenderer') -> None: ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def Render(self, a:'vtkActor', ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLProperty': ...

class vtkOpenGLQuadHelper(object):
    def __init__(self, __a:'vtkOpenGLRenderWindow', vs:str, fs:str, gs:str, flipY:bool=False) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self) -> None: ...

class vtkOpenGLRenderTimer(object):
    elapsed_milliseconds:'getset_descriptor'
    elapsed_nanoseconds:'getset_descriptor'
    elapsed_seconds:'getset_descriptor'
    reusable_elapsed_seconds:'getset_descriptor'
    start_time:'getset_descriptor'
    stop_time:'getset_descriptor'
    def __init__(self) -> None: ...
    def GetElapsedMilliseconds(self) -> float: ...
    def GetElapsedNanoseconds(self) -> int: ...
    def GetElapsedSeconds(self) -> float: ...
    def GetReusableElapsedSeconds(self) -> float: ...
    def GetStartTime(self) -> int: ...
    def GetStopTime(self) -> int: ...
    @staticmethod
    def IsSupported() -> bool: ...
    def Ready(self) -> bool: ...
    def ReleaseGraphicsResources(self) -> None: ...
    def Reset(self) -> None: ...
    def ReusableStart(self) -> None: ...
    def ReusableStop(self) -> None: ...
    def Start(self) -> None: ...
    def Started(self) -> bool: ...
    def Stop(self) -> None: ...
    def Stopped(self) -> bool: ...

class vtkOpenGLRenderTimerLog(vtkmodules.vtkRenderingCore.vtkRenderTimerLog):
    logging_enabled:'getset_descriptor'
    min_timer_pool_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def FrameReady(self) -> bool: ...
    def GetLoggingEnabled(self) -> bool: ...
    def GetMinTimerPoolSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSupported(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkEndEvent(self) -> None: ...
    def MarkFrame(self) -> None: ...
    def MarkStartEvent(self, name:str) -> None: ...
    def NewInstance(self) -> 'vtkOpenGLRenderTimerLog': ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRenderTimerLog': ...
    def SetMinTimerPoolSize(self, _arg:int) -> None: ...

class vtkOpenGLRenderUtilities(vtkmodules.vtkCommonCore.vtkObject):
    full_screen_quad_fragment_shader_template:'getset_descriptor'
    full_screen_quad_geometry_shader:'getset_descriptor'
    full_screen_quad_vertex_shader:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def DrawFullScreenQuad() -> None: ...
    @staticmethod
    def GetFullScreenQuadFragmentShaderTemplate() -> str: ...
    @staticmethod
    def GetFullScreenQuadGeometryShader() -> str: ...
    @staticmethod
    def GetFullScreenQuadVertexShader() -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MarkDebugEvent(event:str) -> None: ...
    def NewInstance(self) -> 'vtkOpenGLRenderUtilities': ...
    @overload
    @staticmethod
    def PrepFullScreenVAO(renWin:'vtkOpenGLRenderWindow', vao:'vtkOpenGLVertexArrayObject', prog:'vtkShaderProgram') -> bool: ...
    @overload
    @staticmethod
    def PrepFullScreenVAO(vertBuf:'vtkOpenGLBufferObject', vao:'vtkOpenGLVertexArrayObject', prog:'vtkShaderProgram') -> bool: ...
    @staticmethod
    def RenderQuad(verts:MutableSequence[float], tcoords:MutableSequence[float], program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRenderUtilities': ...

class vtkOpenGLRenderer(vtkmodules.vtkRenderingCore.vtkRenderer):
    class LightingComplexityEnum(int): ...
    Directional:'LightingComplexityEnum'
    Headlight:'LightingComplexityEnum'
    NoLighting:'LightingComplexityEnum'
    Positional:'LightingComplexityEnum'
    depth_peeling_higher_layer:'getset_descriptor'
    env_map_irradiance:'getset_descriptor'
    env_map_lookup_table:'getset_descriptor'
    env_map_prefiltered:'getset_descriptor'
    lighting_complexity:'getset_descriptor'
    lighting_count:'getset_descriptor'
    lighting_uniforms:'getset_descriptor'
    spherical_harmonics:'getset_descriptor'
    state:'getset_descriptor'
    use_spherical_harmonics:'getset_descriptor'
    user_light_transform:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Clear(self) -> None: ...
    def DeviceRender(self) -> None: ...
    def DeviceRenderOpaqueGeometry(self, fbo:'vtkFrameBufferObjectBase'=...) -> None: ...
    def DeviceRenderTranslucentPolygonalGeometry(self, fbo:'vtkFrameBufferObjectBase'=...) -> None: ...
    def GetDepthPeelingHigherLayer(self) -> int: ...
    def GetEnvMapIrradiance(self) -> 'vtkPBRIrradianceTexture': ...
    def GetEnvMapLookupTable(self) -> 'vtkPBRLUTTexture': ...
    def GetEnvMapPrefiltered(self) -> 'vtkPBRPrefilterTexture': ...
    def GetLightingComplexity(self) -> int: ...
    def GetLightingCount(self) -> int: ...
    def GetLightingUniforms(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSphericalHarmonics(self) -> 'vtkFloatArray': ...
    def GetState(self) -> 'vtkOpenGLState': ...
    def GetUseSphericalHarmonics(self) -> bool: ...
    def GetUserLightTransform(self) -> 'vtkTransform': ...
    @staticmethod
    def HaveAppleQueryAllocationBug() -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsDualDepthPeelingSupported(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLRenderer': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLRenderer': ...
    def SetEnvMapIrradiance(self, _arg:'vtkPBRIrradianceTexture') -> None: ...
    def SetEnvMapLookupTable(self, _arg:'vtkPBRLUTTexture') -> None: ...
    def SetEnvMapPrefiltered(self, _arg:'vtkPBRPrefilterTexture') -> None: ...
    def SetEnvironmentTexture(self, texture:'vtkTexture', isSRGB:bool=False) -> None: ...
    def SetUseSphericalHarmonics(self, _arg:bool) -> None: ...
    def SetUserLightTransform(self, transform:'vtkTransform') -> None: ...
    def UpdateLightingUniforms(self, prog:'vtkShaderProgram') -> None: ...
    def UpdateLights(self) -> int: ...
    def UseSphericalHarmonicsOff(self) -> None: ...
    def UseSphericalHarmonicsOn(self) -> None: ...

class vtkOpenGLShaderCache(vtkmodules.vtkCommonCore.vtkObject):
    elapsed_time:'getset_descriptor'
    last_shader_bound:'getset_descriptor'
    sync_glsl_shader_version:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearLastShaderBound(self) -> None: ...
    def GetLastShaderBound(self) -> 'vtkShaderProgram': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSyncGLSLShaderVersion(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLShaderCache': ...
    @overload
    def ReadyShaderProgram(self, vertexCode:str, fragmentCode:str, geometryCode:str, cap:'vtkTransformFeedback'=...) -> 'vtkShaderProgram': ...
    @overload
    def ReadyShaderProgram(self, vertexCode:str, fragmentCode:str, geometryCode:str, tessControlCode:str, tessEvalCode:str, cap:'vtkTransformFeedback'=...) -> 'vtkShaderProgram': ...
    @overload
    def ReadyShaderProgram(self, shader:'vtkShaderProgram', cap:'vtkTransformFeedback'=...) -> 'vtkShaderProgram': ...
    def ReleaseCurrentShader(self) -> None: ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLShaderCache': ...
    def SetElapsedTime(self, val:float) -> None: ...
    def SetSyncGLSLShaderVersion(self, _arg:bool) -> None: ...
    def SyncGLSLShaderVersionOff(self) -> None: ...
    def SyncGLSLShaderVersionOn(self) -> None: ...

class vtkOpenGLShaderProperty(vtkmodules.vtkRenderingCore.vtkShaderProperty):
    number_of_shader_replacements:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddShaderReplacement(self, shaderType:vtkShader.Type, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddTessControlShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddTessEvaluationShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddVertexShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def ClearAllFragmentShaderReplacements(self) -> None: ...
    def ClearAllGeometryShaderReplacements(self) -> None: ...
    @overload
    def ClearAllShaderReplacements(self) -> None: ...
    @overload
    def ClearAllShaderReplacements(self, shaderType:vtkShader.Type) -> None: ...
    def ClearAllTessControlShaderReplacements(self) -> None: ...
    def ClearAllTessEvalShaderReplacements(self) -> None: ...
    def ClearAllVertexShaderReplacements(self) -> None: ...
    def ClearFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearShaderReplacement(self, shaderType:vtkShader.Type, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearTessControlShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearTessEvaluationShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearVertexShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def DeepCopy(self, p:'vtkOpenGLShaderProperty') -> None: ...
    def GetNthShaderReplacement(self, index:int, name:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def GetNthShaderReplacementTypeAsString(self, index:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfShaderReplacements(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLShaderProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLShaderProperty': ...

class vtkOpenGLSkybox(vtkmodules.vtkRenderingCore.vtkSkybox):
    mapper:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLSkybox': ...
    def Render(self, ren:'vtkRenderer', mapper:'vtkMapper') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLSkybox': ...
    def SetMapper(self, mapper:'vtkMapper') -> None: ...

class vtkOpenGLSphereMapper(vtkOpenGLPolyDataMapper):
    radius:'getset_descriptor'
    scale_array:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLSphereMapper': ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLSphereMapper': ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetScaleArray(self, _arg:str) -> None: ...

class vtkOpenGLState(vtkmodules.vtkCommonCore.vtkObject):
    renderer:'getset_descriptor'
    shader_cache:'getset_descriptor'
    texture_unit_manager:'getset_descriptor'
    vbo_cache:'getset_descriptor'
    vendor:'getset_descriptor'
    version:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ActivateTexture(self, __a:'vtkTextureObject') -> None: ...
    def DeactivateTexture(self, __a:'vtkTextureObject') -> None: ...
    def GetBlendFuncState(self, __a:MutableSequence[int]) -> None: ...
    def GetCurrentDrawFramebufferState(self, drawBinding:int, drawBuffer:int) -> None: ...
    def GetDefaultTextureInternalFormat(self, vtktype:int, numComponents:int, needInteger:bool, needFloat:bool, needSRGB:bool) -> int: ...
    def GetEnumState(self, name:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> str: ...
    def GetShaderCache(self) -> 'vtkOpenGLShaderCache': ...
    def GetTextureUnitForTexture(self, __a:'vtkTextureObject') -> int: ...
    def GetTextureUnitManager(self) -> 'vtkTextureUnitManager': ...
    def GetVBOCache(self) -> 'vtkOpenGLVertexBufferObjectCache': ...
    def GetVendor(self) -> str: ...
    def GetVersion(self) -> str: ...
    def Initialize(self, __a:'vtkOpenGLRenderWindow') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLState': ...
    def Pop(self) -> None: ...
    def PopDrawFramebufferBinding(self) -> None: ...
    def PopFramebufferBindings(self) -> None: ...
    def PopReadFramebufferBinding(self) -> None: ...
    def Push(self) -> None: ...
    def PushDrawFramebufferBinding(self) -> None: ...
    def PushFramebufferBindings(self) -> None: ...
    def PushReadFramebufferBinding(self) -> None: ...
    def Reset(self) -> None: ...
    def ResetEnumState(self, name:int) -> None: ...
    def ResetFramebufferBindings(self) -> None: ...
    def ResetGLActiveTexture(self) -> None: ...
    def ResetGLBlendEquationState(self) -> None: ...
    def ResetGLBlendFuncState(self) -> None: ...
    def ResetGLClearColorState(self) -> None: ...
    def ResetGLClearDepthState(self) -> None: ...
    def ResetGLColorMaskState(self) -> None: ...
    def ResetGLCullFaceState(self) -> None: ...
    def ResetGLDepthFuncState(self) -> None: ...
    def ResetGLDepthMaskState(self) -> None: ...
    def ResetGLScissorState(self) -> None: ...
    def ResetGLViewportState(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLState': ...
    def SetEnumState(self, name:int, value:bool) -> None: ...
    def SetTextureUnitManager(self, textureUnitManager:'vtkTextureUnitManager') -> None: ...
    def SetVBOCache(self, val:'vtkOpenGLVertexBufferObjectCache') -> None: ...
    def VerifyNoActiveTextures(self) -> None: ...
    def vtkBindFramebuffer(self, target:int, fo:'vtkOpenGLFramebufferObject') -> None: ...
    def vtkDrawBuffers(self, n:int, __b:MutableSequence[int], __c:'vtkOpenGLFramebufferObject') -> None: ...
    def vtkReadBuffer(self, __a:int, __b:'vtkOpenGLFramebufferObject') -> None: ...
    def vtkglActiveTexture(self, __a:int) -> None: ...
    def vtkglBindFramebuffer(self, target:int, fb:int) -> None: ...
    def vtkglBlendEquation(self, val:int) -> None: ...
    def vtkglBlendEquationSeparate(self, col:int, alpha:int) -> None: ...
    def vtkglBlendFunc(self, sfactor:int, dfactor:int) -> None: ...
    def vtkglBlendFuncSeparate(self, sfactorRGB:int, dfactorRGB:int, sfactorAlpha:int, dfactorAlpha:int) -> None: ...
    def vtkglBlitFramebuffer(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int, __g:int, __h:int, __i:int, __j:int) -> None: ...
    def vtkglClear(self, mask:int) -> None: ...
    def vtkglClearColor(self, red:float, green:float, blue:float, alpha:float) -> None: ...
    def vtkglClearDepth(self, depth:float) -> None: ...
    def vtkglColorMask(self, r:int, g:int, b:int, a:int) -> None: ...
    def vtkglCullFace(self, val:int) -> None: ...
    def vtkglDepthFunc(self, val:int) -> None: ...
    def vtkglDepthMask(self, flag:int) -> None: ...
    def vtkglDisable(self, cap:int) -> None: ...
    def vtkglDrawBuffer(self, __a:int) -> None: ...
    def vtkglDrawBuffers(self, n:int, __b:MutableSequence[int]) -> None: ...
    def vtkglEnable(self, cap:int) -> None: ...
    def vtkglGetBooleanv(self, pname:int, params:MutableSequence[int]) -> None: ...
    def vtkglGetDoublev(self, pname:int, params:MutableSequence[float]) -> None: ...
    def vtkglGetFloatv(self, pname:int, params:MutableSequence[float]) -> None: ...
    def vtkglGetIntegerv(self, pname:int, params:MutableSequence[int]) -> None: ...
    def vtkglLineWidth(self, __a:float) -> None: ...
    def vtkglPixelStorei(self, __a:int, __b:int) -> None: ...
    def vtkglPointSize(self, __a:float) -> None: ...
    def vtkglReadBuffer(self, __a:int) -> None: ...
    def vtkglScissor(self, x:int, y:int, width:int, height:int) -> None: ...
    def vtkglStencilFunc(self, func:int, ref:int, mask:int) -> None: ...
    def vtkglStencilFuncSeparate(self, face:int, func:int, ref:int, mask:int) -> None: ...
    def vtkglStencilMask(self, mask:int) -> None: ...
    def vtkglStencilMaskSeparate(self, face:int, mask:int) -> None: ...
    def vtkglStencilOp(self, sfail:int, dpfail:int, dppass:int) -> None: ...
    def vtkglStencilOpSeparate(self, face:int, sfail:int, dpfail:int, dppass:int) -> None: ...
    def vtkglViewport(self, x:int, y:int, width:int, height:int) -> None: ...

class vtkOpenGLStickMapper(vtkOpenGLPolyDataMapper):
    orientation_array:'getset_descriptor'
    scale_array:'getset_descriptor'
    selection_id_array:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLStickMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLStickMapper': ...
    def SetOrientationArray(self, _arg:str) -> None: ...
    def SetScaleArray(self, _arg:str) -> None: ...
    def SetSelectionIdArray(self, _arg:str) -> None: ...

class vtkOpenGLTextActor(vtkmodules.vtkRenderingCore.vtkTextActor):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLTextActor': ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLTextActor': ...

class vtkOpenGLTextActor3D(vtkmodules.vtkRenderingCore.vtkTextActor3D):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLTextActor3D': ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLTextActor3D': ...

class vtkOpenGLTextMapper(vtkmodules.vtkRenderingCore.vtkTextMapper):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLTextMapper': ...
    def RenderOverlay(self, vp:'vtkViewport', act:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLTextMapper': ...

class vtkOpenGLUniforms(vtkmodules.vtkRenderingCore.vtkUniforms):
    declarations:'getset_descriptor'
    number_of_uniforms:'getset_descriptor'
    uniform_list_m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetDeclarations(self) -> str: ...
    def GetNthUniformName(self, uniformIndex:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfUniforms(self) -> int: ...
    @overload
    def GetUniform(self, name:str, value:MutableSequence[int]) -> bool: ...
    @overload
    def GetUniform(self, name:str, value:MutableSequence[float]) -> bool: ...
    def GetUniform1fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform1iv(self, name:str, f:MutableSequence[int]) -> bool: ...
    def GetUniform2f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform2fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform2i(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniform3f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform3fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform3uc(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniform4f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform4fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform4uc(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniformListMTime(self) -> int: ...
    @overload
    def GetUniformMatrix(self, name:str, v:'vtkMatrix3x3') -> bool: ...
    @overload
    def GetUniformMatrix(self, name:str, v:'vtkMatrix4x4') -> bool: ...
    def GetUniformMatrix3x3(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniformMatrix4x4(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniformMatrix4x4v(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniformNumberOfComponents(self, name:str) -> int: ...
    def GetUniformNumberOfTuples(self, name:str) -> int: ...
    def GetUniformScalarType(self, name:str) -> int: ...
    def GetUniformf(self, name:str, v:float) -> bool: ...
    def GetUniformi(self, name:str, v:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLUniforms': ...
    def RemoveAllUniforms(self) -> None: ...
    def RemoveUniform(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLUniforms': ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:Sequence[int]) -> None: ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:Sequence[float]) -> None: ...
    def SetUniform1fv(self, name:str, count:int, f:Sequence[float]) -> None: ...
    def SetUniform1iv(self, name:str, count:int, f:Sequence[int]) -> None: ...
    def SetUniform2f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform2i(self, name:str, v:Sequence[int]) -> None: ...
    def SetUniform3f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform3uc(self, name:str, v:Sequence[int]) -> None: ...
    def SetUniform4f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform4uc(self, name:str, v:Sequence[int]) -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix3x3') -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix4x4') -> None: ...
    def SetUniformMatrix3x3(self, name:str, v:MutableSequence[float]) -> None: ...
    def SetUniformMatrix4x4(self, name:str, v:MutableSequence[float]) -> None: ...
    def SetUniformMatrix4x4v(self, name:str, count:int, v:MutableSequence[float]) -> None: ...
    def SetUniformf(self, name:str, v:float) -> None: ...
    def SetUniformi(self, name:str, v:int) -> None: ...
    def SetUniforms(self, p:'vtkShaderProgram') -> bool: ...

class vtkOpenGLVertexArrayObject(vtkmodules.vtkCommonCore.vtkObject):
    force_emulation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def AddAttributeArray(self, program:'vtkShaderProgram', buffer:'vtkOpenGLBufferObject', name:str, offset:int, stride:int, elementType:int, elementTupleSize:int, normalize:bool) -> bool: ...
    @overload
    def AddAttributeArray(self, program:'vtkShaderProgram', buffer:'vtkOpenGLVertexBufferObject', name:str, offset:int, normalize:bool) -> bool: ...
    def AddAttributeArrayWithDivisor(self, program:'vtkShaderProgram', buffer:'vtkOpenGLBufferObject', name:str, offset:int, stride:int, elementType:int, elementTupleSize:int, normalize:bool, divisor:int, isMatrix:bool) -> bool: ...
    def AddAttributeMatrixWithDivisor(self, program:'vtkShaderProgram', buffer:'vtkOpenGLBufferObject', name:str, offset:int, stride:int, elementType:int, elementTupleSize:int, normalize:bool, divisor:int, tupleOffset:int) -> bool: ...
    def Bind(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLVertexArrayObject': ...
    def Release(self) -> None: ...
    def ReleaseGraphicsResources(self) -> None: ...
    def RemoveAttributeArray(self, name:str) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLVertexArrayObject': ...
    def SetForceEmulation(self, val:bool) -> None: ...
    def ShaderProgramChanged(self) -> None: ...

class vtkOpenGLVertexBufferObject(vtkOpenGLBufferObject):
    cache:'getset_descriptor'
    camera:'getset_descriptor'
    coord_shift_and_scale_enabled:'getset_descriptor'
    coord_shift_and_scale_method:'getset_descriptor'
    data_type:'getset_descriptor'
    data_type_size:'getset_descriptor'
    global_coord_shift_and_scale_enabled:'getset_descriptor'
    number_of_components:'getset_descriptor'
    number_of_tuples:'getset_descriptor'
    packed_vbo:'getset_descriptor'
    prop3d:'getset_descriptor'
    scale:'getset_descriptor'
    shift:'getset_descriptor'
    stride:'getset_descriptor'
    upload_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AppendDataArray(self, array:'vtkDataArray') -> None: ...
    def GetCoordShiftAndScaleEnabled(self) -> bool: ...
    def GetCoordShiftAndScaleMethod(self) -> int: ...
    def GetDataType(self) -> int: ...
    def GetDataTypeSize(self) -> int: ...
    @staticmethod
    def GetGlobalCoordShiftAndScaleEnabled() -> int: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def GetPackedVBO(self) -> Tuple[float, float]: ...
    def GetScale(self) -> Tuple[float, float]: ...
    def GetShift(self) -> Tuple[float, float]: ...
    def GetStride(self) -> int: ...
    def GetUploadTime(self) -> 'vtkTimeStamp': ...
    @staticmethod
    def GlobalCoordShiftAndScaleEnabledOff() -> None: ...
    @staticmethod
    def GlobalCoordShiftAndScaleEnabledOn() -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLVertexBufferObject': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLVertexBufferObject': ...
    def SetCache(self, cache:'vtkOpenGLVertexBufferObjectCache') -> None: ...
    def SetCamera(self, cam:'vtkCamera') -> None: ...
    def SetCoordShiftAndScaleMethod(self, meth:int) -> None: ...
    def SetDataType(self, v:int) -> None: ...
    @staticmethod
    def SetGlobalCoordShiftAndScaleEnabled(val:int) -> None: ...
    def SetProp3D(self, prop3d:'vtkProp3D') -> None: ...
    @overload
    def SetScale(self, scale:Sequence[float]) -> None: ...
    @overload
    def SetScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetShift(self, shift:Sequence[float]) -> None: ...
    @overload
    def SetShift(self, x:float, y:float, z:float) -> None: ...
    def SetStride(self, _arg:int) -> None: ...
    def UpdateShiftScale(self, da:'vtkDataArray') -> None: ...
    def UploadDataArray(self, array:'vtkDataArray') -> None: ...
    def UploadVBO(self) -> None: ...

class vtkOpenGLVertexBufferObjectCache(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVBO(self, array:'vtkDataArray', destType:int) -> 'vtkOpenGLVertexBufferObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLVertexBufferObjectCache': ...
    def RemoveVBO(self, vbo:'vtkOpenGLVertexBufferObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLVertexBufferObjectCache': ...

class vtkOpenGLVertexBufferObjectGroup(vtkmodules.vtkCommonCore.vtkObject):
    m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddAllAttributesToVAO(self, program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    def AppendDataArray(self, attribute:str, da:'vtkDataArray', destType:int) -> None: ...
    def ArrayExists(self, attribute:str, da:'vtkDataArray', offset:int, totalOffset:int) -> bool: ...
    @overload
    def BuildAllVBOs(self, __a:'vtkOpenGLVertexBufferObjectCache') -> None: ...
    @overload
    def BuildAllVBOs(self, __a:'vtkViewport') -> None: ...
    @overload
    def CacheDataArray(self, attribute:str, da:'vtkDataArray', cache:'vtkOpenGLVertexBufferObjectCache', destType:int) -> None: ...
    @overload
    def CacheDataArray(self, attribute:str, da:'vtkDataArray', vp:'vtkViewport', destType:int) -> None: ...
    def ClearAllDataArrays(self) -> None: ...
    def ClearAllVBOs(self) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfComponents(self, attribute:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self, attribute:str) -> int: ...
    def GetVBO(self, attribute:str) -> 'vtkOpenGLVertexBufferObject': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLVertexBufferObjectGroup': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAttribute(self, attribute:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLVertexBufferObjectGroup': ...

class vtkOrderIndependentTranslucentPass(vtkOpenGLRenderPass):
    translucent_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslucentPass(self) -> 'vtkRenderPass': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrderIndependentTranslucentPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrderIndependentTranslucentPass': ...
    def SetTranslucentPass(self, translucentPass:'vtkRenderPass') -> None: ...

class vtkOutlineGlowPass(vtkImageProcessingPass):
    outline_intensity:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineIntensity(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOutlineGlowPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOutlineGlowPass': ...
    def SetOutlineIntensity(self, _arg:float) -> None: ...

class vtkOverlayPass(vtkDefaultPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOverlayPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOverlayPass': ...

class vtkPBRIrradianceTexture(vtkOpenGLTexture):
    convert_to_linear:'getset_descriptor'
    input_texture:'getset_descriptor'
    irradiance_size:'getset_descriptor'
    irradiance_step:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ConvertToLinearOff(self) -> None: ...
    def ConvertToLinearOn(self) -> None: ...
    def GetConvertToLinear(self) -> bool: ...
    def GetInputTexture(self) -> 'vtkOpenGLTexture': ...
    def GetIrradianceSize(self) -> int: ...
    def GetIrradianceStep(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def NewInstance(self) -> 'vtkPBRIrradianceTexture': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPBRIrradianceTexture': ...
    def SetConvertToLinear(self, _arg:bool) -> None: ...
    def SetInputTexture(self, texture:'vtkOpenGLTexture') -> None: ...
    def SetIrradianceSize(self, _arg:int) -> None: ...
    def SetIrradianceStep(self, _arg:float) -> None: ...

class vtkPBRLUTTexture(vtkOpenGLTexture):
    lut_samples:'getset_descriptor'
    lut_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetLUTSamples(self) -> int: ...
    def GetLUTSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def NewInstance(self) -> 'vtkPBRLUTTexture': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPBRLUTTexture': ...
    def SetLUTSamples(self, _arg:int) -> None: ...
    def SetLUTSize(self, _arg:int) -> None: ...

class vtkPBRPrefilterTexture(vtkOpenGLTexture):
    convert_to_linear:'getset_descriptor'
    half_precision:'getset_descriptor'
    input_texture:'getset_descriptor'
    prefilter_levels:'getset_descriptor'
    prefilter_max_samples:'getset_descriptor'
    prefilter_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ConvertToLinearOff(self) -> None: ...
    def ConvertToLinearOn(self) -> None: ...
    def GetConvertToLinear(self) -> bool: ...
    def GetHalfPrecision(self) -> bool: ...
    def GetInputTexture(self) -> 'vtkOpenGLTexture': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPrefilterLevels(self) -> int: ...
    def GetPrefilterMaxSamples(self) -> int: ...
    def GetPrefilterSize(self) -> int: ...
    def HalfPrecisionOff(self) -> None: ...
    def HalfPrecisionOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def NewInstance(self) -> 'vtkPBRPrefilterTexture': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPBRPrefilterTexture': ...
    def SetConvertToLinear(self, _arg:bool) -> None: ...
    def SetHalfPrecision(self, _arg:bool) -> None: ...
    def SetInputTexture(self, __a:'vtkOpenGLTexture') -> None: ...
    def SetPrefilterLevels(self, _arg:int) -> None: ...
    def SetPrefilterMaxSamples(self, _arg:int) -> None: ...

class vtkPanoramicProjectionPass(vtkImageProcessingPass):
    Azimuthal:int
    Equirectangular:int
    angle:'getset_descriptor'
    cube_resolution:'getset_descriptor'
    interpolate:'getset_descriptor'
    projection_type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAngle(self) -> float: ...
    def GetAngleMaxValue(self) -> float: ...
    def GetAngleMinValue(self) -> float: ...
    def GetCubeResolution(self) -> int: ...
    def GetInterpolate(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProjectionType(self) -> int: ...
    def GetProjectionTypeMaxValue(self) -> int: ...
    def GetProjectionTypeMinValue(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPanoramicProjectionPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPanoramicProjectionPass': ...
    def SetAngle(self, _arg:float) -> None: ...
    def SetCubeResolution(self, _arg:int) -> None: ...
    def SetInterpolate(self, _arg:bool) -> None: ...
    def SetProjectionType(self, _arg:int) -> None: ...
    def SetProjectionTypeToAzimuthal(self) -> None: ...
    def SetProjectionTypeToEquirectangular(self) -> None: ...

class vtkPixelBufferObject(vtkmodules.vtkCommonCore.vtkObject):
    class BufferType(int): ...
    DynamicCopy:int
    DynamicDraw:int
    DynamicRead:int
    NumberOfUsages:int
    PACKED_BUFFER:'BufferType'
    StaticCopy:int
    StaticDraw:int
    StaticRead:int
    StreamCopy:int
    StreamDraw:int
    StreamRead:int
    UNPACKED_BUFFER:'BufferType'
    components:'getset_descriptor'
    context:'getset_descriptor'
    handle:'getset_descriptor'
    size:'getset_descriptor'
    type:'getset_descriptor'
    usage:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Allocate(self, vtkType:int, numtuples:int, comps:int, mode:'BufferType') -> None: ...
    @overload
    def Allocate(self, nbytes:int, mode:'BufferType') -> None: ...
    def Bind(self, buffer:'BufferType') -> None: ...
    def BindToPackedBuffer(self) -> None: ...
    def BindToUnPackedBuffer(self) -> None: ...
    def Download1D(self, type:int, data:Pointer, dim:int, numcomps:int, increment:int) -> bool: ...
    def Download2D(self, type:int, data:Pointer, dims:MutableSequence[int], numcomps:int, increments:MutableSequence[int]) -> bool: ...
    def Download3D(self, type:int, data:Pointer, dims:MutableSequence[int], numcomps:int, increments:MutableSequence[int]) -> bool: ...
    def GetComponents(self) -> int: ...
    def GetContext(self) -> 'vtkRenderWindow': ...
    def GetHandle(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self) -> int: ...
    def GetType(self) -> int: ...
    def GetUsage(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsSupported(renWin:'vtkRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def MapBuffer(self, type:int, numtuples:int, comps:int, mode:'BufferType') -> Pointer: ...
    @overload
    def MapBuffer(self, numbytes:int, mode:'BufferType') -> Pointer: ...
    @overload
    def MapBuffer(self, mode:'BufferType') -> Pointer: ...
    @overload
    def MapPackedBuffer(self) -> Pointer: ...
    @overload
    def MapPackedBuffer(self, type:int, numtuples:int, comps:int) -> Pointer: ...
    @overload
    def MapPackedBuffer(self, numbytes:int) -> Pointer: ...
    @overload
    def MapUnpackedBuffer(self) -> Pointer: ...
    @overload
    def MapUnpackedBuffer(self, type:int, numtuples:int, comps:int) -> Pointer: ...
    @overload
    def MapUnpackedBuffer(self, numbytes:int) -> Pointer: ...
    def NewInstance(self) -> 'vtkPixelBufferObject': ...
    def ReleaseMemory(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPixelBufferObject': ...
    def SetComponents(self, _arg:int) -> None: ...
    def SetContext(self, context:'vtkRenderWindow') -> None: ...
    @overload
    def SetSize(self, _arg:int) -> None: ...
    @overload
    def SetSize(self, nTups:int, nComps:int) -> None: ...
    def SetType(self, _arg:int) -> None: ...
    def SetUsage(self, _arg:int) -> None: ...
    def UnBind(self) -> None: ...
    def UnmapBuffer(self, mode:'BufferType') -> None: ...
    def UnmapPackedBuffer(self) -> None: ...
    def UnmapUnpackedBuffer(self) -> None: ...
    def Upload1D(self, type:int, data:Pointer, numtuples:int, comps:int, increment:int) -> bool: ...
    def Upload2D(self, type:int, data:Pointer, dims:MutableSequence[int], comps:int, increments:MutableSequence[int]) -> bool: ...
    def Upload3D(self, type:int, data:Pointer, dims:MutableSequence[int], comps:int, increments:MutableSequence[int], components:int, componentList:MutableSequence[int]) -> bool: ...

class vtkPointFillPass(vtkDepthImageProcessingPass):
    candidate_point_ratio:'getset_descriptor'
    minimum_candidate_angle:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCandidatePointRatio(self) -> float: ...
    def GetMinimumCandidateAngle(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointFillPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointFillPass': ...
    def SetCandidatePointRatio(self, _arg:float) -> None: ...
    def SetMinimumCandidateAngle(self, _arg:float) -> None: ...

class vtkRenderPassCollection(vtkmodules.vtkCommonCore.vtkCollection):
    last_render_pass:'getset_descriptor'
    next_render_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddItem(self, pass_:'vtkRenderPass') -> None: ...
    def GetLastRenderPass(self) -> 'vtkRenderPass': ...
    def GetNextRenderPass(self) -> 'vtkRenderPass': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderPassCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderPassCollection': ...

class vtkRenderStepsPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    camera_pass:'getset_descriptor'
    lights_pass:'getset_descriptor'
    opaque_pass:'getset_descriptor'
    overlay_pass:'getset_descriptor'
    post_process_pass:'getset_descriptor'
    translucent_pass:'getset_descriptor'
    volumetric_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCameraPass(self) -> 'vtkCameraPass': ...
    def GetLightsPass(self) -> 'vtkRenderPass': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpaquePass(self) -> 'vtkRenderPass': ...
    def GetOverlayPass(self) -> 'vtkRenderPass': ...
    def GetPostProcessPass(self) -> 'vtkRenderPass': ...
    def GetTranslucentPass(self) -> 'vtkRenderPass': ...
    def GetVolumetricPass(self) -> 'vtkRenderPass': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderStepsPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderStepsPass': ...
    def SetCameraPass(self, __a:'vtkCameraPass') -> None: ...
    def SetLightsPass(self, __a:'vtkRenderPass') -> None: ...
    def SetOpaquePass(self, __a:'vtkRenderPass') -> None: ...
    def SetOverlayPass(self, __a:'vtkRenderPass') -> None: ...
    def SetPostProcessPass(self, __a:'vtkRenderPass') -> None: ...
    def SetTranslucentPass(self, __a:'vtkRenderPass') -> None: ...
    def SetVolumetricPass(self, __a:'vtkRenderPass') -> None: ...

class vtkRenderbuffer(vtkmodules.vtkCommonCore.vtkObject):
    context:'getset_descriptor'
    handle:'getset_descriptor'
    height:'getset_descriptor'
    samples:'getset_descriptor'
    width:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Create(self, format:int, width:int, height:int) -> int: ...
    @overload
    def Create(self, format:int, width:int, height:int, samples:int) -> int: ...
    def CreateColorAttachment(self, width:int, height:int) -> int: ...
    def CreateDepthAttachment(self, width:int, height:int) -> int: ...
    def GetContext(self) -> 'vtkRenderWindow': ...
    def GetHandle(self) -> int: ...
    def GetHeight(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSamples(self) -> int: ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsSupported(renWin:'vtkRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderbuffer': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def Resize(self, width:int, height:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderbuffer': ...
    def SetContext(self, win:'vtkRenderWindow') -> None: ...

class vtkSSAAPass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    color_format:'getset_descriptor'
    delegate_pass:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColorFormat(self) -> int: ...
    def GetDelegatePass(self) -> 'vtkRenderPass': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSSAAPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSSAAPass': ...
    def SetColorFormat(self, _arg:int) -> None: ...
    def SetDelegatePass(self, delegatePass:'vtkRenderPass') -> None: ...

class vtkSSAOPass(vtkImageProcessingPass):
    bias:'getset_descriptor'
    blur:'getset_descriptor'
    depth_format:'getset_descriptor'
    intensity_scale:'getset_descriptor'
    intensity_shift:'getset_descriptor'
    kernel_size:'getset_descriptor'
    radius:'getset_descriptor'
    volume_opacity_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BlurOff(self) -> None: ...
    def BlurOn(self) -> None: ...
    def GetBias(self) -> float: ...
    def GetBlur(self) -> bool: ...
    def GetIntensityScale(self) -> float: ...
    def GetIntensityShift(self) -> float: ...
    def GetIntensityShiftMaxValue(self) -> float: ...
    def GetIntensityShiftMinValue(self) -> float: ...
    def GetKernelSize(self) -> int: ...
    def GetKernelSizeMaxValue(self) -> int: ...
    def GetKernelSizeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetVolumeOpacityThreshold(self) -> float: ...
    def GetVolumeOpacityThresholdMaxValue(self) -> float: ...
    def GetVolumeOpacityThresholdMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSSAOPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def PreReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSSAOPass': ...
    def SetBias(self, _arg:float) -> None: ...
    def SetBlur(self, _arg:bool) -> None: ...
    def SetDepthFormat(self, _arg:int) -> None: ...
    def SetIntensityScale(self, _arg:float) -> None: ...
    def SetIntensityShift(self, _arg:float) -> None: ...
    def SetKernelSize(self, _arg:int) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetShaderParameters(self, program:'vtkShaderProgram', mapper:'vtkAbstractMapper', prop:'vtkProp', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetVolumeOpacityThreshold(self, _arg:float) -> None: ...

class vtkSequencePass(vtkmodules.vtkRenderingCore.vtkRenderPass):
    passes:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPasses(self) -> 'vtkRenderPassCollection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSequencePass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSequencePass': ...
    def SetPasses(self, passes:'vtkRenderPassCollection') -> None: ...

class vtkShader(vtkmodules.vtkCommonCore.vtkObject):
    class Type(int): ...
    Compute:'Type'
    Fragment:'Type'
    Geometry:'Type'
    TessControl:'Type'
    TessEvaluation:'Type'
    Unknown:'Type'
    Vertex:'Type'
    error:'getset_descriptor'
    handle:'getset_descriptor'
    source:'getset_descriptor'
    type:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Cleanup(self) -> None: ...
    def Compile(self) -> bool: ...
    def GetError(self) -> str: ...
    def GetHandle(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSource(self) -> str: ...
    def GetType(self) -> 'Type': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsComputeShaderSupported() -> bool: ...
    @staticmethod
    def IsTessellationShaderSupported() -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShader': ...
    def SetSource(self, source:str) -> None: ...
    def SetType(self, type:'Type') -> None: ...

class vtkShaderProgram(vtkmodules.vtkCommonCore.vtkObject):
    class UniformGroups(int): ...
    class NormalizeOption(int): ...
    CameraGroup:'UniformGroups'
    LightingGroup:'UniformGroups'
    NoNormalize:'NormalizeOption'
    Normalize:'NormalizeOption'
    UserGroup:'UniformGroups'
    compiled:'getset_descriptor'
    compute_shader:'getset_descriptor'
    error:'getset_descriptor'
    file_name_prefix_for_debugging:'getset_descriptor'
    fragment_shader:'getset_descriptor'
    geometry_shader:'getset_descriptor'
    handle:'getset_descriptor'
    md5_hash:'getset_descriptor'
    number_of_outputs:'getset_descriptor'
    tess_control_shader:'getset_descriptor'
    tess_evaluation_shader:'getset_descriptor'
    transform_feedback:'getset_descriptor'
    vertex_shader:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CompiledOff(self) -> None: ...
    def CompiledOn(self) -> None: ...
    def DisableAttributeArray(self, name:str) -> bool: ...
    def EnableAttributeArray(self, name:str) -> bool: ...
    def FindAttributeArray(self, name:str) -> int: ...
    def FindUniform(self, name:str) -> int: ...
    def GetCompiled(self) -> bool: ...
    def GetComputeShader(self) -> 'vtkShader': ...
    def GetError(self) -> str: ...
    def GetFileNamePrefixForDebugging(self) -> str: ...
    def GetFragmentShader(self) -> 'vtkShader': ...
    def GetGeometryShader(self) -> 'vtkShader': ...
    def GetHandle(self) -> int: ...
    def GetMD5Hash(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTessControlShader(self) -> 'vtkShader': ...
    def GetTessEvaluationShader(self) -> 'vtkShader': ...
    def GetTransformFeedback(self) -> 'vtkTransformFeedback': ...
    def GetUniformGroupUpdateTime(self, __a:int) -> int: ...
    def GetVertexShader(self) -> 'vtkShader': ...
    def IsA(self, type:str) -> int: ...
    def IsAttributeUsed(self, name:str) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def IsUniformUsed(self, __a:str) -> bool: ...
    def NewInstance(self) -> 'vtkShaderProgram': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShaderProgram': ...
    def SetCompiled(self, _arg:bool) -> None: ...
    def SetComputeShader(self, __a:'vtkShader') -> None: ...
    def SetFileNamePrefixForDebugging(self, _arg:str) -> None: ...
    def SetFragmentShader(self, __a:'vtkShader') -> None: ...
    def SetGeometryShader(self, __a:'vtkShader') -> None: ...
    def SetMD5Hash(self, hash:str) -> None: ...
    def SetNumberOfOutputs(self, _arg:int) -> None: ...
    def SetTessControlShader(self, __a:'vtkShader') -> None: ...
    def SetTessEvaluationShader(self, __a:'vtkShader') -> None: ...
    def SetTransformFeedback(self, tfc:'vtkTransformFeedback') -> None: ...
    def SetUniform1fv(self, name:str, count:int, f:Sequence[float]) -> bool: ...
    def SetUniform1iv(self, name:str, count:int, f:Sequence[int]) -> bool: ...
    def SetUniform2f(self, name:str, v:Sequence[float]) -> bool: ...
    def SetUniform2fv(self, name:str, count:int, f:Sequence[float]) -> bool: ...
    def SetUniform2i(self, name:str, v:Sequence[int]) -> bool: ...
    def SetUniform3f(self, name:str, v:Sequence[float]) -> bool: ...
    def SetUniform3fv(self, name:str, count:int, f:Sequence[float]) -> bool: ...
    def SetUniform3uc(self, name:str, v:Sequence[int]) -> bool: ...
    def SetUniform4f(self, name:str, v:Sequence[float]) -> bool: ...
    def SetUniform4fv(self, name:str, count:int, f:Sequence[float]) -> bool: ...
    def SetUniform4uc(self, name:str, v:Sequence[int]) -> bool: ...
    def SetUniformGroupUpdateTime(self, __a:int, tm:int) -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix3x3') -> bool: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix4x4') -> bool: ...
    def SetUniformMatrix3x3(self, name:str, v:MutableSequence[float]) -> bool: ...
    def SetUniformMatrix4x4(self, name:str, v:MutableSequence[float]) -> bool: ...
    def SetUniformMatrix4x4v(self, name:str, count:int, v:MutableSequence[float]) -> bool: ...
    def SetUniformf(self, name:str, v:float) -> bool: ...
    def SetUniformi(self, name:str, v:int) -> bool: ...
    def SetVertexShader(self, __a:'vtkShader') -> None: ...
    @overload
    @staticmethod
    def Substitute(source:str, search:str, replace:str, all:bool=True) -> bool: ...
    @overload
    @staticmethod
    def Substitute(shader:'vtkShader', search:str, replace:str, all:bool=True) -> bool: ...
    def UseAttributeArray(self, name:str, offset:int, stride:int, elementType:int, elementTupleSize:int, normalize:'NormalizeOption') -> bool: ...
    def isBound(self) -> bool: ...

class vtkShadowMapBakerPass(vtkOpenGLRenderPass):
    composite_z_pass:'getset_descriptor'
    exponential_constant:'getset_descriptor'
    has_shadows:'getset_descriptor'
    need_update:'getset_descriptor'
    opaque_sequence:'getset_descriptor'
    resolution:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCompositeZPass(self) -> 'vtkRenderPass': ...
    def GetExponentialConstant(self) -> float: ...
    def GetHasShadows(self) -> bool: ...
    def GetNeedUpdate(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpaqueSequence(self) -> 'vtkRenderPass': ...
    def GetResolution(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightCreatesShadow(self, l:'vtkLight') -> bool: ...
    def NewInstance(self) -> 'vtkShadowMapBakerPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShadowMapBakerPass': ...
    def SetCompositeZPass(self, compositeZPass:'vtkRenderPass') -> None: ...
    def SetExponentialConstant(self, _arg:float) -> None: ...
    def SetOpaqueSequence(self, opaqueSequence:'vtkRenderPass') -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetUpToDate(self) -> None: ...

class vtkShadowMapPass(vtkOpenGLRenderPass):
    fragment_declaration:'getset_descriptor'
    fragment_implementation:'getset_descriptor'
    opaque_sequence:'getset_descriptor'
    shadow_map_baker_pass:'getset_descriptor'
    shadow_map_texture_units:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFragmentDeclaration(self) -> str: ...
    def GetFragmentImplementation(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpaqueSequence(self) -> 'vtkRenderPass': ...
    def GetShadowMapBakerPass(self) -> 'vtkShadowMapBakerPass': ...
    def GetShadowMapTextureUnits(self) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShadowMapPass': ...
    def PostReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def PreReplaceShaderValues(self, vertexShader:str, geometryShader:str, fragmentShader:str, mapper:'vtkAbstractMapper', prop:'vtkProp') -> bool: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShadowMapPass': ...
    def SetOpaqueSequence(self, opaqueSequence:'vtkRenderPass') -> None: ...
    def SetShaderParameters(self, program:'vtkShaderProgram', mapper:'vtkAbstractMapper', prop:'vtkProp', VAO:'vtkOpenGLVertexArrayObject'=...) -> bool: ...
    def SetShadowMapBakerPass(self, shadowMapBakerPass:'vtkShadowMapBakerPass') -> None: ...
    @staticmethod
    def ShadowMapPass() -> 'vtkInformationObjectBaseKey': ...
    def ShadowMapTransforms(self) -> Tuple[float, float]: ...

class vtkSimpleMotionBlurPass(vtkDepthImageProcessingPass):
    color_format:'getset_descriptor'
    color_texture:'getset_descriptor'
    depth_format:'getset_descriptor'
    depth_texture:'getset_descriptor'
    sub_frames:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetColorTexture(self) -> 'vtkTextureObject': ...
    def GetDepthTexture(self) -> 'vtkTextureObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSubFrames(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleMotionBlurPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleMotionBlurPass': ...
    def SetColorFormat(self, _arg:int) -> None: ...
    def SetDepthFormat(self, _arg:int) -> None: ...
    def SetSubFrames(self, subFrames:int) -> None: ...

class vtkSobelGradientMagnitudePass(vtkImageProcessingPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSobelGradientMagnitudePass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSobelGradientMagnitudePass': ...

class vtkTextureObject(vtkmodules.vtkCommonCore.vtkObject):
    AlwaysTrue:int
    ClampToBorder:int
    ClampToEdge:int
    Equal:int
    Fixed16:int
    Fixed24:int
    Fixed32:int
    Fixed8:int
    Float16:int
    Float32:int
    Gequal:int
    Greater:int
    Lequal:int
    Less:int
    Linear:int
    LinearMipmapLinear:int
    LinearMipmapNearest:int
    MirroredRepeat:int
    Native:int
    Nearest:int
    NearestMipmapLinear:int
    NearestMipmapNearest:int
    Never:int
    NotEqual:int
    NumberOfDepthFormats:int
    NumberOfDepthTextureCompareFunctions:int
    NumberOfMinificationModes:int
    NumberOfWrapModes:int
    Repeat:int
    auto_parameters:'getset_descriptor'
    base_level:'getset_descriptor'
    border_color:'getset_descriptor'
    components:'getset_descriptor'
    context:'getset_descriptor'
    data_type:'getset_descriptor'
    depth:'getset_descriptor'
    depth_texture_compare:'getset_descriptor'
    depth_texture_compare_function:'getset_descriptor'
    format:'getset_descriptor'
    generate_mipmap:'getset_descriptor'
    handle:'getset_descriptor'
    height:'getset_descriptor'
    internal_format:'getset_descriptor'
    linear_magnification:'getset_descriptor'
    magnification_filter:'getset_descriptor'
    max_level:'getset_descriptor'
    max_lod:'getset_descriptor'
    maximum_anisotropic_filtering:'getset_descriptor'
    maximum_texture_size3d:'getset_descriptor'
    min_lod:'getset_descriptor'
    minification_filter:'getset_descriptor'
    number_of_dimensions:'getset_descriptor'
    require_depth_buffer_float:'getset_descriptor'
    require_texture_float:'getset_descriptor'
    require_texture_integer:'getset_descriptor'
    samples:'getset_descriptor'
    supports_depth_buffer_float:'getset_descriptor'
    supports_texture_float:'getset_descriptor'
    supports_texture_integer:'getset_descriptor'
    target:'getset_descriptor'
    texture_unit:'getset_descriptor'
    tuples:'getset_descriptor'
    use_srgb_color_space:'getset_descriptor'
    vtk_data_type:'getset_descriptor'
    width:'getset_descriptor'
    wrap_r:'getset_descriptor'
    wrap_s:'getset_descriptor'
    wrap_t:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Activate(self) -> None: ...
    def Allocate1D(self, width:int, numComps:int, vtkType:int) -> bool: ...
    def Allocate2D(self, width:int, height:int, numComps:int, vtkType:int, level:int=0) -> bool: ...
    def Allocate3D(self, width:int, height:int, depth:int, numComps:int, vtkType:int) -> bool: ...
    def AllocateDepth(self, width:int, height:int, internalFormat:int) -> bool: ...
    def AllocateDepthStencil(self, width:int, height:int) -> bool: ...
    def AllocateProxyTexture3D(self, width:int, height:int, depth:int, numComps:int, dataType:int) -> bool: ...
    def AssignToExistingTexture(self, handle:int, target:int) -> None: ...
    def AutoParametersOff(self) -> None: ...
    def AutoParametersOn(self) -> None: ...
    def Bind(self) -> None: ...
    def CopyFromFrameBuffer(self, srcXmin:int, srcYmin:int, dstXmin:int, dstYmin:int, width:int, height:int) -> None: ...
    @overload
    def CopyToFrameBuffer(self, program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    @overload
    def CopyToFrameBuffer(self, srcXmin:int, srcYmin:int, srcXmax:int, srcYmax:int, dstXmin:int, dstYmin:int, dstXmax:int, dstYmax:int, dstSizeX:int, dstSizeY:int, program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    @overload
    def CopyToFrameBuffer(self, srcXmin:int, srcYmin:int, srcXmax:int, srcYmax:int, dstXmin:int, dstYmin:int, dstSizeX:int, dstSizeY:int, program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    @overload
    def CopyToFrameBuffer(self, tcoords:MutableSequence[float], verts:MutableSequence[float], program:'vtkShaderProgram', vao:'vtkOpenGLVertexArrayObject') -> None: ...
    def Create1D(self, numComps:int, pbo:'vtkPixelBufferObject', shaderSupportsTextureInt:bool) -> bool: ...
    def Create1DFromRaw(self, width:int, numComps:int, dataType:int, data:Pointer) -> bool: ...
    @overload
    def Create2D(self, width:int, height:int, numComps:int, pbo:'vtkPixelBufferObject', shaderSupportsTextureInt:bool) -> bool: ...
    @overload
    def Create2D(self, width:int, height:int, numComps:int, vtktype:int, __e:bool) -> bool: ...
    def Create2DArrayFromRaw(self, width:int, height:int, numComps:int, dataType:int, nbLayers:int, data:Pointer) -> bool: ...
    def Create2DFromRaw(self, width:int, height:int, numComps:int, dataType:int, data:Pointer) -> bool: ...
    @overload
    def Create3D(self, width:int, height:int, depth:int, numComps:int, pbo:'vtkPixelBufferObject', shaderSupportsTextureInt:bool) -> bool: ...
    @overload
    def Create3D(self, width:int, height:int, depth:int, numComps:int, vtktype:int, __f:bool) -> bool: ...
    def Create3DFromRaw(self, width:int, height:int, depth:int, numComps:int, dataType:int, data:Pointer) -> bool: ...
    def CreateDepth(self, width:int, height:int, internalFormat:int, pbo:'vtkPixelBufferObject') -> bool: ...
    def CreateDepthFromRaw(self, width:int, height:int, internalFormat:int, rawType:int, raw:Pointer) -> bool: ...
    def CreateTextureBuffer(self, numValues:int, numComps:int, dataType:int, bo:'vtkOpenGLBufferObject') -> bool: ...
    def Deactivate(self) -> None: ...
    @overload
    def Download(self) -> 'vtkPixelBufferObject': ...
    @overload
    def Download(self, target:int, level:int) -> 'vtkPixelBufferObject': ...
    def EmulateTextureBufferWith2DTextures(self, numValues:int, numComps:int, dataType:int, bo:'vtkOpenGLBufferObject') -> bool: ...
    def GetAutoParameters(self) -> int: ...
    def GetBaseLevel(self) -> int: ...
    def GetBorderColor(self) -> Tuple[float, float, float, float]: ...
    def GetComponents(self) -> int: ...
    def GetContext(self) -> 'vtkOpenGLRenderWindow': ...
    def GetDataType(self, vtk_scalar_type:int) -> int: ...
    def GetDefaultDataType(self, vtk_scalar_type:int) -> int: ...
    def GetDefaultFormat(self, vtktype:int, numComps:int, shaderSupportsTextureInt:bool) -> int: ...
    def GetDefaultInternalFormat(self, vtktype:int, numComps:int, shaderSupportsTextureInt:bool) -> int: ...
    def GetDepth(self) -> int: ...
    def GetDepthTextureCompare(self) -> bool: ...
    def GetDepthTextureCompareFunction(self) -> int: ...
    def GetFormat(self, vtktype:int, numComps:int, shaderSupportsTextureInt:bool) -> int: ...
    def GetGenerateMipmap(self) -> bool: ...
    def GetHandle(self) -> int: ...
    def GetHeight(self) -> int: ...
    def GetInternalFormat(self, vtktype:int, numComps:int, shaderSupportsTextureInt:bool) -> int: ...
    def GetLinearMagnification(self) -> bool: ...
    def GetMagnificationFilter(self) -> int: ...
    def GetMagnificationFilterMode(self, vtktype:int) -> int: ...
    def GetMaxLOD(self) -> float: ...
    def GetMaxLevel(self) -> int: ...
    def GetMaximumAnisotropicFiltering(self) -> float: ...
    @staticmethod
    def GetMaximumTextureSize(context:'vtkOpenGLRenderWindow') -> int: ...
    @overload
    @staticmethod
    def GetMaximumTextureSize3D(context:'vtkOpenGLRenderWindow') -> int: ...
    @overload
    def GetMaximumTextureSize3D(self) -> int: ...
    def GetMinLOD(self) -> float: ...
    def GetMinificationFilter(self) -> int: ...
    def GetMinificationFilterMode(self, vtktype:int) -> int: ...
    def GetNumberOfDimensions(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRequireDepthBufferFloat(self) -> bool: ...
    def GetRequireTextureFloat(self) -> bool: ...
    def GetRequireTextureInteger(self) -> bool: ...
    def GetSamples(self) -> int: ...
    def GetShiftAndScale(self, shift:float, scale:float) -> None: ...
    def GetSupportsDepthBufferFloat(self) -> bool: ...
    def GetSupportsTextureFloat(self) -> bool: ...
    def GetSupportsTextureInteger(self) -> bool: ...
    def GetTarget(self) -> int: ...
    def GetTextureUnit(self) -> int: ...
    def GetTuples(self) -> int: ...
    def GetUseSRGBColorSpace(self) -> bool: ...
    def GetVTKDataType(self) -> int: ...
    def GetWidth(self) -> int: ...
    def GetWrapR(self) -> int: ...
    def GetWrapRMode(self, vtktype:int) -> int: ...
    def GetWrapS(self) -> int: ...
    def GetWrapSMode(self, vtktype:int) -> int: ...
    def GetWrapT(self) -> int: ...
    def GetWrapTMode(self, vtktype:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsBound(self) -> bool: ...
    @overload
    @staticmethod
    def IsSupported(renWin:'vtkOpenGLRenderWindow', requireTexFloat:bool, requireDepthFloat:bool, requireTexInt:bool) -> bool: ...
    @overload
    @staticmethod
    def IsSupported(renWin:'vtkOpenGLRenderWindow') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextureObject': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def ResetFormatAndType(self) -> None: ...
    def Resize(self, width:int, height:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextureObject': ...
    def SendParameters(self) -> None: ...
    def SetAutoParameters(self, _arg:int) -> None: ...
    def SetBaseLevel(self, _arg:int) -> None: ...
    @overload
    def SetBorderColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBorderColor(self, _arg:Sequence[float]) -> None: ...
    def SetContext(self, __a:'vtkOpenGLRenderWindow') -> None: ...
    def SetDataType(self, glType:int) -> None: ...
    def SetDepthTextureCompare(self, _arg:bool) -> None: ...
    def SetDepthTextureCompareFunction(self, _arg:int) -> None: ...
    def SetFormat(self, glFormat:int) -> None: ...
    def SetGenerateMipmap(self, _arg:bool) -> None: ...
    def SetInternalFormat(self, glInternalFormat:int) -> None: ...
    def SetLinearMagnification(self, val:bool) -> None: ...
    def SetMagnificationFilter(self, _arg:int) -> None: ...
    def SetMaxLOD(self, _arg:float) -> None: ...
    def SetMaxLevel(self, _arg:int) -> None: ...
    def SetMaximumAnisotropicFiltering(self, _arg:float) -> None: ...
    def SetMinLOD(self, _arg:float) -> None: ...
    def SetMinificationFilter(self, _arg:int) -> None: ...
    def SetRequireDepthBufferFloat(self, _arg:bool) -> None: ...
    def SetRequireTextureFloat(self, _arg:bool) -> None: ...
    def SetRequireTextureInteger(self, _arg:bool) -> None: ...
    def SetSamples(self, _arg:int) -> None: ...
    def SetUseSRGBColorSpace(self, _arg:bool) -> None: ...
    def SetWrapR(self, _arg:int) -> None: ...
    def SetWrapS(self, _arg:int) -> None: ...
    def SetWrapT(self, _arg:int) -> None: ...
    def UseSRGBColorSpaceOff(self) -> None: ...
    def UseSRGBColorSpaceOn(self) -> None: ...

class vtkTextureUnitManager(vtkmodules.vtkCommonCore.vtkObject):
    number_of_texture_units:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @overload
    def Allocate(self) -> int: ...
    @overload
    def Allocate(self, unit:int) -> int: ...
    def Free(self, textureUnitId:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTextureUnits(self) -> int: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsAllocated(self, textureUnitId:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextureUnitManager': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextureUnitManager': ...

class vtkToneMappingPass(vtkImageProcessingPass):
    Clamp:int
    Exponential:int
    GenericFilmic:int
    NeutralPBR:int
    Reinhard:int
    contrast:'getset_descriptor'
    exposure:'getset_descriptor'
    hdr_max:'getset_descriptor'
    mid_in:'getset_descriptor'
    mid_out:'getset_descriptor'
    shoulder:'getset_descriptor'
    tone_mapping_type:'getset_descriptor'
    use_aces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetContrast(self) -> float: ...
    def GetContrastMaxValue(self) -> float: ...
    def GetContrastMinValue(self) -> float: ...
    def GetExposure(self) -> float: ...
    def GetHdrMax(self) -> float: ...
    def GetHdrMaxMaxValue(self) -> float: ...
    def GetHdrMaxMinValue(self) -> float: ...
    def GetMidIn(self) -> float: ...
    def GetMidInMaxValue(self) -> float: ...
    def GetMidInMinValue(self) -> float: ...
    def GetMidOut(self) -> float: ...
    def GetMidOutMaxValue(self) -> float: ...
    def GetMidOutMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShoulder(self) -> float: ...
    def GetShoulderMaxValue(self) -> float: ...
    def GetShoulderMinValue(self) -> float: ...
    def GetToneMappingType(self) -> int: ...
    def GetToneMappingTypeMaxValue(self) -> int: ...
    def GetToneMappingTypeMinValue(self) -> int: ...
    def GetUseACES(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkToneMappingPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkToneMappingPass': ...
    def SetContrast(self, _arg:float) -> None: ...
    def SetExposure(self, _arg:float) -> None: ...
    def SetGenericFilmicDefaultPresets(self) -> None: ...
    def SetGenericFilmicUncharted2Presets(self) -> None: ...
    def SetHdrMax(self, _arg:float) -> None: ...
    def SetMidIn(self, _arg:float) -> None: ...
    def SetMidOut(self, _arg:float) -> None: ...
    def SetShoulder(self, _arg:float) -> None: ...
    def SetToneMappingType(self, _arg:int) -> None: ...
    def SetUseACES(self, _arg:bool) -> None: ...

class vtkTransformFeedback(vtkmodules.vtkCommonCore.vtkObject):
    class VaryingRole(int): ...
    Color_RGBA_F:'VaryingRole'
    Next_Buffer:'VaryingRole'
    Normal_F:'VaryingRole'
    Vertex_ClipCoordinate_F:'VaryingRole'
    buffer_data:'getset_descriptor'
    buffer_size:'getset_descriptor'
    bytes_per_vertex:'getset_descriptor'
    number_of_vertices:'getset_descriptor'
    primitive_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddVarying(self, role:'VaryingRole', var:str) -> None: ...
    def Allocate(self, nbBuffers:int, size:int, hint:int) -> None: ...
    def BindBuffer(self, allocateOneBuffer:bool=True) -> None: ...
    def BindVaryings(self, prog:'vtkShaderProgram') -> None: ...
    def ClearVaryings(self) -> None: ...
    def GetBuffer(self, index:int) -> 'vtkOpenGLBufferObject': ...
    def GetBufferData(self) -> Pointer: ...
    def GetBufferHandle(self, index:int=0) -> int: ...
    def GetBufferSize(self) -> int: ...
    @overload
    @staticmethod
    def GetBytesPerVertex(role:'VaryingRole') -> int: ...
    @overload
    def GetBytesPerVertex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVertices(self) -> int: ...
    def GetPrimitiveMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformFeedback': ...
    def ReadBuffer(self, index:int=0) -> None: ...
    def ReleaseBufferData(self, freeBuffer:bool=True) -> None: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformFeedback': ...
    @overload
    def SetNumberOfVertices(self, _arg:int) -> None: ...
    @overload
    def SetNumberOfVertices(self, drawMode:int, inputVerts:int) -> None: ...
    def SetPrimitiveMode(self, _arg:int) -> None: ...

class vtkTranslucentPass(vtkDefaultPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTranslucentPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTranslucentPass': ...

class vtkValuePass(vtkOpenGLRenderPass):
    class Mode(int): ...
    FLOATING_POINT:'Mode'
    INVERTIBLE_LUT:'Mode'
    float_image_extents:'getset_descriptor'
    input_array_to_process:'getset_descriptor'
    input_component_to_process:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFloatImageData(self, format:int, width:int, height:int, data:Pointer) -> None: ...
    def GetFloatImageDataArray(self, ren:'vtkRenderer') -> 'vtkFloatArray': ...
    def GetFloatImageExtents(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkValuePass': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkValuePass': ...
    @overload
    def SetInputArrayToProcess(self, fieldAssociation:int, name:str) -> None: ...
    @overload
    def SetInputArrayToProcess(self, fieldAssociation:int, fieldId:int) -> None: ...
    def SetInputComponentToProcess(self, component:int) -> None: ...

class vtkVolumetricPass(vtkDefaultPass):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumetricPass': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumetricPass': ...

class vtkXOpenGLRenderWindow(vtkOpenGLRenderWindow):
    coverable:'getset_descriptor'
    current_cursor:'getset_descriptor'
    desired_depth:'getset_descriptor'
    desired_visual_info:'getset_descriptor'
    display_id:'getset_descriptor'
    event_pending:'getset_descriptor'
    full_screen:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_fb_config:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    icon:'getset_descriptor'
    next_window_id:'getset_descriptor'
    next_window_info:'getset_descriptor'
    parent_id:'getset_descriptor'
    parent_info:'getset_descriptor'
    platform_supports_render_window_sharing:'getset_descriptor'
    position:'getset_descriptor'
    screen_size:'getset_descriptor'
    show_window:'getset_descriptor'
    size:'getset_descriptor'
    stereo_capable_window:'getset_descriptor'
    window_id:'getset_descriptor'
    window_info:'getset_descriptor'
    window_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def EnsureDisplay(self) -> bool: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def GetDesiredDepth(self) -> int: ...
    def GetDesiredVisualInfo(self) -> 'vtkXVisualInfo': ...
    def GetEventPending(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericFBConfig(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlatformSupportsRenderWindowSharing(self) -> bool: ...
    def GetPosition(self) -> Tuple[int, int]: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def InitializeFromCurrentContext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkXOpenGLRenderWindow': ...
    def PopContext(self) -> None: ...
    def PrefFullScreen(self) -> None: ...
    def PushContext(self) -> None: ...
    def ReleaseCurrent(self) -> None: ...
    def Render(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXOpenGLRenderWindow': ...
    def SetCoverable(self, coverable:int) -> None: ...
    def SetCurrentCursor(self, __a:int) -> None: ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetForceMakeCurrent(self) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetIcon(self, img:'vtkImageData') -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, info:str) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, info:str) -> None: ...
    @overload
    def SetPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetPosition(self, a:MutableSequence[int]) -> None: ...
    def SetShowWindow(self, val:bool) -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetStereoCapableWindow(self, capable:int) -> None: ...
    def SetSwapControl(self, i:int) -> bool: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, info:str) -> None: ...
    def SetWindowName(self, __a:str) -> None: ...
    def ShowCursor(self) -> None: ...
    def Start(self) -> None: ...
    def WindowInitialize(self) -> None: ...
    def WindowRemap(self) -> None: ...

