"""Basic Open Agent Tools.

An open foundational toolkit providing essential components for building AI agents
with minimal dependencies for local (non-HTTP/API) actions.
"""

__version__ = "0.13.14"

# Modular structure
from . import (
    archive,
    color,
    crypto,
    data,
    datetime,
    diagrams,
    excel,
    exceptions,
    file_system,
    html,
    image,
    markdown,
    network,
    pdf,
    powerpoint,
    system,
    text,
    todo,
    types,
    utilities,
    word,
    xml,
)
from . import (
    logging as log_module,
)

# Helper functions for tool management
from .helpers import (
    get_tool_info,
    list_all_available_tools,
    load_all_archive_tools,
    load_all_color_tools,
    load_all_crypto_tools,
    load_all_data_tools,
    load_all_datetime_tools,
    load_all_diagrams_tools,
    load_all_excel_tools,
    load_all_filesystem_tools,
    load_all_html_tools,
    load_all_image_tools,
    load_all_logging_tools,
    load_all_markdown_tools,
    load_all_network_tools,
    load_all_pdf_tools,
    load_all_powerpoint_tools,
    load_all_system_tools,
    load_all_text_tools,
    load_all_todo_tools,
    load_all_tools,
    load_all_utilities_tools,
    load_all_word_tools,
    load_all_xml_tools,
    load_data_config_tools,
    load_data_csv_tools,
    load_data_json_tools,
    load_data_validation_tools,
    merge_tool_lists,
)

__all__: list[str] = [
    # All implemented modules
    "archive",
    "color",
    "crypto",
    "data",
    "datetime",
    "diagrams",
    "excel",
    "file_system",
    "html",
    "image",
    "log_module",
    "markdown",
    "network",
    "pdf",
    "powerpoint",
    "system",
    "text",
    "todo",
    "utilities",
    "word",
    "xml",
    # Common infrastructure
    "exceptions",
    "types",
    # Helper functions
    "load_all_archive_tools",
    "load_all_color_tools",
    "load_all_crypto_tools",
    "load_all_data_tools",
    "load_all_datetime_tools",
    "load_all_diagrams_tools",
    "load_all_excel_tools",
    "load_all_filesystem_tools",
    "load_all_html_tools",
    "load_all_image_tools",
    "load_all_logging_tools",
    "load_all_markdown_tools",
    "load_all_network_tools",
    "load_all_pdf_tools",
    "load_all_powerpoint_tools",
    "load_all_system_tools",
    "load_all_text_tools",
    "load_all_todo_tools",
    "load_all_tools",
    "load_all_utilities_tools",
    "load_all_word_tools",
    "load_all_xml_tools",
    "load_data_config_tools",
    "load_data_csv_tools",
    "load_data_json_tools",
    "load_data_validation_tools",
    "merge_tool_lists",
    "get_tool_info",
    "list_all_available_tools",
]
