import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogicAppWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#enabled LogicAppWorkflow#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#integration_service_environment_id LogicAppWorkflow#integration_service_environment_id}.
     *
     * @stability stable
     */
    readonly integrationServiceEnvironmentId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#location LogicAppWorkflow#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#logic_app_integration_account_id LogicAppWorkflow#logic_app_integration_account_id}.
     *
     * @stability stable
     */
    readonly logicAppIntegrationAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#name LogicAppWorkflow#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#parameters LogicAppWorkflow#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#resource_group_name LogicAppWorkflow#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#tags LogicAppWorkflow#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#workflow_parameters LogicAppWorkflow#workflow_parameters}.
     *
     * @stability stable
     */
    readonly workflowParameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#workflow_schema LogicAppWorkflow#workflow_schema}.
     *
     * @stability stable
     */
    readonly workflowSchema?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#workflow_version LogicAppWorkflow#workflow_version}.
     *
     * @stability stable
     */
    readonly workflowVersion?: string;
    /**
     * access_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#access_control LogicAppWorkflow#access_control}
     *
     * @stability stable
     */
    readonly accessControl?: LogicAppWorkflowAccessControl;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#timeouts LogicAppWorkflow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LogicAppWorkflowTimeouts;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowAccessControlAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}.
     *
     * @stability stable
     */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlActionToTerraform(struct?: LogicAppWorkflowAccessControlActionOutputReference | LogicAppWorkflowAccessControlAction): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowAccessControlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowAccessControlAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowAccessControlAction | undefined);
    private _allowedCallerIpAddressRange?;
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRange(): string[];
    /**
     * @stability stable
     */
    set allowedCallerIpAddressRange(value: string[]);
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowAccessControlContent {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}.
     *
     * @stability stable
     */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlContentToTerraform(struct?: LogicAppWorkflowAccessControlContentOutputReference | LogicAppWorkflowAccessControlContent): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowAccessControlContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowAccessControlContent | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowAccessControlContent | undefined);
    private _allowedCallerIpAddressRange?;
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRange(): string[];
    /**
     * @stability stable
     */
    set allowedCallerIpAddressRange(value: string[]);
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowAccessControlTrigger {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}.
     *
     * @stability stable
     */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlTriggerToTerraform(struct?: LogicAppWorkflowAccessControlTriggerOutputReference | LogicAppWorkflowAccessControlTrigger): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowAccessControlTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowAccessControlTrigger | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowAccessControlTrigger | undefined);
    private _allowedCallerIpAddressRange?;
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRange(): string[];
    /**
     * @stability stable
     */
    set allowedCallerIpAddressRange(value: string[]);
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowAccessControlWorkflowManagement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#allowed_caller_ip_address_range LogicAppWorkflow#allowed_caller_ip_address_range}.
     *
     * @stability stable
     */
    readonly allowedCallerIpAddressRange: string[];
}
export declare function logicAppWorkflowAccessControlWorkflowManagementToTerraform(struct?: LogicAppWorkflowAccessControlWorkflowManagementOutputReference | LogicAppWorkflowAccessControlWorkflowManagement): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowAccessControlWorkflowManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowAccessControlWorkflowManagement | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowAccessControlWorkflowManagement | undefined);
    private _allowedCallerIpAddressRange?;
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRange(): string[];
    /**
     * @stability stable
     */
    set allowedCallerIpAddressRange(value: string[]);
    /**
     * @stability stable
     */
    get allowedCallerIpAddressRangeInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowAccessControl {
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#action LogicAppWorkflow#action}
     *
     * @stability stable
     */
    readonly action?: LogicAppWorkflowAccessControlAction;
    /**
     * content block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#content LogicAppWorkflow#content}
     *
     * @stability stable
     */
    readonly content?: LogicAppWorkflowAccessControlContent;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#trigger LogicAppWorkflow#trigger}
     *
     * @stability stable
     */
    readonly trigger?: LogicAppWorkflowAccessControlTrigger;
    /**
     * workflow_management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#workflow_management LogicAppWorkflow#workflow_management}
     *
     * @stability stable
     */
    readonly workflowManagement?: LogicAppWorkflowAccessControlWorkflowManagement;
}
export declare function logicAppWorkflowAccessControlToTerraform(struct?: LogicAppWorkflowAccessControlOutputReference | LogicAppWorkflowAccessControl): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowAccessControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowAccessControl | undefined);
    private _action;
    /**
     * @stability stable
     */
    get action(): LogicAppWorkflowAccessControlActionOutputReference;
    /**
     * @stability stable
     */
    putAction(value: LogicAppWorkflowAccessControlAction): void;
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): LogicAppWorkflowAccessControlAction | undefined;
    private _content;
    /**
     * @stability stable
     */
    get content(): LogicAppWorkflowAccessControlContentOutputReference;
    /**
     * @stability stable
     */
    putContent(value: LogicAppWorkflowAccessControlContent): void;
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): LogicAppWorkflowAccessControlContent | undefined;
    private _trigger;
    /**
     * @stability stable
     */
    get trigger(): LogicAppWorkflowAccessControlTriggerOutputReference;
    /**
     * @stability stable
     */
    putTrigger(value: LogicAppWorkflowAccessControlTrigger): void;
    /**
     * @stability stable
     */
    resetTrigger(): void;
    /**
     * @stability stable
     */
    get triggerInput(): LogicAppWorkflowAccessControlTrigger | undefined;
    private _workflowManagement;
    /**
     * @stability stable
     */
    get workflowManagement(): LogicAppWorkflowAccessControlWorkflowManagementOutputReference;
    /**
     * @stability stable
     */
    putWorkflowManagement(value: LogicAppWorkflowAccessControlWorkflowManagement): void;
    /**
     * @stability stable
     */
    resetWorkflowManagement(): void;
    /**
     * @stability stable
     */
    get workflowManagementInput(): LogicAppWorkflowAccessControlWorkflowManagement | undefined;
}
/**
 * @stability stable
 */
export interface LogicAppWorkflowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#create LogicAppWorkflow#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#delete LogicAppWorkflow#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#read LogicAppWorkflow#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html#update LogicAppWorkflow#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function logicAppWorkflowTimeoutsToTerraform(struct?: LogicAppWorkflowTimeoutsOutputReference | LogicAppWorkflowTimeouts): any;
/**
 * @stability stable
 */
export declare class LogicAppWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LogicAppWorkflowTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LogicAppWorkflowTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html azurerm_logic_app_workflow}.
 *
 * @stability stable
 */
export declare class LogicAppWorkflow extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_workflow.html azurerm_logic_app_workflow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogicAppWorkflowConfig);
    /**
     * @stability stable
     */
    get accessEndpoint(): string;
    /**
     * @stability stable
     */
    get connectorEndpointIpAddresses(): string[];
    /**
     * @stability stable
     */
    get connectorOutboundIpAddresses(): string[];
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationServiceEnvironmentId?;
    /**
     * @stability stable
     */
    get integrationServiceEnvironmentId(): string;
    /**
     * @stability stable
     */
    set integrationServiceEnvironmentId(value: string);
    /**
     * @stability stable
     */
    resetIntegrationServiceEnvironmentId(): void;
    /**
     * @stability stable
     */
    get integrationServiceEnvironmentIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _logicAppIntegrationAccountId?;
    /**
     * @stability stable
     */
    get logicAppIntegrationAccountId(): string;
    /**
     * @stability stable
     */
    set logicAppIntegrationAccountId(value: string);
    /**
     * @stability stable
     */
    resetLogicAppIntegrationAccountId(): void;
    /**
     * @stability stable
     */
    get logicAppIntegrationAccountIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get workflowEndpointIpAddresses(): string[];
    /**
     * @stability stable
     */
    get workflowOutboundIpAddresses(): string[];
    private _workflowParameters?;
    /**
     * @stability stable
     */
    get workflowParameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set workflowParameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWorkflowParameters(): void;
    /**
     * @stability stable
     */
    get workflowParametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _workflowSchema?;
    /**
     * @stability stable
     */
    get workflowSchema(): string;
    /**
     * @stability stable
     */
    set workflowSchema(value: string);
    /**
     * @stability stable
     */
    resetWorkflowSchema(): void;
    /**
     * @stability stable
     */
    get workflowSchemaInput(): string | undefined;
    private _workflowVersion?;
    /**
     * @stability stable
     */
    get workflowVersion(): string;
    /**
     * @stability stable
     */
    set workflowVersion(value: string);
    /**
     * @stability stable
     */
    resetWorkflowVersion(): void;
    /**
     * @stability stable
     */
    get workflowVersionInput(): string | undefined;
    private _accessControl;
    /**
     * @stability stable
     */
    get accessControl(): LogicAppWorkflowAccessControlOutputReference;
    /**
     * @stability stable
     */
    putAccessControl(value: LogicAppWorkflowAccessControl): void;
    /**
     * @stability stable
     */
    resetAccessControl(): void;
    /**
     * @stability stable
     */
    get accessControlInput(): LogicAppWorkflowAccessControl | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LogicAppWorkflowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LogicAppWorkflowTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LogicAppWorkflowTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
