#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed May 17 10:32:46 2017 by generateDS.py version 2.22a.
#
# Command line options:
#   ('-o', 'sfftk/sfftk/schema/v_0_6_0_a_2.py')
#
# Command line arguments:
#   ../../schema/trunk/DA_schema/segmentation_da.xsd
#
# Command line:
#   /usr/local/bin/generateDS.py -o "sfftk/sfftk/schema/v_0_6_0_a_2.py" ../../schema/trunk/DA_schema/segmentation_da.xsd
#
# Current working directory (os.getcwd()):
#   trunk
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
from lxml import etree as etree_


Validate_simpletypes_ = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        parser = etree_.ETCompatXMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                return instring.encode(ExternalEncoding)
            else:
                return instring

    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class segmentation(GeneratedsSuper):
    """Link to assembly or component id. Version History 0.2, 2015/3/15,
    Ardan Patwardhan: 1) Added support for color 2) Added support
    for triangle representation of segment - this is in support of
    Amira segmentations 0.3, 2015/10/21, Paul Korir: 1) Added
    voxelTransform 2) Added filePath for segmentLinks to HDF5
    (Segger) segmentations 3) Added segmentObjects with contours and
    meshes for IMOD 0.4, 2015/11/04, Paul Korir: 1) Added alpha for
    rgb color (transparency) 0.5, 2015/12/14, Paul Korir: 1) Removed
    'voxelTransform' 2) Moved 'numberOfCopies' as
    'numberOfInstances' to be a sequence element within
    'biologicalAnnotation' 3) Made 'color' a choice between 'name'
    (X11/HTML4 sRGB colour space names) and 'rgba' 4) Added a
    'transform' element, which is a possibly empty list of
    transformation matrices referenced within the document by a non-
    negative identifier 5) Renamed 'segmentLink' to
    'voxelSegmentation' and added a 'transformId' element 6) Renamed
    'color' element to 'colour' and 'colorType' to 'colourType' 7)
    Structured 'shapePrimitive' to a list of 'shapePrimitive'
    (substitution group for 'ellipsoid', 'cuboid', 'pyramid',
    'cylinder') 8) Identified and labeled deprecated data types 9)
    Renamed shapePrimitive 'pyramid' to 'cone' and added tentative
    definition 10) Removed 'origin' and 'viewVectorRotation'
    elements from shape primitives (cuboid, ellipsoid, cone,
    cylinder) and replaced with 'transformId' element 11) Renamed
    references to 'triangles' to 'polygons' e.g. 'triangleListType'
    now 'polygonListType' 0.5.1, 2015/12/23, Paul Korir: 1) Change
    colourType to have rgbaType minOccurs=1 2) Added 'attribute'
    element (e.g. for FOM) to shapePrimitive 3) Deleted comment:
    'Are the CCP4 format masks going to be allowed? If so, we could
    represent the information of the mask (mapType) here.' from
    'voxelSegmentation'. 4) Added segment 'format' element to
    'voxelSegmentation' restricted to values 'runLengthEncoding',
    'MRC', or 'Segger' 5) Renamed 'voxelSegmentation' to
    'threeDVolume' and deprecated 'subTomogramAverage'. 6)
    Restructured 'transforms' into a list ('transformList') of
    'transform', which is a substitutionGroup of
    'transformationMatrix', 'canonicalEulerAngles' or
    'viewVectorRotation'. 7) Added an 'angleDegreeType' to restrict
    angle range in degrees [0,360]. 0.5.2, 2016/01/04, Paul Korir:
    1) Made 'transformList' optional 2) Added 'id' attributes for
    'canonicalEulerAngle' and 'viewVectorRotation' 3) Annotations
    for 'filePath' 4) Added 'other' to types for 'externalReference'
    and optional 'otherTypes' attribute 5) Changed type of 'name'
    element in 'colour' from 'xs:string' to 'xs:token' 6) Created
    'threeDVolumeType' to be used by 'threeDVolume' and
    'subtomogramAverage' 7) Added 'id' attributes for
    'shapePrimitive' and 'threeDVolumeType' 8) Renamed 'contours' to
    'contourList' 9) Created 'meshList' as a sequence of 'mesh'.
    Each 'mesh' has an 'id' 0.5.3, 2016/01/06, Paul Korir: 1)
    Renamed 'transformationMatrixType' attribute from 'transformId'
    to 'id' 2) Created 'dimensionType' for all 'shapePrimitive'
    dimensions 0.5.4, 2016/01/06, Paul Korir: 1) Added element
    'primaryDescriptor' of type restricted string to 'threeDVolume',
    'shapePrimitiveList', 'contourList', 'meshList' 0.5.5,
    2016/01/22, Paul Korir: 1) Changed 'vertices' and 'polygons' to
    'vertexList' and 'polygonList', respectively. 2) Added attribute
    'designation' restricted to string 'vertex' (default) and
    'normal' to 'vertex' element. 0.5.6, 2016/01/25, Paul Korir: 1)
    Changed attribute 'polygonID' from 'positiveInteger' to
    'nonNegativeInteger' 0.5.7, 2016/01/26, Paul Korir: 1) Change
    element names to save disk space: 'vertex' to 'v', 'vertexID' to
    'vID', 'point' to 'p', 'polygon' to 'P', 'polygonID' to 'PID' 2)
    Changed 'vertexType' to have ID of type 'xs:nonNegativeInteger'
    (from 'xs:positiveInteger') 0.5.8, 2016/04/26, Paul Korir: 1)
    Added 'version' element at the root. 0.5.8, 2016/08/08, Paul
    Korir: 2) Made 'shapePrimitive' element 'attribute (not present
    in 'subtomogramAverage' optional (minOccurs=0) 0.5.8,
    2016/08/17, Paul Korir: 3) Added a 'transformId' element to
    'contourList' and to 'mesh'. 0.5.8, 2016/10/04, Paul Korir: 4)
    Simplified shape primitives by eliminating internal layering
    e.g. cone/dimensions/height to cone/height 0.5.8, 2016/10/14,
    Paul Korir: 5) (Finally) renamed 'surfaceType' to 'meshType' for
    consistency. 0.5.8, 2016/10/20, Paul Korir: 6) 'macromolecule'
    and 'complex' changed from 'positiveInteger' to 'string'
    0.6.0a1, 2017/02/28, Paul Korir: 1) Added 'EMAN' as a
    'threeDVolume' format 0.6.0a2, 2017/05/15, Paul Korir: 1)
    Restructured 'externalReferences' from simpleType to complexType
    2) Changed 'externalReference' to 'externalReferenceType' and
    replaced elements with attributes"""
    subclass = None
    superclass = None
    def __init__(self, schemaVersion='0.6.0a2', version=None, name=None, software=None, transformList=None, filePath=None, primaryDescriptor=None, segmentList=None, details=None):
        self.original_tagname_ = None
        self.schemaVersion = _cast(None, schemaVersion)
        self.version = version
        self.name = name
        self.software = software
        self.transformList = transformList
        self.filePath = filePath
        self.primaryDescriptor = primaryDescriptor
        self.validate_primaryDescriptorType(self.primaryDescriptor)
        self.segmentList = segmentList
        self.details = details
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segmentation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segmentation.subclass:
            return segmentation.subclass(*args_, **kwargs_)
        else:
            return segmentation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_software(self): return self.software
    def set_software(self, software): self.software = software
    def get_transformList(self): return self.transformList
    def set_transformList(self, transformList): self.transformList = transformList
    def get_filePath(self): return self.filePath
    def set_filePath(self, filePath): self.filePath = filePath
    def get_primaryDescriptor(self): return self.primaryDescriptor
    def set_primaryDescriptor(self, primaryDescriptor): self.primaryDescriptor = primaryDescriptor
    def get_segmentList(self): return self.segmentList
    def set_segmentList(self, segmentList): self.segmentList = segmentList
    def get_details(self): return self.details
    def set_details(self, details): self.details = details
    def get_schemaVersion(self): return self.schemaVersion
    def set_schemaVersion(self, schemaVersion): self.schemaVersion = schemaVersion
    def validate_primaryDescriptorType(self, value):
        # Validate type primaryDescriptorType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['threeDVolume', 'shapePrimitiveList', 'contourList', 'meshList']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on primaryDescriptorType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.version is not None or
            self.name is not None or
            self.software is not None or
            self.transformList is not None or
            self.filePath is not None or
            self.primaryDescriptor is not None or
            self.segmentList is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='segmentation', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='segmentation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='segmentation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='segmentation'):
        if self.schemaVersion != "0.6.0a2" and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            outfile.write(' schemaVersion=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.schemaVersion), input_name='schemaVersion')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='segmentation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespace_, eol_))
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespace_, eol_))
        if self.software is not None:
            self.software.export(outfile, level, namespace_, name_='software', pretty_print=pretty_print)
        if self.transformList is not None:
            self.transformList.export(outfile, level, namespace_, name_='transformList', pretty_print=pretty_print)
        if self.filePath is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfilePath>%s</%sfilePath>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.filePath), input_name='filePath')), namespace_, eol_))
        if self.primaryDescriptor is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprimaryDescriptor>%s</%sprimaryDescriptor>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.primaryDescriptor), input_name='primaryDescriptor')), namespace_, eol_))
        if self.segmentList is not None:
            self.segmentList.export(outfile, level, namespace_, name_='segmentList', pretty_print=pretty_print)
        if self.details is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('schemaVersion', node)
        if value is not None and 'schemaVersion' not in already_processed:
            already_processed.add('schemaVersion')
            self.schemaVersion = value
            self.schemaVersion = ' '.join(self.schemaVersion.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'version':
            version_ = child_.text
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'name':
            name_ = child_.text
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'software':
            obj_ = softwareType.factory()
            obj_.build(child_)
            self.software = obj_
            obj_.original_tagname_ = 'software'
        elif nodeName_ == 'transformList':
            obj_ = transformListType.factory()
            obj_.build(child_)
            self.transformList = obj_
            obj_.original_tagname_ = 'transformList'
        elif nodeName_ == 'filePath':
            filePath_ = child_.text
            filePath_ = re_.sub(String_cleanup_pat_, " ", filePath_).strip()
            filePath_ = self.gds_validate_string(filePath_, node, 'filePath')
            self.filePath = filePath_
        elif nodeName_ == 'primaryDescriptor':
            primaryDescriptor_ = child_.text
            primaryDescriptor_ = self.gds_validate_string(primaryDescriptor_, node, 'primaryDescriptor')
            self.primaryDescriptor = primaryDescriptor_
            # validate type primaryDescriptorType
            self.validate_primaryDescriptorType(self.primaryDescriptor)
        elif nodeName_ == 'segmentList':
            obj_ = segmentListType.factory()
            obj_.build(child_)
            self.segmentList = obj_
            obj_.original_tagname_ = 'segmentList'
        elif nodeName_ == 'details':
            details_ = child_.text
            details_ = self.gds_validate_string(details_, node, 'details')
            self.details = details_
# end class segmentation


class softwareType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, version=None, processingDetails=None):
        self.original_tagname_ = None
        self.name = name
        self.version = version
        self.processingDetails = processingDetails
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, softwareType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if softwareType.subclass:
            return softwareType.subclass(*args_, **kwargs_)
        else:
            return softwareType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def get_processingDetails(self): return self.processingDetails
    def set_processingDetails(self, processingDetails): self.processingDetails = processingDetails
    def hasContent_(self):
        if (
            self.name is not None or
            self.version is not None or
            self.processingDetails is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='softwareType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='softwareType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='softwareType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='softwareType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='softwareType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespace_, eol_))
        if self.version is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespace_, eol_))
        if self.processingDetails is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocessingDetails>%s</%sprocessingDetails>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.processingDetails), input_name='processingDetails')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = re_.sub(String_cleanup_pat_, " ", name_).strip()
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'version':
            version_ = child_.text
            version_ = re_.sub(String_cleanup_pat_, " ", version_).strip()
            version_ = self.gds_validate_string(version_, node, 'version')
            self.version = version_
        elif nodeName_ == 'processingDetails':
            processingDetails_ = child_.text
            processingDetails_ = self.gds_validate_string(processingDetails_, node, 'processingDetails')
            self.processingDetails = processingDetails_
# end class softwareType


class transformationMatrixType(GeneratedsSuper):
    """data is a space-separated sequence of numbers to be converted to
    floats. The number of items in 'data' is equivalent to the
    product of 'rows' and 'cols'."""
    subclass = None
    superclass = None
    def __init__(self, id=None, rows=None, cols=None, data=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.rows = rows
        self.cols = cols
        self.data = data
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transformationMatrixType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transformationMatrixType.subclass:
            return transformationMatrixType.subclass(*args_, **kwargs_)
        else:
            return transformationMatrixType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_rows(self): return self.rows
    def set_rows(self, rows): self.rows = rows
    def get_cols(self): return self.cols
    def set_cols(self, cols): self.cols = cols
    def get_data(self): return self.data
    def set_data(self, data): self.data = data
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.rows is not None or
            self.cols is not None or
            self.data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='transformationMatrixType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='transformationMatrixType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='transformationMatrixType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='transformationMatrixType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='transformationMatrixType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.rows is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srows>%s</%srows>%s' % (namespace_, self.gds_format_integer(self.rows, input_name='rows'), namespace_, eol_))
        if self.cols is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scols>%s</%scols>%s' % (namespace_, self.gds_format_integer(self.cols, input_name='cols'), namespace_, eol_))
        if self.data is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.data), input_name='data')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'rows':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'rows')
            self.rows = ival_
        elif nodeName_ == 'cols':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'cols')
            self.cols = ival_
        elif nodeName_ == 'data':
            data_ = child_.text
            data_ = self.gds_validate_string(data_, node, 'data')
            self.data = data_
# end class transformationMatrixType


class canonicalEulerAnglesType(GeneratedsSuper):
    """Euler angler according to Heymann et al. 2005
    (doi:10.1016/j.jsb.2005.06.001)Angles are specified in degrees
    together with their bounds."""
    subclass = None
    superclass = None
    def __init__(self, id=None, phi=None, theta=None, psi=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.phi = phi
        self.validate_angleDegreeType(self.phi)
        self.theta = theta
        self.validate_angleDegreeType(self.theta)
        self.psi = psi
        self.validate_angleDegreeType(self.psi)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, canonicalEulerAnglesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if canonicalEulerAnglesType.subclass:
            return canonicalEulerAnglesType.subclass(*args_, **kwargs_)
        else:
            return canonicalEulerAnglesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_phi(self): return self.phi
    def set_phi(self, phi): self.phi = phi
    def get_theta(self): return self.theta
    def set_theta(self, theta): self.theta = theta
    def get_psi(self): return self.psi
    def set_psi(self, psi): self.psi = psi
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_angleDegreeType(self, value):
        # Validate type angleDegreeType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on angleDegreeType' % {"value" : value} )
            if value > 360:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on angleDegreeType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.phi is not None or
            self.theta is not None or
            self.psi is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='canonicalEulerAnglesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='canonicalEulerAnglesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='canonicalEulerAnglesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='canonicalEulerAnglesType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='canonicalEulerAnglesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phi is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphi>%s</%sphi>%s' % (namespace_, self.gds_format_float(self.phi, input_name='phi'), namespace_, eol_))
        if self.theta is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stheta>%s</%stheta>%s' % (namespace_, self.gds_format_float(self.theta, input_name='theta'), namespace_, eol_))
        if self.psi is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spsi>%s</%spsi>%s' % (namespace_, self.gds_format_float(self.psi, input_name='psi'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'phi':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'phi')
            self.phi = fval_
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.phi)
        elif nodeName_ == 'theta':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'theta')
            self.theta = fval_
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.theta)
        elif nodeName_ == 'psi':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'psi')
            self.psi = fval_
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.psi)
# end class canonicalEulerAnglesType


class viewVectorRotationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, r=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.x = x
        self.y = y
        self.z = z
        self.r = r
        self.validate_angleDegreeType(self.r)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, viewVectorRotationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if viewVectorRotationType.subclass:
            return viewVectorRotationType.subclass(*args_, **kwargs_)
        else:
            return viewVectorRotationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def get_r(self): return self.r
    def set_r(self, r): self.r = r
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_angleDegreeType(self, value):
        # Validate type angleDegreeType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on angleDegreeType' % {"value" : value} )
            if value > 360:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on angleDegreeType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.r is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='viewVectorRotationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='viewVectorRotationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='viewVectorRotationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='viewVectorRotationType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='viewVectorRotationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_float(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_float(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_float(self.z, input_name='z'), namespace_, eol_))
        if self.r is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sr>%s</%sr>%s' % (namespace_, self.gds_format_float(self.r, input_name='r'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
        elif nodeName_ == 'r':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'r')
            self.r = fval_
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.r)
# end class viewVectorRotationType


class segmentType(GeneratedsSuper):
    """For the root segment: parentSegmentID = 0"""
    subclass = None
    superclass = None
    def __init__(self, id=None, parentID=None, biologicalAnnotation=None, complexesAndMacromolecules=None, colour=None, threeDVolume=None, shapePrimitiveList=None, contourList=None, meshList=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.parentID = _cast(int, parentID)
        self.biologicalAnnotation = biologicalAnnotation
        self.complexesAndMacromolecules = complexesAndMacromolecules
        self.colour = colour
        self.threeDVolume = threeDVolume
        self.shapePrimitiveList = shapePrimitiveList
        self.contourList = contourList
        self.meshList = meshList
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segmentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segmentType.subclass:
            return segmentType.subclass(*args_, **kwargs_)
        else:
            return segmentType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_biologicalAnnotation(self): return self.biologicalAnnotation
    def set_biologicalAnnotation(self, biologicalAnnotation): self.biologicalAnnotation = biologicalAnnotation
    def get_complexesAndMacromolecules(self): return self.complexesAndMacromolecules
    def set_complexesAndMacromolecules(self, complexesAndMacromolecules): self.complexesAndMacromolecules = complexesAndMacromolecules
    def get_colour(self): return self.colour
    def set_colour(self, colour): self.colour = colour
    def get_threeDVolume(self): return self.threeDVolume
    def set_threeDVolume(self, threeDVolume): self.threeDVolume = threeDVolume
    def get_shapePrimitiveList(self): return self.shapePrimitiveList
    def set_shapePrimitiveList(self, shapePrimitiveList): self.shapePrimitiveList = shapePrimitiveList
    def get_contourList(self): return self.contourList
    def set_contourList(self, contourList): self.contourList = contourList
    def get_meshList(self): return self.meshList
    def set_meshList(self, meshList): self.meshList = meshList
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_parentID(self): return self.parentID
    def set_parentID(self, parentID): self.parentID = parentID
    def hasContent_(self):
        if (
            self.biologicalAnnotation is not None or
            self.complexesAndMacromolecules is not None or
            self.colour is not None or
            self.threeDVolume is not None or
            self.shapePrimitiveList is not None or
            self.contourList is not None or
            self.meshList is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='segmentType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='segmentType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='segmentType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='segmentType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.parentID is not None and 'parentID' not in already_processed:
            already_processed.add('parentID')
            outfile.write(' parentID="%s"' % self.gds_format_integer(self.parentID, input_name='parentID'))
    def exportChildren(self, outfile, level, namespace_='', name_='segmentType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.biologicalAnnotation is not None:
            self.biologicalAnnotation.export(outfile, level, namespace_, name_='biologicalAnnotation', pretty_print=pretty_print)
        if self.complexesAndMacromolecules is not None:
            self.complexesAndMacromolecules.export(outfile, level, namespace_, name_='complexesAndMacromolecules', pretty_print=pretty_print)
        if self.colour is not None:
            self.colour.export(outfile, level, namespace_, name_='colour', pretty_print=pretty_print)
        if self.threeDVolume is not None:
            self.threeDVolume.export(outfile, level, namespace_, name_='threeDVolume', pretty_print=pretty_print)
        if self.shapePrimitiveList is not None:
            self.shapePrimitiveList.export(outfile, level, namespace_, name_='shapePrimitiveList', pretty_print=pretty_print)
        if self.contourList is not None:
            self.contourList.export(outfile, level, namespace_, name_='contourList', pretty_print=pretty_print)
        if self.meshList is not None:
            self.meshList.export(outfile, level, namespace_, name_='meshList', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('parentID', node)
        if value is not None and 'parentID' not in already_processed:
            already_processed.add('parentID')
            try:
                self.parentID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.parentID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'biologicalAnnotation':
            obj_ = biologicalAnnotationType.factory()
            obj_.build(child_)
            self.biologicalAnnotation = obj_
            obj_.original_tagname_ = 'biologicalAnnotation'
        elif nodeName_ == 'complexesAndMacromolecules':
            obj_ = macromoleculesAndComplexesType.factory()
            obj_.build(child_)
            self.complexesAndMacromolecules = obj_
            obj_.original_tagname_ = 'complexesAndMacromolecules'
        elif nodeName_ == 'colour':
            obj_ = colourType.factory()
            obj_.build(child_)
            self.colour = obj_
            obj_.original_tagname_ = 'colour'
        elif nodeName_ == 'threeDVolume':
            obj_ = threeDVolumeType.factory()
            obj_.build(child_)
            self.threeDVolume = obj_
            obj_.original_tagname_ = 'threeDVolume'
        elif nodeName_ == 'shapePrimitiveList':
            obj_ = shapePrimitiveListType.factory()
            obj_.build(child_)
            self.shapePrimitiveList = obj_
            obj_.original_tagname_ = 'shapePrimitiveList'
        elif nodeName_ == 'contourList':
            obj_ = contourListType.factory()
            obj_.build(child_)
            self.contourList = obj_
            obj_.original_tagname_ = 'contourList'
        elif nodeName_ == 'meshList':
            obj_ = meshListType.factory()
            obj_.build(child_)
            self.meshList = obj_
            obj_.original_tagname_ = 'meshList'
# end class segmentType


class macromoleculesAndComplexesType(GeneratedsSuper):
    """Depending on the problem, one can either reference the sample on the
    macromolecule level or the complex level."""
    subclass = None
    superclass = None
    def __init__(self, macromolecule=None, complex=None):
        self.original_tagname_ = None
        self.macromolecule = macromolecule
        self.complex = complex
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromoleculesAndComplexesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromoleculesAndComplexesType.subclass:
            return macromoleculesAndComplexesType.subclass(*args_, **kwargs_)
        else:
            return macromoleculesAndComplexesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_macromolecule(self): return self.macromolecule
    def set_macromolecule(self, macromolecule): self.macromolecule = macromolecule
    def get_complex(self): return self.complex
    def set_complex(self, complex): self.complex = complex
    def hasContent_(self):
        if (
            self.macromolecule is not None or
            self.complex is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromoleculesAndComplexesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromoleculesAndComplexesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromoleculesAndComplexesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromoleculesAndComplexesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromoleculesAndComplexesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.macromolecule is not None:
            self.macromolecule.export(outfile, level, namespace_, name_='macromolecule', pretty_print=pretty_print)
        if self.complex is not None:
            self.complex.export(outfile, level, namespace_, name_='complex', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'macromolecule':
            obj_ = macromoleculeType.factory()
            obj_.build(child_)
            self.macromolecule = obj_
            obj_.original_tagname_ = 'macromolecule'
        elif nodeName_ == 'complex':
            obj_ = complexType.factory()
            obj_.build(child_)
            self.complex = obj_
            obj_.original_tagname_ = 'complex'
# end class macromoleculesAndComplexesType


class threeDVolumeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, file=None, objectPath=None, contourLevel=None, transformId=None, format=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.file = file
        self.objectPath = objectPath
        self.contourLevel = contourLevel
        self.transformId = transformId
        self.format = format
        self.validate_formatType(self.format)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, threeDVolumeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if threeDVolumeType.subclass:
            return threeDVolumeType.subclass(*args_, **kwargs_)
        else:
            return threeDVolumeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_file(self): return self.file
    def set_file(self, file): self.file = file
    def get_objectPath(self): return self.objectPath
    def set_objectPath(self, objectPath): self.objectPath = objectPath
    def get_contourLevel(self): return self.contourLevel
    def set_contourLevel(self, contourLevel): self.contourLevel = contourLevel
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_formatType(self, value):
        # Validate type formatType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_:
            value = str(value)
            enumerations = ['runLengthEncoding', 'MRC', 'Segger', 'EMAN']
            enumeration_respectee = False
            for enum in enumerations:
                if value == enum:
                    enumeration_respectee = True
                    break
            if not enumeration_respectee:
                warnings_.warn('Value "%(value)s" does not match xsd enumeration restriction on formatType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.file is not None or
            self.objectPath is not None or
            self.contourLevel is not None or
            self.transformId is not None or
            self.format is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='threeDVolumeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='threeDVolumeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='threeDVolumeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='threeDVolumeType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='threeDVolumeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), namespace_, eol_))
        if self.objectPath is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sobjectPath>%s</%sobjectPath>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.objectPath), input_name='objectPath')), namespace_, eol_))
        if self.contourLevel is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontourLevel>%s</%scontourLevel>%s' % (namespace_, self.gds_format_float(self.contourLevel, input_name='contourLevel'), namespace_, eol_))
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
        if self.format is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.format), input_name='format')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'file':
            file_ = child_.text
            file_ = re_.sub(String_cleanup_pat_, " ", file_).strip()
            file_ = self.gds_validate_string(file_, node, 'file')
            self.file = file_
        elif nodeName_ == 'objectPath':
            objectPath_ = child_.text
            objectPath_ = re_.sub(String_cleanup_pat_, " ", objectPath_).strip()
            objectPath_ = self.gds_validate_string(objectPath_, node, 'objectPath')
            self.objectPath = objectPath_
        elif nodeName_ == 'contourLevel':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'contourLevel')
            self.contourLevel = fval_
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
        elif nodeName_ == 'format':
            format_ = child_.text
            format_ = self.gds_validate_string(format_, node, 'format')
            self.format = format_
            # validate type formatType
            self.validate_formatType(self.format)
# end class threeDVolumeType


class meshType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, vertexList=None, polygonList=None, transformId=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.vertexList = vertexList
        self.polygonList = polygonList
        self.transformId = transformId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, meshType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if meshType.subclass:
            return meshType.subclass(*args_, **kwargs_)
        else:
            return meshType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_vertexList(self): return self.vertexList
    def set_vertexList(self, vertexList): self.vertexList = vertexList
    def get_polygonList(self): return self.polygonList
    def set_polygonList(self, polygonList): self.polygonList = polygonList
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.vertexList is not None or
            self.polygonList is not None or
            self.transformId is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='meshType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='meshType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='meshType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='meshType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='meshType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vertexList is not None:
            self.vertexList.export(outfile, level, namespace_, name_='vertexList', pretty_print=pretty_print)
        if self.polygonList is not None:
            self.polygonList.export(outfile, level, namespace_, name_='polygonList', pretty_print=pretty_print)
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'vertexList':
            obj_ = vertexListType.factory()
            obj_.build(child_)
            self.vertexList = obj_
            obj_.original_tagname_ = 'vertexList'
        elif nodeName_ == 'polygonList':
            obj_ = polygonListType.factory()
            obj_.build(child_)
            self.polygonList = obj_
            obj_.original_tagname_ = 'polygonList'
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
# end class meshType


class vertexListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, numVertices=None, v=None):
        self.original_tagname_ = None
        self.numVertices = _cast(int, numVertices)
        if v is None:
            self.v = []
        else:
            self.v = v
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vertexListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vertexListType.subclass:
            return vertexListType.subclass(*args_, **kwargs_)
        else:
            return vertexListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_v(self): return self.v
    def set_v(self, v): self.v = v
    def add_v(self, value): self.v.append(value)
    def insert_v_at(self, index, value): self.v.insert(index, value)
    def replace_v_at(self, index, value): self.v[index] = value
    def get_numVertices(self): return self.numVertices
    def set_numVertices(self, numVertices): self.numVertices = numVertices
    def hasContent_(self):
        if (
            self.v
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vertexListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vertexListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vertexListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vertexListType'):
        if self.numVertices is not None and 'numVertices' not in already_processed:
            already_processed.add('numVertices')
            outfile.write(' numVertices="%s"' % self.gds_format_integer(self.numVertices, input_name='numVertices'))
    def exportChildren(self, outfile, level, namespace_='', name_='vertexListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for v_ in self.v:
            v_.export(outfile, level, namespace_, name_='v', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numVertices', node)
        if value is not None and 'numVertices' not in already_processed:
            already_processed.add('numVertices')
            try:
                self.numVertices = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.numVertices <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'v':
            obj_ = vertexType.factory()
            obj_.build(child_)
            self.v.append(obj_)
            obj_.original_tagname_ = 'v'
# end class vertexListType


class polygonListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, numPolygons=None, P=None):
        self.original_tagname_ = None
        self.numPolygons = _cast(int, numPolygons)
        if P is None:
            self.P = []
        else:
            self.P = P
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, polygonListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if polygonListType.subclass:
            return polygonListType.subclass(*args_, **kwargs_)
        else:
            return polygonListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_P(self): return self.P
    def set_P(self, P): self.P = P
    def add_P(self, value): self.P.append(value)
    def insert_P_at(self, index, value): self.P.insert(index, value)
    def replace_P_at(self, index, value): self.P[index] = value
    def get_numPolygons(self): return self.numPolygons
    def set_numPolygons(self, numPolygons): self.numPolygons = numPolygons
    def hasContent_(self):
        if (
            self.P
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='polygonListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='polygonListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='polygonListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='polygonListType'):
        if self.numPolygons is not None and 'numPolygons' not in already_processed:
            already_processed.add('numPolygons')
            outfile.write(' numPolygons="%s"' % self.gds_format_integer(self.numPolygons, input_name='numPolygons'))
    def exportChildren(self, outfile, level, namespace_='', name_='polygonListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for P_ in self.P:
            P_.export(outfile, level, namespace_, name_='P', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('numPolygons', node)
        if value is not None and 'numPolygons' not in already_processed:
            already_processed.add('numPolygons')
            try:
                self.numPolygons = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.numPolygons <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'P':
            obj_ = polygonType.factory()
            obj_.build(child_)
            self.P.append(obj_)
            obj_.original_tagname_ = 'P'
# end class polygonListType


class vertexType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, vID=None, designation='vertex', x=None, y=None, z=None):
        self.original_tagname_ = None
        self.vID = _cast(int, vID)
        self.designation = _cast(None, designation)
        self.x = x
        self.y = y
        self.z = z
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vertexType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vertexType.subclass:
            return vertexType.subclass(*args_, **kwargs_)
        else:
            return vertexType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def get_vID(self): return self.vID
    def set_vID(self, vID): self.vID = vID
    def get_designation(self): return self.designation
    def set_designation(self, designation): self.designation = designation
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='vertexType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='vertexType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='vertexType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='vertexType'):
        if self.vID is not None and 'vID' not in already_processed:
            already_processed.add('vID')
            outfile.write(' vID="%s"' % self.gds_format_integer(self.vID, input_name='vID'))
        if self.designation != "vertex" and 'designation' not in already_processed:
            already_processed.add('designation')
            outfile.write(' designation=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.designation), input_name='designation')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='vertexType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_float(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_float(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_float(self.z, input_name='z'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('vID', node)
        if value is not None and 'vID' not in already_processed:
            already_processed.add('vID')
            try:
                self.vID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.vID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('designation', node)
        if value is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            self.designation = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
# end class vertexType


class polygonType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, PID=None, v=None):
        self.original_tagname_ = None
        self.PID = _cast(int, PID)
        if v is None:
            self.v = []
        else:
            self.v = v
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, polygonType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if polygonType.subclass:
            return polygonType.subclass(*args_, **kwargs_)
        else:
            return polygonType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_v(self): return self.v
    def set_v(self, v): self.v = v
    def add_v(self, value): self.v.append(value)
    def insert_v_at(self, index, value): self.v.insert(index, value)
    def replace_v_at(self, index, value): self.v[index] = value
    def get_PID(self): return self.PID
    def set_PID(self, PID): self.PID = PID
    def hasContent_(self):
        if (
            self.v
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='polygonType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='polygonType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='polygonType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='polygonType'):
        if self.PID is not None and 'PID' not in already_processed:
            already_processed.add('PID')
            outfile.write(' PID="%s"' % self.gds_format_integer(self.PID, input_name='PID'))
    def exportChildren(self, outfile, level, namespace_='', name_='polygonType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for v_ in self.v:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sv>%s</%sv>%s' % (namespace_, self.gds_format_integer(v_, input_name='v'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('PID', node)
        if value is not None and 'PID' not in already_processed:
            already_processed.add('PID')
            try:
                self.PID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.PID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'v':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'v')
            self.v.append(ival_)
# end class polygonType


class colourType(GeneratedsSuper):
    """The 'name' corresponds to the sRGB colour space name and maps
    precisely to an RGB value. When this happens, the alpha channel
    should be set to '1' (opaque). Requires the use of an external
    Python module (webcolors.py)."""
    subclass = None
    superclass = None
    def __init__(self, name=None, rgba=None):
        self.original_tagname_ = None
        self.name = name
        self.rgba = rgba
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, colourType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if colourType.subclass:
            return colourType.subclass(*args_, **kwargs_)
        else:
            return colourType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_rgba(self): return self.rgba
    def set_rgba(self, rgba): self.rgba = rgba
    def hasContent_(self):
        if (
            self.name is not None or
            self.rgba is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='colourType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='colourType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='colourType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='colourType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='colourType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespace_, eol_))
        if self.rgba is not None:
            self.rgba.export(outfile, level, namespace_, name_='rgba', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'name':
            name_ = child_.text
            name_ = re_.sub(String_cleanup_pat_, " ", name_).strip()
            name_ = self.gds_validate_string(name_, node, 'name')
            self.name = name_
        elif nodeName_ == 'rgba':
            obj_ = rgbaType.factory()
            obj_.build(child_)
            self.rgba = obj_
            obj_.original_tagname_ = 'rgba'
# end class colourType


class rgbaType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, red=None, green=None, blue=None, alpha=1.0):
        self.original_tagname_ = None
        self.red = red
        self.validate_colourChannelType(self.red)
        self.green = green
        self.validate_colourChannelType(self.green)
        self.blue = blue
        self.validate_colourChannelType(self.blue)
        self.alpha = alpha
        self.validate_colourChannelType(self.alpha)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, rgbaType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if rgbaType.subclass:
            return rgbaType.subclass(*args_, **kwargs_)
        else:
            return rgbaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_red(self): return self.red
    def set_red(self, red): self.red = red
    def get_green(self): return self.green
    def set_green(self, green): self.green = green
    def get_blue(self): return self.blue
    def set_blue(self, blue): self.blue = blue
    def get_alpha(self): return self.alpha
    def set_alpha(self, alpha): self.alpha = alpha
    def validate_colourChannelType(self, value):
        # Validate type colourChannelType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0.0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on colourChannelType' % {"value" : value} )
            if value > 1.0:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on colourChannelType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.red is not None or
            self.green is not None or
            self.blue is not None or
            self.alpha != 1.0
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='rgbaType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='rgbaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='rgbaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='rgbaType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='rgbaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.red is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sred>%s</%sred>%s' % (namespace_, self.gds_format_float(self.red, input_name='red'), namespace_, eol_))
        if self.green is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgreen>%s</%sgreen>%s' % (namespace_, self.gds_format_float(self.green, input_name='green'), namespace_, eol_))
        if self.blue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sblue>%s</%sblue>%s' % (namespace_, self.gds_format_float(self.blue, input_name='blue'), namespace_, eol_))
        if self.alpha != 1.0:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salpha>%s</%salpha>%s' % (namespace_, self.gds_format_float(self.alpha, input_name='alpha'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'red':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'red')
            self.red = fval_
            # validate type colourChannelType
            self.validate_colourChannelType(self.red)
        elif nodeName_ == 'green':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'green')
            self.green = fval_
            # validate type colourChannelType
            self.validate_colourChannelType(self.green)
        elif nodeName_ == 'blue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'blue')
            self.blue = fval_
            # validate type colourChannelType
            self.validate_colourChannelType(self.blue)
        elif nodeName_ == 'alpha':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'alpha')
            self.alpha = fval_
            # validate type colourChannelType
            self.validate_colourChannelType(self.alpha)
# end class rgbaType


class contourType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, p=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        if p is None:
            self.p = []
        else:
            self.p = p
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contourType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contourType.subclass:
            return contourType.subclass(*args_, **kwargs_)
        else:
            return contourType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_p(self): return self.p
    def set_p(self, p): self.p = p
    def add_p(self, value): self.p.append(value)
    def insert_p_at(self, index, value): self.p.insert(index, value)
    def replace_p_at(self, index, value): self.p[index] = value
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def hasContent_(self):
        if (
            self.p
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contourType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contourType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contourType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contourType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='contourType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for p_ in self.p:
            p_.export(outfile, level, namespace_, name_='p', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'p':
            obj_ = floatVectorType.factory()
            obj_.build(child_)
            self.p.append(obj_)
            obj_.original_tagname_ = 'p'
# end class contourType


class floatVectorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None):
        self.original_tagname_ = None
        self.x = _cast(float, x)
        self.y = _cast(float, y)
        self.z = _cast(float, z)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, floatVectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if floatVectorType.subclass:
            return floatVectorType.subclass(*args_, **kwargs_)
        else:
            return floatVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='floatVectorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='floatVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='floatVectorType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='floatVectorType'):
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name='x'))
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name='y'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name='z'))
    def exportChildren(self, outfile, level, namespace_='', name_='floatVectorType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            try:
                self.x = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (x): %s' % exp)
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            try:
                self.y = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (y): %s' % exp)
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            try:
                self.z = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (z): %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class floatVectorType


class externalReferenceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, type_=None, otherType=None, value=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.type_ = _cast(None, type_)
        self.otherType = _cast(None, otherType)
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalReferenceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalReferenceType.subclass:
            return externalReferenceType.subclass(*args_, **kwargs_)
        else:
            return externalReferenceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_otherType(self): return self.otherType
    def set_otherType(self, otherType): self.otherType = otherType
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalReferenceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalReferenceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalReferenceType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalReferenceType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.type_), input_name='type')), ))
        if self.otherType is not None and 'otherType' not in already_processed:
            already_processed.add('otherType')
            outfile.write(' otherType=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.otherType), input_name='otherType')), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='externalReferenceType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('otherType', node)
        if value is not None and 'otherType' not in already_processed:
            already_processed.add('otherType')
            self.otherType = value
            self.otherType = ' '.join(self.otherType.split())
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class externalReferenceType


class transform(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transform)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transform.subclass:
            return transform.subclass(*args_, **kwargs_)
        else:
            return transform(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='transform', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='transform')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='transform', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='transform'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='transform', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class transform


class shapePrimitive(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self):
        self.original_tagname_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, shapePrimitive)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if shapePrimitive.subclass:
            return shapePrimitive.subclass(*args_, **kwargs_)
        else:
            return shapePrimitive(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='shapePrimitive', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='shapePrimitive')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='shapePrimitive', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='shapePrimitive'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='shapePrimitive', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class shapePrimitive


class cuboid(GeneratedsSuper):
    """3D rectangle'attribute' could refer to figure of merit (FOM)"""
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, transformId=None, attribute=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.x = x
        self.validate_dimensionType(self.x)
        self.y = y
        self.validate_dimensionType(self.y)
        self.z = z
        self.validate_dimensionType(self.z)
        self.transformId = transformId
        self.attribute = attribute
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cuboid)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cuboid.subclass:
            return cuboid.subclass(*args_, **kwargs_)
        else:
            return cuboid(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_attribute(self): return self.attribute
    def set_attribute(self, attribute): self.attribute = attribute
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_dimensionType(self, value):
        # Validate type dimensionType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dimensionType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.transformId is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cuboid', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cuboid')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cuboid', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cuboid'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='cuboid', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_float(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_float(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_float(self.z, input_name='z'), namespace_, eol_))
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
        if self.attribute is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespace_, self.gds_format_float(self.attribute, input_name='attribute'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.x)
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.y)
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.z)
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
        elif nodeName_ == 'attribute':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
# end class cuboid


class ellipsoid(GeneratedsSuper):
    """3D sphere"""
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, transformId=None, attribute=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.x = x
        self.validate_dimensionType(self.x)
        self.y = y
        self.validate_dimensionType(self.y)
        self.z = z
        self.validate_dimensionType(self.z)
        self.transformId = transformId
        self.attribute = attribute
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ellipsoid)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ellipsoid.subclass:
            return ellipsoid.subclass(*args_, **kwargs_)
        else:
            return ellipsoid(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_attribute(self): return self.attribute
    def set_attribute(self, attribute): self.attribute = attribute
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_dimensionType(self, value):
        # Validate type dimensionType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dimensionType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.transformId is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ellipsoid', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ellipsoid')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ellipsoid', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ellipsoid'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='ellipsoid', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_float(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_float(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_float(self.z, input_name='z'), namespace_, eol_))
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
        if self.attribute is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespace_, self.gds_format_float(self.attribute, input_name='attribute'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.x)
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.y)
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.z)
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
        elif nodeName_ == 'attribute':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
# end class ellipsoid


class cylinder(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, height=None, diameter=None, transformId=None, attribute=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.height = height
        self.validate_dimensionType(self.height)
        self.diameter = diameter
        self.validate_dimensionType(self.diameter)
        self.transformId = transformId
        self.attribute = attribute
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cylinder)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cylinder.subclass:
            return cylinder.subclass(*args_, **kwargs_)
        else:
            return cylinder(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_height(self): return self.height
    def set_height(self, height): self.height = height
    def get_diameter(self): return self.diameter
    def set_diameter(self, diameter): self.diameter = diameter
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_attribute(self): return self.attribute
    def set_attribute(self, attribute): self.attribute = attribute
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_dimensionType(self, value):
        # Validate type dimensionType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dimensionType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.height is not None or
            self.diameter is not None or
            self.transformId is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cylinder', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cylinder')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cylinder', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cylinder'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='cylinder', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.height is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheight>%s</%sheight>%s' % (namespace_, self.gds_format_float(self.height, input_name='height'), namespace_, eol_))
        if self.diameter is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdiameter>%s</%sdiameter>%s' % (namespace_, self.gds_format_float(self.diameter, input_name='diameter'), namespace_, eol_))
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
        if self.attribute is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespace_, self.gds_format_float(self.attribute, input_name='attribute'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'height':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'height')
            self.height = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.height)
        elif nodeName_ == 'diameter':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'diameter')
            self.diameter = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.diameter)
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
        elif nodeName_ == 'attribute':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
# end class cylinder


class cone(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None, height=None, bottomRadius=None, transformId=None, attribute=None):
        self.original_tagname_ = None
        self.id = _cast(int, id)
        self.height = height
        self.validate_dimensionType(self.height)
        self.bottomRadius = bottomRadius
        self.validate_dimensionType(self.bottomRadius)
        self.transformId = transformId
        self.attribute = attribute
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cone.subclass:
            return cone.subclass(*args_, **kwargs_)
        else:
            return cone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_height(self): return self.height
    def set_height(self, height): self.height = height
    def get_bottomRadius(self): return self.bottomRadius
    def set_bottomRadius(self, bottomRadius): self.bottomRadius = bottomRadius
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def get_attribute(self): return self.attribute
    def set_attribute(self, attribute): self.attribute = attribute
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def validate_dimensionType(self, value):
        # Validate type dimensionType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on dimensionType' % {"value" : value} )
    def hasContent_(self):
        if (
            self.height is not None or
            self.bottomRadius is not None or
            self.transformId is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='cone', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='cone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='cone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='cone'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='cone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.height is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheight>%s</%sheight>%s' % (namespace_, self.gds_format_float(self.height, input_name='height'), namespace_, eol_))
        if self.bottomRadius is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbottomRadius>%s</%sbottomRadius>%s' % (namespace_, self.gds_format_float(self.bottomRadius, input_name='bottomRadius'), namespace_, eol_))
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
        if self.attribute is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespace_, self.gds_format_float(self.attribute, input_name='attribute'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            try:
                self.id = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'height':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'height')
            self.height = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.height)
        elif nodeName_ == 'bottomRadius':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'bottomRadius')
            self.bottomRadius = fval_
            # validate type dimensionType
            self.validate_dimensionType(self.bottomRadius)
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
        elif nodeName_ == 'attribute':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
# end class cone


class meshPointType(GeneratedsSuper):
    """A mesh is a sequence of trianglesDeprecated"""
    subclass = None
    superclass = None
    def __init__(self, index=None, designation=None, point=None):
        self.original_tagname_ = None
        self.index = _cast(int, index)
        self.designation = _cast(None, designation)
        if point is None:
            self.point = []
        else:
            self.point = point
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, meshPointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if meshPointType.subclass:
            return meshPointType.subclass(*args_, **kwargs_)
        else:
            return meshPointType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_point(self): return self.point
    def set_point(self, point): self.point = point
    def add_point(self, value): self.point.append(value)
    def insert_point_at(self, index, value): self.point.insert(index, value)
    def replace_point_at(self, index, value): self.point[index] = value
    def get_index(self): return self.index
    def set_index(self, index): self.index = index
    def get_designation(self): return self.designation
    def set_designation(self, designation): self.designation = designation
    def hasContent_(self):
        if (
            self.point
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='meshPointType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='meshPointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='meshPointType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='meshPointType'):
        if self.index is not None and 'index' not in already_processed:
            already_processed.add('index')
            outfile.write(' index="%s"' % self.gds_format_integer(self.index, input_name='index'))
        if self.designation is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            outfile.write(' designation=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.designation), input_name='designation')), ))
    def exportChildren(self, outfile, level, namespace_='', name_='meshPointType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for point_ in self.point:
            point_.export(outfile, level, namespace_, name_='point', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('index', node)
        if value is not None and 'index' not in already_processed:
            already_processed.add('index')
            try:
                self.index = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.index < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('designation', node)
        if value is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            self.designation = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'point':
            obj_ = floatVectorType.factory()
            obj_.build(child_)
            self.point.append(obj_)
            obj_.original_tagname_ = 'point'
# end class meshPointType


class hsvType(GeneratedsSuper):
    """Deprecated"""
    subclass = None
    superclass = None
    def __init__(self, hue=None, saturation=None, value=None):
        self.original_tagname_ = None
        self.hue = hue
        self.saturation = saturation
        self.value = value
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, hsvType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if hsvType.subclass:
            return hsvType.subclass(*args_, **kwargs_)
        else:
            return hsvType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_hue(self): return self.hue
    def set_hue(self, hue): self.hue = hue
    def get_saturation(self): return self.saturation
    def set_saturation(self, saturation): self.saturation = saturation
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (
            self.hue is not None or
            self.saturation is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='hsvType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='hsvType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='hsvType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='hsvType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='hsvType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.hue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shue>%s</%shue>%s' % (namespace_, self.gds_format_float(self.hue, input_name='hue'), namespace_, eol_))
        if self.saturation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssaturation>%s</%ssaturation>%s' % (namespace_, self.gds_format_float(self.saturation, input_name='saturation'), namespace_, eol_))
        if self.value is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespace_, self.gds_format_float(self.value, input_name='value'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'hue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'hue')
            self.hue = fval_
        elif nodeName_ == 'saturation':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'saturation')
            self.saturation = fval_
        elif nodeName_ == 'value':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'value')
            self.value = fval_
# end class hsvType


class runLengthEncodingType(GeneratedsSuper):
    """Deprecated"""
    subclass = None
    superclass = None
    def __init__(self, string=None, offset=None, boxSize=None):
        self.original_tagname_ = None
        self.string = string
        self.validate_stringType(self.string)
        self.offset = offset
        self.boxSize = boxSize
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, runLengthEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if runLengthEncodingType.subclass:
            return runLengthEncodingType.subclass(*args_, **kwargs_)
        else:
            return runLengthEncodingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_string(self): return self.string
    def set_string(self, string): self.string = string
    def get_offset(self): return self.offset
    def set_offset(self, offset): self.offset = offset
    def get_boxSize(self): return self.boxSize
    def set_boxSize(self, boxSize): self.boxSize = boxSize
    def validate_stringType(self, value):
        # Validate type stringType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_stringType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_stringType_patterns_, ))
    validate_stringType_patterns_ = [['^\\d+(,\\d+)+$']]
    def hasContent_(self):
        if (
            self.string is not None or
            self.offset is not None or
            self.boxSize is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='runLengthEncodingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='runLengthEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='runLengthEncodingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='runLengthEncodingType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='runLengthEncodingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.string is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstring>%s</%sstring>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.string), input_name='string')), namespace_, eol_))
        if self.offset is not None:
            self.offset.export(outfile, level, namespace_, name_='offset', pretty_print=pretty_print)
        if self.boxSize is not None:
            self.boxSize.export(outfile, level, namespace_, name_='boxSize', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'string':
            string_ = child_.text
            string_ = re_.sub(String_cleanup_pat_, " ", string_).strip()
            string_ = self.gds_validate_string(string_, node, 'string')
            self.string = string_
            # validate type stringType
            self.validate_stringType(self.string)
        elif nodeName_ == 'offset':
            obj_ = integerVectorType.factory()
            obj_.build(child_)
            self.offset = obj_
            obj_.original_tagname_ = 'offset'
        elif nodeName_ == 'boxSize':
            obj_ = positiveIntegerVectorType.factory()
            obj_.build(child_)
            self.boxSize = obj_
            obj_.original_tagname_ = 'boxSize'
# end class runLengthEncodingType


class integerVectorType(GeneratedsSuper):
    """Deprecated"""
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None):
        self.original_tagname_ = None
        self.x = x
        self.y = y
        self.z = z
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, integerVectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if integerVectorType.subclass:
            return integerVectorType.subclass(*args_, **kwargs_)
        else:
            return integerVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='integerVectorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='integerVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='integerVectorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='integerVectorType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='integerVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_integer(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_integer(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_integer(self.z, input_name='z'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'x')
            self.x = ival_
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'y')
            self.y = ival_
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'z')
            self.z = ival_
# end class integerVectorType


class positiveIntegerVectorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None):
        self.original_tagname_ = None
        self.x = x
        self.y = y
        self.z = z
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, positiveIntegerVectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if positiveIntegerVectorType.subclass:
            return positiveIntegerVectorType.subclass(*args_, **kwargs_)
        else:
            return positiveIntegerVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_x(self): return self.x
    def set_x(self, x): self.x = x
    def get_y(self): return self.y
    def set_y(self, y): self.y = y
    def get_z(self): return self.z
    def set_z(self, z): self.z = z
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='positiveIntegerVectorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='positiveIntegerVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='positiveIntegerVectorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='positiveIntegerVectorType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='positiveIntegerVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespace_, self.gds_format_integer(self.x, input_name='x'), namespace_, eol_))
        if self.y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespace_, self.gds_format_integer(self.y, input_name='y'), namespace_, eol_))
        if self.z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespace_, self.gds_format_integer(self.z, input_name='z'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'x':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'x')
            self.x = ival_
        elif nodeName_ == 'y':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'y')
            self.y = ival_
        elif nodeName_ == 'z':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'z')
            self.z = ival_
# end class positiveIntegerVectorType


class transformListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, transform=None):
        self.original_tagname_ = None
        if transform is None:
            self.transform = []
        else:
            self.transform = transform
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transformListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transformListType.subclass:
            return transformListType.subclass(*args_, **kwargs_)
        else:
            return transformListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_transform(self): return self.transform
    def set_transform(self, transform): self.transform = transform
    def add_transform(self, value): self.transform.append(value)
    def insert_transform_at(self, index, value): self.transform.insert(index, value)
    def replace_transform_at(self, index, value): self.transform[index] = value
    def hasContent_(self):
        if (
            self.transform
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='transformListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='transformListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='transformListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='transformListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='transformListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for transform_ in self.transform:
            transform_.export(outfile, level, namespace_, name_='transform', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'transform':
            obj_ = transform.factory()
            obj_.build(child_)
            self.transform.append(obj_)
            obj_.original_tagname_ = 'transform'
        elif nodeName_ == 'transformationMatrix':
            obj_ = transformationMatrixType.factory()
            obj_.build(child_)
            self.transform.append(obj_)
            obj_.original_tagname_ = 'transformationMatrix'
        elif nodeName_ == 'canonicalEulerAngles':
            obj_ = canonicalEulerAnglesType.factory()
            obj_.build(child_)
            self.transform.append(obj_)
            obj_.original_tagname_ = 'canonicalEulerAngles'
        elif nodeName_ == 'viewVectorRotation':
            obj_ = viewVectorRotationType.factory()
            obj_.build(child_)
            self.transform.append(obj_)
            obj_.original_tagname_ = 'viewVectorRotation'
# end class transformListType


class segmentListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, segment=None):
        self.original_tagname_ = None
        if segment is None:
            self.segment = []
        else:
            self.segment = segment
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segmentListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segmentListType.subclass:
            return segmentListType.subclass(*args_, **kwargs_)
        else:
            return segmentListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_segment(self): return self.segment
    def set_segment(self, segment): self.segment = segment
    def add_segment(self, value): self.segment.append(value)
    def insert_segment_at(self, index, value): self.segment.insert(index, value)
    def replace_segment_at(self, index, value): self.segment[index] = value
    def hasContent_(self):
        if (
            self.segment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='segmentListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='segmentListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='segmentListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='segmentListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='segmentListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for segment_ in self.segment:
            segment_.export(outfile, level, namespace_, name_='segment', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'segment':
            obj_ = segmentType.factory()
            obj_.build(child_)
            self.segment.append(obj_)
            obj_.original_tagname_ = 'segment'
# end class segmentListType


class biologicalAnnotationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, description=None, externalReferences=None, numberOfInstances=None):
        self.original_tagname_ = None
        self.description = description
        self.externalReferences = externalReferences
        self.numberOfInstances = numberOfInstances
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, biologicalAnnotationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if biologicalAnnotationType.subclass:
            return biologicalAnnotationType.subclass(*args_, **kwargs_)
        else:
            return biologicalAnnotationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_externalReferences(self): return self.externalReferences
    def set_externalReferences(self, externalReferences): self.externalReferences = externalReferences
    def get_numberOfInstances(self): return self.numberOfInstances
    def set_numberOfInstances(self, numberOfInstances): self.numberOfInstances = numberOfInstances
    def hasContent_(self):
        if (
            self.description is not None or
            self.externalReferences is not None or
            self.numberOfInstances is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='biologicalAnnotationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='biologicalAnnotationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='biologicalAnnotationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='biologicalAnnotationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='biologicalAnnotationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespace_, eol_))
        if self.externalReferences is not None:
            self.externalReferences.export(outfile, level, namespace_, name_='externalReferences', pretty_print=pretty_print)
        if self.numberOfInstances is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumberOfInstances>%s</%snumberOfInstances>%s' % (namespace_, self.gds_format_integer(self.numberOfInstances, input_name='numberOfInstances'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
        elif nodeName_ == 'externalReferences':
            obj_ = externalReferencesType.factory()
            obj_.build(child_)
            self.externalReferences = obj_
            obj_.original_tagname_ = 'externalReferences'
        elif nodeName_ == 'numberOfInstances':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'numberOfInstances')
            self.numberOfInstances = ival_
# end class biologicalAnnotationType


class externalReferencesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ref=None):
        self.original_tagname_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, externalReferencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if externalReferencesType.subclass:
            return externalReferencesType.subclass(*args_, **kwargs_)
        else:
            return externalReferencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ref(self): return self.ref
    def set_ref(self, ref): self.ref = ref
    def add_ref(self, value): self.ref.append(value)
    def insert_ref_at(self, index, value): self.ref.insert(index, value)
    def replace_ref_at(self, index, value): self.ref[index] = value
    def hasContent_(self):
        if (
            self.ref
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='externalReferencesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='externalReferencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='externalReferencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='externalReferencesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='externalReferencesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ref_ in self.ref:
            ref_.export(outfile, level, namespace_, name_='ref', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ref':
            obj_ = externalReferenceType.factory()
            obj_.build(child_)
            self.ref.append(obj_)
            obj_.original_tagname_ = 'ref'
# end class externalReferencesType


class shapePrimitiveListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, shapePrimitive=None):
        self.original_tagname_ = None
        if shapePrimitive is None:
            self.shapePrimitive = []
        else:
            self.shapePrimitive = shapePrimitive
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, shapePrimitiveListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if shapePrimitiveListType.subclass:
            return shapePrimitiveListType.subclass(*args_, **kwargs_)
        else:
            return shapePrimitiveListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_shapePrimitive(self): return self.shapePrimitive
    def set_shapePrimitive(self, shapePrimitive): self.shapePrimitive = shapePrimitive
    def add_shapePrimitive(self, value): self.shapePrimitive.append(value)
    def insert_shapePrimitive_at(self, index, value): self.shapePrimitive.insert(index, value)
    def replace_shapePrimitive_at(self, index, value): self.shapePrimitive[index] = value
    def hasContent_(self):
        if (
            self.shapePrimitive
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='shapePrimitiveListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='shapePrimitiveListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='shapePrimitiveListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='shapePrimitiveListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='shapePrimitiveListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for shapePrimitive_ in self.shapePrimitive:
            shapePrimitive_.export(outfile, level, namespace_, name_='shapePrimitive', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'shapePrimitive':
            obj_ = shapePrimitive.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'shapePrimitive'
        elif nodeName_ == 'cuboid':
            obj_ = cuboid.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'cuboid'
        elif nodeName_ == 'ellipsoid':
            obj_ = ellipsoid.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'ellipsoid'
        elif nodeName_ == 'cylinder':
            obj_ = cylinder.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'cylinder'
        elif nodeName_ == 'cone':
            obj_ = cone.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'cone'
        elif nodeName_ == 'subtomogramAverage':
            obj_ = threeDVolumeType.factory()
            obj_.build(child_)
            self.shapePrimitive.append(obj_)
            obj_.original_tagname_ = 'subtomogramAverage'
# end class shapePrimitiveListType


class contourListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, contour=None, transformId=None):
        self.original_tagname_ = None
        if contour is None:
            self.contour = []
        else:
            self.contour = contour
        self.transformId = transformId
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contourListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contourListType.subclass:
            return contourListType.subclass(*args_, **kwargs_)
        else:
            return contourListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_contour(self): return self.contour
    def set_contour(self, contour): self.contour = contour
    def add_contour(self, value): self.contour.append(value)
    def insert_contour_at(self, index, value): self.contour.insert(index, value)
    def replace_contour_at(self, index, value): self.contour[index] = value
    def get_transformId(self): return self.transformId
    def set_transformId(self, transformId): self.transformId = transformId
    def hasContent_(self):
        if (
            self.contour or
            self.transformId is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='contourListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='contourListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='contourListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='contourListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='contourListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for contour_ in self.contour:
            contour_.export(outfile, level, namespace_, name_='contour', pretty_print=pretty_print)
        if self.transformId is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespace_, self.gds_format_integer(self.transformId, input_name='transformId'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'contour':
            obj_ = contourType.factory()
            obj_.build(child_)
            self.contour.append(obj_)
            obj_.original_tagname_ = 'contour'
        elif nodeName_ == 'transformId':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
# end class contourListType


class meshListType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, mesh=None):
        self.original_tagname_ = None
        if mesh is None:
            self.mesh = []
        else:
            self.mesh = mesh
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, meshListType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if meshListType.subclass:
            return meshListType.subclass(*args_, **kwargs_)
        else:
            return meshListType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_mesh(self): return self.mesh
    def set_mesh(self, mesh): self.mesh = mesh
    def add_mesh(self, value): self.mesh.append(value)
    def insert_mesh_at(self, index, value): self.mesh.insert(index, value)
    def replace_mesh_at(self, index, value): self.mesh[index] = value
    def hasContent_(self):
        if (
            self.mesh
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='meshListType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='meshListType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='meshListType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='meshListType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='meshListType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for mesh_ in self.mesh:
            mesh_.export(outfile, level, namespace_, name_='mesh', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'mesh':
            obj_ = meshType.factory()
            obj_.build(child_)
            self.mesh.append(obj_)
            obj_.original_tagname_ = 'mesh'
# end class meshListType


class macromoleculeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.original_tagname_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromoleculeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromoleculeType.subclass:
            return macromoleculeType.subclass(*args_, **kwargs_)
        else:
            return macromoleculeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def add_id(self, value): self.id.append(value)
    def insert_id_at(self, index, value): self.id.insert(index, value)
    def replace_id_at(self, index, value): self.id[index] = value
    def hasContent_(self):
        if (
            self.id
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='macromoleculeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='macromoleculeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='macromoleculeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='macromoleculeType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='macromoleculeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for id_ in self.id:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(id_), input_name='id')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id.append(id_)
# end class macromoleculeType


class complexType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, id=None):
        self.original_tagname_ = None
        if id is None:
            self.id = []
        else:
            self.id = id
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complexType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complexType.subclass:
            return complexType.subclass(*args_, **kwargs_)
        else:
            return complexType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def add_id(self, value): self.id.append(value)
    def insert_id_at(self, index, value): self.id.insert(index, value)
    def replace_id_at(self, index, value): self.id[index] = value
    def hasContent_(self):
        if (
            self.id
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='complexType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='complexType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='complexType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='complexType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='complexType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for id_ in self.id:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sid>%s</%sid>%s' % (namespace_, self.gds_encode(self.gds_format_string(quote_xml(id_), input_name='id')), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'id':
            id_ = child_.text
            id_ = self.gds_validate_string(id_, node, 'id')
            self.id.append(id_)
# end class complexType


GDSClassesMapping = {
    'P': polygonType,
    'biologicalAnnotation': biologicalAnnotationType,
    'boxSize': positiveIntegerVectorType,
    'canonicalEulerAngles': canonicalEulerAnglesType,
    'colour': colourType,
    'complex': complexType,
    'complexesAndMacromolecules': macromoleculesAndComplexesType,
    'contour': contourType,
    'contourList': contourListType,
    'externalReferences': externalReferencesType,
    'macromolecule': macromoleculeType,
    'mesh': meshType,
    'meshList': meshListType,
    'offset': integerVectorType,
    'p': floatVectorType,
    'point': floatVectorType,
    'polygonList': polygonListType,
    'ref': externalReferenceType,
    'rgba': rgbaType,
    'segment': segmentType,
    'segmentList': segmentListType,
    'shapePrimitiveList': shapePrimitiveListType,
    'software': softwareType,
    'subtomogramAverage': threeDVolumeType,
    'threeDVolume': threeDVolumeType,
    'transformList': transformListType,
    'transformationMatrix': transformationMatrixType,
    'v': vertexType,
    'vertexList': vertexListType,
    'viewVectorRotation': viewVectorRotationType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    parser = None
    doc = parsexml_(StringIO(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from v_0_6_0_a_2 import *\n\n')
        sys.stdout.write('import v_0_6_0_a_2 as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "biologicalAnnotationType",
    "canonicalEulerAnglesType",
    "colourType",
    "complexType",
    "cone",
    "contourListType",
    "contourType",
    "cuboid",
    "cylinder",
    "ellipsoid",
    "externalReferenceType",
    "externalReferencesType",
    "floatVectorType",
    "hsvType",
    "integerVectorType",
    "macromoleculeType",
    "macromoleculesAndComplexesType",
    "meshListType",
    "meshPointType",
    "meshType",
    "polygonListType",
    "polygonType",
    "positiveIntegerVectorType",
    "rgbaType",
    "runLengthEncodingType",
    "segmentListType",
    "segmentType",
    "segmentation",
    "shapePrimitive",
    "shapePrimitiveListType",
    "softwareType",
    "threeDVolumeType",
    "transform",
    "transformListType",
    "transformationMatrixType",
    "vertexListType",
    "vertexType",
    "viewVectorRotationType"
]
