"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const s3 = require("aws-cdk-lib/aws-s3");
const core = require("aws-cdk-lib/core");
const aws_s3objectlambda_1 = require("aws-cdk-lib/aws-s3objectlambda");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
class AccessPointBase extends core.Resource {
    /** Implement the `IAccessPoint.domainName` field. */
    get domainName() {
        const urlSuffix = this.stack.urlSuffix;
        return `${this.accessPointName}-${this.env.account}.s3-object-lambda.${urlSuffix}`;
    }
    /** Implement the `IAccessPoint.regionalDomainName` field. */
    get regionalDomainName() {
        const urlSuffix = this.stack.urlSuffix;
        const region = this.env.region;
        return `${this.accessPointName}-${this.env.account}.s3-object-lambda.${region}.${urlSuffix}`;
    }
    /** Implement the `IAccessPoint.virtualHostedUrlForObject` method. */
    virtualHostedUrlForObject(key, options) {
        const domainName = options?.regional ?? true ? this.regionalDomainName : this.domainName;
        const prefix = `https://${domainName}`;
        if (!key) {
            return prefix;
        }
        if (key.startsWith('/')) {
            key = key.slice(1);
        }
        if (key.endsWith('/')) {
            key = key.slice(0, -1);
        }
        return `${prefix}/${key}`;
    }
}
/**
 * Checks the access point name against the rules in https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html#access-points-names
 * @param name The name of the access point
 */
function validateAccessPointName(name) {
    if (name.length < 3 || name.length > 50) {
        throw new Error('Access point name must be between 3 and 50 characters long');
    }
    if (name.endsWith('-s3alias')) {
        throw new Error('Access point name cannot end with the suffix -s3alias');
    }
    if (name[0] === '-' || name[name.length - 1] === '-') {
        throw new Error('Access point name cannot begin or end with a dash');
    }
    if (!/^[0-9a-z](.(?![\.A-Z_]))+[0-9a-z]$/.test(name)) {
        throw new Error('Access point name must begin with a number or lowercase letter and not contain underscores, uppercase letters, or periods');
    }
}
/**
 * An S3 object lambda access point for intercepting and
 * transforming `GetObject` requests.
 */
let AccessPoint = class AccessPoint extends AccessPointBase {
    /**
     * Reference an existing AccessPoint defined outside of the CDK code.
     */
    static fromAccessPointAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_s3objectlambda_alpha_AccessPointAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAccessPointAttributes);
            }
            throw error;
        }
        const arn = core.Arn.split(attrs.accessPointArn, core.ArnFormat.SLASH_RESOURCE_NAME);
        if (!arn.resourceName) {
            throw new Error('Unable to parse access point name');
        }
        const name = arn.resourceName;
        class Import extends AccessPointBase {
            constructor() {
                super(...arguments);
                this.accessPointArn = attrs.accessPointArn;
                this.accessPointCreationDate = attrs.accessPointCreationDate;
                this.accessPointName = name;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.accessPointName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_s3objectlambda_alpha_AccessPointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AccessPoint);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.accessPointName) {
            validateAccessPointName(props.accessPointName);
        }
        const supporting = new s3.CfnAccessPoint(this, 'SupportingAccessPoint', {
            bucket: props.bucket.bucketName,
        });
        const allowedFeatures = [];
        if (props.supportsGetObjectPartNumber) {
            allowedFeatures.push('GetObject-PartNumber');
        }
        if (props.supportsGetObjectRange) {
            allowedFeatures.push('GetObject-Range');
        }
        const accessPoint = new aws_s3objectlambda_1.CfnAccessPoint(this, id, {
            name: this.physicalName,
            objectLambdaConfiguration: {
                allowedFeatures,
                cloudWatchMetricsEnabled: props.cloudWatchMetricsEnabled,
                supportingAccessPoint: supporting.attrArn,
                transformationConfigurations: [
                    {
                        actions: ['GetObject'],
                        contentTransformation: {
                            AwsLambda: {
                                FunctionArn: props.handler.functionArn,
                                FunctionPayload: props.payload ? JSON.stringify(props.payload) : undefined,
                            },
                        },
                    },
                ],
            },
        });
        this.s3AccessPointArn = supporting.attrArn;
        this.accessPointName = accessPoint.ref;
        this.accessPointArn = accessPoint.attrArn;
        this.accessPointCreationDate = accessPoint.attrCreationDate;
        props.handler.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3-object-lambda:WriteGetObjectResponse'],
            resources: ['*'],
        }));
    }
};
exports.AccessPoint = AccessPoint;
_a = JSII_RTTI_SYMBOL_1;
AccessPoint[_a] = { fqn: "@aws-cdk/aws-s3objectlambda-alpha.AccessPoint", version: "2.200.1-alpha.0" };
/** Uniquely identifies this class. */
AccessPoint.PROPERTY_INJECTION_ID = '@aws-cdk.aws-s3objectlambda-alpha.AccessPoint';
exports.AccessPoint = AccessPoint = __decorate([
    prop_injectable_1.propertyInjectable
], AccessPoint);
//# sourceMappingURL=data:application/json;base64,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