import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::AutoScalingPlans::ScalingPlan`
 *
 * @stable
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export interface CfnScalingPlanProps {
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    readonly applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    readonly scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`
 *
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 * @stable
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 */
export declare class CfnScalingPlan extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScalingPlans::ScalingPlan";
    /**
     * @cloudformationAttribute ScalingPlanName
     */
    readonly attrScalingPlanName: string;
    /**
     * @cloudformationAttribute ScalingPlanVersion
     */
    readonly attrScalingPlanVersion: string;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     */
    applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     */
    scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::AutoScalingPlans::ScalingPlan`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPlanProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html
     */
    interface ApplicationSourceProperty {
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.CloudFormationStackARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn
         */
        readonly cloudFormationStackArn?: string;
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.TagFilters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters
         */
        readonly tagFilters?: Array<CfnScalingPlan.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html
     */
    interface CustomizedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Statistic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html
     */
    interface CustomizedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Statistic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name
         */
        readonly name: string;
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html
     */
    interface PredefinedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.PredefinedLoadMetricType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype
         */
        readonly predefinedLoadMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.ResourceLabel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html
     */
    interface PredefinedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.PredefinedScalingMetricType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype
         */
        readonly predefinedScalingMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.ResourceLabel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html
     */
    interface ScalingInstructionProperty {
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification
         */
        readonly customizedLoadMetricSpecification?: CfnScalingPlan.CustomizedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling
         */
        readonly disableDynamicScaling?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MaxCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity
         */
        readonly maxCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MinCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity
         */
        readonly minCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification
         */
        readonly predefinedLoadMetricSpecification?: CfnScalingPlan.PredefinedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior
         */
        readonly predictiveScalingMaxCapacityBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBuffer`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer
         */
        readonly predictiveScalingMaxCapacityBuffer?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode
         */
        readonly predictiveScalingMode?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ResourceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid
         */
        readonly resourceId: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalableDimension`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension
         */
        readonly scalableDimension: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalingPolicyUpdateBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior
         */
        readonly scalingPolicyUpdateBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScheduledActionBufferTime`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime
         */
        readonly scheduledActionBufferTime?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ServiceNamespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace
         */
        readonly serviceNamespace: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations
         */
        readonly targetTrackingConfigurations: Array<CfnScalingPlan.TargetTrackingConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html
     */
    interface TagFilterProperty {
        /**
         * `CfnScalingPlan.TagFilterProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key
         */
        readonly key: string;
        /**
         * `CfnScalingPlan.TagFilterProperty.Values`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values
         */
        readonly values?: string[];
    }
}
export declare namespace CfnScalingPlan {
    /**
     * @stable
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification
         */
        readonly customizedScalingMetricSpecification?: CfnScalingPlan.CustomizedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.EstimatedInstanceWarmup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup
         */
        readonly estimatedInstanceWarmup?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification
         */
        readonly predefinedScalingMetricSpecification?: CfnScalingPlan.PredefinedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleInCooldown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleOutCooldown`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.TargetValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue
         */
        readonly targetValue: number;
    }
}
