![Model Tuner Logo](https://github.com/uclamii/model_tuner/blob/main/assets/modeltunertiny.png?raw=true)

[![Downloads](https://pepy.tech/badge/model_tuner)](https://pepy.tech/project/model_tuner) [![PyPI](https://img.shields.io/pypi/v/model_tuner.svg)](https://pypi.org/project/model_tuner/) [![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0) [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.12727322.svg)](https://doi.org/10.5281/zenodo.12727322)


The model_tuner class is a versatile and powerful tool designed to facilitate the training, evaluation, and tuning of machine learning models. It supports various functionalities such as handling imbalanced data, applying different scaling and imputation techniques, calibrating models, and conducting cross-validation. This class is particularly useful for model selection and hyperparameter tuning, ensuring optimal performance across different metrics.

## Prerequisites

Before you install `model_tuner`, ensure your system meets the following requirements:

- `Python`: Version `3.7` or higher is required to run `model_tuner`.

Additionally, `model_tuner` depends on the following packages, which will be automatically installed when you install `model_tuner` using pip:

- `numpy`: Version 1.21.6 or higher

- `pandas`: Version 1.3.5 or higher

- `joblib`: Version 1.3.2 or higher

- `scikit-learn`: Version 1.0.2 or higher

- `scipy`: Version 1.7.3 or higher

- `tqdm`: Version 4.66.4 or higher


## Installation

You can install `model_tuner` directly from PyPI:

```bash
pip install model_tuner
```

## 📄 Official Documentation

https://uclamii.github.io/model_tuner

## 🌐 Author Website

https://www.mii.ucla.edu/

## ⚖️ License

`model_tuner` is distributed under the Apache License. See [LICENSE](https://github.com/uclamii/model_tuner?tab=Apache-2.0-1-ov-file) for more information.

## 📚 Citing `model_tuner`

If you use `model_tuner` in your research or projects, please consider citing it.

```bibtex
@software{arthur_funnell_2024_12727322,
  author       = {Arthur Funnell,
                  Leonid Shpaner and
                  Panayiotis Petousis},
  title        = {uclamii/model\_tuner: model tuner 0.0.12a},
  month        = jul,
  year         = 2024,
  publisher    = {Zenodo},
  version      = {0.0.12a},
  doi          = {10.5281/zenodo.12727322},
  url          = {https://doi.org/10.5281/zenodo.12727322}
}
```


## Support

If you have any questions or issues with `model_tuner`, please open an issue on this GitHub repository.


## Acknowledgements

This work was supported by the UCLA Medical Informatics Institute (MII) and the Clinical and Translational Science Institute (CTSI). Special thanks to Dr. Alex Bui for his invaluable guidance and support, and to Panayiotis Petousis for his original contributions to this codebase.
