"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryCodeBundler = void 0;
const child_process_1 = require("child_process");
const fs = require("fs");
const path = require("path");
const PACKAGE_JSON_PATTERN = /^package\.json$/;
const SOURCE_JS_PATTERN = /^.+\.js$/;
class CanaryCodeBundler {
    constructor(codePath) {
        this.codePath = codePath;
        const codePathStats = fs.lstatSync(this.codePath);
        if (!codePathStats.isDirectory) {
            throw new Error(`Invalid codePath: ${this.codePath}`);
        }
    }
    copy(pattern, outputDir) {
        const outputDirStats = fs.lstatSync(outputDir);
        if (!outputDirStats.isDirectory) {
            throw new Error(`Invalid outputDir: ${outputDir}`);
        }
        fs.readdirSync(this.codePath)
            .filter(f => f.match(pattern))
            .forEach(f => {
            fs.copyFileSync(`${this.codePath}/${f}`, `${outputDir}/${f}`);
        });
    }
    tryBundle(outputDir, _options) {
        fs.mkdirSync(`${outputDir}/nodejs`);
        this.copy(PACKAGE_JSON_PATTERN, `${outputDir}/nodejs`);
        (0, child_process_1.execSync)('npm install', { cwd: `${outputDir}/nodejs` });
        this.copy(SOURCE_JS_PATTERN, `${outputDir}/nodejs/node_modules`);
        return true;
    }
    toJSON() {
        return {
            codePath: path.relative(__dirname, this.codePath),
        };
    }
}
exports.CanaryCodeBundler = CanaryCodeBundler;
//# sourceMappingURL=data:application/json;base64,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