import { Duration } from 'aws-cdk-lib';
import { IAlarm } from 'aws-cdk-lib/aws-cloudwatch';
import { EcsApplication, EcsDeploymentGroup, IEcsDeploymentConfig } from 'aws-cdk-lib/aws-codedeploy';
import { BaseService } from 'aws-cdk-lib/aws-ecs';
import { ApplicationLoadBalancedFargateService, ApplicationLoadBalancedFargateServiceProps } from 'aws-cdk-lib/aws-ecs-patterns';
import { ApplicationListener, ApplicationTargetGroup, HealthCheck } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { ApiTestStep, ApiCanary } from '../api-canary';
import { AppSpecHooks } from '../ecs-appspec';
import { EcsDeployment } from '../ecs-deployment';
/**
 * The properties for the ApplicationLoadBalancedCodeDeployedFargateService service.
 */
export interface ApplicationLoadBalancedCodeDeployedFargateServiceProps extends ApplicationLoadBalancedFargateServiceProps {
    /**
     * The timeout for a CodeDeploy deployment.
     *
     * @default - 60 minutes
     */
    readonly deploymentTimeout?: Duration;
    /**
     * The time to wait before terminating the original (blue) task set.
     *
     * @default - 10 minutes
     */
    readonly terminationWaitTime?: Duration;
    /**
     * The deployment configuration to use for the deployment group.
     *
     * @default - EcsDeploymentConfig.ALL_AT_ONCE
     */
    readonly deploymentConfig?: IEcsDeploymentConfig;
    /**
     * The amount of time for ELB to wait before changing the state of a deregistering target
     * from 'draining' to 'unused'.
     *
     * @default - 300 seconds
     */
    readonly deregistrationDelay?: Duration;
    /**
     * The healthcheck to configure on the Application Load Balancer target groups.
     *
     * @default - no health check is configured
     */
    readonly targetHealthCheck?: HealthCheck;
    /**
     * The bucket to use for access logs from the Application Load Balancer.
     *
     * @default - a new S3 bucket will be created
     */
    readonly accessLogBucket?: IBucket;
    /**
     * The prefix to use for access logs from the Application Load Balancer.
     *
     * @default - none
     */
    readonly accessLogPrefix?: string;
    /**
     * The threshold for response time alarm.
     *
     * @default - no alarm will be created
     */
    readonly responseTimeAlarmThreshold?: Duration;
    /**
     * The number of threads to run concurrently for the synthetic test.
     *
     * @default - 20
     */
    readonly apiCanaryThreadCount?: number;
    /**
     * The frequency for running the api canaries.
     *
     * @default - 5 minutes
     */
    readonly apiCanarySchedule?: Duration;
    /**
     * The threshold for how long a api canary can take to run.
     *
     * @default - no alarm is created for test duration
     */
    readonly apiCanaryTimeout?: Duration;
    /**
     * The steps to run in the canary.
     *
     * @default - no synthetic test will be created
     */
    readonly apiTestSteps?: ApiTestStep[];
    /**
     * The port to use for test traffic on the listener
     *
     * @default - listenerPort + 1
     */
    readonly testPort?: number;
    /**
     * Optional lifecycle hooks
     *
     * @default - no lifecycle hooks
     */
    readonly hooks?: AppSpecHooks;
    /**
     * The physical, human-readable name of the CodeDeploy Application.
     *
     * @default an auto-generated name will be used
     */
    readonly applicationName?: string;
    /**
     * The physical, human-readable name of the CodeDeploy Deployment Group.
     *
     * @default An auto-generated name will be used.
     */
    readonly deploymentGroupName?: string;
}
/**
 * A Fargate service running on an ECS cluster fronted by an application load balancer and deployed by CodeDeploy.
 */
export declare class ApplicationLoadBalancedCodeDeployedFargateService extends ApplicationLoadBalancedFargateService {
    /**
     * Composite alarm for monitoring health of service.
     */
    healthAlarm?: IAlarm;
    /**
     * API Canary for the service.
     */
    apiCanary?: ApiCanary;
    /**
     * Test listener to use for CodeDeploy deployments.
     */
    testListener: ApplicationListener;
    /**
     * Test target group to use for CodeDeploy deployments.
     */
    greenTargetGroup: ApplicationTargetGroup;
    /**
     * S3 Bucket used for access logs.
     */
    accessLogBucket: IBucket;
    /**
     * CodeDeploy application for this service.
     */
    application: EcsApplication;
    /**
     * CodeDeploy deployment group for this service.
     */
    deploymentGroup: EcsDeploymentGroup;
    /**
     * CodeDeploy deployment for this service.
     */
    deployment: EcsDeployment;
    /**
     * Constructs a new instance of the ApplicationLoadBalancedCodeDeployedFargateService class.
     */
    constructor(scope: Construct, id: string, props: ApplicationLoadBalancedCodeDeployedFargateServiceProps);
    protected addServiceAsTarget(service: BaseService): void;
}
