import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
} from "@smithy/types";
import { CodeDeployClientResolvedConfig } from "../CodeDeployClient";
export interface CodeDeployHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface CodeDeployHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    CodeDeployClientResolvedConfig,
    HandlerExecutionContext,
    CodeDeployHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultCodeDeployHttpAuthSchemeParametersProvider: (
  config: CodeDeployClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<CodeDeployHttpAuthSchemeParameters>;
export interface CodeDeployHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<CodeDeployHttpAuthSchemeParameters> {}
export declare const defaultCodeDeployHttpAuthSchemeProvider: CodeDeployHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: CodeDeployHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: CodeDeployHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
