"""create_deferrable_constraint

Revision ID: 85982c1f3b95
Revises: c4c46d14ca6a
Create Date: 2023-03-20 17:24:33.709162

"""
import alembic
import sqlalchemy as sa  # type: ignore

# revision identifiers, used by Alembic.
revision = '85982c1f3b95'
down_revision = 'c4c46d14ca6a'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    alembic.op.drop_index('ux_transfers_source_blockchain_id_nonce_status_id',
                          table_name='transfers')
    alembic.op.create_index(
        'ix_transfers_source_blockchain_id_nonce_status_id', 'transfers',
        ['source_blockchain_id',
         sa.text('nonce DESC'), 'status_id'], unique=False)
    alembic.op.create_unique_constraint(
        'uq_transfers_source_blockchain_id_nonce_status_id', 'transfers',
        ['source_blockchain_id', 'nonce', 'status_id'], deferrable='True')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    alembic.op.drop_constraint(
        'uq_transfers_source_blockchain_id_nonce_status_id', 'transfers',
        type_='unique')
    alembic.op.drop_index('ix_transfers_source_blockchain_id_nonce_status_id',
                          table_name='transfers')
    alembic.op.create_index(
        'ux_transfers_source_blockchain_id_nonce_status_id', 'transfers',
        ['source_blockchain_id', 'nonce', 'status_id'], unique=False)
    # ### end Alembic commands ###
